/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.layer.context.TcpContext;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="SendAscii")
public class SendAsciiAction
extends AsciiAction {
    private static final Logger LOGGER = LogManager.getLogger();

    SendAsciiAction() {
    }

    public SendAsciiAction(String asciiString, String encoding) {
        super(asciiString, encoding);
    }

    public SendAsciiAction(String encoding) {
        super(encoding);
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TcpContext tcpContext = state.getTcpContext();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            LOGGER.info("Sending ASCII message: {}", (Object)this.getAsciiText());
            tcpContext.getTransportHandler().sendData(this.getAsciiText().getBytes(this.getEncoding()));
            this.setExecuted(true);
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
        }
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

