/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;

@XmlRootElement(name="SendDynamicServerKeyExchange")
public class SendDynamicServerKeyExchangeAction
extends CommonSendAction {
    public SendDynamicServerKeyExchangeAction() {
    }

    public SendDynamicServerKeyExchangeAction(String connectionAlias) {
        super(connectionAlias);
    }

    public String toString() {
        StringBuilder sb = this.isExecuted() ? new StringBuilder("Send Action:\n") : new StringBuilder("Send Action: (not executed)\n");
        sb.append("\tMessages:");
        if (this.getSentMessages() != null) {
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(", ");
            }
            sb.append("\n");
        } else {
            sb.append("null (no messages set)");
        }
        return sb.toString();
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder(super.toCompactString());
        if (this.getSentMessages() != null && !this.getSentMessages().isEmpty()) {
            sb.append(" (");
            for (ProtocolMessage message : this.getSentMessages()) {
                sb.append(message.toCompactString());
                sb.append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(",")).append(")");
        } else {
            sb.append(" (no messages set)");
        }
        return sb.toString();
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        CipherSuite selectedCipherSuite = tlsContext.getChooser().getSelectedCipherSuite();
        ServerKeyExchangeMessage serverKeyExchangeMessage = new WorkflowConfigurationFactory(tlsContext.getConfig()).createServerKeyExchangeMessage(selectedCipherSuite.getKeyExchangeAlgorithm());
        if (serverKeyExchangeMessage != null) {
            LinkedList configurationList = new LinkedList();
            configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.MESSAGE, (DataContainer[])new ServerKeyExchangeMessage[]{serverKeyExchangeMessage}));
            return ActionHelperUtil.sortAndAddOptions(tlsContext.getLayerStack(), true, this.getActionOptions(), configurationList);
        }
        return null;
    }
}

