/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="SendRaw")
public class SendRawAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] data;

    SendRawAction() {
    }

    public SendRawAction(byte[] data) {
        this.data = data;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TransportHandler transportHandler = state.getContext().getTransportHandler();
        if (this.isExecuted()) {
            throw new ActionExecutionException("Action already executed!");
        }
        try {
            LOGGER.info("Sending raw message: {}", (Object)DataConverter.bytesToHexString((byte[])this.getData()));
            transportHandler.sendData(this.getData());
            this.setExecuted(true);
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            this.setExecuted(this.getActionOptions().contains((Object)ActionOption.MAY_FAIL));
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendRawAction that = (SendRawAction)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return this.getClass().getName() + ": " + (this.isExecuted() ? "(executed)" : "(not executed)");
    }
}

