/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.Modifiable;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.protocol.util.DeepCopyUtil;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.CommonSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.container.ActionHelperUtil;
import java.util.LinkedList;
import java.util.List;

public class SendRecordsFromLastFlightAction
extends CommonSendAction {
    public SendRecordsFromLastFlightAction() {
    }

    public SendRecordsFromLastFlightAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    protected List<LayerConfiguration<?>> createLayerConfiguration(State state) {
        List<Record> lastRecords = this.getLastSendingAction(state.getWorkflowTrace()).getSentRecords();
        List duplicatedRecords = (List)DeepCopyUtil.deepCopy(lastRecords);
        for (int i = 0; i < duplicatedRecords.size(); ++i) {
            ((Record)duplicatedRecords.get(i)).setCleanProtocolMessageBytes(Modifiable.explicit((byte[])((byte[])lastRecords.get(i).getCleanProtocolMessageBytes().getValue())));
        }
        LinkedList configurationList = new LinkedList();
        configurationList.add(new SpecificSendLayerConfiguration((LayerType)ImplementedLayers.RECORD, duplicatedRecords));
        return ActionHelperUtil.sortAndAddOptions(state.getTlsContext(this.connectionAlias).getLayerStack(), true, this.getActionOptions(), configurationList);
    }

    private SendingAction getLastSendingAction(WorkflowTrace trace) {
        for (int i = 0; i < trace.getSendingActions().size(); ++i) {
            if (trace.getSendingActions().get(i) != this || i == 0) continue;
            return trace.getSendingActions().get(i - 1);
        }
        throw new WorkflowExecutionException("Cannot find last sending action");
    }
}

