/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import de.rub.nds.tlsattacker.transport.TimeableTransportHandler;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
public class SetMeasuringActiveAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean valueToSet = false;
    boolean asPlanned = false;

    public SetMeasuringActiveAction() {
    }

    public SetMeasuringActiveAction(boolean valueToSet) {
        this.valueToSet = valueToSet;
    }

    @Override
    public void execute(State state) throws ActionExecutionException {
        TransportHandler transportHandler = state.getTlsContext(this.getConnectionAlias()).getTransportHandler();
        if (transportHandler instanceof TimeableTransportHandler) {
            TimeableTransportHandler timeableTransportHandler = (TimeableTransportHandler)transportHandler;
            timeableTransportHandler.setMeasuringActive(this.valueToSet);
            LOGGER.debug("Set measuringActive in transport handler to {}", (Object)this.valueToSet);
            this.asPlanned = true;
        } else {
            LOGGER.warn("Can't enable or disable measurements as transport handler is not suited to collect measurements");
        }
    }

    @Override
    public void reset() {
        this.asPlanned = false;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.asPlanned;
    }
}

