/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.connection.Aliasable;
import de.rub.nds.tlsattacker.core.exceptions.ActionExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TlsAction
implements Serializable,
Aliasable {
    private static final boolean EXECUTED_DEFAULT = false;
    private Boolean executed = null;
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(type=ActionOption.class, name="ActionOption")})
    private Set<ActionOption> actionOptions;
    @XmlTransient
    private Boolean singleConnectionWorkflow = true;
    @XmlTransient
    private final Set<String> aliases = new LinkedHashSet<String>();

    public TlsAction() {
    }

    public TlsAction(Set<ActionOption> actionOptions) {
        this.actionOptions = actionOptions;
    }

    public boolean isExecuted() {
        if (this.executed == null) {
            return false;
        }
        return this.executed;
    }

    public void setExecuted(Boolean executed) {
        this.executed = executed;
    }

    public Boolean isSingleConnectionWorkflow() {
        return this.singleConnectionWorkflow;
    }

    public void setSingleConnectionWorkflow(Boolean singleConnectionWorkflow) {
        this.singleConnectionWorkflow = singleConnectionWorkflow;
    }

    public abstract void execute(State var1) throws ActionExecutionException;

    public abstract void reset();

    public void normalize() {
    }

    public void normalize(TlsAction defaultAction) {
    }

    public void filter() {
    }

    public void filter(TlsAction defaultAction) {
    }

    @Override
    public String getFirstAlias() {
        return this.getAllAliases().iterator().next();
    }

    @Override
    public boolean containsAllAliases(Collection<String> aliases) {
        return this.getAllAliases().containsAll(aliases);
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.getAllAliases().contains(alias);
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
    }

    @Override
    public Set<String> getAllAliases() {
        return this.aliases;
    }

    public abstract boolean executedAsPlanned();

    public boolean isMessageAction() {
        return this instanceof MessageAction;
    }

    @Override
    public String aliasesToString() {
        StringBuilder sb = new StringBuilder();
        for (String alias : this.getAllAliases()) {
            sb.append(alias).append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        if (!this.getAllAliases().isEmpty()) {
            sb.append(" [").append(this.aliasesToString()).append("]");
        }
        return sb.toString();
    }

    public final Set<ActionOption> getActionOptions() {
        return this.actionOptions;
    }

    public final void setActionOptions(Set<ActionOption> actionOptions) {
        this.actionOptions = actionOptions;
    }

    public final void addActionOption(ActionOption option) {
        if (this.actionOptions == null) {
            this.actionOptions = new HashSet<ActionOption>();
        }
        this.actionOptions.add(option);
    }
}

