/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.container;

import de.rub.nds.tlsattacker.core.layer.DataContainerFilter;
import de.rub.nds.tlsattacker.core.layer.IgnoreLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.LayerStack;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.MissingReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.MissingSendLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.ReceiveTillHttpContentConfiguration;
import de.rub.nds.tlsattacker.core.layer.SpecificReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.layer.impl.DataContainerFilters.DiscardExceptFilter;
import de.rub.nds.tlsattacker.core.layer.impl.DataContainerFilters.GenericDataContainerFilter;
import de.rub.nds.tlsattacker.core.layer.impl.DataContainerFilters.Tls.WarningAlertFilter;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.message.KeyUpdateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.quic.frame.AckFrame;
import de.rub.nds.tlsattacker.core.quic.frame.NewConnectionIdFrame;
import de.rub.nds.tlsattacker.core.quic.frame.NewTokenFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PaddingFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PingFrame;
import de.rub.nds.tlsattacker.core.quic.frame.RetireConnectionIdFrame;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionHelperUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ActionHelperUtil() {
    }

    public static List<DataContainer> getDataContainersForLayer(LayerType type, LayerStackProcessingResult processingResult) {
        if (processingResult == null) {
            return null;
        }
        for (LayerProcessingResult<?> result : processingResult.getLayerProcessingResultList()) {
            if (result.getLayerType() != type) continue;
            return result.getUsedContainers();
        }
        return new LinkedList<DataContainer>();
    }

    public static List<LayerConfiguration<?>> sortAndAddOptions(LayerStack layerStack, boolean sending, Set<ActionOption> actionOptions, List<LayerConfiguration<?>> unsortedLayerConfigurations) {
        List<LayerConfiguration<?>> sortedLayerConfigurations = ActionHelperUtil.sortLayerConfigurations(layerStack, sending, unsortedLayerConfigurations);
        return ActionHelperUtil.applyAllMessageFilters(sortedLayerConfigurations, actionOptions);
    }

    public static List<LayerConfiguration<?>> applyAllMessageFilters(List<LayerConfiguration<?>> messageLayerConfiguration, Set<ActionOption> actionOptions) {
        for (LayerConfiguration<?> layerConfig : messageLayerConfiguration) {
            ActionHelperUtil.applyMessageFilters(layerConfig, actionOptions);
        }
        return messageLayerConfiguration;
    }

    public static LayerConfiguration<?> applyMessageFilters(LayerConfiguration<?> messageLayerConfiguration, Set<ActionOption> actionOptions) {
        LinkedList<DataContainerFilter> containerFilters = new LinkedList<DataContainerFilter>();
        if (actionOptions != null) {
            if (actionOptions.contains((Object)ActionOption.IGNORE_UNEXPECTED_APP_DATA)) {
                containerFilters.add(new GenericDataContainerFilter(ApplicationMessage.class));
            }
            if (actionOptions.contains((Object)ActionOption.IGNORE_UNEXPECTED_KEY_UPDATE_MESSAGES)) {
                containerFilters.add(new GenericDataContainerFilter(KeyUpdateMessage.class));
            }
            if (actionOptions.contains((Object)ActionOption.IGNORE_UNEXPECTED_NEW_SESSION_TICKETS)) {
                containerFilters.add(new GenericDataContainerFilter(NewSessionTicketMessage.class));
            }
            if (actionOptions.contains((Object)ActionOption.IGNORE_UNEXPECTED_WARNINGS)) {
                containerFilters.add(new WarningAlertFilter());
            }
            if (actionOptions.contains((Object)ActionOption.CHECK_ONLY_EXPECTED) && messageLayerConfiguration.getContainerList() != null) {
                List<Class> containerClasses = messageLayerConfiguration.getContainerList().stream().map((Function<DataContainer, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lde/rub/nds/tlsattacker/core/layer/data/DataContainer;)Ljava/lang/Class;)()).toList();
                containerFilters.add(new DiscardExceptFilter(containerClasses));
            }
            if (!actionOptions.contains((Object)ActionOption.QUIC_FRAMES_STRICT_PADDING)) {
                containerFilters.add(new GenericDataContainerFilter(PaddingFrame.class));
                containerFilters.add(new GenericDataContainerFilter(PingFrame.class));
            }
            if (actionOptions.contains((Object)ActionOption.QUIC_FRAMES_IGNORE_NT_NCID_RTCID)) {
                containerFilters.add(new GenericDataContainerFilter(NewTokenFrame.class));
                containerFilters.add(new GenericDataContainerFilter(NewConnectionIdFrame.class));
                containerFilters.add(new GenericDataContainerFilter(RetireConnectionIdFrame.class));
            }
            if (actionOptions.contains((Object)ActionOption.QUIC_FRAMES_IGNORE_ACK)) {
                containerFilters.add(new GenericDataContainerFilter(AckFrame.class));
            }
            if (messageLayerConfiguration instanceof SpecificReceiveLayerConfiguration) {
                messageLayerConfiguration.setContainerFilterList(containerFilters);
            }
        }
        return messageLayerConfiguration;
    }

    public static List<LayerConfiguration<?>> createReceiveTillHttpContentConfiguration(TlsContext tlsContext, String httpContent) {
        LayerStack layerStack = tlsContext.getLayerStack();
        ReceiveTillHttpContentConfiguration httpConfiguration = new ReceiveTillHttpContentConfiguration(null, httpContent);
        return ActionHelperUtil.sortLayerConfigurations(layerStack, false, List.of(httpConfiguration));
    }

    private static List<LayerConfiguration<?>> sortLayerConfigurations(LayerStack layerStack, boolean sending, List<LayerConfiguration<?>> unsortedLayerConfigurations) {
        LinkedList sortedLayerConfigurations = new LinkedList();
        LinkedList unsortedLayerConfigurationsMutable = new LinkedList(unsortedLayerConfigurations);
        boolean alreadyConfiguredLayer = false;
        for (LayerType layerType : layerStack.getLayersInStack()) {
            ImplementedLayers layer;
            try {
                layer = (ImplementedLayers)layerType;
            }
            catch (ClassCastException e) {
                LOGGER.warn("Cannot assign layer {} to current LayerStack. LayerType not implemented for TlsAction.", (Object)layerType.getName());
                continue;
            }
            Optional<Object> layerConfiguration = Optional.empty();
            layerConfiguration = unsortedLayerConfigurationsMutable.stream().filter(Objects::nonNull).filter(layerConfig -> layerConfig.getLayerType().equals(layer)).findFirst();
            if (layerConfiguration.isPresent()) {
                alreadyConfiguredLayer = true;
                sortedLayerConfigurations.add((LayerConfiguration)layerConfiguration.get());
                unsortedLayerConfigurationsMutable.remove(layerConfiguration.get());
                continue;
            }
            if (alreadyConfiguredLayer) {
                if (sending) {
                    sortedLayerConfigurations.add(new MissingSendLayerConfiguration(layerType));
                    continue;
                }
                sortedLayerConfigurations.add(new MissingReceiveLayerConfiguration(layerType));
                continue;
            }
            sortedLayerConfigurations.add(new IgnoreLayerConfiguration(layerType));
        }
        return sortedLayerConfigurations;
    }
}

