/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.factory;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.StarttlsType;
import de.rub.nds.tlsattacker.core.http.HttpRequestMessage;
import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.AckMessage;
import de.rub.nds.tlsattacker.core.protocol.message.AlertMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CoreClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.CookieExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.quic.constants.QuicTransportErrorCodes;
import de.rub.nds.tlsattacker.core.quic.frame.AckFrame;
import de.rub.nds.tlsattacker.core.quic.frame.ConnectionCloseFrame;
import de.rub.nds.tlsattacker.core.quic.frame.HandshakeDoneFrame;
import de.rub.nds.tlsattacker.core.quic.frame.PingFrame;
import de.rub.nds.tlsattacker.core.quic.packet.RetryPacket;
import de.rub.nds.tlsattacker.core.quic.packet.VersionNegotiationPacket;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceConfigurationUtil;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedGenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.ClearBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyPreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.EchConfigDnsRequestAction;
import de.rub.nds.tlsattacker.core.workflow.action.EsniKeyDnsRequestAction;
import de.rub.nds.tlsattacker.core.workflow.action.FlushSessionCacheAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardDataAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardRecordsAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageActionFactory;
import de.rub.nds.tlsattacker.core.workflow.action.PopAndSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedMessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedRecordAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintLastHandledApplicationDataAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintSecretsAction;
import de.rub.nds.tlsattacker.core.workflow.action.QuicPathChallengeAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveQuicTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChCiphersAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChExtensionsAction;
import de.rub.nds.tlsattacker.core.workflow.action.RenegotiationAction;
import de.rub.nds.tlsattacker.core.workflow.action.ResetConnectionAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerCertificateAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowConfigurationFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Config config;
    private RunningModeType mode;

    public WorkflowConfigurationFactory(Config config) {
        this.config = config;
    }

    public WorkflowTrace createWorkflowTrace(WorkflowTraceType type, RunningModeType mode) {
        this.mode = mode;
        if (type == null) {
            throw new RuntimeException("Cannot create WorkflowTrace from NULL type");
        }
        switch (type) {
            case HELLO: {
                return this.createHelloWorkflow();
            }
            case FULL: {
                return this.createFullWorkflow();
            }
            case HANDSHAKE: {
                return this.createHandshakeWorkflow();
            }
            case SHORT_HELLO: {
                return this.createShortHelloWorkflow();
            }
            case SSL2_HELLO: {
                return this.createSsl2HelloWorkflow();
            }
            case CLIENT_RENEGOTIATION_WITHOUT_RESUMPTION: {
                return this.createClientRenegotiationWorkflow();
            }
            case CLIENT_RENEGOTIATION: {
                return this.createClientRenegotiationWithResumptionWorkflow();
            }
            case SERVER_RENEGOTIATION: {
                return this.createServerRenegotiationWorkflow();
            }
            case DYNAMIC_CLIENT_RENEGOTIATION_WITHOUT_RESUMPTION: {
                return this.createDynamicClientRenegotiationWithoutResumption();
            }
            case HTTPS: {
                return this.createHttpsWorkflow();
            }
            case RESUMPTION: {
                return this.createResumptionWorkflow();
            }
            case FULL_RESUMPTION: {
                return this.createFullResumptionWorkflow();
            }
            case SIMPLE_MITM_PROXY: {
                return this.createSimpleMitmProxyWorkflow();
            }
            case SIMPLE_FORWARDING_MITM_PROXY: {
                return this.createSimpleForwardingMitmProxyWorkflow();
            }
            case TLS13_PSK: {
                return this.createTls13PskWorkflow(false);
            }
            case FULL_TLS13_PSK: {
                return this.createFullTls13PskWorkflow(false);
            }
            case ZERO_RTT: {
                return this.createTls13PskWorkflow(true);
            }
            case FULL_ZERO_RTT: {
                return this.createFullTls13PskWorkflow(true);
            }
            case FALSE_START: {
                return this.createFalseStartWorkflow();
            }
            case RSA_SYNC_PROXY: {
                return this.createSyncProxyWorkflow();
            }
            case DYNAMIC_HANDSHAKE: {
                return this.createDynamicHandshakeWorkflow();
            }
            case DYNAMIC_HELLO: {
                return this.createDynamicHelloWorkflow();
            }
            case DYNAMIC_HTTPS: {
                return this.createHttpsDynamicWorkflow();
            }
            case QUIC_VERSION_NEGOTIATION: {
                return this.createQuicVersionNegotiationWorkflow();
            }
            case QUIC_PORT_CONNECTION_MIGRATION: {
                return this.createQuicConnectionMigrationWorkflow(false);
            }
            case QUIC_IPV6_CONNECTION_MIGRATION: {
                return this.createQuicConnectionMigrationWorkflow(true);
            }
        }
        throw new ConfigurationException("Unknown WorkflowTraceType " + type.name());
    }

    private AliasedConnection getConnection() {
        AliasedConnection con = null;
        if (this.mode == null) {
            throw new ConfigurationException("Running mode not set, can't configure workflow");
        }
        switch (this.mode) {
            case CLIENT: {
                con = this.config.getDefaultClientConnection();
                break;
            }
            case SERVER: {
                con = this.config.getDefaultServerConnection();
                break;
            }
            default: {
                throw new ConfigurationException("This workflow can only be configured for modes CLIENT and SERVER, but actual mode was " + String.valueOf((Object)this.mode));
            }
        }
        return con;
    }

    public WorkflowTrace createTlsEntryWorkflowTrace(AliasedConnection connection) {
        WorkflowTrace workflowTrace = new WorkflowTrace();
        if (this.config.getStarttlsType() != StarttlsType.NONE) {
            this.addStartTlsActions(connection, this.config.getStarttlsType(), workflowTrace);
        }
        if (this.config.getQuicRetryFlowRequired().booleanValue()) {
            workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
            workflowTrace.addTlsAction(MessageActionFactory.createQuicAction(this.config, connection, ConnectionEndType.SERVER, new RetryPacket()));
        }
        return workflowTrace;
    }

    private WorkflowTrace createShortHelloWorkflow() {
        return this.createShortHelloWorkflow(this.getConnection());
    }

    public WorkflowTrace createShortHelloWorkflow(AliasedConnection connection) {
        WorkflowTrace workflowTrace = this.createTlsEntryWorkflowTrace(connection);
        if (this.config.isAddEncryptedServerNameIndicationExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            workflowTrace.addTlsAction(new EsniKeyDnsRequestAction());
        }
        if (this.config.isAddEncryptedClientHelloExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            workflowTrace.addTlsAction(new EchConfigDnsRequestAction());
        }
        workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, this.generateClientHelloMessage(this.config, connection)));
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isDtlsCookieExchange().booleanValue()) {
            if (this.config.getHighestProtocolVersion().isDTLS13()) {
                ServerHelloMessage serverHelloMessage = new ServerHelloMessage(this.config, true);
                serverHelloMessage.addExtension(new CookieExtensionMessage());
                workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, serverHelloMessage));
            } else {
                workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new HelloVerifyRequestMessage()));
            }
            CoreClientHelloMessage clientHello = this.generateClientHelloMessage(this.config, connection);
            if (this.config.getHighestProtocolVersion().isDTLS13() && this.config.isDtlsCookieExchange().booleanValue() && !clientHello.getExtensions().contains(CookieExtensionMessage.class)) {
                clientHello.addExtension(new CookieExtensionMessage());
            }
            workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, clientHello));
        }
        workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new ServerHelloMessage(this.config)));
        return workflowTrace;
    }

    private WorkflowTrace createHelloWorkflow() {
        return this.createHelloWorkflow(this.getConnection());
    }

    public WorkflowTrace createHelloWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createShortHelloWorkflow(connection);
        trace.removeTlsAction(trace.getTlsActions().size() - 1);
        CipherSuite selectedCipherSuite = this.config.getDefaultSelectedCipherSuite();
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        messages.add(new ServerHelloMessage(this.config));
        if (this.config.getHighestProtocolVersion().isTLS13() && (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT)) {
            ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
            ccs.setRequired(false);
            messages.add(ccs);
        }
        if (this.config.getHighestProtocolVersion().is13()) {
            messages.add(new EncryptedExtensionsMessage(this.config));
            if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                messages.add(new CertificateRequestMessage(this.config));
            }
            if (!selectedCipherSuite.isPWD()) {
                messages.add(new CertificateMessage());
                messages.add(new CertificateVerifyMessage());
            }
            messages.add(new FinishedMessage());
        } else {
            if (selectedCipherSuite.requiresServerCertificateMessage()) {
                messages.add(new CertificateMessage());
            }
            this.addServerKeyExchangeMessage(messages);
            if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                messages.add(new CertificateRequestMessage(this.config));
            }
            messages.add(new ServerHelloDoneMessage());
        }
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, messages));
        return trace;
    }

    private WorkflowTrace createHandshakeWorkflow() {
        return this.createHandshakeWorkflow(this.getConnection());
    }

    public WorkflowTrace createHandshakeWorkflow(AliasedConnection connection) {
        WorkflowTrace workflowTrace = this.createHelloWorkflow(connection);
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        if (this.config.getHighestProtocolVersion().isTLS13() && (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.SERVER)) {
            ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
            ccs.setRequired(false);
            messages.add(ccs);
        }
        if (this.config.getHighestProtocolVersion().is13()) {
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateMessage());
                messages.add(new CertificateVerifyMessage());
            }
        } else {
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateMessage());
                this.addClientKeyExchangeMessage(messages);
                messages.add(new CertificateVerifyMessage());
            } else {
                this.addClientKeyExchangeMessage(messages);
            }
            messages.add(new ChangeCipherSpecMessage());
        }
        messages.add(new FinishedMessage());
        workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, messages));
        if (!this.config.getHighestProtocolVersion().is13()) {
            workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new ChangeCipherSpecMessage(), new FinishedMessage()));
        }
        if (this.config.getHighestProtocolVersion().isDTLS13()) {
            workflowTrace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new AckMessage()));
        }
        if (this.config.getExpectHandshakeDoneQuicFrame().booleanValue()) {
            workflowTrace.addTlsAction(new ReceiveQuicTillAction(new HandshakeDoneFrame()));
        }
        return workflowTrace;
    }

    private WorkflowTrace createFullWorkflow() {
        return this.createFullWorkflow(this.getConnection());
    }

    public WorkflowTrace createFullWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createHandshakeWorkflow(connection);
        if (this.config.isServerSendsApplicationData().booleanValue()) {
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new ApplicationMessage()));
        }
        if (this.config.isAddHeartbeatExtension().booleanValue()) {
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ApplicationMessage(), new HeartbeatMessage()));
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new HeartbeatMessage()));
        } else {
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ApplicationMessage()));
        }
        return trace;
    }

    private WorkflowTrace createFalseStartWorkflow() {
        return this.createFalseStartWorkflow(this.getConnection());
    }

    private WorkflowTrace createFalseStartWorkflow(AliasedConnection connection) {
        if (this.config.getHighestProtocolVersion().is13()) {
            throw new ConfigurationException("The false start workflow is not implemented for (D)TLS 1.3");
        }
        WorkflowTrace workflowTrace = this.createHandshakeWorkflow(connection);
        MessageAction appData = MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ApplicationMessage());
        TlsAction lastClientAction = connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT ? (TlsAction)((Object)workflowTrace.getLastSendingAction()) : (TlsAction)((Object)workflowTrace.getLastReceivingAction());
        int i = workflowTrace.getTlsActions().indexOf(lastClientAction);
        workflowTrace.addTlsAction(i + 1, appData);
        return workflowTrace;
    }

    private WorkflowTrace createSsl2HelloWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        MessageAction action = MessageActionFactory.createSSL2Action(this.config, connection, ConnectionEndType.CLIENT, new SSL2ClientHelloMessage());
        trace.addTlsAction(action);
        action = MessageActionFactory.createSSL2Action(this.config, connection, ConnectionEndType.SERVER, new SSL2ServerHelloMessage());
        trace.addTlsAction(action);
        return trace;
    }

    private WorkflowTrace createFullResumptionWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isFinishWithCloseNotify().booleanValue()) {
            AlertMessage alert = new AlertMessage();
            alert.setConfig(AlertLevel.WARNING, AlertDescription.CLOSE_NOTIFY);
            trace.addTlsAction(new SendAction(alert));
        }
        trace.addTlsAction(new ResetConnectionAction());
        WorkflowTrace tempTrace = this.createResumptionWorkflow();
        for (TlsAction resumption : tempTrace.getTlsActions()) {
            trace.addTlsAction(resumption);
        }
        return trace;
    }

    private WorkflowTrace createResumptionWorkflow() {
        return this.createResumptionWorkflow(this.getConnection());
    }

    public WorkflowTrace createResumptionWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createTlsEntryWorkflowTrace(connection);
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, this.generateClientHelloMessage(this.config, connection)));
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isDtlsCookieExchange().booleanValue()) {
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new HelloVerifyRequestMessage()));
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, this.generateClientHelloMessage(this.config, connection)));
        }
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new ServerHelloMessage(this.config), new ChangeCipherSpecMessage(), new FinishedMessage()));
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ChangeCipherSpecMessage(), new FinishedMessage()));
        return trace;
    }

    private WorkflowTrace createClientRenegotiationWithResumptionWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        trace.addTlsAction(new RenegotiationAction());
        WorkflowTrace renegotiationTrace = this.createResumptionWorkflow();
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            if (!reneAction.isMessageAction()) continue;
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createClientRenegotiationWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        trace.addTlsAction(new RenegotiationAction());
        trace.addTlsAction(new FlushSessionCacheAction());
        WorkflowTrace renegotiationTrace = this.createHandshakeWorkflow(conEnd);
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            if (!reneAction.isMessageAction()) continue;
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createServerRenegotiationWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(connection);
        WorkflowTrace renegotiationTrace = this.createHandshakeWorkflow(connection);
        trace.addTlsAction(new RenegotiationAction());
        MessageAction action = MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new HelloRequestMessage());
        trace.addTlsAction(action);
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            if (!reneAction.isMessageAction()) continue;
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createHttpsWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(connection);
        this.appendHttpMessages(connection, trace);
        return trace;
    }

    private WorkflowTrace createHttpsDynamicWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = this.createDynamicHandshakeWorkflow();
        this.appendHttpMessages(connection, trace);
        return trace;
    }

    public void appendHttpMessages(AliasedConnection connection, WorkflowTrace trace) {
        MessageAction action = MessageActionFactory.createHttpAction(this.config, connection, ConnectionEndType.CLIENT, new HttpRequestMessage(this.config));
        trace.addTlsAction(action);
        action = MessageActionFactory.createHttpAction(this.config, connection, ConnectionEndType.SERVER, new HttpResponseMessage());
        trace.addTlsAction(action);
    }

    private WorkflowTrace createSimpleMitmProxyWorkflow() {
        if (this.mode != RunningModeType.MITM) {
            throw new ConfigurationException("This workflow trace can only be created when running in MITM mode. Actual mode: " + String.valueOf((Object)this.mode));
        }
        InboundConnection inboundConnection = this.config.getDefaultServerConnection();
        OutboundConnection outboundConnection = this.config.getDefaultClientConnection();
        if (outboundConnection == null || inboundConnection == null) {
            throw new ConfigurationException("Could not find both necessary connection ends");
        }
        String clientToMitmAlias = inboundConnection.getAlias();
        String mitmToServerAlias = outboundConnection.getAlias();
        LOGGER.debug("Building mitm trace for: {}, {}", (Object)inboundConnection, (Object)outboundConnection);
        WorkflowTrace clientToMitmHandshake = this.createHandshakeWorkflow(inboundConnection);
        WorkflowTrace mitmToServerHandshake = this.createHandshakeWorkflow(outboundConnection);
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace worklfowTrace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        worklfowTrace.addConnection(inboundConnection);
        worklfowTrace.addConnection(outboundConnection);
        worklfowTrace.addTlsActions(clientToMitmHandshake.getTlsActions());
        worklfowTrace.addTlsActions(mitmToServerHandshake.getTlsActions());
        ForwardMessagesAction f = new ForwardMessagesAction(clientToMitmAlias, mitmToServerAlias, new ApplicationMessage());
        worklfowTrace.addTlsAction(f);
        PrintLastHandledApplicationDataAction p = new PrintLastHandledApplicationDataAction(clientToMitmAlias);
        p.setStringEncoding("US-ASCII");
        worklfowTrace.addTlsAction(p);
        f = new ForwardMessagesAction(mitmToServerAlias, clientToMitmAlias, new ApplicationMessage());
        worklfowTrace.addTlsAction(f);
        p = new PrintLastHandledApplicationDataAction(mitmToServerAlias);
        p.setStringEncoding("US-ASCII");
        worklfowTrace.addTlsAction(p);
        return worklfowTrace;
    }

    private WorkflowTrace createSimpleForwardingMitmProxyWorkflow() {
        if (this.mode != RunningModeType.MITM) {
            throw new ConfigurationException("This workflow trace can only be created when running in MITM mode. Actual mode: " + String.valueOf((Object)this.mode));
        }
        InboundConnection inboundConnection = this.config.getDefaultServerConnection();
        OutboundConnection outboundConnection = this.config.getDefaultClientConnection();
        if (outboundConnection == null || inboundConnection == null) {
            throw new ConfigurationException("Could not find both necessary connection ends");
        }
        String clientToMitmAlias = inboundConnection.getAlias();
        String mitmToServerAlias = outboundConnection.getAlias();
        LOGGER.debug("Building mitm trace for: {}, {}", (Object)inboundConnection, (Object)outboundConnection);
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        trace.addConnection(inboundConnection);
        trace.addConnection(outboundConnection);
        ForwardRecordsAction forwardRecordsAction = new ForwardRecordsAction(clientToMitmAlias, mitmToServerAlias, new Record[0]);
        trace.addTlsAction(forwardRecordsAction);
        ForwardRecordsAction forwardRecordsAction2 = new ForwardRecordsAction(mitmToServerAlias, clientToMitmAlias, new Record[0]);
        trace.addTlsAction(forwardRecordsAction2);
        ForwardRecordsAction forwardRecordsAction3 = new ForwardRecordsAction(clientToMitmAlias, mitmToServerAlias, new Record[0]);
        trace.addTlsAction(forwardRecordsAction3);
        ForwardRecordsAction forwardRecordsAction4 = new ForwardRecordsAction(mitmToServerAlias, clientToMitmAlias, new Record[0]);
        trace.addTlsAction(forwardRecordsAction4);
        return trace;
    }

    private WorkflowTrace createTls13PskWorkflow(boolean zeroRtt) {
        ApplicationMessage earlyDataMsg;
        CoreClientHelloMessage clientHello;
        AliasedConnection connection = this.getConnection();
        ChangeCipherSpecMessage ccsServer = new ChangeCipherSpecMessage();
        ChangeCipherSpecMessage ccsClient = new ChangeCipherSpecMessage();
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            ccsServer.setRequired(false);
        } else {
            ccsClient.setRequired(false);
        }
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        LinkedList<ProtocolMessage> clientHelloMessages = new LinkedList<ProtocolMessage>();
        LinkedList<ProtocolMessage> serverMessages = new LinkedList<ProtocolMessage>();
        LinkedList<ProtocolMessage> clientMessages = new LinkedList<ProtocolMessage>();
        FinishedMessage serverFin = new FinishedMessage();
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            clientHello = this.generateClientHelloMessage(this.config, connection);
            earlyDataMsg = new ApplicationMessage();
            earlyDataMsg.setDataConfig(this.config.getEarlyData());
        } else {
            clientHello = this.generateClientHelloMessage(this.config, connection);
            earlyDataMsg = new ApplicationMessage();
        }
        clientHelloMessages.add(clientHello);
        if (zeroRtt) {
            if ((Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.SERVER) && !this.config.getHighestProtocolVersion().isDTLS13()) {
                clientHelloMessages.add(ccsClient);
            }
            clientHelloMessages.add(earlyDataMsg);
        }
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, clientHelloMessages));
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isDtlsCookieExchange().booleanValue()) {
            ServerHelloMessage serverHelloMessage = new ServerHelloMessage(this.config, true);
            serverHelloMessage.addExtension(new CookieExtensionMessage());
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, serverHelloMessage));
            ClientHelloMessage clientHelloMessage = new ClientHelloMessage(this.config);
            clientHelloMessage.addExtension(new CookieExtensionMessage());
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, clientHelloMessage));
        }
        ServerHelloMessage serverHello = new ServerHelloMessage(this.config);
        serverMessages.add(serverHello);
        EncryptedExtensionsMessage encExtMsg = new EncryptedExtensionsMessage(this.config);
        if (zeroRtt) {
            encExtMsg.addExtension(new EarlyDataExtensionMessage());
        }
        if ((Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) && !this.config.getHighestProtocolVersion().isDTLS13()) {
            serverMessages.add(ccsServer);
        }
        if (!(zeroRtt || !Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) && connection.getLocalConnectionEndType() != ConnectionEndType.SERVER || this.config.getHighestProtocolVersion().isDTLS13())) {
            clientMessages.add(ccsClient);
        }
        serverMessages.add(encExtMsg);
        serverMessages.add(serverFin);
        MessageAction serverMsgsAction = MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, serverMessages);
        serverMsgsAction.addActionOption(ActionOption.IGNORE_UNEXPECTED_NEW_SESSION_TICKETS);
        trace.addTlsAction(serverMsgsAction);
        if (zeroRtt && !this.config.getQuic().booleanValue()) {
            clientMessages.add(new EndOfEarlyDataMessage());
        }
        clientMessages.add(new FinishedMessage());
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, clientMessages));
        if (this.config.getHighestProtocolVersion().isDTLS13()) {
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new AckMessage()));
        }
        return trace;
    }

    private WorkflowTrace createFullTls13PskWorkflow(boolean zeroRtt) {
        MessageAction newSessionTicketAction;
        AliasedConnection ourConnection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow();
        if (ourConnection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            List<ProtocolMessage> clientHellos = WorkflowTraceConfigurationUtil.getStaticConfiguredSendMessages(trace, HandshakeMessageType.CLIENT_HELLO);
            for (ProtocolMessage handshakeMessage : clientHellos) {
                ClientHelloMessage clientHello = (ClientHelloMessage)handshakeMessage;
                if (clientHello.getExtensions() == null) continue;
                EarlyDataExtensionMessage earlyDataExtension = clientHello.getExtension(EarlyDataExtensionMessage.class);
                clientHello.getExtensions().remove(earlyDataExtension);
                PreSharedKeyExtensionMessage pskExtension = clientHello.getExtension(PreSharedKeyExtensionMessage.class);
                clientHello.getExtensions().remove(pskExtension);
            }
        } else {
            EncryptedExtensionsMessage encryptedExtensionsMessage;
            ServerHelloMessage serverHello = (ServerHelloMessage)WorkflowTraceConfigurationUtil.getFirstStaticConfiguredSendMessage(trace, HandshakeMessageType.SERVER_HELLO);
            if (serverHello.getExtensions() != null) {
                PreSharedKeyExtensionMessage pskExtension = serverHello.getExtension(PreSharedKeyExtensionMessage.class);
                serverHello.getExtensions().remove(pskExtension);
            }
            if ((encryptedExtensionsMessage = (EncryptedExtensionsMessage)WorkflowTraceConfigurationUtil.getFirstStaticConfiguredSendMessage(trace, HandshakeMessageType.ENCRYPTED_EXTENSIONS)) != null && encryptedExtensionsMessage.getExtensions() != null) {
                EarlyDataExtensionMessage earlyDataExtension = encryptedExtensionsMessage.getExtension(EarlyDataExtensionMessage.class);
                encryptedExtensionsMessage.getExtensions().remove(earlyDataExtension);
            }
        }
        if ((newSessionTicketAction = MessageActionFactory.createTLSAction(this.config, ourConnection, ConnectionEndType.SERVER, new NewSessionTicketMessage(this.config, false))) instanceof ReceiveAction) {
            newSessionTicketAction.getActionOptions().add(ActionOption.IGNORE_UNEXPECTED_NEW_SESSION_TICKETS);
        }
        trace.addTlsAction(newSessionTicketAction);
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isFinishWithCloseNotify().booleanValue()) {
            AlertMessage alert = new AlertMessage();
            alert.setConfig(AlertLevel.WARNING, AlertDescription.CLOSE_NOTIFY);
            trace.addTlsAction(new SendAction(alert));
        }
        if (this.config.getQuic().booleanValue()) {
            trace.addTlsAction(MessageActionFactory.createQuicAction(this.config, ourConnection, ConnectionEndType.CLIENT, new ConnectionCloseFrame(QuicTransportErrorCodes.NO_ERROR.getValue())));
        }
        trace.addTlsAction(new ResetConnectionAction());
        WorkflowTrace zeroRttTrace = this.createTls13PskWorkflow(zeroRtt);
        for (TlsAction zeroRttAction : zeroRttTrace.getTlsActions()) {
            trace.addTlsAction(zeroRttAction);
        }
        return trace;
    }

    private WorkflowTrace createSyncProxyWorkflow() {
        if (this.mode != RunningModeType.MITM) {
            throw new ConfigurationException("This workflow trace can only be created when running in MITM mode. Actual mode: " + String.valueOf((Object)this.mode));
        }
        InboundConnection inboundConnection = this.config.getDefaultServerConnection();
        String clientToMitmAlias = inboundConnection.getAlias();
        OutboundConnection outboundConnection = this.config.getDefaultClientConnection();
        String mitmToServerAlias = outboundConnection.getAlias();
        if (outboundConnection == null || inboundConnection == null) {
            throw new ConfigurationException("Could not find both necessary connection ends");
        }
        LOGGER.info("Building synchronizing proxy trace for:\n{}, {}", (Object)((AliasedConnection)inboundConnection).toCompactString(), (Object)((AliasedConnection)outboundConnection).toCompactString());
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowTrace(this.config.getDefaultClientConnection());
        trace.addConnection(inboundConnection);
        trace.addConnection(outboundConnection);
        List<CipherSuite> removeCiphers = CipherSuite.getImplemented();
        removeCiphers.addAll(CipherSuite.getNotImplemented());
        ArrayList<CipherSuite> keepCiphers = new ArrayList<CipherSuite>();
        for (CipherSuite cs : removeCiphers) {
            if (!cs.name().startsWith("TLS_RSA")) continue;
            keepCiphers.add(cs);
        }
        removeCiphers.removeAll(keepCiphers);
        List<ExtensionType> removeExtensions = ExtensionType.getReceivable();
        ArrayList keepExtensions = new ArrayList();
        removeExtensions.removeAll(keepExtensions);
        trace.addTlsActions(new BufferedGenericReceiveAction(clientToMitmAlias), new CopyBuffersAction(clientToMitmAlias, mitmToServerAlias), new RemBufferedChCiphersAction(mitmToServerAlias, removeCiphers), new RemBufferedChExtensionsAction(mitmToServerAlias, removeExtensions), new BufferedSendAction(mitmToServerAlias), new ClearBuffersAction(clientToMitmAlias), new BufferedGenericReceiveAction(mitmToServerAlias), new CopyBuffersAction(mitmToServerAlias, clientToMitmAlias), new PopAndSendAction(clientToMitmAlias), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new PopBufferedMessageAction(clientToMitmAlias), new PopBufferedRecordAction(clientToMitmAlias), new SendAction(clientToMitmAlias, new CertificateMessage()), new PopAndSendAction(clientToMitmAlias), new ClearBuffersAction(mitmToServerAlias), new BufferedGenericReceiveAction(clientToMitmAlias), new CopyBuffersAction(clientToMitmAlias, mitmToServerAlias), new PopBuffersAction(mitmToServerAlias), new CopyPreMasterSecretAction(clientToMitmAlias, mitmToServerAlias), new SendAction(mitmToServerAlias, new RSAClientKeyExchangeMessage()), new PopAndSendAction(mitmToServerAlias), new ClearBuffersAction(mitmToServerAlias), new ClearBuffersAction(clientToMitmAlias), new SendAction(mitmToServerAlias, new FinishedMessage()), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new ReceiveAction(mitmToServerAlias, new ChangeCipherSpecMessage(), new FinishedMessage()), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new SendAction(clientToMitmAlias, new ChangeCipherSpecMessage(), new FinishedMessage()), new ForwardDataAction(clientToMitmAlias, mitmToServerAlias), new ForwardDataAction(mitmToServerAlias, clientToMitmAlias));
        return trace;
    }

    public ClientKeyExchangeMessage createClientKeyExchangeMessage(KeyExchangeAlgorithm algorithm) {
        if (algorithm != null) {
            switch (algorithm) {
                case RSA: 
                case RSA_EXPORT: {
                    return new RSAClientKeyExchangeMessage();
                }
                case ECDHE_ECDSA: 
                case ECDH_ECDSA: 
                case ECDH_RSA: 
                case ECDHE_RSA: 
                case ECDH_ANON: {
                    return new ECDHClientKeyExchangeMessage();
                }
                case DHE_DSS: 
                case DHE_RSA: 
                case DH_ANON: 
                case DH_DSS: 
                case DH_RSA: {
                    return new DHClientKeyExchangeMessage();
                }
                case PSK: {
                    return new PskClientKeyExchangeMessage();
                }
                case DHE_PSK: {
                    return new PskDhClientKeyExchangeMessage();
                }
                case ECDHE_PSK: {
                    return new PskEcDhClientKeyExchangeMessage();
                }
                case RSA_PSK: {
                    return new PskRsaClientKeyExchangeMessage();
                }
                case SRP_SHA_DSS: 
                case SRP_SHA_RSA: 
                case SRP_SHA: {
                    return new SrpClientKeyExchangeMessage();
                }
                case VKO_GOST01: 
                case VKO_GOST12: {
                    return new GOSTClientKeyExchangeMessage();
                }
                case ECCPWD: {
                    return new PWDClientKeyExchangeMessage();
                }
            }
            LOGGER.warn("Unsupported key exchange algorithm: '{}', not creating ClientKeyExchange Message", (Object)algorithm);
        } else {
            LOGGER.warn("Unsupported key exchange algorithm: 'null', not creating ClientKeyExchange Message");
        }
        return null;
    }

    public ServerKeyExchangeMessage createServerKeyExchangeMessage(KeyExchangeAlgorithm algorithm) {
        if (algorithm != null) {
            switch (algorithm) {
                case RSA: 
                case DH_DSS: 
                case DH_RSA: {
                    return null;
                }
                case ECDHE_ECDSA: 
                case ECDHE_RSA: 
                case ECDH_ANON: {
                    return new ECDHEServerKeyExchangeMessage();
                }
                case DHE_DSS: 
                case DHE_RSA: 
                case DH_ANON: {
                    return new DHEServerKeyExchangeMessage();
                }
                case PSK: {
                    return new PskServerKeyExchangeMessage();
                }
                case DHE_PSK: {
                    return new PskDheServerKeyExchangeMessage();
                }
                case ECDHE_PSK: {
                    return new PskEcDheServerKeyExchangeMessage();
                }
                case SRP_SHA_DSS: 
                case SRP_SHA_RSA: 
                case SRP_SHA: {
                    return new SrpServerKeyExchangeMessage();
                }
                case ECCPWD: {
                    return new PWDServerKeyExchangeMessage();
                }
                case RSA_EXPORT: {
                    return new RSAServerKeyExchangeMessage();
                }
            }
            LOGGER.warn("Unsupported key exchange algorithm: '{}', not creating ServerKeyExchange Message", (Object)algorithm);
        } else {
            LOGGER.warn("Unsupported key exchange algorithm: 'null', not creating ServerKeyExchange Message");
        }
        return null;
    }

    public void addClientKeyExchangeMessage(List<ProtocolMessage> messages) {
        CipherSuite cs = this.config.getDefaultSelectedCipherSuite();
        ClientKeyExchangeMessage message = this.createClientKeyExchangeMessage(cs.getKeyExchangeAlgorithm());
        if (message != null) {
            messages.add(message);
        }
    }

    public void addServerKeyExchangeMessage(List<ProtocolMessage> messages) {
        CipherSuite cs = this.config.getDefaultSelectedCipherSuite();
        ServerKeyExchangeMessage message = this.createServerKeyExchangeMessage(cs.getKeyExchangeAlgorithm());
        if (message != null) {
            messages.add(message);
        }
    }

    public WorkflowTrace addStartTlsActions(AliasedConnection connection, StarttlsType type, WorkflowTrace workflowTrace) {
        return null;
    }

    private WorkflowTrace createDynamicHelloWorkflow() {
        return this.createDynamicHelloWorkflow(this.getConnection());
    }

    public WorkflowTrace createDynamicHelloWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createTlsEntryWorkflowTrace(connection);
        if (this.config.isAddEncryptedServerNameIndicationExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            trace.addTlsAction(new EsniKeyDnsRequestAction());
        }
        if (this.config.isAddEncryptedClientHelloExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            trace.addTlsAction(new EchConfigDnsRequestAction());
        }
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, this.generateClientHelloMessage(this.config, connection)));
        if (this.config.getHighestProtocolVersion().isDTLS() && this.config.isDtlsCookieExchange().booleanValue()) {
            if (this.config.getHighestProtocolVersion().isDTLS13()) {
                ServerHelloMessage serverHelloMessage = new ServerHelloMessage(this.config, true);
                serverHelloMessage.addExtension(new CookieExtensionMessage());
                trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, serverHelloMessage));
            } else {
                trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, new HelloVerifyRequestMessage()));
            }
            CoreClientHelloMessage clientHello = this.generateClientHelloMessage(this.config, connection);
            if (this.config.getHighestProtocolVersion().isDTLS13() && this.config.isDtlsCookieExchange().booleanValue() && !clientHello.getExtensions().contains(CookieExtensionMessage.class)) {
                clientHello.addExtension(new CookieExtensionMessage());
            }
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, clientHello));
        }
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            if (this.config.getHighestProtocolVersion().is13()) {
                trace.addTlsAction(new ReceiveTillAction(new FinishedMessage()));
            } else {
                trace.addTlsAction(new ReceiveTillAction(new ServerHelloDoneMessage()));
            }
            return trace;
        }
        if (this.config.getHighestProtocolVersion().is13()) {
            LinkedList<ProtocolMessage> tls13Messages = new LinkedList<ProtocolMessage>();
            tls13Messages.add(new ServerHelloMessage(this.config));
            if (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) && !this.config.getHighestProtocolVersion().isDTLS13()) {
                ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
                ccs.setRequired(false);
                tls13Messages.add(ccs);
            }
            tls13Messages.add(new EncryptedExtensionsMessage(this.config));
            if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                tls13Messages.add(new CertificateRequestMessage(this.config));
            }
            tls13Messages.add(new CertificateMessage());
            tls13Messages.add(new CertificateVerifyMessage());
            tls13Messages.add(new FinishedMessage());
            trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.SERVER, tls13Messages));
        } else {
            trace.addTlsAction(new SendAction(new ServerHelloMessage(this.config)));
            trace.addTlsAction(new SendDynamicServerCertificateAction());
            trace.addTlsAction(new SendDynamicServerKeyExchangeAction());
            if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                trace.addTlsAction(new SendAction(new CertificateRequestMessage(this.config)));
            }
            trace.addTlsAction(new SendAction(new ServerHelloDoneMessage()));
        }
        return trace;
    }

    private WorkflowTrace createDynamicHandshakeWorkflow() {
        return this.createDynamicHandshakeWorkflow(this.getConnection());
    }

    public WorkflowTrace createDynamicHandshakeWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createDynamicHelloWorkflow(connection);
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            if (this.config.getHighestProtocolVersion().is13()) {
                LinkedList<ProtocolMessage> tls13Messages = new LinkedList<ProtocolMessage>();
                if (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) && !this.config.getHighestProtocolVersion().isDTLS13()) {
                    ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
                    ccs.setRequired(false);
                    tls13Messages.add(ccs);
                }
                if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                    tls13Messages.add(new CertificateMessage());
                    tls13Messages.add(new CertificateVerifyMessage());
                }
                tls13Messages.add(new FinishedMessage());
                trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, tls13Messages));
                if (this.config.getExpectHandshakeDoneQuicFrame().booleanValue()) {
                    trace.addTlsAction(new ReceiveQuicTillAction(new HandshakeDoneFrame()));
                }
                if (this.config.getHighestProtocolVersion().isDTLS13()) {
                    trace.addTlsAction(new ReceiveAction(new AckMessage()));
                }
            } else {
                if (Objects.equals(this.config.isClientAuthentication(), Boolean.TRUE)) {
                    trace.addTlsAction(new SendAction(new CertificateMessage()));
                    trace.addTlsAction(new SendDynamicClientKeyExchangeAction());
                    trace.addTlsAction(new SendAction(new CertificateVerifyMessage()));
                } else {
                    trace.addTlsAction(new SendDynamicClientKeyExchangeAction());
                }
                trace.addTlsAction(new SendAction(new ChangeCipherSpecMessage(), new FinishedMessage()));
                trace.addTlsAction(new ReceiveTillAction(new FinishedMessage()));
            }
            return trace;
        }
        trace.addTlsAction(new ReceiveTillAction(new FinishedMessage()));
        if (this.config.getHighestProtocolVersion().isDTLS13()) {
            trace.addTlsAction(new SendAction(new AckMessage()));
        } else {
            trace.addTlsAction(new SendAction(new ChangeCipherSpecMessage(), new FinishedMessage()));
        }
        return trace;
    }

    private WorkflowTrace createQuicVersionNegotiationWorkflow() {
        return this.createQuicVersionNegotiationWorkflow(this.getConnection());
    }

    public WorkflowTrace createQuicVersionNegotiationWorkflow(AliasedConnection connection) {
        WorkflowTrace trace = this.createTlsEntryWorkflowTrace(connection);
        trace.addTlsAction(MessageActionFactory.createTLSAction(this.config, connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        trace.addTlsAction(new ReceiveAction(new VersionNegotiationPacket()));
        return trace;
    }

    private WorkflowTrace createQuicConnectionMigrationWorkflow(boolean switchToIPv6) {
        return this.createQuicConnectionMigrationWorkflow(this.getConnection(), switchToIPv6);
    }

    public WorkflowTrace createQuicConnectionMigrationWorkflow(AliasedConnection connection, boolean switchToIPv6) {
        WorkflowTrace trace = this.createDynamicHandshakeWorkflow();
        trace.addTlsAction(new ResetConnectionAction(false, switchToIPv6));
        trace.addTlsAction(MessageActionFactory.createQuicAction(this.config, connection, ConnectionEndType.CLIENT, new PingFrame()));
        QuicPathChallengeAction pathChallengeAction = new QuicPathChallengeAction(connection.getAlias(), false);
        trace.addTlsAction(pathChallengeAction);
        trace.addTlsAction(MessageActionFactory.createQuicAction(this.config, connection, ConnectionEndType.CLIENT, new PingFrame()));
        trace.addTlsAction(MessageActionFactory.createQuicAction(this.config, connection, ConnectionEndType.SERVER, new AckFrame(false)));
        return trace;
    }

    private WorkflowTrace createDynamicClientRenegotiationWithoutResumption() {
        WorkflowTrace trace = this.createDynamicHandshakeWorkflow();
        trace.addTlsAction(new RenegotiationAction());
        trace.addTlsAction(new FlushSessionCacheAction());
        WorkflowTrace renegotiationTrace = this.createDynamicHandshakeWorkflow();
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            if (!reneAction.isMessageAction()) continue;
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private CoreClientHelloMessage generateClientHelloMessage(Config tlsConfig, AliasedConnection connection) {
        if (this.config.isAddEncryptedClientHelloExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            return new EncryptedClientHelloMessage(this.config);
        }
        return new ClientHelloMessage(this.config);
    }
}

