/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.modifiableVariable;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableHolder;
import de.rub.nds.modifiablevariable.util.ModifiableVariableAnalyzer;
import de.rub.nds.modifiablevariable.util.ModifiableVariableField;
import de.rub.nds.modifiablevariable.util.ModifiableVariableListHolder;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.modifiablevariable.util.ReflectionHelper;
import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceConfigurationUtil;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceResultUtil;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModvarHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Random random = RandomHelper.getRandom();

    public ModifiableVariableField pickRandomField(List<ModifiableVariableField> fields) {
        int fieldNumber = this.random.nextInt(fields.size());
        return fields.get(fieldNumber);
    }

    public List<ModifiableVariableField> getAllNonNullSentFieldsOfType(WorkflowTrace trace, Class<?> type) {
        List<ModifiableVariableField> allNonNullSentFields = this.getAllNonNullSentFields(trace);
        LinkedList<ModifiableVariableField> resultFields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableField field : allNonNullSentFields) {
            try {
                if (!field.getModifiableVariable().getClass().equals(type)) continue;
                resultFields.add(field);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Could not retrieved Modvar");
                LOGGER.debug((Object)ex);
            }
        }
        return resultFields;
    }

    public List<ModifiableVariableField> getAllNonNullSentFields(WorkflowTrace trace) {
        List<ModifiableVariableListHolder> holderList = this.getStaticallyConfiguredSendModifiableVariableHoldersRecursively(trace);
        LinkedList<ModifiableVariableField> allFields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableListHolder holder : holderList) {
            for (Field field : holder.getFields()) {
                allFields.add(new ModifiableVariableField(holder.getObject(), field));
            }
        }
        LinkedList<ModifiableVariableField> filteredList = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableField field : allFields) {
            try {
                if (field.getModifiableVariable() == null) continue;
                filteredList.add(field);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.warn("Could not access field!");
                throw new WorkflowExecutionException("Could not access Field!", (Throwable)ex);
            }
        }
        return filteredList;
    }

    public List<ModifiableVariableField> getAllStaticallyConfiguredSentFields(WorkflowTrace trace) {
        List<ModifiableVariableListHolder> holderList = this.getStaticallyConfiguredSendModifiableVariableHoldersRecursively(trace);
        LinkedList<ModifiableVariableField> allFields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableListHolder holder : holderList) {
            for (Field field : holder.getFields()) {
                allFields.add(new ModifiableVariableField(holder.getObject(), field));
            }
        }
        return allFields;
    }

    public List<ModifiableVariableHolder> getSentModifiableVariableHolders(WorkflowTrace trace) {
        List<ProtocolMessage> protocolMessages = WorkflowTraceResultUtil.getAllSentMessages(trace);
        LinkedList<ModifiableVariableHolder> result = new LinkedList<ModifiableVariableHolder>();
        for (ProtocolMessage pm : protocolMessages) {
            result.addAll(pm.getAllModifiableVariableHolders());
        }
        return result;
    }

    public List<ModifiableVariableListHolder> getReceivedModifiableVariableHoldersRecursively(WorkflowTrace trace) {
        List<ProtocolMessage> protocolMessages = WorkflowTraceResultUtil.getAllReceivedMessages(trace);
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (ProtocolMessage pm : protocolMessages) {
            result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively((Object)pm));
        }
        return result;
    }

    public List<ModifiableVariableListHolder> getStaticallyConfiguredSendModifiableVariableHoldersRecursively(WorkflowTrace trace) {
        List<ProtocolMessage> protocolMessages = WorkflowTraceConfigurationUtil.getAllStaticConfiguredSendMessages(trace);
        LinkedList<ModifiableVariableListHolder> result = new LinkedList<ModifiableVariableListHolder>();
        for (ProtocolMessage pm : protocolMessages) {
            result.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively((Object)pm));
        }
        return result;
    }

    public List<ModifiableVariableField> getAllModifiableVariableFieldsRecursively(Object object) {
        List<ModifiableVariableListHolder> holders = this.getAllModifiableVariableHoldersRecursively(object);
        LinkedList<ModifiableVariableField> fields = new LinkedList<ModifiableVariableField>();
        for (ModifiableVariableListHolder holder : holders) {
            for (Field f : holder.getFields()) {
                fields.add(new ModifiableVariableField(holder.getObject(), f));
            }
        }
        return fields;
    }

    public List<ModifiableVariableListHolder> getAllModifiableVariableHoldersRecursively(Object object) {
        LinkedList<ModifiableVariableListHolder> holders = new LinkedList<ModifiableVariableListHolder>();
        List modFields = ModifiableVariableAnalyzer.getAllModifiableVariableFields((Object)object);
        if (!modFields.isEmpty()) {
            holders.add(new ModifiableVariableListHolder(object, modFields));
        }
        List allFields = ReflectionHelper.getFieldsUpTo(object.getClass(), null, null);
        allFields.forEach(f -> {
            try {
                HoldsModifiableVariable holdsVariable = f.getAnnotation(HoldsModifiableVariable.class);
                f.setAccessible(true);
                Object possibleHolder = f.get(object);
                if (possibleHolder != null && holdsVariable != null) {
                    if (possibleHolder instanceof List) {
                        holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromList((List)((List)possibleHolder)));
                    } else if (possibleHolder.getClass().isArray()) {
                        holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersFromArray((Object[])((Object[])possibleHolder)));
                    } else if (!ProtocolMessage.class.isInstance(object)) {
                        holders.addAll(ModifiableVariableAnalyzer.getAllModifiableVariableHoldersRecursively((Object)possibleHolder));
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                LOGGER.error("Could not access Field!", (Throwable)ex);
            }
        });
        return holders;
    }
}

