/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.task;

import de.rub.nds.protocol.exception.TransportHandlerConnectException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.task.ITask;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TlsTask
implements ITask,
Callable<ITask> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long DEFAULT_ADDITIONAL_SLEEP_TIME_MS = 1000L;
    private static final long DEFAULT_ADDITIONAL_TCP_TIMEOUT_MS = 5000L;
    private boolean hasError = false;
    private final int reexecutions;
    private final long additionalSleepTime;
    private final boolean increasingSleepTimes;
    private final long additionalTcpTimeout;
    private Function<State, Integer> beforeTransportPreInitCallback = null;
    private Function<State, Integer> beforeTransportInitCallback = null;
    private Function<State, Integer> afterTransportInitCallback = null;
    private Function<State, Integer> afterExecutionCallback = null;

    public TlsTask(int reexecutions) {
        this.reexecutions = reexecutions;
        this.additionalSleepTime = 1000L;
        this.increasingSleepTimes = true;
        this.additionalTcpTimeout = 5000L;
    }

    public TlsTask(int reexecutions, long additionalSleepTime, boolean increasingSleepTimes, long additionalTcpTimeout) {
        this.reexecutions = reexecutions;
        this.additionalSleepTime = additionalSleepTime;
        this.increasingSleepTimes = increasingSleepTimes;
        this.additionalTcpTimeout = additionalTcpTimeout;
    }

    @Override
    public ITask call() {
        Throwable exception = null;
        long sleepTime = 0L;
        for (int i = 0; i < this.reexecutions + 1; ++i) {
            try {
                boolean executionSuccess;
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                if (executionSuccess = this.execute()) {
                    this.hasError = false;
                    break;
                }
                LOGGER.debug("Could not execute task correctly. Increasing Timeout and reexecuting");
                if (this.increasingSleepTimes) {
                    sleepTime += this.additionalSleepTime;
                }
                this.hasError = true;
            }
            catch (TransportHandlerConnectException e) {
                LOGGER.warn("Could not connect to target. Sleep and Retry");
                try {
                    Thread.sleep(this.additionalTcpTimeout);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Interrupted during sleep", (Throwable)ex);
                }
                this.hasError = true;
                exception = e;
            }
            catch (Exception e) {
                this.hasError = true;
                if (this.increasingSleepTimes) {
                    sleepTime += this.additionalSleepTime;
                }
                exception = e;
            }
            if (i >= this.reexecutions) continue;
            try {
                this.reset();
                continue;
            }
            catch (Throwable e) {
                LOGGER.error("Could not reset state!", e);
                this.hasError = true;
                exception = e;
                break;
            }
        }
        if (this.hasError) {
            LOGGER.warn("Could not execute Workflow.", exception);
        }
        return this;
    }

    public boolean isHasError() {
        return this.hasError;
    }

    public abstract void reset();

    public int getReexecutions() {
        return this.reexecutions;
    }

    public Function<State, Integer> getBeforeTransportPreInitCallback() {
        return this.beforeTransportPreInitCallback;
    }

    public void setBeforeTransportPreInitCallback(Function<State, Integer> beforeTransportPreInitCallback) {
        this.beforeTransportPreInitCallback = beforeTransportPreInitCallback;
    }

    public Function<State, Integer> getBeforeTransportInitCallback() {
        return this.beforeTransportInitCallback;
    }

    public void setBeforeTransportInitCallback(Function<State, Integer> beforeTransportInitCallback) {
        this.beforeTransportInitCallback = beforeTransportInitCallback;
    }

    public Function<State, Integer> getAfterTransportInitCallback() {
        return this.afterTransportInitCallback;
    }

    public void setAfterTransportInitCallback(Function<State, Integer> afterTransportInitCallback) {
        this.afterTransportInitCallback = afterTransportInitCallback;
    }

    public Function<State, Integer> getAfterExecutionCallback() {
        return this.afterExecutionCallback;
    }

    public void setAfterExecutionCallback(Function<State, Integer> afterExecutionCallback) {
        this.afterExecutionCallback = afterExecutionCallback;
    }

    public WorkflowExecutor getExecutor(State state) {
        WorkflowExecutor executor = WorkflowExecutorFactory.createWorkflowExecutor(state.getConfig().getWorkflowExecutorType(), state);
        if (this.beforeTransportPreInitCallback != null && executor.getBeforeTransportPreInitCallback() == null) {
            executor.setBeforeTransportPreInitCallback(this.beforeTransportPreInitCallback);
        }
        if (this.beforeTransportInitCallback != null && executor.getBeforeTransportInitCallback() == null) {
            executor.setBeforeTransportInitCallback(this.beforeTransportInitCallback);
        }
        if (this.afterTransportInitCallback != null && executor.getAfterTransportInitCallback() == null) {
            executor.setAfterTransportInitCallback(this.afterTransportInitCallback);
        }
        if (this.afterExecutionCallback != null && executor.getAfterExecutionCallback() == null) {
            executor.setAfterExecutionCallback(this.afterExecutionCallback);
        }
        return executor;
    }
}

