/*
 * Copyright 2012 Dominic Spill
 *
 * This file is part of Project Ubertooth.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */


#ifndef __BLUETOOTH_H
#define __BLUETOOTH_H

#include "ubertooth.h"

#define MAX_SYNCWORD_ERRS 5

extern bdaddr target;
extern u64 syncword;
extern u8 afh_enabled;
extern u8 afh_map[10];
extern u8 used_channels;

/* Barker distance/correct gains us very little when sniffing a known AC
static const u8 ao_barker_distance[] = {
	3,2,3,3,2,1,3,2,2,1,3,2,1,0,2,1,3,3,2,3,3,2,3,3,3,2,3,3,2,1,3,2, //0x00-0x1f
	3,3,2,3,3,2,3,3,3,2,3,3,2,1,3,2,2,3,1,2,3,3,2,3,3,3,2,3,3,2,3,3, //0x20-0x3f
	3,3,2,3,3,2,3,3,3,2,3,3,2,1,3,2,2,3,1,2,3,3,2,3,3,3,2,3,3,2,3,3, //0x40-0x5f
	2,3,1,2,3,3,2,3,3,3,2,3,3,2,3,3,1,2,0,1,2,3,1,2,2,3,1,2,3,3,2,3};//0x60-0x7f

static const u8 ao_barker_correct[] = {
	0x0d, 0x0d, 0x72, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d,
	0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x72, 0x0d, 0x72, 0x72, 0x0d, 0x0d,
	0x72, 0x0d, 0x0d, 0x0d, 0x72, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x72,
	0x0d, 0x72, 0x72, 0x0d, 0x0d, 0x72, 0x0d, 0x0d, 0x0d, 0x72, 0x0d,
	0x0d, 0x0d, 0x0d, 0x0d, 0x72, 0x72, 0x72, 0x72, 0x72, 0x0d, 0x72,
	0x72, 0x72, 0x0d, 0x72, 0x72, 0x0d, 0x0d, 0x72, 0x0d, 0x72, 0x0d,
	0x72, 0x72, 0x0d, 0x0d, 0x72, 0x0d, 0x0d, 0x0d, 0x72, 0x0d, 0x0d,
	0x0d, 0x0d, 0x0d, 0x72, 0x72, 0x72, 0x72, 0x72, 0x0d, 0x72, 0x72,
	0x72, 0x0d, 0x72, 0x72, 0x0d, 0x0d, 0x72, 0x0d, 0x72, 0x72, 0x72,
	0x72, 0x72, 0x0d, 0x72, 0x72, 0x72, 0x0d, 0x72, 0x72, 0x0d, 0x0d,
	0x72, 0x0d, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72,
	0x72, 0x72, 0x72, 0x72, 0x0d, 0x72, 0x72};
*/

void precalc();
u16 next_hop(u32 clkn);
int find_access_code(u8 *idle_rxbuf);

#endif /* __BLUETOOTH_H */
