---
title: "Community"
weight: 5
---

## Join the Urx Community

Connect with other Urx users, share experiences, and get help from the community.

### Coming Soon

Community resources and channels are being established. This page will include:

- **Community Forums**: Discussion boards for users
- **Chat Channels**: Real-time communication (Discord, Slack, etc.)
- **Social Media**: Follow updates and announcements
- **User Groups**: Regional or topic-specific groups
- **Events**: Meetups, webinars, and conferences
- **Resources**: Community-contributed tutorials and guides

### Current Community Channels

#### GitHub

- **Issues**: [Report bugs and request features](https://github.com/hahwul/urx/issues)
- **Discussions**: [Ask questions and share ideas](https://github.com/hahwul/urx/discussions)
- **Pull Requests**: [Contribute code](https://github.com/hahwul/urx/pulls)

#### Social Media

- **Twitter/X**: Follow [@hahwul](https://twitter.com/hahwul) for updates
- **Blog**: Check [hahwul.com](https://www.hahwul.com) for articles

### Get Involved

#### For Users

- Share your use cases and workflows
- Report bugs and suggest features
- Help answer questions from other users
- Write tutorials and guides
- Star the project on GitHub

#### For Developers

- Contribute code improvements
- Fix bugs and add features
- Improve documentation
- Review pull requests
- Share security research findings

### Community Guidelines

- **Be Respectful**: Treat all community members with respect
- **Be Helpful**: Share knowledge and help others learn
- **Be Constructive**: Provide actionable feedback
- **Follow Code of Conduct**: Review our [Code of Conduct](https://github.com/hahwul/urx/blob/main/CODE_OF_CONDUCT.md)

### Showcase

Have you built something cool with Urx? We'd love to hear about it!

- Blog posts about Urx usage
- Integration examples
- Custom workflows
- Security findings (responsibly disclosed)

Share your work:
- Tag us on social media
- Post in GitHub Discussions
- Submit to our showcase (coming soon)

### Resources

- [Getting Started Guide](../../getting_started/introduction)
- [Usage Examples](../../usage/examples)
- [Contributing Guide](../contributing)
- [Changelog](../changelog)

---

**Note**: Community channels and resources are being expanded. Check back regularly for updates, or watch the GitHub repository for announcements.
