
# frozen_string_literal: true

module Wpxf
  # A file system path option.
  class PathOption < Option
    # Check if the specified value is valid in the context of this option.
    # @param value the value to validate.
    # @return [Boolean] true if valid.
    def valid?(value)
      return super if empty?(value)
      File.exist?(value)
    end
  end
end
