# frozen_string_literal: true

module Wpxf
  # Provides methods for emitting events that should output information
  # to the user interface of the calling application.
  module OutputEmitters
    # Emit a successful operation event.
    # @param message [String] the message to output.
    # @param verbose [Boolean] the verbose level flag.
    def emit_success(message, verbose = false)
      event_emitter.emit(
        event: :output,
        verbose: verbose,
        type: :success,
        msg: message
      )
    end

    # Emit a general info event.
    # @param message [String] the message to output.
    # @param verbose [Boolean] the verbose level flag.
    def emit_info(message, verbose = false)
      event_emitter.emit(
        event: :output,
        verbose: verbose,
        type: :info,
        msg: message
      )
    end

    # Emit a warning event.
    # @param message [String] the message to output.
    # @param verbose [Boolean] the verbose level flag.
    def emit_warning(message, verbose = false)
      event_emitter.emit(
        event: :output,
        verbose: verbose,
        type: :warning,
        msg: message
      )
    end

    # Emit an error event.
    # @param message [String] the message to output.
    # @param verbose [Boolean] the verbose level flag.
    def emit_error(message, verbose = false)
      event_emitter.emit(
        event: :output,
        verbose: verbose,
        type: :error,
        msg: message
      )
    end

    # Emit an event containing tabular data.
    # @param rows [Array] an array of hashes containing the row data.
    # @param verbose [Boolean] the verbose level flag.
    def emit_table(rows, verbose = false)
      event_emitter.emit(
        event: :output,
        verbose: verbose,
        type: :table,
        rows: rows
      )
    end
  end
end
