# frozen_string_literal: true

module Wpxf::Payloads
  # A custom payload container.
  class Custom < Wpxf::Payload
    include Wpxf

    def initialize
      super

      unregister_option(get_option('encode_payload'))
      register_options([
        StringOption.new(
          name: 'payload_path',
          required: true,
          desc: 'The path to the custom payload'
        )
      ])
    end

    def encoded
      raw
    end

    def payload_path
      File.expand_path(datastore['payload_path'])
    end

    def prepare(mod)
      unless File.exist?(payload_path)
        mod.emit_error "#{payload_path} does not exist"
        return false
      end

      true
    end

    def raw
      File.open(payload_path, 'rb', &:read)
    end
  end
end
