/* BEGIN_LEGAL 

Copyright (c) 2026 Intel Corporation

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  
END_LEGAL */
/// @file xed-flag-enum.h

// This file was automatically generated.
// Do not edit this file.

#if !defined(XED_FLAG_ENUM_H)
# define XED_FLAG_ENUM_H
#include "xed-common-hdrs.h"
#define XED_FLAG_INVALID_DEFINED 1
#define XED_FLAG_of_DEFINED 1
#define XED_FLAG_sf_DEFINED 1
#define XED_FLAG_zf_DEFINED 1
#define XED_FLAG_af_DEFINED 1
#define XED_FLAG_pf_DEFINED 1
#define XED_FLAG_cf_DEFINED 1
#define XED_FLAG_df_DEFINED 1
#define XED_FLAG_vif_DEFINED 1
#define XED_FLAG_iopl_DEFINED 1
#define XED_FLAG_if_DEFINED 1
#define XED_FLAG_ac_DEFINED 1
#define XED_FLAG_vm_DEFINED 1
#define XED_FLAG_rf_DEFINED 1
#define XED_FLAG_nt_DEFINED 1
#define XED_FLAG_tf_DEFINED 1
#define XED_FLAG_id_DEFINED 1
#define XED_FLAG_vip_DEFINED 1
#define XED_FLAG_fc0_DEFINED 1
#define XED_FLAG_fc1_DEFINED 1
#define XED_FLAG_fc2_DEFINED 1
#define XED_FLAG_fc3_DEFINED 1
#define XED_FLAG_LAST_DEFINED 1
typedef enum {
  XED_FLAG_INVALID,
  XED_FLAG_of, ///<< overflow flag
  XED_FLAG_sf, ///< sign flag
  XED_FLAG_zf, ///< zero flag
  XED_FLAG_af, ///< auxiliary flag
  XED_FLAG_pf, ///< parity flag
  XED_FLAG_cf, ///< carry flag
  XED_FLAG_df, ///< direction flag
  XED_FLAG_vif, ///< virtual interrupt flag
  XED_FLAG_iopl, ///< I/O privilege level
  XED_FLAG_if, ///< interrupt flag
  XED_FLAG_ac, ///< alignment check
  XED_FLAG_vm, ///< virtual-8086 mode
  XED_FLAG_rf, ///< resume flag
  XED_FLAG_nt, ///< nested task
  XED_FLAG_tf, ///< traf flag
  XED_FLAG_id, ///< ID flag
  XED_FLAG_vip, ///< virtual interrupt pending
  XED_FLAG_fc0, ///< x87 FC0 flag
  XED_FLAG_fc1, ///< x87 FC1 flag
  XED_FLAG_fc2, ///< x87 FC2 flag
  XED_FLAG_fc3, ///< x87 FC3 flag
  XED_FLAG_LAST
} xed_flag_enum_t;

/// This converts strings to #xed_flag_enum_t types.
/// @param s A C-string.
/// @return #xed_flag_enum_t
/// @ingroup ENUM
XED_DLL_EXPORT xed_flag_enum_t str2xed_flag_enum_t(const char* s);
/// This converts strings to #xed_flag_enum_t types.
/// @param p An enumeration element of type xed_flag_enum_t.
/// @return string
/// @ingroup ENUM
XED_DLL_EXPORT const char* xed_flag_enum_t2str(const xed_flag_enum_t p);

/// Returns the last element of the enumeration
/// @return xed_flag_enum_t The last element of the enumeration.
/// @ingroup ENUM
XED_DLL_EXPORT xed_flag_enum_t xed_flag_enum_t_last(void);
#endif
