#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# -:-:-:-:-:-:-::-:-:#
#    XSRF Probe     #
# -:-:-:-:-:-:-::-:-:#

# Author: 0xInfection
# This module requires XSRFProbe
# https://github.com/0xInfection/XSRFProbe

# this module holds values for controlling the entire scan interface.

# Lets assign some global variables...
global SITE_URL, DEBUG, USER_AGENT, USER_AGENT_RANDOM, COOKIE_BASED, COOKIE_VALUE
global HEADER_VALUES, TIMEOUT_VALUE, REFERER_ORIGIN_CHECKS, REFERER_URL, POST_BASED
global DISPLAY_HEADERS, EXECUTABLES, FILE_EXTENSIONS, POC_GENERATION, OUTPUT_DIR, VERIFY_CERT
global CRAWL_SITE, TOKEN_CHECKS, DELAY_VALUE, SCAN_ANALYSIS, EXCLUDE_DIRS, GEN_MALICIOUS
global NO_COLORS

# Site Url to be scanned (Required)
SITE_URL = ""

# Switch for whether to crawl the site or not
CRAWL_SITE = False

# Print out verbose (turn it off for only brief outputs).
# Turning off is Highly Discouraged, since you will miss what the tool is doing.
DEBUG = True

# Debug level of the output (beta test feature)
DEBUG_LEVEL = 3

# User-Agent to be used (If COOKIE_VALUE is not supplied)
USER_AGENT_RANDOM = False

# User-Agent to be used (If COOKIE_VALUE supplied).
#
# This is standard User-Agent emulating Chrome 68 on Windows 10
#
# NOTE: This is a precaution in case the cookie value is supplied,
# if the user-agent gets changed from time to time, the remote
# application might trigger up some protection agents
USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.79 Safari/537.36"

# Cookie value to be sent alongwith the requests. This option is particularly
# needed for a wholesome check on CSRFs. Since for a basic successful CSRF attack
# one needs to have a site with long-duration persistent session cookies and no
# Referer validation.
#
# Also you might want to keep this value to '' untill you want to scan your
# web application as a authorised user/admin with elevated priviledges,
# which might give XSRFProbe a wider scope to scan. This is typically
# recommended for websites which has logins/sessions feature. (eg. Social
# Networking Sites, E-Commerce Sites).
#
# NOTE: If this value is not supplied, XSRFProbe will only scan for simple
# cookies which the tool might encounter while making requests, especially
# POST requests.
COOKIE_VALUE = []

# Header values to be used (Modify it as per your need)
HEADER_VALUES = {
    "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9",
    "Accept-Language": "en-US,en;q=0.9",
    "Accept-Encoding": "gzip, deflate, br",
    "Sec-Fetch-Mode": "navigate",
    "DNT": "1",  # Do Not Track Request Header :D
    "Connection": "close",
}

# Email value to be supplied when parsing/filling forms
# You can modify it as per your need :)
EMAIL_VALUE = "csrf.testing@xsrfprobe.tld"

# Plaintext value to be supplied when parsing/filling forms
TEXT_VALUE = "csrftesting"

# Request Timeout (Keep the max. timeout value to 10s)
TIMEOUT_VALUE = 7

# The time delay between requests. This option is especially required
# when there is some sort of security measure such as load-balancers
# or a Firewall (WAF).
DELAY_VALUE = 0

# Whether to include Cookie Based Checks everywhere
#
# Note: If you keep this to 'True', you must supply a
# cookie value in COOKIE_VALUE to test with full efficiency.
# Otherwise only a partial check will be done against the cookies
# which XSRFProbe might come across while requesting forms/data
# and other relevant areas.
#
# (Recommended Keeping True)
COOKIE_BASED = True

# Include checks for Form Based CSRFs (POST method)
# (Recommended keeping True)
POST_BASED = True

# Anti-CSRF Token Checks (Recommended keeping True)
TOKEN_CHECKS = True

# Referer/Origin Checks (Recommended keeping True)
REFERER_ORIGIN_CHECKS = True

# Whether to submit Crafted Forms (Recommended keeping True)
# If you turn this to False, it will omit form submissions,
# so there will be more chances of missing out most possible
# cases of Form based (POST Based) CSRFs.
FORM_SUBMISSION = True

# A switch to determine whether to verify certificates upon
# requests. This will help devs test their web-app with self-signed
# certificates.
VERIFY_CERT = True

# Referer Url (Change It Accordingly)
# eg. Use one of your Subdomains (Same Origin Policy))
REFERER_URL = "http://not-a-valid-referer.xsrfprobe-csrftesting.0xinfection.xyz"

# Origin Url (Change It Accordingly)
# eg. Use one of your Subdomains (Same Origin Policy))
ORIGIN_URL = "http://not-a-valid-origin.xsrfprobe-csrftesting.0xinfection.xyz"

# The length of the custom token to be generated for params
#
# The recommended value I prefer is 6. Greater value might
# result in database problems. since every form on the server
# will be submitted 5+ times for various methods of CSRF attacks.
#
# Lower value wll not harm but it will make it difficult
# identifying request parameters and token values in a.
TOKEN_GENERATION_LENGTH = 6

# List of Urls that are not to be scanned (excluded).
EXCLUDE_DIRS = []

# Output directory where everything (including logs) are to
# be stored
OUTPUT_DIR = ""

# Allow JSON output
JSON_OUTPUT = False

# This option is for displaying the headers received as response.
# Turn this off if you don't want to see the headers on the
# terminal, or if it feels irritating.
DISPLAY_HEADERS = False

# No colors option
NO_COLORS = False

# Option for controlling post-scan analysis. Turning it off
# results in not analysing the tokens gathered.
SCAN_ANALYSIS = True

# Option to skip PoC Form Generation of POST_BASED Request Forgeries.
# The form will not be generated.
POC_GENERATION = True

# Option whether or not to generate a malicious CSRF form with all
# hidden fields.
GEN_MALICIOUS = False

# A list of file extensions that might be come across while scanning
# and crawling
FILE_EXTENSIONS = [
    "png",
    "jpg",
    "jpeg",
    "pdf",
    "js",
    "css",
    "ico",
    "bmp",
    "svg",
    "json",
    "xml",
    "xls",
    "csv",
    "docx",
]
# These are a list of executable files that are found on the web
EXECUTABLES = [
    "deb",
    "bat",
    "exe",
    "msu",
    "msi",
    "apk",
    "bin",
    "csh",
    "inf",
    "ini",
    "msc",
    "osx",
    "out",
    "vbe",
    "ws",
    "msp",
    "jse",
]
