// See the file "COPYING" in the main distribution directory for copyright.

#pragma once

#include <cstring>
#include <string>

#include <hilti/rt/filesystem.h>

#include "zeek/zeek-config-paths.h"

namespace zeek::spicy::configuration {

using path = hilti::rt::filesystem::path;

namespace {

// This mimics zeek-config to get the Zeek include directories.
static inline void add_path(std::string& old_path, const path& new_path) {
    if ( new_path.empty() )
        return;

    if ( ! old_path.empty() )
        old_path += ":";

    old_path += new_path.native();
}
} // namespace

static path get_env_path_or(const char* name, const char* default_) {
    assert(std::strlen(default_) != 0);
    if ( auto p = hilti::rt::getenv(name); p && ! p->empty() )
        return {*p};
    else
        return default_;
}

inline auto InstallBinDir() { return path("/usr/share/zeek") / "bin"; }

inline auto LibraryPath() { return get_env_path_or("ZEEK_SPICY_LIBRARY_PATH", "/usr/share/zeek/share/zeek/spicy"); }

inline auto ModulePath() { return get_env_path_or("ZEEK_SPICY_MODULE_PATH", "/usr/share/zeek/lib/zeek/spicy"); }

inline auto DataPath() { return get_env_path_or("ZEEK_SPICY_DATA_PATH", "/usr/share/zeek/share/zeek"); }

inline auto CxxZeekIncludesDirectories() {
    std::string includes;
    add_path(includes, path("/usr/share/zeek") / "include");

    // When changing any of the following, also update "zeek-config.in".
    add_path(includes, "/usr/include");
    add_path(includes, "/usr/include");
    add_path(includes, "/usr/include");
    add_path(includes, "/usr/include");
    add_path(includes, "");

    return includes;
}

// Version of Spicy that we are compiling against. Used for codegen changes in glue-compiler.cc.
// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define SPICY_VERSION_NUMBER 11600

inline const auto InstallPrefix = path("/usr/share/zeek");

} // namespace zeek::spicy::configuration
