#include "caf/config.hpp"
#include "caf/string_view.hpp"

CAF_PUSH_DEPRECATED_WARNING

#include "caf/net/basp/ec.hpp"

#include <string>

namespace caf::net::basp {

std::string to_string(ec x) {
  switch (x) {
    default:
      return "???";
    case ec::invalid_magic_number:
      return "caf::net::basp::ec::invalid_magic_number";
    case ec::unexpected_number_of_bytes:
      return "caf::net::basp::ec::unexpected_number_of_bytes";
    case ec::unexpected_payload:
      return "caf::net::basp::ec::unexpected_payload";
    case ec::missing_payload:
      return "caf::net::basp::ec::missing_payload";
    case ec::illegal_state:
      return "caf::net::basp::ec::illegal_state";
    case ec::invalid_handshake:
      return "caf::net::basp::ec::invalid_handshake";
    case ec::missing_handshake:
      return "caf::net::basp::ec::missing_handshake";
    case ec::unexpected_handshake:
      return "caf::net::basp::ec::unexpected_handshake";
    case ec::version_mismatch:
      return "caf::net::basp::ec::version_mismatch";
    case ec::unimplemented:
      return "caf::net::basp::ec::unimplemented";
    case ec::app_identifiers_mismatch:
      return "caf::net::basp::ec::app_identifiers_mismatch";
    case ec::invalid_payload:
      return "caf::net::basp::ec::invalid_payload";
    case ec::invalid_scheme:
      return "caf::net::basp::ec::invalid_scheme";
    case ec::invalid_locator:
      return "caf::net::basp::ec::invalid_locator";
  }
}

bool from_string(string_view in, ec& out) {
  if (in == "caf::net::basp::ec::invalid_magic_number") {
    out = ec::invalid_magic_number;
    return true;
  }
  if (in == "caf::net::basp::ec::unexpected_number_of_bytes") {
    out = ec::unexpected_number_of_bytes;
    return true;
  }
  if (in == "caf::net::basp::ec::unexpected_payload") {
    out = ec::unexpected_payload;
    return true;
  }
  if (in == "caf::net::basp::ec::missing_payload") {
    out = ec::missing_payload;
    return true;
  }
  if (in == "caf::net::basp::ec::illegal_state") {
    out = ec::illegal_state;
    return true;
  }
  if (in == "caf::net::basp::ec::invalid_handshake") {
    out = ec::invalid_handshake;
    return true;
  }
  if (in == "caf::net::basp::ec::missing_handshake") {
    out = ec::missing_handshake;
    return true;
  }
  if (in == "caf::net::basp::ec::unexpected_handshake") {
    out = ec::unexpected_handshake;
    return true;
  }
  if (in == "caf::net::basp::ec::version_mismatch") {
    out = ec::version_mismatch;
    return true;
  }
  if (in == "caf::net::basp::ec::unimplemented") {
    out = ec::unimplemented;
    return true;
  }
  if (in == "caf::net::basp::ec::app_identifiers_mismatch") {
    out = ec::app_identifiers_mismatch;
    return true;
  }
  if (in == "caf::net::basp::ec::invalid_payload") {
    out = ec::invalid_payload;
    return true;
  }
  if (in == "caf::net::basp::ec::invalid_scheme") {
    out = ec::invalid_scheme;
    return true;
  }
  if (in == "caf::net::basp::ec::invalid_locator") {
    out = ec::invalid_locator;
    return true;
  }
  return false;
}

bool from_integer(std::underlying_type_t<ec> in,
                  ec& out) {
  auto result = static_cast<ec>(in);
  switch (result) {
    default:
      return false;
    case ec::invalid_magic_number:
    case ec::unexpected_number_of_bytes:
    case ec::unexpected_payload:
    case ec::missing_payload:
    case ec::illegal_state:
    case ec::invalid_handshake:
    case ec::missing_handshake:
    case ec::unexpected_handshake:
    case ec::version_mismatch:
    case ec::unimplemented:
    case ec::app_identifiers_mismatch:
    case ec::invalid_payload:
    case ec::invalid_scheme:
    case ec::invalid_locator:
      out = result;
      return true;
  }
}

} // namespace caf::net::basp

