// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file /build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.h
 ** Define the hilti::detail::parser::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

#ifndef YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_HILTI_SRC_AUTOGEN_PARSER_H_INCLUDED
# define YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_HILTI_SRC_AUTOGEN_PARSER_H_INCLUDED


# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif
# include "location.hh"


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

#line 29 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
namespace hilti { namespace detail { namespace parser {
#line 183 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.h"




  /// A Bison parser.
  class Parser
  {
  public:
#ifdef YYSTYPE
# ifdef __GNUC__
#  pragma GCC message "bison: do not #define YYSTYPE in C++, use %define api.value.type"
# endif
    typedef YYSTYPE value_type;
#else
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class value_type
  {
  public:
    /// Type of *this.
    typedef value_type self_type;

    /// Empty construction.
    value_type () YY_NOEXCEPT
      : yyraw_ ()
    {}

    /// Construct and fill.
    template <typename T>
    value_type (YY_RVREF (T) t)
    {
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    value_type (const self_type&) = delete;
    /// Non copyable.
    self_type& operator= (const self_type&) = delete;
#endif

    /// Destruction, allowed only if empty.
    ~value_type () YY_NOEXCEPT
    {}

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
    }

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    value_type (const self_type&);
    /// Non copyable.
    self_type& operator= (const self_type&);
#endif

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yyraw_;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yyraw_;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // "bool value"
      char dummy1[sizeof (bool)];

      // "real value"
      char dummy2[sizeof (double)];

      // attribute
      char dummy3[sizeof (hilti::Attribute*)];

      // opt_attributes
      char dummy4[sizeof (hilti::AttributeSet*)];

      // ctor
      // tuple
      // list
      // set
      // map
      // struct_
      // regexp
      char dummy5[sizeof (hilti::Ctor*)];

      // global_scope_decl
      // type_decl
      // constant_decl
      // local_decl
      // local_init_decl
      // global_decl
      // function_decl
      // import_decl
      // property_decl
      // struct_field
      // union_field
      char dummy6[sizeof (hilti::Declaration*)];

      // struct_fields
      // opt_union_fields
      // union_fields
      char dummy7[sizeof (hilti::Declarations)];

      // opt_func_default_expr
      // expr
      // expr_no_or_error
      // expr_or_error
      // expr_1
      // call_expr
      // member_expr
      // ctor_expr
      // tuple_elem
      // tuple_expr
      char dummy8[sizeof (hilti::Expression*)];

      // opt_type_arguments
      // case_exprs
      // opt_exprs
      // exprs
      // opt_tuple_elems1
      // opt_tuple_elems2
      char dummy9[sizeof (hilti::Expressions)];

      // function_with_body
      // method_with_body
      // hook_with_body
      // function_without_body
      char dummy10[sizeof (hilti::Function*)];

      // local_id
      // scoped_id
      // dotted_id
      // function_id
      // scoped_function_id
      char dummy11[sizeof (hilti::ID)];

      // qtype
      char dummy12[sizeof (hilti::QualifiedType*)];

      // block
      // braced_block
      // stmt
      // opt_else_block
      // stmt_decl
      // stmt_expr
      char dummy13[sizeof (hilti::Statement*)];

      // opt_stmts
      // stmts
      char dummy14[sizeof (hilti::Statements)];

      // func_param_type
      // base_type_no_attrs
      // base_type
      // type
      // function_type
      // tuple_type
      // struct_type
      // union_type
      // enum_type
      // bitfield_type
      char dummy15[sizeof (hilti::UnqualifiedType*)];

      // map_elem
      char dummy16[sizeof (hilti::ctor::map::Element*)];

      // opt_map_elems
      // map_elems
      char dummy17[sizeof (hilti::ctor::map::Elements)];

      // re_pattern_constant
      // opt_re_pattern_constant_flags
      char dummy18[sizeof (hilti::ctor::regexp::Pattern)];

      // re_patterns
      char dummy19[sizeof (hilti::ctor::regexp::Patterns)];

      // struct_elem
      char dummy20[sizeof (hilti::ctor::struct_::Field*)];

      // struct_elems
      char dummy21[sizeof (hilti::ctor::struct_::Fields)];

      // opt_linkage
      char dummy22[sizeof (hilti::declaration::Linkage)];

      // opt_func_param_kind
      char dummy23[sizeof (hilti::parameter::Kind)];

      // switch_case
      char dummy24[sizeof (hilti::statement::switch_::Case*)];

      // opt_switch_cases
      // switch_cases
      char dummy25[sizeof (hilti::statement::switch_::Cases)];

      // try_catch
      char dummy26[sizeof (hilti::statement::try_::Catch*)];

      // try_catches
      char dummy27[sizeof (hilti::statement::try_::Catches)];

      // bitfield_bit_range
      char dummy28[sizeof (hilti::type::bitfield::BitRange*)];

      // opt_bitfield_bit_ranges
      // bitfield_bit_ranges
      char dummy29[sizeof (hilti::type::bitfield::BitRanges)];

      // enum_label
      char dummy30[sizeof (hilti::type::enum_::Label*)];

      // enum_labels
      char dummy31[sizeof (hilti::type::enum_::Labels)];

      // opt_func_cc
      char dummy32[sizeof (hilti::type::function::CallingConvention)];

      // opt_func_flavor
      // func_flavor
      char dummy33[sizeof (hilti::type::function::Flavor)];

      // func_param
      char dummy34[sizeof (hilti::type::function::Parameter*)];

      // opt_func_params
      // func_params
      // opt_struct_params
      char dummy35[sizeof (hilti::type::function::Parameters)];

      // tuple_type_elem
      char dummy36[sizeof (hilti::type::tuple::Element*)];

      // tuple_type_elems
      char dummy37[sizeof (hilti::type::tuple::Elements)];

      // global_scope_items
      char dummy38[sizeof (std::pair<Declarations, Statements>)];

      // "identifier"
      // "scoped identifier"
      // "scoped ~finally"
      // "dotted identifier"
      // "attribute"
      // "property"
      // "string value"
      // "bytes value"
      // "regular expression value"
      // "address value"
      // "port value"
      char dummy39[sizeof (std::string)];

      // "unsigned integer value"
      char dummy40[sizeof (uint64_t)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me_;
      /// A buffer large enough to store any of the semantic values.
      char yyraw_[size];
    };
  };

#endif
    /// Backward compatibility (Bison 3.8).
    typedef value_type semantic_type;

    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m)
        : std::runtime_error (m)
        , location (l)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
        , location (s.location)
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;

      location_type location;
    };

    /// Token kinds.
    struct token
    {
      enum token_kind_type
      {
        YYEMPTY = -2,
    EOD = 0,                       // "<end of input>"
    YYerror = 256,                 // error
    YYUNDEF = 257,                 // "invalid token"
    IDENT = 258,                   // "identifier"
    SCOPED_IDENT = 259,            // "scoped identifier"
    SCOPED_FINALIZE = 260,         // "scoped ~finally"
    DOTTED_IDENT = 261,            // "dotted identifier"
    ATTRIBUTE = 262,               // "attribute"
    PROPERTY = 263,                // "property"
    CSTRING = 264,                 // "string value"
    CBYTES = 265,                  // "bytes value"
    CREGEXP = 266,                 // "regular expression value"
    CADDRESS = 267,                // "address value"
    CPORT = 268,                   // "port value"
    CUREAL = 269,                  // "real value"
    CUINTEGER = 270,               // "unsigned integer value"
    CBOOL = 271,                   // "bool value"
    ADD = 272,                     // "add"
    ASSERT = 273,                  // "assert"
    ASSERT_EXCEPTION = 274,        // "assert-exception"
    ADDRESS = 275,                 // "addr"
    AFTER = 276,                   // "after"
    AND = 277,                     // "&&"
    ANY = 278,                     // "any"
    ARROW = 279,                   // "->"
    AUTO = 280,                    // "auto"
    AT = 281,                      // "at"
    BEGIN_ = 282,                  // "begin"
    BITFIELD = 283,                // "bitfield"
    BOOL = 284,                    // "bool"
    BREAK = 285,                   // "break"
    BYTES = 286,                   // "bytes"
    CADDR = 287,                   // "caddr"
    CALLABLE = 288,                // "callable"
    CASE = 289,                    // "case"
    CAST = 290,                    // "cast"
    CATCH = 291,                   // "catch"
    CHANNEL = 292,                 // "channel"
    CLASSIFIER = 293,              // "classifier"
    CNULL = 294,                   // "Null"
    CONST = 295,                   // "const"
    CONTINUE = 296,                // "continue"
    CONTEXT = 297,                 // "context"
    COPY = 298,                    // "copy"
    DECLARE = 299,                 // "declare"
    DEFAULT = 300,                 // "default"
    DELETE = 301,                  // "delete"
    DIVIDEASSIGN = 302,            // "/="
    DOLLARDOLLAR = 303,            // "$$"
    DOTDOT = 304,                  // ".."
    REAL = 305,                    // "real"
    ELSE = 306,                    // "else"
    END_ = 307,                    // "end"
    ENUM = 308,                    // "enum"
    EQ = 309,                      // "=="
    ERROR = 310,                   // "error"
    EXCEPTION = 311,               // "exception"
    EXPORT = 312,                  // "export"
    EXTERN = 313,                  // "extern"
    EXTERN_NO_SUSPEND = 314,       // "extern-no-suspend"
    FILE = 315,                    // "file"
    FINALIZE = 316,                // "~finally"
    FOR = 317,                     // "for"
    FROM = 318,                    // "from"
    FUNCTION = 319,                // "function"
    GEQ = 320,                     // ">="
    GLOBAL = 321,                  // "global"
    HASATTR = 322,                 // "?."
    HOOK = 323,                    // "hook"
    IF = 324,                      // "if"
    IMPORT = 325,                  // "import"
    IN = 326,                      // "in"
    INIT = 327,                    // "init"
    INOUT = 328,                   // "inout"
    INT = 329,                     // "int"
    INT16 = 330,                   // "int16"
    INT32 = 331,                   // "int32"
    INT64 = 332,                   // "int64"
    INT8 = 333,                    // "int8"
    INTERVAL = 334,                // "interval"
    INTERVAL_NS = 335,             // "interval_ns"
    IOSRC = 336,                   // "iosrc"
    ITERATOR = 337,                // "iterator"
    CONST_ITERATOR = 338,          // "const_iterator"
    LEQ = 339,                     // "<="
    LIBRARY_TYPE = 340,            // "library type"
    LIBRARY_TYPE_CONST = 341,      // "const library type"
    LIST = 342,                    // "list"
    LOCAL = 343,                   // "local"
    MAP = 344,                     // "map"
    MATCH_TOKEN_STATE = 345,       // "match_token_state"
    METHOD = 346,                  // "method"
    MINUSASSIGN = 347,             // "-="
    MINUSMINUS = 348,              // "--"
    MOD = 349,                     // "%"
    MODULE = 350,                  // "module"
    MOVE = 351,                    // "move"
    NEW = 352,                     // "new"
    NEQ = 353,                     // "!="
    NETWORK = 354,                 // "net"
    NOT_IN = 355,                  // "!in"
    OPTIONAL = 356,                // "optional"
    OR = 357,                      // "||"
    OVERLAY = 358,                 // "overlay"
    PACK = 359,                    // "pack"
    PLUSASSIGN = 360,              // "+="
    PLUSPLUS = 361,                // "++"
    PORT = 362,                    // "port"
    POW = 363,                     // "**"
    PREINIT = 364,                 // "preinit"
    PRIVATE = 365,                 // "private"
    PUBLIC = 366,                  // "public"
    STRONG_REF = 367,              // "strong_ref"
    REGEXP = 368,                  // "regexp"
    RESULT = 369,                  // "result"
    RETURN = 370,                  // "return"
    SCOPE = 371,                   // "scope"
    SET = 372,                     // "set"
    SHIFTLEFT = 373,               // "<<"
    SHIFTRIGHT = 374,              // ">>"
    STREAM = 375,                  // "stream"
    STRING = 376,                  // "string"
    STRUCT = 377,                  // "struct"
    SWITCH = 378,                  // "switch"
    TIME = 379,                    // "time"
    TIME_NS = 380,                 // "time_ns"
    TIMER = 381,                   // "timer"
    TIMERMGR = 382,                // "timer_mgr"
    TIMESASSIGN = 383,             // "*="
    THROW = 384,                   // "throw"
    TRY = 385,                     // "try"
    TRYATTR = 386,                 // ".?"
    TUPLE = 387,                   // "tuple"
    TYPE = 388,                    // "type"
    TYPEINFO = 389,                // "typeinfo"
    UINT = 390,                    // "uint"
    UINT16 = 391,                  // "uint16"
    UINT32 = 392,                  // "uint32"
    UINT64 = 393,                  // "uint64"
    UINT8 = 394,                   // "uint8"
    UNION = 395,                   // "union"
    UNPACK = 396,                  // "unpack"
    UNSET = 397,                   // "unset"
    VECTOR = 398,                  // "vector"
    VIEW = 399,                    // "view"
    VOID = 400,                    // "void"
    WHILE = 401,                   // "while"
    WITH = 402,                    // "with"
    VALUE_REF = 403,               // "value_ref"
    WEAK_REF = 404,                // "weak_ref"
    YIELD = 405,                   // "yield"
    UNARY_PREC = 406               // UNARY_PREC
      };
      /// Backward compatibility alias (Bison 3.6).
      typedef token_kind_type yytokentype;
    };

    /// Token kind, as returned by yylex.
    typedef token::token_kind_type token_kind_type;

    /// Backward compatibility alias (Bison 3.6).
    typedef token_kind_type token_type;

    /// Symbol kinds.
    struct symbol_kind
    {
      enum symbol_kind_type
      {
        YYNTOKENS = 177, ///< Number of tokens.
        S_YYEMPTY = -2,
        S_YYEOF = 0,                             // "<end of input>"
        S_YYerror = 1,                           // error
        S_YYUNDEF = 2,                           // "invalid token"
        S_IDENT = 3,                             // "identifier"
        S_SCOPED_IDENT = 4,                      // "scoped identifier"
        S_SCOPED_FINALIZE = 5,                   // "scoped ~finally"
        S_DOTTED_IDENT = 6,                      // "dotted identifier"
        S_ATTRIBUTE = 7,                         // "attribute"
        S_PROPERTY = 8,                          // "property"
        S_CSTRING = 9,                           // "string value"
        S_CBYTES = 10,                           // "bytes value"
        S_CREGEXP = 11,                          // "regular expression value"
        S_CADDRESS = 12,                         // "address value"
        S_CPORT = 13,                            // "port value"
        S_CUREAL = 14,                           // "real value"
        S_CUINTEGER = 15,                        // "unsigned integer value"
        S_CBOOL = 16,                            // "bool value"
        S_ADD = 17,                              // "add"
        S_ASSERT = 18,                           // "assert"
        S_ASSERT_EXCEPTION = 19,                 // "assert-exception"
        S_ADDRESS = 20,                          // "addr"
        S_AFTER = 21,                            // "after"
        S_AND = 22,                              // "&&"
        S_ANY = 23,                              // "any"
        S_ARROW = 24,                            // "->"
        S_AUTO = 25,                             // "auto"
        S_AT = 26,                               // "at"
        S_BEGIN_ = 27,                           // "begin"
        S_BITFIELD = 28,                         // "bitfield"
        S_BOOL = 29,                             // "bool"
        S_BREAK = 30,                            // "break"
        S_BYTES = 31,                            // "bytes"
        S_CADDR = 32,                            // "caddr"
        S_CALLABLE = 33,                         // "callable"
        S_CASE = 34,                             // "case"
        S_CAST = 35,                             // "cast"
        S_CATCH = 36,                            // "catch"
        S_CHANNEL = 37,                          // "channel"
        S_CLASSIFIER = 38,                       // "classifier"
        S_CNULL = 39,                            // "Null"
        S_CONST = 40,                            // "const"
        S_CONTINUE = 41,                         // "continue"
        S_CONTEXT = 42,                          // "context"
        S_COPY = 43,                             // "copy"
        S_DECLARE = 44,                          // "declare"
        S_DEFAULT = 45,                          // "default"
        S_DELETE = 46,                           // "delete"
        S_DIVIDEASSIGN = 47,                     // "/="
        S_DOLLARDOLLAR = 48,                     // "$$"
        S_DOTDOT = 49,                           // ".."
        S_REAL = 50,                             // "real"
        S_ELSE = 51,                             // "else"
        S_END_ = 52,                             // "end"
        S_ENUM = 53,                             // "enum"
        S_EQ = 54,                               // "=="
        S_ERROR = 55,                            // "error"
        S_EXCEPTION = 56,                        // "exception"
        S_EXPORT = 57,                           // "export"
        S_EXTERN = 58,                           // "extern"
        S_EXTERN_NO_SUSPEND = 59,                // "extern-no-suspend"
        S_FILE = 60,                             // "file"
        S_FINALIZE = 61,                         // "~finally"
        S_FOR = 62,                              // "for"
        S_FROM = 63,                             // "from"
        S_FUNCTION = 64,                         // "function"
        S_GEQ = 65,                              // ">="
        S_GLOBAL = 66,                           // "global"
        S_HASATTR = 67,                          // "?."
        S_HOOK = 68,                             // "hook"
        S_IF = 69,                               // "if"
        S_IMPORT = 70,                           // "import"
        S_IN = 71,                               // "in"
        S_INIT = 72,                             // "init"
        S_INOUT = 73,                            // "inout"
        S_INT = 74,                              // "int"
        S_INT16 = 75,                            // "int16"
        S_INT32 = 76,                            // "int32"
        S_INT64 = 77,                            // "int64"
        S_INT8 = 78,                             // "int8"
        S_INTERVAL = 79,                         // "interval"
        S_INTERVAL_NS = 80,                      // "interval_ns"
        S_IOSRC = 81,                            // "iosrc"
        S_ITERATOR = 82,                         // "iterator"
        S_CONST_ITERATOR = 83,                   // "const_iterator"
        S_LEQ = 84,                              // "<="
        S_LIBRARY_TYPE = 85,                     // "library type"
        S_LIBRARY_TYPE_CONST = 86,               // "const library type"
        S_LIST = 87,                             // "list"
        S_LOCAL = 88,                            // "local"
        S_MAP = 89,                              // "map"
        S_MATCH_TOKEN_STATE = 90,                // "match_token_state"
        S_METHOD = 91,                           // "method"
        S_MINUSASSIGN = 92,                      // "-="
        S_MINUSMINUS = 93,                       // "--"
        S_MOD = 94,                              // "%"
        S_MODULE = 95,                           // "module"
        S_MOVE = 96,                             // "move"
        S_NEW = 97,                              // "new"
        S_NEQ = 98,                              // "!="
        S_NETWORK = 99,                          // "net"
        S_NOT_IN = 100,                          // "!in"
        S_OPTIONAL = 101,                        // "optional"
        S_OR = 102,                              // "||"
        S_OVERLAY = 103,                         // "overlay"
        S_PACK = 104,                            // "pack"
        S_PLUSASSIGN = 105,                      // "+="
        S_PLUSPLUS = 106,                        // "++"
        S_PORT = 107,                            // "port"
        S_POW = 108,                             // "**"
        S_PREINIT = 109,                         // "preinit"
        S_PRIVATE = 110,                         // "private"
        S_PUBLIC = 111,                          // "public"
        S_STRONG_REF = 112,                      // "strong_ref"
        S_REGEXP = 113,                          // "regexp"
        S_RESULT = 114,                          // "result"
        S_RETURN = 115,                          // "return"
        S_SCOPE = 116,                           // "scope"
        S_SET = 117,                             // "set"
        S_SHIFTLEFT = 118,                       // "<<"
        S_SHIFTRIGHT = 119,                      // ">>"
        S_STREAM = 120,                          // "stream"
        S_STRING = 121,                          // "string"
        S_STRUCT = 122,                          // "struct"
        S_SWITCH = 123,                          // "switch"
        S_TIME = 124,                            // "time"
        S_TIME_NS = 125,                         // "time_ns"
        S_TIMER = 126,                           // "timer"
        S_TIMERMGR = 127,                        // "timer_mgr"
        S_TIMESASSIGN = 128,                     // "*="
        S_THROW = 129,                           // "throw"
        S_TRY = 130,                             // "try"
        S_TRYATTR = 131,                         // ".?"
        S_TUPLE = 132,                           // "tuple"
        S_TYPE = 133,                            // "type"
        S_TYPEINFO = 134,                        // "typeinfo"
        S_UINT = 135,                            // "uint"
        S_UINT16 = 136,                          // "uint16"
        S_UINT32 = 137,                          // "uint32"
        S_UINT64 = 138,                          // "uint64"
        S_UINT8 = 139,                           // "uint8"
        S_UNION = 140,                           // "union"
        S_UNPACK = 141,                          // "unpack"
        S_UNSET = 142,                           // "unset"
        S_VECTOR = 143,                          // "vector"
        S_VIEW = 144,                            // "view"
        S_VOID = 145,                            // "void"
        S_WHILE = 146,                           // "while"
        S_WITH = 147,                            // "with"
        S_VALUE_REF = 148,                       // "value_ref"
        S_WEAK_REF = 149,                        // "weak_ref"
        S_YIELD = 150,                           // "yield"
        S_151_ = 151,                            // '='
        S_152_ = 152,                            // '?'
        S_153_ = 153,                            // ':'
        S_154_ = 154,                            // '<'
        S_155_ = 155,                            // '>'
        S_156_ = 156,                            // '|'
        S_157_ = 157,                            // '^'
        S_158_ = 158,                            // '&'
        S_159_ = 159,                            // '+'
        S_160_ = 160,                            // '-'
        S_161_ = 161,                            // '%'
        S_162_ = 162,                            // '*'
        S_163_ = 163,                            // '/'
        S_UNARY_PREC = 164,                      // UNARY_PREC
        S_165_ = 165,                            // '.'
        S_166_ = 166,                            // '['
        S_167_ = 167,                            // '{'
        S_168_ = 168,                            // '}'
        S_169_ = 169,                            // ';'
        S_170_ = 170,                            // '('
        S_171_ = 171,                            // ')'
        S_172_ = 172,                            // ','
        S_173_ = 173,                            // ']'
        S_174_ = 174,                            // '!'
        S_175_ = 175,                            // '~'
        S_176_ = 176,                            // '$'
        S_YYACCEPT = 177,                        // $accept
        S_module = 178,                          // module
        S_local_id = 179,                        // local_id
        S_scoped_id = 180,                       // scoped_id
        S_dotted_id = 181,                       // dotted_id
        S_182_1 = 182,                           // $@1
        S_183_2 = 183,                           // $@2
        S_global_scope_items = 184,              // global_scope_items
        S_global_scope_decl = 185,               // global_scope_decl
        S_type_decl = 186,                       // type_decl
        S_constant_decl = 187,                   // constant_decl
        S_local_decl = 188,                      // local_decl
        S_local_init_decl = 189,                 // local_init_decl
        S_global_decl = 190,                     // global_decl
        S_opt_type_arguments = 191,              // opt_type_arguments
        S_function_decl = 192,                   // function_decl
        S_import_decl = 193,                     // import_decl
        S_property_decl = 194,                   // property_decl
        S_opt_linkage = 195,                     // opt_linkage
        S_function_id = 196,                     // function_id
        S_scoped_function_id = 197,              // scoped_function_id
        S_function_with_body = 198,              // function_with_body
        S_method_with_body = 199,                // method_with_body
        S_hook_with_body = 200,                  // hook_with_body
        S_function_without_body = 201,           // function_without_body
        S_opt_func_flavor = 202,                 // opt_func_flavor
        S_func_flavor = 203,                     // func_flavor
        S_opt_func_cc = 204,                     // opt_func_cc
        S_opt_func_params = 205,                 // opt_func_params
        S_func_params = 206,                     // func_params
        S_func_param = 207,                      // func_param
        S_func_param_type = 208,                 // func_param_type
        S_opt_func_param_kind = 209,             // opt_func_param_kind
        S_opt_func_default_expr = 210,           // opt_func_default_expr
        S_block = 211,                           // block
        S_braced_block = 212,                    // braced_block
        S_opt_stmts = 213,                       // opt_stmts
        S_stmts = 214,                           // stmts
        S_stmt = 215,                            // stmt
        S_opt_else_block = 216,                  // opt_else_block
        S_opt_switch_cases = 217,                // opt_switch_cases
        S_switch_cases = 218,                    // switch_cases
        S_switch_case = 219,                     // switch_case
        S_case_exprs = 220,                      // case_exprs
        S_try_catches = 221,                     // try_catches
        S_try_catch = 222,                       // try_catch
        S_stmt_decl = 223,                       // stmt_decl
        S_stmt_expr = 224,                       // stmt_expr
        S_base_type_no_attrs = 225,              // base_type_no_attrs
        S_base_type = 226,                       // base_type
        S_type = 227,                            // type
        S_qtype = 228,                           // qtype
        S_type_param_begin = 229,                // type_param_begin
        S_type_param_end = 230,                  // type_param_end
        S_function_type = 231,                   // function_type
        S_tuple_type = 232,                      // tuple_type
        S_tuple_type_elems = 233,                // tuple_type_elems
        S_tuple_type_elem = 234,                 // tuple_type_elem
        S_struct_type = 235,                     // struct_type
        S_opt_struct_params = 236,               // opt_struct_params
        S_struct_fields = 237,                   // struct_fields
        S_struct_field = 238,                    // struct_field
        S_union_type = 239,                      // union_type
        S_opt_union_fields = 240,                // opt_union_fields
        S_union_fields = 241,                    // union_fields
        S_union_field = 242,                     // union_field
        S_enum_type = 243,                       // enum_type
        S_enum_labels = 244,                     // enum_labels
        S_enum_label = 245,                      // enum_label
        S_bitfield_type = 246,                   // bitfield_type
        S_247_3 = 247,                           // $@3
        S_opt_bitfield_bit_ranges = 248,         // opt_bitfield_bit_ranges
        S_bitfield_bit_ranges = 249,             // bitfield_bit_ranges
        S_bitfield_bit_range = 250,              // bitfield_bit_range
        S_expr = 251,                            // expr
        S_expr_no_or_error = 252,                // expr_no_or_error
        S_opt_exprs = 253,                       // opt_exprs
        S_exprs = 254,                           // exprs
        S_expr_or_error = 255,                   // expr_or_error
        S_expr_1 = 256,                          // expr_1
        S_call_expr = 257,                       // call_expr
        S_member_expr = 258,                     // member_expr
        S_ctor = 259,                            // ctor
        S_ctor_expr = 260,                       // ctor_expr
        S_tuple = 261,                           // tuple
        S_opt_tuple_elems1 = 262,                // opt_tuple_elems1
        S_opt_tuple_elems2 = 263,                // opt_tuple_elems2
        S_tuple_elem = 264,                      // tuple_elem
        S_tuple_expr = 265,                      // tuple_expr
        S_list = 266,                            // list
        S_set = 267,                             // set
        S_map = 268,                             // map
        S_struct_ = 269,                         // struct_
        S_struct_elems = 270,                    // struct_elems
        S_struct_elem = 271,                     // struct_elem
        S_regexp = 272,                          // regexp
        S_re_patterns = 273,                     // re_patterns
        S_re_pattern_constant = 274,             // re_pattern_constant
        S_275_4 = 275,                           // $@4
        S_276_5 = 276,                           // $@5
        S_opt_re_pattern_constant_flags = 277,   // opt_re_pattern_constant_flags
        S_opt_map_elems = 278,                   // opt_map_elems
        S_map_elems = 279,                       // map_elems
        S_map_elem = 280,                        // map_elem
        S_attribute = 281,                       // attribute
        S_opt_attributes = 282                   // opt_attributes
      };
    };

    /// (Internal) symbol kind.
    typedef symbol_kind::symbol_kind_type symbol_kind_type;

    /// The number of tokens.
    static const symbol_kind_type YYNTOKENS = symbol_kind::YYNTOKENS;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol kind
    /// via kind ().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol () YY_NOEXCEPT
        : value ()
        , location ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that)
        : Base (std::move (that))
        , value ()
        , location (std::move (that.location))
      {
        switch (this->kind ())
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.move< bool > (std::move (that.value));
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.move< double > (std::move (that.value));
        break;

      case symbol_kind::S_attribute: // attribute
        value.move< hilti::Attribute* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.move< hilti::AttributeSet* > (std::move (that.value));
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.move< hilti::Ctor* > (std::move (that.value));
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.move< hilti::Declaration* > (std::move (that.value));
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.move< hilti::Declarations > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.move< hilti::Expression* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.move< hilti::Expressions > (std::move (that.value));
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.move< hilti::Function* > (std::move (that.value));
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.move< hilti::ID > (std::move (that.value));
        break;

      case symbol_kind::S_qtype: // qtype
        value.move< hilti::QualifiedType* > (std::move (that.value));
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.move< hilti::Statement* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.move< hilti::Statements > (std::move (that.value));
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.move< hilti::UnqualifiedType* > (std::move (that.value));
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.move< hilti::ctor::map::Element* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.move< hilti::ctor::map::Elements > (std::move (that.value));
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.move< hilti::ctor::regexp::Pattern > (std::move (that.value));
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.move< hilti::ctor::regexp::Patterns > (std::move (that.value));
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.move< hilti::ctor::struct_::Field* > (std::move (that.value));
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.move< hilti::ctor::struct_::Fields > (std::move (that.value));
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.move< hilti::declaration::Linkage > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.move< hilti::parameter::Kind > (std::move (that.value));
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.move< hilti::statement::switch_::Case* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.move< hilti::statement::switch_::Cases > (std::move (that.value));
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.move< hilti::statement::try_::Catch* > (std::move (that.value));
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.move< hilti::statement::try_::Catches > (std::move (that.value));
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.move< hilti::type::bitfield::BitRange* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.move< hilti::type::bitfield::BitRanges > (std::move (that.value));
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.move< hilti::type::enum_::Label* > (std::move (that.value));
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.move< hilti::type::enum_::Labels > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.move< hilti::type::function::CallingConvention > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.move< hilti::type::function::Flavor > (std::move (that.value));
        break;

      case symbol_kind::S_func_param: // func_param
        value.move< hilti::type::function::Parameter* > (std::move (that.value));
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.move< hilti::type::function::Parameters > (std::move (that.value));
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.move< hilti::type::tuple::Element* > (std::move (that.value));
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.move< hilti::type::tuple::Elements > (std::move (that.value));
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.move< std::pair<Declarations, Statements> > (std::move (that.value));
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.move< std::string > (std::move (that.value));
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.move< uint64_t > (std::move (that.value));
        break;

      default:
        break;
    }

      }
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructors for typed symbols.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, location_type&& l)
        : Base (t)
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const location_type& l)
        : Base (t)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, bool&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const bool& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, double&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const double& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Attribute*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Attribute*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::AttributeSet*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::AttributeSet*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Ctor*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Ctor*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Declaration*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Declaration*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Declarations&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Declarations& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Expression*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Expression*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Expressions&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Expressions& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Function*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Function*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ID&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ID& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::QualifiedType*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::QualifiedType*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Statement*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Statement*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::Statements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::Statements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::UnqualifiedType*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::UnqualifiedType*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::map::Element*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::map::Element*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::map::Elements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::map::Elements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::regexp::Pattern&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::regexp::Pattern& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::regexp::Patterns&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::regexp::Patterns& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::struct_::Field*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::struct_::Field*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::ctor::struct_::Fields&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::ctor::struct_::Fields& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::declaration::Linkage&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::declaration::Linkage& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::parameter::Kind&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::parameter::Kind& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::switch_::Case*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::switch_::Case*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::switch_::Cases&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::switch_::Cases& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::try_::Catch*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::try_::Catch*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::statement::try_::Catches&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::statement::try_::Catches& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::bitfield::BitRange*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::bitfield::BitRange*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::bitfield::BitRanges&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::bitfield::BitRanges& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::enum_::Label*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::enum_::Label*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::enum_::Labels&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::enum_::Labels& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::CallingConvention&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::CallingConvention& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::Flavor&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::Flavor& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::Parameter*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::Parameter*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::function::Parameters&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::function::Parameters& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::tuple::Element*&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::tuple::Element*& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, hilti::type::tuple::Elements&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const hilti::type::tuple::Elements& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::pair<Declarations, Statements>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::pair<Declarations, Statements>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::string&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::string& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, uint64_t&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const uint64_t& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }



      /// Destroy contents, and record that is empty.
      void clear () YY_NOEXCEPT
      {
        // User destructor.
        symbol_kind_type yykind = this->kind ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yykind)
        {
       default:
          break;
        }

        // Value type destructor.
switch (yykind)
    {
      case symbol_kind::S_CBOOL: // "bool value"
        value.template destroy< bool > ();
        break;

      case symbol_kind::S_CUREAL: // "real value"
        value.template destroy< double > ();
        break;

      case symbol_kind::S_attribute: // attribute
        value.template destroy< hilti::Attribute* > ();
        break;

      case symbol_kind::S_opt_attributes: // opt_attributes
        value.template destroy< hilti::AttributeSet* > ();
        break;

      case symbol_kind::S_ctor: // ctor
      case symbol_kind::S_tuple: // tuple
      case symbol_kind::S_list: // list
      case symbol_kind::S_set: // set
      case symbol_kind::S_map: // map
      case symbol_kind::S_struct_: // struct_
      case symbol_kind::S_regexp: // regexp
        value.template destroy< hilti::Ctor* > ();
        break;

      case symbol_kind::S_global_scope_decl: // global_scope_decl
      case symbol_kind::S_type_decl: // type_decl
      case symbol_kind::S_constant_decl: // constant_decl
      case symbol_kind::S_local_decl: // local_decl
      case symbol_kind::S_local_init_decl: // local_init_decl
      case symbol_kind::S_global_decl: // global_decl
      case symbol_kind::S_function_decl: // function_decl
      case symbol_kind::S_import_decl: // import_decl
      case symbol_kind::S_property_decl: // property_decl
      case symbol_kind::S_struct_field: // struct_field
      case symbol_kind::S_union_field: // union_field
        value.template destroy< hilti::Declaration* > ();
        break;

      case symbol_kind::S_struct_fields: // struct_fields
      case symbol_kind::S_opt_union_fields: // opt_union_fields
      case symbol_kind::S_union_fields: // union_fields
        value.template destroy< hilti::Declarations > ();
        break;

      case symbol_kind::S_opt_func_default_expr: // opt_func_default_expr
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_no_or_error: // expr_no_or_error
      case symbol_kind::S_expr_or_error: // expr_or_error
      case symbol_kind::S_expr_1: // expr_1
      case symbol_kind::S_call_expr: // call_expr
      case symbol_kind::S_member_expr: // member_expr
      case symbol_kind::S_ctor_expr: // ctor_expr
      case symbol_kind::S_tuple_elem: // tuple_elem
      case symbol_kind::S_tuple_expr: // tuple_expr
        value.template destroy< hilti::Expression* > ();
        break;

      case symbol_kind::S_opt_type_arguments: // opt_type_arguments
      case symbol_kind::S_case_exprs: // case_exprs
      case symbol_kind::S_opt_exprs: // opt_exprs
      case symbol_kind::S_exprs: // exprs
      case symbol_kind::S_opt_tuple_elems1: // opt_tuple_elems1
      case symbol_kind::S_opt_tuple_elems2: // opt_tuple_elems2
        value.template destroy< hilti::Expressions > ();
        break;

      case symbol_kind::S_function_with_body: // function_with_body
      case symbol_kind::S_method_with_body: // method_with_body
      case symbol_kind::S_hook_with_body: // hook_with_body
      case symbol_kind::S_function_without_body: // function_without_body
        value.template destroy< hilti::Function* > ();
        break;

      case symbol_kind::S_local_id: // local_id
      case symbol_kind::S_scoped_id: // scoped_id
      case symbol_kind::S_dotted_id: // dotted_id
      case symbol_kind::S_function_id: // function_id
      case symbol_kind::S_scoped_function_id: // scoped_function_id
        value.template destroy< hilti::ID > ();
        break;

      case symbol_kind::S_qtype: // qtype
        value.template destroy< hilti::QualifiedType* > ();
        break;

      case symbol_kind::S_block: // block
      case symbol_kind::S_braced_block: // braced_block
      case symbol_kind::S_stmt: // stmt
      case symbol_kind::S_opt_else_block: // opt_else_block
      case symbol_kind::S_stmt_decl: // stmt_decl
      case symbol_kind::S_stmt_expr: // stmt_expr
        value.template destroy< hilti::Statement* > ();
        break;

      case symbol_kind::S_opt_stmts: // opt_stmts
      case symbol_kind::S_stmts: // stmts
        value.template destroy< hilti::Statements > ();
        break;

      case symbol_kind::S_func_param_type: // func_param_type
      case symbol_kind::S_base_type_no_attrs: // base_type_no_attrs
      case symbol_kind::S_base_type: // base_type
      case symbol_kind::S_type: // type
      case symbol_kind::S_function_type: // function_type
      case symbol_kind::S_tuple_type: // tuple_type
      case symbol_kind::S_struct_type: // struct_type
      case symbol_kind::S_union_type: // union_type
      case symbol_kind::S_enum_type: // enum_type
      case symbol_kind::S_bitfield_type: // bitfield_type
        value.template destroy< hilti::UnqualifiedType* > ();
        break;

      case symbol_kind::S_map_elem: // map_elem
        value.template destroy< hilti::ctor::map::Element* > ();
        break;

      case symbol_kind::S_opt_map_elems: // opt_map_elems
      case symbol_kind::S_map_elems: // map_elems
        value.template destroy< hilti::ctor::map::Elements > ();
        break;

      case symbol_kind::S_re_pattern_constant: // re_pattern_constant
      case symbol_kind::S_opt_re_pattern_constant_flags: // opt_re_pattern_constant_flags
        value.template destroy< hilti::ctor::regexp::Pattern > ();
        break;

      case symbol_kind::S_re_patterns: // re_patterns
        value.template destroy< hilti::ctor::regexp::Patterns > ();
        break;

      case symbol_kind::S_struct_elem: // struct_elem
        value.template destroy< hilti::ctor::struct_::Field* > ();
        break;

      case symbol_kind::S_struct_elems: // struct_elems
        value.template destroy< hilti::ctor::struct_::Fields > ();
        break;

      case symbol_kind::S_opt_linkage: // opt_linkage
        value.template destroy< hilti::declaration::Linkage > ();
        break;

      case symbol_kind::S_opt_func_param_kind: // opt_func_param_kind
        value.template destroy< hilti::parameter::Kind > ();
        break;

      case symbol_kind::S_switch_case: // switch_case
        value.template destroy< hilti::statement::switch_::Case* > ();
        break;

      case symbol_kind::S_opt_switch_cases: // opt_switch_cases
      case symbol_kind::S_switch_cases: // switch_cases
        value.template destroy< hilti::statement::switch_::Cases > ();
        break;

      case symbol_kind::S_try_catch: // try_catch
        value.template destroy< hilti::statement::try_::Catch* > ();
        break;

      case symbol_kind::S_try_catches: // try_catches
        value.template destroy< hilti::statement::try_::Catches > ();
        break;

      case symbol_kind::S_bitfield_bit_range: // bitfield_bit_range
        value.template destroy< hilti::type::bitfield::BitRange* > ();
        break;

      case symbol_kind::S_opt_bitfield_bit_ranges: // opt_bitfield_bit_ranges
      case symbol_kind::S_bitfield_bit_ranges: // bitfield_bit_ranges
        value.template destroy< hilti::type::bitfield::BitRanges > ();
        break;

      case symbol_kind::S_enum_label: // enum_label
        value.template destroy< hilti::type::enum_::Label* > ();
        break;

      case symbol_kind::S_enum_labels: // enum_labels
        value.template destroy< hilti::type::enum_::Labels > ();
        break;

      case symbol_kind::S_opt_func_cc: // opt_func_cc
        value.template destroy< hilti::type::function::CallingConvention > ();
        break;

      case symbol_kind::S_opt_func_flavor: // opt_func_flavor
      case symbol_kind::S_func_flavor: // func_flavor
        value.template destroy< hilti::type::function::Flavor > ();
        break;

      case symbol_kind::S_func_param: // func_param
        value.template destroy< hilti::type::function::Parameter* > ();
        break;

      case symbol_kind::S_opt_func_params: // opt_func_params
      case symbol_kind::S_func_params: // func_params
      case symbol_kind::S_opt_struct_params: // opt_struct_params
        value.template destroy< hilti::type::function::Parameters > ();
        break;

      case symbol_kind::S_tuple_type_elem: // tuple_type_elem
        value.template destroy< hilti::type::tuple::Element* > ();
        break;

      case symbol_kind::S_tuple_type_elems: // tuple_type_elems
        value.template destroy< hilti::type::tuple::Elements > ();
        break;

      case symbol_kind::S_global_scope_items: // global_scope_items
        value.template destroy< std::pair<Declarations, Statements> > ();
        break;

      case symbol_kind::S_IDENT: // "identifier"
      case symbol_kind::S_SCOPED_IDENT: // "scoped identifier"
      case symbol_kind::S_SCOPED_FINALIZE: // "scoped ~finally"
      case symbol_kind::S_DOTTED_IDENT: // "dotted identifier"
      case symbol_kind::S_ATTRIBUTE: // "attribute"
      case symbol_kind::S_PROPERTY: // "property"
      case symbol_kind::S_CSTRING: // "string value"
      case symbol_kind::S_CBYTES: // "bytes value"
      case symbol_kind::S_CREGEXP: // "regular expression value"
      case symbol_kind::S_CADDRESS: // "address value"
      case symbol_kind::S_CPORT: // "port value"
        value.template destroy< std::string > ();
        break;

      case symbol_kind::S_CUINTEGER: // "unsigned integer value"
        value.template destroy< uint64_t > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// The user-facing name of this symbol.
      std::string name () const YY_NOEXCEPT
      {
        return Parser::symbol_name (this->kind ());
      }

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      value_type value;

      /// The location.
      location_type location;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_kind
    {
      /// The symbol kind as needed by the constructor.
      typedef token_kind_type kind_type;

      /// Default constructor.
      by_kind () YY_NOEXCEPT;

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_kind (by_kind&& that) YY_NOEXCEPT;
#endif

      /// Copy constructor.
      by_kind (const by_kind& that) YY_NOEXCEPT;

      /// Constructor from (external) token numbers.
      by_kind (kind_type t) YY_NOEXCEPT;



      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_kind& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// The symbol kind.
      /// \a S_YYEMPTY when empty.
      symbol_kind_type kind_;
    };

    /// Backward compatibility for a private implementation detail (Bison 3.6).
    typedef by_kind by_type;

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_kind>
    {
      /// Superclass.
      typedef basic_symbol<by_kind> super_type;

      /// Empty symbol.
      symbol_type () YY_NOEXCEPT {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, location_type l)
        : super_type (token_kind_type (tok), std::move (l))
#else
      symbol_type (int tok, const location_type& l)
        : super_type (token_kind_type (tok), l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, bool v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const bool& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, double v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const double& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, std::string v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const std::string& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, uint64_t v, location_type l)
        : super_type (token_kind_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const uint64_t& v, const location_type& l)
        : super_type (token_kind_type (tok), v, l)
#endif
      {}
    };

    /// Build a parser object.
    Parser (Driver* driver_yyarg, Builder* builder_yyarg);
    virtual ~Parser ();

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    Parser (const Parser&) = delete;
    /// Non copyable.
    Parser& operator= (const Parser&) = delete;
#endif

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    /// The user-facing name of the symbol whose (internal) number is
    /// YYSYMBOL.  No bounds checking.
    static std::string symbol_name (symbol_kind_type yysymbol);

    // Implementation of make_symbol for each token kind.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EOD (location_type l)
      {
        return symbol_type (token::EOD, std::move (l));
      }
#else
      static
      symbol_type
      make_EOD (const location_type& l)
      {
        return symbol_type (token::EOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYerror (location_type l)
      {
        return symbol_type (token::YYerror, std::move (l));
      }
#else
      static
      symbol_type
      make_YYerror (const location_type& l)
      {
        return symbol_type (token::YYerror, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYUNDEF (location_type l)
      {
        return symbol_type (token::YYUNDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYUNDEF (const location_type& l)
      {
        return symbol_type (token::YYUNDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCOPED_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::SCOPED_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_SCOPED_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::SCOPED_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCOPED_FINALIZE (std::string v, location_type l)
      {
        return symbol_type (token::SCOPED_FINALIZE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_SCOPED_FINALIZE (const std::string& v, const location_type& l)
      {
        return symbol_type (token::SCOPED_FINALIZE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOTTED_IDENT (std::string v, location_type l)
      {
        return symbol_type (token::DOTTED_IDENT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DOTTED_IDENT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::DOTTED_IDENT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ATTRIBUTE (std::string v, location_type l)
      {
        return symbol_type (token::ATTRIBUTE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ATTRIBUTE (const std::string& v, const location_type& l)
      {
        return symbol_type (token::ATTRIBUTE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPERTY (std::string v, location_type l)
      {
        return symbol_type (token::PROPERTY, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PROPERTY (const std::string& v, const location_type& l)
      {
        return symbol_type (token::PROPERTY, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CSTRING (std::string v, location_type l)
      {
        return symbol_type (token::CSTRING, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CSTRING (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CSTRING, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBYTES (std::string v, location_type l)
      {
        return symbol_type (token::CBYTES, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CBYTES (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CBYTES, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CREGEXP (std::string v, location_type l)
      {
        return symbol_type (token::CREGEXP, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CREGEXP (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CREGEXP, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CADDRESS (std::string v, location_type l)
      {
        return symbol_type (token::CADDRESS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CADDRESS (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CADDRESS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CPORT (std::string v, location_type l)
      {
        return symbol_type (token::CPORT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CPORT (const std::string& v, const location_type& l)
      {
        return symbol_type (token::CPORT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUREAL (double v, location_type l)
      {
        return symbol_type (token::CUREAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CUREAL (const double& v, const location_type& l)
      {
        return symbol_type (token::CUREAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUINTEGER (uint64_t v, location_type l)
      {
        return symbol_type (token::CUINTEGER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CUINTEGER (const uint64_t& v, const location_type& l)
      {
        return symbol_type (token::CUINTEGER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBOOL (bool v, location_type l)
      {
        return symbol_type (token::CBOOL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CBOOL (const bool& v, const location_type& l)
      {
        return symbol_type (token::CBOOL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD (location_type l)
      {
        return symbol_type (token::ADD, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD (const location_type& l)
      {
        return symbol_type (token::ADD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASSERT (location_type l)
      {
        return symbol_type (token::ASSERT, std::move (l));
      }
#else
      static
      symbol_type
      make_ASSERT (const location_type& l)
      {
        return symbol_type (token::ASSERT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASSERT_EXCEPTION (location_type l)
      {
        return symbol_type (token::ASSERT_EXCEPTION, std::move (l));
      }
#else
      static
      symbol_type
      make_ASSERT_EXCEPTION (const location_type& l)
      {
        return symbol_type (token::ASSERT_EXCEPTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADDRESS (location_type l)
      {
        return symbol_type (token::ADDRESS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADDRESS (const location_type& l)
      {
        return symbol_type (token::ADDRESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AFTER (location_type l)
      {
        return symbol_type (token::AFTER, std::move (l));
      }
#else
      static
      symbol_type
      make_AFTER (const location_type& l)
      {
        return symbol_type (token::AFTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AND (location_type l)
      {
        return symbol_type (token::AND, std::move (l));
      }
#else
      static
      symbol_type
      make_AND (const location_type& l)
      {
        return symbol_type (token::AND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANY (location_type l)
      {
        return symbol_type (token::ANY, std::move (l));
      }
#else
      static
      symbol_type
      make_ANY (const location_type& l)
      {
        return symbol_type (token::ANY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ARROW (location_type l)
      {
        return symbol_type (token::ARROW, std::move (l));
      }
#else
      static
      symbol_type
      make_ARROW (const location_type& l)
      {
        return symbol_type (token::ARROW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AUTO (location_type l)
      {
        return symbol_type (token::AUTO, std::move (l));
      }
#else
      static
      symbol_type
      make_AUTO (const location_type& l)
      {
        return symbol_type (token::AUTO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AT (location_type l)
      {
        return symbol_type (token::AT, std::move (l));
      }
#else
      static
      symbol_type
      make_AT (const location_type& l)
      {
        return symbol_type (token::AT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BEGIN_ (location_type l)
      {
        return symbol_type (token::BEGIN_, std::move (l));
      }
#else
      static
      symbol_type
      make_BEGIN_ (const location_type& l)
      {
        return symbol_type (token::BEGIN_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BITFIELD (location_type l)
      {
        return symbol_type (token::BITFIELD, std::move (l));
      }
#else
      static
      symbol_type
      make_BITFIELD (const location_type& l)
      {
        return symbol_type (token::BITFIELD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOOL (location_type l)
      {
        return symbol_type (token::BOOL, std::move (l));
      }
#else
      static
      symbol_type
      make_BOOL (const location_type& l)
      {
        return symbol_type (token::BOOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BREAK (location_type l)
      {
        return symbol_type (token::BREAK, std::move (l));
      }
#else
      static
      symbol_type
      make_BREAK (const location_type& l)
      {
        return symbol_type (token::BREAK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BYTES (location_type l)
      {
        return symbol_type (token::BYTES, std::move (l));
      }
#else
      static
      symbol_type
      make_BYTES (const location_type& l)
      {
        return symbol_type (token::BYTES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CADDR (location_type l)
      {
        return symbol_type (token::CADDR, std::move (l));
      }
#else
      static
      symbol_type
      make_CADDR (const location_type& l)
      {
        return symbol_type (token::CADDR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CALLABLE (location_type l)
      {
        return symbol_type (token::CALLABLE, std::move (l));
      }
#else
      static
      symbol_type
      make_CALLABLE (const location_type& l)
      {
        return symbol_type (token::CALLABLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CASE (location_type l)
      {
        return symbol_type (token::CASE, std::move (l));
      }
#else
      static
      symbol_type
      make_CASE (const location_type& l)
      {
        return symbol_type (token::CASE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CAST (location_type l)
      {
        return symbol_type (token::CAST, std::move (l));
      }
#else
      static
      symbol_type
      make_CAST (const location_type& l)
      {
        return symbol_type (token::CAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CATCH (location_type l)
      {
        return symbol_type (token::CATCH, std::move (l));
      }
#else
      static
      symbol_type
      make_CATCH (const location_type& l)
      {
        return symbol_type (token::CATCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHANNEL (location_type l)
      {
        return symbol_type (token::CHANNEL, std::move (l));
      }
#else
      static
      symbol_type
      make_CHANNEL (const location_type& l)
      {
        return symbol_type (token::CHANNEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CLASSIFIER (location_type l)
      {
        return symbol_type (token::CLASSIFIER, std::move (l));
      }
#else
      static
      symbol_type
      make_CLASSIFIER (const location_type& l)
      {
        return symbol_type (token::CLASSIFIER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CNULL (location_type l)
      {
        return symbol_type (token::CNULL, std::move (l));
      }
#else
      static
      symbol_type
      make_CNULL (const location_type& l)
      {
        return symbol_type (token::CNULL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONST (location_type l)
      {
        return symbol_type (token::CONST, std::move (l));
      }
#else
      static
      symbol_type
      make_CONST (const location_type& l)
      {
        return symbol_type (token::CONST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTINUE (location_type l)
      {
        return symbol_type (token::CONTINUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTINUE (const location_type& l)
      {
        return symbol_type (token::CONTINUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTEXT (location_type l)
      {
        return symbol_type (token::CONTEXT, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTEXT (const location_type& l)
      {
        return symbol_type (token::CONTEXT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COPY (location_type l)
      {
        return symbol_type (token::COPY, std::move (l));
      }
#else
      static
      symbol_type
      make_COPY (const location_type& l)
      {
        return symbol_type (token::COPY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DECLARE (location_type l)
      {
        return symbol_type (token::DECLARE, std::move (l));
      }
#else
      static
      symbol_type
      make_DECLARE (const location_type& l)
      {
        return symbol_type (token::DECLARE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFAULT (location_type l)
      {
        return symbol_type (token::DEFAULT, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFAULT (const location_type& l)
      {
        return symbol_type (token::DEFAULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DELETE (location_type l)
      {
        return symbol_type (token::DELETE, std::move (l));
      }
#else
      static
      symbol_type
      make_DELETE (const location_type& l)
      {
        return symbol_type (token::DELETE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIVIDEASSIGN (location_type l)
      {
        return symbol_type (token::DIVIDEASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_DIVIDEASSIGN (const location_type& l)
      {
        return symbol_type (token::DIVIDEASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOLLARDOLLAR (location_type l)
      {
        return symbol_type (token::DOLLARDOLLAR, std::move (l));
      }
#else
      static
      symbol_type
      make_DOLLARDOLLAR (const location_type& l)
      {
        return symbol_type (token::DOLLARDOLLAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOTDOT (location_type l)
      {
        return symbol_type (token::DOTDOT, std::move (l));
      }
#else
      static
      symbol_type
      make_DOTDOT (const location_type& l)
      {
        return symbol_type (token::DOTDOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL (location_type l)
      {
        return symbol_type (token::REAL, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL (const location_type& l)
      {
        return symbol_type (token::REAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ELSE (location_type l)
      {
        return symbol_type (token::ELSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ELSE (const location_type& l)
      {
        return symbol_type (token::ELSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_END_ (location_type l)
      {
        return symbol_type (token::END_, std::move (l));
      }
#else
      static
      symbol_type
      make_END_ (const location_type& l)
      {
        return symbol_type (token::END_, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENUM (location_type l)
      {
        return symbol_type (token::ENUM, std::move (l));
      }
#else
      static
      symbol_type
      make_ENUM (const location_type& l)
      {
        return symbol_type (token::ENUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ (location_type l)
      {
        return symbol_type (token::EQ, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ (const location_type& l)
      {
        return symbol_type (token::EQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR (location_type l)
      {
        return symbol_type (token::ERROR, std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR (const location_type& l)
      {
        return symbol_type (token::ERROR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCEPTION (location_type l)
      {
        return symbol_type (token::EXCEPTION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCEPTION (const location_type& l)
      {
        return symbol_type (token::EXCEPTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPORT (location_type l)
      {
        return symbol_type (token::EXPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPORT (const location_type& l)
      {
        return symbol_type (token::EXPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTERN (location_type l)
      {
        return symbol_type (token::EXTERN, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTERN (const location_type& l)
      {
        return symbol_type (token::EXTERN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTERN_NO_SUSPEND (location_type l)
      {
        return symbol_type (token::EXTERN_NO_SUSPEND, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTERN_NO_SUSPEND (const location_type& l)
      {
        return symbol_type (token::EXTERN_NO_SUSPEND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE (location_type l)
      {
        return symbol_type (token::FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE (const location_type& l)
      {
        return symbol_type (token::FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FINALIZE (location_type l)
      {
        return symbol_type (token::FINALIZE, std::move (l));
      }
#else
      static
      symbol_type
      make_FINALIZE (const location_type& l)
      {
        return symbol_type (token::FINALIZE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOR (location_type l)
      {
        return symbol_type (token::FOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FOR (const location_type& l)
      {
        return symbol_type (token::FOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FROM (location_type l)
      {
        return symbol_type (token::FROM, std::move (l));
      }
#else
      static
      symbol_type
      make_FROM (const location_type& l)
      {
        return symbol_type (token::FROM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION (location_type l)
      {
        return symbol_type (token::FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION (const location_type& l)
      {
        return symbol_type (token::FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GEQ (location_type l)
      {
        return symbol_type (token::GEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_GEQ (const location_type& l)
      {
        return symbol_type (token::GEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GLOBAL (location_type l)
      {
        return symbol_type (token::GLOBAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GLOBAL (const location_type& l)
      {
        return symbol_type (token::GLOBAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HASATTR (location_type l)
      {
        return symbol_type (token::HASATTR, std::move (l));
      }
#else
      static
      symbol_type
      make_HASATTR (const location_type& l)
      {
        return symbol_type (token::HASATTR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOOK (location_type l)
      {
        return symbol_type (token::HOOK, std::move (l));
      }
#else
      static
      symbol_type
      make_HOOK (const location_type& l)
      {
        return symbol_type (token::HOOK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IF (location_type l)
      {
        return symbol_type (token::IF, std::move (l));
      }
#else
      static
      symbol_type
      make_IF (const location_type& l)
      {
        return symbol_type (token::IF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IMPORT (location_type l)
      {
        return symbol_type (token::IMPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_IMPORT (const location_type& l)
      {
        return symbol_type (token::IMPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IN (location_type l)
      {
        return symbol_type (token::IN, std::move (l));
      }
#else
      static
      symbol_type
      make_IN (const location_type& l)
      {
        return symbol_type (token::IN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT (location_type l)
      {
        return symbol_type (token::INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT (const location_type& l)
      {
        return symbol_type (token::INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INOUT (location_type l)
      {
        return symbol_type (token::INOUT, std::move (l));
      }
#else
      static
      symbol_type
      make_INOUT (const location_type& l)
      {
        return symbol_type (token::INOUT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT (location_type l)
      {
        return symbol_type (token::INT, std::move (l));
      }
#else
      static
      symbol_type
      make_INT (const location_type& l)
      {
        return symbol_type (token::INT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT16 (location_type l)
      {
        return symbol_type (token::INT16, std::move (l));
      }
#else
      static
      symbol_type
      make_INT16 (const location_type& l)
      {
        return symbol_type (token::INT16, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT32 (location_type l)
      {
        return symbol_type (token::INT32, std::move (l));
      }
#else
      static
      symbol_type
      make_INT32 (const location_type& l)
      {
        return symbol_type (token::INT32, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT64 (location_type l)
      {
        return symbol_type (token::INT64, std::move (l));
      }
#else
      static
      symbol_type
      make_INT64 (const location_type& l)
      {
        return symbol_type (token::INT64, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT8 (location_type l)
      {
        return symbol_type (token::INT8, std::move (l));
      }
#else
      static
      symbol_type
      make_INT8 (const location_type& l)
      {
        return symbol_type (token::INT8, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL (location_type l)
      {
        return symbol_type (token::INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL (const location_type& l)
      {
        return symbol_type (token::INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL_NS (location_type l)
      {
        return symbol_type (token::INTERVAL_NS, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL_NS (const location_type& l)
      {
        return symbol_type (token::INTERVAL_NS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IOSRC (location_type l)
      {
        return symbol_type (token::IOSRC, std::move (l));
      }
#else
      static
      symbol_type
      make_IOSRC (const location_type& l)
      {
        return symbol_type (token::IOSRC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ITERATOR (location_type l)
      {
        return symbol_type (token::ITERATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_ITERATOR (const location_type& l)
      {
        return symbol_type (token::ITERATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONST_ITERATOR (location_type l)
      {
        return symbol_type (token::CONST_ITERATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_CONST_ITERATOR (const location_type& l)
      {
        return symbol_type (token::CONST_ITERATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LEQ (location_type l)
      {
        return symbol_type (token::LEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_LEQ (const location_type& l)
      {
        return symbol_type (token::LEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIBRARY_TYPE (location_type l)
      {
        return symbol_type (token::LIBRARY_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_LIBRARY_TYPE (const location_type& l)
      {
        return symbol_type (token::LIBRARY_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIBRARY_TYPE_CONST (location_type l)
      {
        return symbol_type (token::LIBRARY_TYPE_CONST, std::move (l));
      }
#else
      static
      symbol_type
      make_LIBRARY_TYPE_CONST (const location_type& l)
      {
        return symbol_type (token::LIBRARY_TYPE_CONST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIST (location_type l)
      {
        return symbol_type (token::LIST, std::move (l));
      }
#else
      static
      symbol_type
      make_LIST (const location_type& l)
      {
        return symbol_type (token::LIST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOCAL (location_type l)
      {
        return symbol_type (token::LOCAL, std::move (l));
      }
#else
      static
      symbol_type
      make_LOCAL (const location_type& l)
      {
        return symbol_type (token::LOCAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAP (location_type l)
      {
        return symbol_type (token::MAP, std::move (l));
      }
#else
      static
      symbol_type
      make_MAP (const location_type& l)
      {
        return symbol_type (token::MAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MATCH_TOKEN_STATE (location_type l)
      {
        return symbol_type (token::MATCH_TOKEN_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_MATCH_TOKEN_STATE (const location_type& l)
      {
        return symbol_type (token::MATCH_TOKEN_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_METHOD (location_type l)
      {
        return symbol_type (token::METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_METHOD (const location_type& l)
      {
        return symbol_type (token::METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUSASSIGN (location_type l)
      {
        return symbol_type (token::MINUSASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUSASSIGN (const location_type& l)
      {
        return symbol_type (token::MINUSASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUSMINUS (location_type l)
      {
        return symbol_type (token::MINUSMINUS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUSMINUS (const location_type& l)
      {
        return symbol_type (token::MINUSMINUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOD (location_type l)
      {
        return symbol_type (token::MOD, std::move (l));
      }
#else
      static
      symbol_type
      make_MOD (const location_type& l)
      {
        return symbol_type (token::MOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODULE (location_type l)
      {
        return symbol_type (token::MODULE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODULE (const location_type& l)
      {
        return symbol_type (token::MODULE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOVE (location_type l)
      {
        return symbol_type (token::MOVE, std::move (l));
      }
#else
      static
      symbol_type
      make_MOVE (const location_type& l)
      {
        return symbol_type (token::MOVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEW (location_type l)
      {
        return symbol_type (token::NEW, std::move (l));
      }
#else
      static
      symbol_type
      make_NEW (const location_type& l)
      {
        return symbol_type (token::NEW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEQ (location_type l)
      {
        return symbol_type (token::NEQ, std::move (l));
      }
#else
      static
      symbol_type
      make_NEQ (const location_type& l)
      {
        return symbol_type (token::NEQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NETWORK (location_type l)
      {
        return symbol_type (token::NETWORK, std::move (l));
      }
#else
      static
      symbol_type
      make_NETWORK (const location_type& l)
      {
        return symbol_type (token::NETWORK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOT_IN (location_type l)
      {
        return symbol_type (token::NOT_IN, std::move (l));
      }
#else
      static
      symbol_type
      make_NOT_IN (const location_type& l)
      {
        return symbol_type (token::NOT_IN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIONAL (location_type l)
      {
        return symbol_type (token::OPTIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIONAL (const location_type& l)
      {
        return symbol_type (token::OPTIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OR (location_type l)
      {
        return symbol_type (token::OR, std::move (l));
      }
#else
      static
      symbol_type
      make_OR (const location_type& l)
      {
        return symbol_type (token::OR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OVERLAY (location_type l)
      {
        return symbol_type (token::OVERLAY, std::move (l));
      }
#else
      static
      symbol_type
      make_OVERLAY (const location_type& l)
      {
        return symbol_type (token::OVERLAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PACK (location_type l)
      {
        return symbol_type (token::PACK, std::move (l));
      }
#else
      static
      symbol_type
      make_PACK (const location_type& l)
      {
        return symbol_type (token::PACK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUSASSIGN (location_type l)
      {
        return symbol_type (token::PLUSASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUSASSIGN (const location_type& l)
      {
        return symbol_type (token::PLUSASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUSPLUS (location_type l)
      {
        return symbol_type (token::PLUSPLUS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUSPLUS (const location_type& l)
      {
        return symbol_type (token::PLUSPLUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PORT (location_type l)
      {
        return symbol_type (token::PORT, std::move (l));
      }
#else
      static
      symbol_type
      make_PORT (const location_type& l)
      {
        return symbol_type (token::PORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POW (location_type l)
      {
        return symbol_type (token::POW, std::move (l));
      }
#else
      static
      symbol_type
      make_POW (const location_type& l)
      {
        return symbol_type (token::POW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREINIT (location_type l)
      {
        return symbol_type (token::PREINIT, std::move (l));
      }
#else
      static
      symbol_type
      make_PREINIT (const location_type& l)
      {
        return symbol_type (token::PREINIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIVATE (location_type l)
      {
        return symbol_type (token::PRIVATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIVATE (const location_type& l)
      {
        return symbol_type (token::PRIVATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PUBLIC (location_type l)
      {
        return symbol_type (token::PUBLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_PUBLIC (const location_type& l)
      {
        return symbol_type (token::PUBLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRONG_REF (location_type l)
      {
        return symbol_type (token::STRONG_REF, std::move (l));
      }
#else
      static
      symbol_type
      make_STRONG_REF (const location_type& l)
      {
        return symbol_type (token::STRONG_REF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGEXP (location_type l)
      {
        return symbol_type (token::REGEXP, std::move (l));
      }
#else
      static
      symbol_type
      make_REGEXP (const location_type& l)
      {
        return symbol_type (token::REGEXP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESULT (location_type l)
      {
        return symbol_type (token::RESULT, std::move (l));
      }
#else
      static
      symbol_type
      make_RESULT (const location_type& l)
      {
        return symbol_type (token::RESULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RETURN (location_type l)
      {
        return symbol_type (token::RETURN, std::move (l));
      }
#else
      static
      symbol_type
      make_RETURN (const location_type& l)
      {
        return symbol_type (token::RETURN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCOPE (location_type l)
      {
        return symbol_type (token::SCOPE, std::move (l));
      }
#else
      static
      symbol_type
      make_SCOPE (const location_type& l)
      {
        return symbol_type (token::SCOPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SET (location_type l)
      {
        return symbol_type (token::SET, std::move (l));
      }
#else
      static
      symbol_type
      make_SET (const location_type& l)
      {
        return symbol_type (token::SET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFTLEFT (location_type l)
      {
        return symbol_type (token::SHIFTLEFT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFTLEFT (const location_type& l)
      {
        return symbol_type (token::SHIFTLEFT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFTRIGHT (location_type l)
      {
        return symbol_type (token::SHIFTRIGHT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFTRIGHT (const location_type& l)
      {
        return symbol_type (token::SHIFTRIGHT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STREAM (location_type l)
      {
        return symbol_type (token::STREAM, std::move (l));
      }
#else
      static
      symbol_type
      make_STREAM (const location_type& l)
      {
        return symbol_type (token::STREAM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRING (location_type l)
      {
        return symbol_type (token::STRING, std::move (l));
      }
#else
      static
      symbol_type
      make_STRING (const location_type& l)
      {
        return symbol_type (token::STRING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRUCT (location_type l)
      {
        return symbol_type (token::STRUCT, std::move (l));
      }
#else
      static
      symbol_type
      make_STRUCT (const location_type& l)
      {
        return symbol_type (token::STRUCT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SWITCH (location_type l)
      {
        return symbol_type (token::SWITCH, std::move (l));
      }
#else
      static
      symbol_type
      make_SWITCH (const location_type& l)
      {
        return symbol_type (token::SWITCH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIME (location_type l)
      {
        return symbol_type (token::TIME, std::move (l));
      }
#else
      static
      symbol_type
      make_TIME (const location_type& l)
      {
        return symbol_type (token::TIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIME_NS (location_type l)
      {
        return symbol_type (token::TIME_NS, std::move (l));
      }
#else
      static
      symbol_type
      make_TIME_NS (const location_type& l)
      {
        return symbol_type (token::TIME_NS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMER (location_type l)
      {
        return symbol_type (token::TIMER, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMER (const location_type& l)
      {
        return symbol_type (token::TIMER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMERMGR (location_type l)
      {
        return symbol_type (token::TIMERMGR, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMERMGR (const location_type& l)
      {
        return symbol_type (token::TIMERMGR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMESASSIGN (location_type l)
      {
        return symbol_type (token::TIMESASSIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMESASSIGN (const location_type& l)
      {
        return symbol_type (token::TIMESASSIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THROW (location_type l)
      {
        return symbol_type (token::THROW, std::move (l));
      }
#else
      static
      symbol_type
      make_THROW (const location_type& l)
      {
        return symbol_type (token::THROW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRY (location_type l)
      {
        return symbol_type (token::TRY, std::move (l));
      }
#else
      static
      symbol_type
      make_TRY (const location_type& l)
      {
        return symbol_type (token::TRY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRYATTR (location_type l)
      {
        return symbol_type (token::TRYATTR, std::move (l));
      }
#else
      static
      symbol_type
      make_TRYATTR (const location_type& l)
      {
        return symbol_type (token::TRYATTR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TUPLE (location_type l)
      {
        return symbol_type (token::TUPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_TUPLE (const location_type& l)
      {
        return symbol_type (token::TUPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPE (location_type l)
      {
        return symbol_type (token::TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPE (const location_type& l)
      {
        return symbol_type (token::TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPEINFO (location_type l)
      {
        return symbol_type (token::TYPEINFO, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPEINFO (const location_type& l)
      {
        return symbol_type (token::TYPEINFO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT (location_type l)
      {
        return symbol_type (token::UINT, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT (const location_type& l)
      {
        return symbol_type (token::UINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT16 (location_type l)
      {
        return symbol_type (token::UINT16, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT16 (const location_type& l)
      {
        return symbol_type (token::UINT16, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT32 (location_type l)
      {
        return symbol_type (token::UINT32, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT32 (const location_type& l)
      {
        return symbol_type (token::UINT32, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT64 (location_type l)
      {
        return symbol_type (token::UINT64, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT64 (const location_type& l)
      {
        return symbol_type (token::UINT64, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UINT8 (location_type l)
      {
        return symbol_type (token::UINT8, std::move (l));
      }
#else
      static
      symbol_type
      make_UINT8 (const location_type& l)
      {
        return symbol_type (token::UINT8, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNION (location_type l)
      {
        return symbol_type (token::UNION, std::move (l));
      }
#else
      static
      symbol_type
      make_UNION (const location_type& l)
      {
        return symbol_type (token::UNION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNPACK (location_type l)
      {
        return symbol_type (token::UNPACK, std::move (l));
      }
#else
      static
      symbol_type
      make_UNPACK (const location_type& l)
      {
        return symbol_type (token::UNPACK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNSET (location_type l)
      {
        return symbol_type (token::UNSET, std::move (l));
      }
#else
      static
      symbol_type
      make_UNSET (const location_type& l)
      {
        return symbol_type (token::UNSET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VECTOR (location_type l)
      {
        return symbol_type (token::VECTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_VECTOR (const location_type& l)
      {
        return symbol_type (token::VECTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VIEW (location_type l)
      {
        return symbol_type (token::VIEW, std::move (l));
      }
#else
      static
      symbol_type
      make_VIEW (const location_type& l)
      {
        return symbol_type (token::VIEW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VOID (location_type l)
      {
        return symbol_type (token::VOID, std::move (l));
      }
#else
      static
      symbol_type
      make_VOID (const location_type& l)
      {
        return symbol_type (token::VOID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WHILE (location_type l)
      {
        return symbol_type (token::WHILE, std::move (l));
      }
#else
      static
      symbol_type
      make_WHILE (const location_type& l)
      {
        return symbol_type (token::WHILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WITH (location_type l)
      {
        return symbol_type (token::WITH, std::move (l));
      }
#else
      static
      symbol_type
      make_WITH (const location_type& l)
      {
        return symbol_type (token::WITH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VALUE_REF (location_type l)
      {
        return symbol_type (token::VALUE_REF, std::move (l));
      }
#else
      static
      symbol_type
      make_VALUE_REF (const location_type& l)
      {
        return symbol_type (token::VALUE_REF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEAK_REF (location_type l)
      {
        return symbol_type (token::WEAK_REF, std::move (l));
      }
#else
      static
      symbol_type
      make_WEAK_REF (const location_type& l)
      {
        return symbol_type (token::WEAK_REF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YIELD (location_type l)
      {
        return symbol_type (token::YIELD, std::move (l));
      }
#else
      static
      symbol_type
      make_YIELD (const location_type& l)
      {
        return symbol_type (token::YIELD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNARY_PREC (location_type l)
      {
        return symbol_type (token::UNARY_PREC, std::move (l));
      }
#else
      static
      symbol_type
      make_UNARY_PREC (const location_type& l)
      {
        return symbol_type (token::UNARY_PREC, l);
      }
#endif


    class context
    {
    public:
      context (const Parser& yyparser, const symbol_type& yyla);
      const symbol_type& lookahead () const YY_NOEXCEPT { return yyla_; }
      symbol_kind_type token () const YY_NOEXCEPT { return yyla_.kind (); }
      const location_type& location () const YY_NOEXCEPT { return yyla_.location; }

      /// Put in YYARG at most YYARGN of the expected tokens, and return the
      /// number of tokens stored in YYARG.  If YYARG is null, return the
      /// number of expected tokens (guaranteed to be less than YYNTOKENS).
      int expected_tokens (symbol_kind_type yyarg[], int yyargn) const;

    private:
      const Parser& yyparser_;
      const symbol_type& yyla_;
    };

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    Parser (const Parser&);
    /// Non copyable.
    Parser& operator= (const Parser&);
#endif


    /// Stored state numbers (used for stacks).
    typedef short state_type;

    /// The arguments of the error message.
    int yy_syntax_error_arguments_ (const context& yyctx,
                                    symbol_kind_type yyarg[], int yyargn) const;

    /// Generate an error message.
    /// \param yyctx     the context in which the error occurred.
    virtual std::string yysyntax_error_ (const context& yyctx) const;
    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    static state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT;

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT;

    static const short yypact_ninf_;
    static const short yytable_ninf_;

    /// Convert a scanner token kind \a t to a symbol kind.
    /// In theory \a t should be a token_kind_type, but character literals
    /// are valid, yet not members of the token_kind_type enum.
    static symbol_kind_type yytranslate_ (int t) YY_NOEXCEPT;

    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *yystr);

    /// For a symbol, its name in clear.
    static const char* const yytname_[];


    // Tables.
    // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
    // STATE-NUM.
    static const short yypact_[];

    // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
    // Performed when YYTABLE does not specify something else to do.  Zero
    // means the default is an error.
    static const short yydefact_[];

    // YYPGOTO[NTERM-NUM].
    static const short yypgoto_[];

    // YYDEFGOTO[NTERM-NUM].
    static const short yydefgoto_[];

    // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
    // positive, shift that token.  If negative, reduce the rule whose
    // number is the opposite.  If YYTABLE_NINF, syntax error.
    static const short yytable_[];

    static const short yycheck_[];

    // YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
    // state STATE-NUM.
    static const short yystos_[];

    // YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.
    static const short yyr1_[];

    // YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.
    static const signed char yyr2_[];


#if YYDEBUG
    // YYRLINE[YYN] -- Source line where rule number YYN was defined.
    static const short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r) const;
    /// Print the state stack on the debug stream.
    virtual void yy_stack_print_ () const;

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol kind, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol kind as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_state& that);

      /// The symbol kind (corresponding to \a state).
      /// \a symbol_kind::S_YYEMPTY when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      /// We use the initial state, as it does not have a value.
      enum { empty_state = 0 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);

      /// Assignment, needed by push_back by other implementations.
      /// Needed by some other old implementations.
      stack_symbol_type& operator= (const stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::iterator iterator;
      typedef typename S::const_iterator const_iterator;
      typedef typename S::size_type size_type;
      typedef typename std::ptrdiff_t index_type;

      stack (size_type n = 200) YY_NOEXCEPT
        : seq_ (n)
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Non copyable.
      stack (const stack&) = delete;
      /// Non copyable.
      stack& operator= (const stack&) = delete;
#endif

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (index_type i) const
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (index_type i)
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (std::ptrdiff_t n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      index_type
      size () const YY_NOEXCEPT
      {
        return index_type (seq_.size ());
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.begin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.end ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, index_type range) YY_NOEXCEPT
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (index_type i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        index_type range_;
      };

    private:
#if YY_CPLUSPLUS < 201103L
      /// Non copyable.
      stack (const stack&);
      /// Non copyable.
      stack& operator= (const stack&);
#endif
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1) YY_NOEXCEPT;

    /// Constants.
    enum
    {
      yylast_ = 7494,     ///< Last index in yytable_.
      yynnts_ = 106,  ///< Number of nonterminal symbols.
      yyfinal_ = 5 ///< Termination state number.
    };


    // User arguments.
    Driver* driver;
    Builder* builder;

  };


#line 29 "/build/zeek/src/zeek/auxil/spicy/hilti/toolchain/src/compiler/parser/parser.yy"
} } } // hilti::detail::parser
#line 4974 "/build/zeek/src/zeek/build/auxil/spicy/hilti/src/autogen/__parser.h"




#endif // !YY_YY_BUILD_ZEEK_SRC_ZEEK_BUILD_AUXIL_SPICY_HILTI_SRC_AUTOGEN_PARSER_H_INCLUDED
