{
switch ( rhs->Tag() ) {
case EXPR_ADD:	return AddVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_SUB:	return SubVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_TIMES:	return TimesVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_DIVIDE:	return DivideVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_MASK:	return MaskVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_MOD:	return ModVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_AND_AND:	return And_AndVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_OR_OR:	return Or_OrVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_AND:	return AndVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_OR:	return OrVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_XOR:	return XorVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_LSHIFT:	return LshiftVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_RSHIFT:	return RshiftVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_TO_ANY_COERCE:	return To_Any_CoerceVC(lhs, r1->AsConstExpr());
case EXPR_FIELD:	return FieldRCi(lhs, r1->AsConstExpr(), rhs->AsFieldExpr()->Field());
case EXPR_IN:	return InVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_LT:	return LTVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_LE:	return LEVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_EQ:	return EQVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_NE:	return NEVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_GE:	return GEVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_GT:	return GTVCV(lhs, r1->AsConstExpr(), r2->AsNameExpr());
case EXPR_NOT:	return NotVC(lhs, r1->AsConstExpr());
case EXPR_COMPLEMENT:	return ComplementVC(lhs, r1->AsConstExpr());
case EXPR_POSITIVE:	return PositiveVC(lhs, r1->AsConstExpr());
case EXPR_NEGATE:	return NegateVC(lhs, r1->AsConstExpr());
case EXPR_CAST:	return CastVC(lhs, r1->AsConstExpr());
default:
	reporter->InternalError("inconsistency in C1 assignment: %s", obj_desc(rhs).c_str());
}
}
