{
switch ( rhs->Tag() ) {
case EXPR_ADD:
	if ( rt->Tag() == TYPE_VECTOR )
		return AddVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return AddVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_SUB:
	if ( rt->Tag() == TYPE_VECTOR )
		return SubVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return SubVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_TIMES:
	if ( rt->Tag() == TYPE_VECTOR )
		return TimesVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return TimesVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_DIVIDE:
	if ( rt->Tag() == TYPE_VECTOR )
		return DivideVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return DivideVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_MASK:	return MaskVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_MOD:
	if ( rt->Tag() == TYPE_VECTOR )
		return ModVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return ModVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_AND_AND:
	if ( rt->Tag() == TYPE_VECTOR )
		return And_AndVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return And_AndVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_OR_OR:
	if ( rt->Tag() == TYPE_VECTOR )
		return Or_OrVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return Or_OrVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_AND:
	if ( rt->Tag() == TYPE_VECTOR )
		return AndVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return AndVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_OR:
	if ( rt->Tag() == TYPE_VECTOR )
		return OrVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return OrVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_XOR:
	if ( rt->Tag() == TYPE_VECTOR )
		return XorVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return XorVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_LSHIFT:
	if ( rt->Tag() == TYPE_VECTOR )
		return LshiftVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return LshiftVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_RSHIFT:
	if ( rt->Tag() == TYPE_VECTOR )
		return RshiftVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return RshiftVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_TO_ANY_COERCE:	return To_Any_CoerceVV(lhs, r1->AsNameExpr());
case EXPR_FROM_ANY_COERCE:	return From_Any_CoerceVV(lhs, r1->AsNameExpr());
case EXPR_FROM_ANY_VEC_COERCE:	return From_Any_Vec_CoerceVV(lhs, r1->AsNameExpr());
case EXPR_FIELD:	return FieldRVi(lhs, r1->AsNameExpr(), rhs->AsFieldExpr()->Field());
case EXPR_HAS_FIELD:	return Has_FieldVRi(lhs, r1->AsNameExpr(), rhs->AsHasFieldExpr()->Field());
case EXPR_IN:	return InVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_COND:	return CondVVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr(), r3->AsNameExpr());
case EXPR_LT:
	if ( rt->Tag() == TYPE_VECTOR )
		return LTVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return LTVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_LE:
	if ( rt->Tag() == TYPE_VECTOR )
		return LEVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return LEVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_EQ:
	if ( rt->Tag() == TYPE_VECTOR )
		return EQVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return EQVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_NE:
	if ( rt->Tag() == TYPE_VECTOR )
		return NEVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return NEVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_GE:
	if ( rt->Tag() == TYPE_VECTOR )
		return GEVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return GEVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_GT:
	if ( rt->Tag() == TYPE_VECTOR )
		return GTVVV_vec(lhs, r1->AsNameExpr(), r2->AsNameExpr());
	else
		return GTVVV(lhs, r1->AsNameExpr(), r2->AsNameExpr());
case EXPR_CLONE:	return CloneVV(lhs, r1->AsNameExpr());
case EXPR_SIZE:	return SizeVV(lhs, r1->AsNameExpr());
case EXPR_NOT:	return NotVV(lhs, r1->AsNameExpr());
case EXPR_COMPLEMENT:	return ComplementVV(lhs, r1->AsNameExpr());
case EXPR_POSITIVE:
	if ( rt->Tag() == TYPE_VECTOR )
		return PositiveVV_vec(lhs, r1->AsNameExpr());
	else
		return PositiveVV(lhs, r1->AsNameExpr());
case EXPR_NEGATE:
	if ( rt->Tag() == TYPE_VECTOR )
		return NegateVV_vec(lhs, r1->AsNameExpr());
	else
		return NegateVV(lhs, r1->AsNameExpr());
case EXPR_CAST:	return CastVV(lhs, r1->AsNameExpr());
default:
	reporter->InternalError("inconsistency in V assignment: %s", obj_desc(rhs).c_str());
}
}
