ZAMStmt ZAMCompiler::Vector_Elem_AssignVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_VECTOR_ELEM_ASSIGN_VVV, n1, n2, n3);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Any_Vector_Elem_AssignVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_ANY_VECTOR_ELEM_ASSIGN_VVV, n1, n2, n3);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Any_Vector_Elem_AssignVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_ANY_VECTOR_ELEM_ASSIGN_VVC, n1, n2, c);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Vector_Elem_Assign_AnyVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_VECTOR_ELEM_ASSIGN_ANY_VVV, n1, n2, n3);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Vector_Elem_AssignVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_VECTOR_ELEM_ASSIGN_VVC, n1, n2, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Vector_Elem_AssignVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_VECTOR_ELEM_ASSIGN_VVi, n1, n2, i);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Any_Vector_Elem_AssignVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_ANY_VECTOR_ELEM_ASSIGN_VVi, n1, n2, i);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Vector_Elem_Assign_AnyVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_VECTOR_ELEM_ASSIGN_ANY_VVi, n1, n2, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VCVi_field_S, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VCVi_field_D, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VVCi_field_S, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VVCi_field_D, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VVVi_field_S, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VVVi_field_D, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ADD_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ADD_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ADD_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ADD_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VCV_T, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VCVi_field_T, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VCVi_field_D, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VVC_T, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VVCi_field_T, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VVCi_field_D, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VVV_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VVVi_field_T, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VVVi_field_D, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SubVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_SUB_VVV_vec_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SUB_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SUB_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SUB_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VCVi_field_D, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VVCi_field_D, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VVVi_field_D, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::TimesVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_TIMES_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_TIMES_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_TIMES_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VCVi_field_D, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VVCi_field_D, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VVVi_field_D, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DivideVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_DIVIDE_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_DIVIDE_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_DIVIDE_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VCV_AU, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VCV_AI, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VCVi_field_AU, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VCVi_field_AI, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VVC_AU, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VVC_AI, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VVCi_field_AU, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VVCi_field_AI, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VVV_AU, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VVV_AI, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::MaskVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MASK_VVVi_field_AU, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MASK_VVVi_field_AI, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ModVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_MOD_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_MOD_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::And_AndVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_AND_AND_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Or_OrVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_OR_OR_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VCV_T, n1, c, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VCV_P, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VCV_U, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VCVi_field_T, n1, c, n2, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VCVi_field_P, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VCVi_field_U, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VVC_T, n1, n2, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VVC_P, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VVC_U, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VVCi_field_T, n1, n2, c, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VVCi_field_P, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VVCi_field_U, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VVV_T, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VVV_P, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VVV_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VVVi_field_T, n1, n2, n3, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VVVi_field_P, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VVVi_field_U, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AndVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_AND_VVV_vec_T, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_AND_VVV_vec_P, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_AND_VVV_vec_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VCV_T, n1, c, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VCV_P, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VCV_U, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VCVi_field_T, n1, c, n2, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VCVi_field_P, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VCVi_field_U, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VVC_T, n1, n2, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VVC_P, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VVC_U, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VVCi_field_T, n1, n2, c, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VVCi_field_P, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VVCi_field_U, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VVV_T, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VVV_P, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VVV_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VVVi_field_T, n1, n2, n3, i);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VVVi_field_P, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VVVi_field_U, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::OrVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_OR_VVV_vec_T, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_OR_VVV_vec_P, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_OR_VVV_vec_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VCV_U, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VCVi_field_U, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VVC_U, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VVCi_field_U, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VVV_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VVVi_field_U, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::XorVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_XOR_VVV_vec_U, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LshiftVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LSHIFT_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LSHIFT_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVCVi_field(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VCVi_field_U, n1, c, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VCVi_field_I, n1, c, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVVCi_field(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VVCi_field_U, n1, n2, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VVCi_field_I, n1, n2, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVVVi_field(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VVVi_field_U, n1, n2, n3, i);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VVVi_field_I, n1, n2, n3, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RshiftVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_RSHIFT_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_RSHIFT_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::To_Any_CoerceVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_TO_ANY_COERCE_VC, n, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::To_Any_CoerceVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_TO_ANY_COERCE_VV, n1, n2);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::From_Any_CoerceVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_FROM_ANY_COERCE_VV, n1, n2);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::From_Any_Vec_CoerceVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_FROM_ANY_VEC_COERCE_VV, n1, n2);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Direct_RecordV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_DIRECT_RECORD_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_RecordV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_FromVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_FROM_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_NTVi(const NameExpr* n, int i)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_NT_Vi, n, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_NT_FromVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_NT_FROM_VVi, n1, n2, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_InitsV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_Inits_FromVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_FROM_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_Inits_And_NTVi(const NameExpr* n, int i)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_AND_NT_Vi, n, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Construct_Known_Record_With_Inits_And_NT_FromVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_CONSTRUCT_KNOWN_RECORD_WITH_INITS_AND_NT_FROM_VVi, n1, n2, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Assign_FieldsVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ASSIGN_FIELDS_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Assign_Fields_ManagedVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ASSIGN_FIELDS_MANAGED_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Assign_Fields_All_ManagedVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ASSIGN_FIELDS_ALL_MANAGED_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Add_Int_FieldsVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ADD_INT_FIELDS_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Add_Double_FieldsVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ADD_DOUBLE_FIELDS_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Rec_Add_FieldsVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REC_ADD_FIELDS_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Concretize_Vector_FieldsV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CONCRETIZE_VECTOR_FIELDS_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IndexVecBoolSelectVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_INDEXVECBOOLSELECT_VVV, n1, n2, n3);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IndexVecBoolSelectVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_INDEXVECBOOLSELECT_VCV, n1, c, n2);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IndexVecIntSelectVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_INDEXVECINTSELECT_VVV, n1, n2, n3);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IndexVecIntSelectVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_INDEXVECINTSELECT_VCV, n1, c, n2);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IndexVVL(const NameExpr* n1, const NameExpr* n2, const ListExpr* l)
	{
	return CompileIndex(n1, n2, l, false);
	}

ZAMStmt ZAMCompiler::IndexVCL(const NameExpr* n, const ConstExpr* c, const ListExpr* l)
	{
	return CompileIndex(n, c, l, false);
	}

ZAMStmt ZAMCompiler::WhenIndexVVL(const NameExpr* n1, const NameExpr* n2, const ListExpr* l)
	{
	return CompileIndex(n1, n2, l, true);
	}

ZAMStmt ZAMCompiler::WhenIndexVCL(const NameExpr* n, const ConstExpr* c, const ListExpr* l)
	{
	return CompileIndex(n, c, l, true);
	}

ZAMStmt ZAMCompiler::AnyIndexVVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_ANYINDEX_VVi, n1, n2, i);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Assign_AnyVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_ASSIGN_ANY_VV, n1, n2);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Assign_AnyVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_ASSIGN_ANY_VC, n, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::FieldRCi(const NameExpr* n, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = n->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_RCi_R, n, c, i);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_RCi_P, n, c, i);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_RCi_O, n, c, i);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_RCi_V, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_RCi_U, n, c, i);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_RCi_t, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_RCi_D, n, c, i);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_RCi_T, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_RCi_N, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_RCi_A, n, c, i);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_RCi_a, n, c, i);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_RCi_L, n, c, i);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_RCi_F, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_RCi_S, n, c, i);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_RCi_f, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_RCi_I, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(t);
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(c->GetType()), i/* type 5 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::FieldRVi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_RVi_R, n1, n2, i);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_RVi_P, n1, n2, i);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_RVi_O, n1, n2, i);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_RVi_V, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_RVi_U, n1, n2, i);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_RVi_t, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_RVi_D, n1, n2, i);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_RVi_T, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_RVi_N, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_RVi_A, n1, n2, i);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_RVi_a, n1, n2, i);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_RVi_L, n1, n2, i);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_RVi_F, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_RVi_S, n1, n2, i);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_RVi_f, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_RVi_I, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(t);
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n2->GetType()), i/* type 5 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Has_FieldVRi(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	z = GenInst(OP_HAS_FIELD_VRi, n1, n2, i);
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n2->GetType()), i/* type 5 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Has_FieldVRii(const NameExpr* n1, const NameExpr* n2, int i1, int i2)
	{
	ZInstI z;
	z = GenInst(OP_HAS_FIELD_VRii, n1, n2, i1, i2);
	z.TrackRecordTypesForFields(cast_intrusive<RecordType>(n1->GetType()), i1, cast_intrusive<RecordType>(n2->GetType()), i2 /* type 1 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::InVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	return CompileInExpr(n1, n2, n3);
	}

ZAMStmt ZAMCompiler::InVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	return CompileInExpr(n1, c, n2);
	}

ZAMStmt ZAMCompiler::InVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	return CompileInExpr(n1, n2, c);
	}

ZAMStmt ZAMCompiler::L_In_TVLV(const NameExpr* n1, const ListExpr* l, const NameExpr* n2)
	{
	return CompileInExpr(n1, l, n2);
	}

ZAMStmt ZAMCompiler::L_In_TVLC(const NameExpr* n, const ListExpr* l, const ConstExpr* c)
	{
	return CompileInExpr(n, l, c);
	}

ZAMStmt ZAMCompiler::L_In_VecVLV(const NameExpr* n1, const ListExpr* l, const NameExpr* n2)
	{
	return CompileInExpr(n1, l, n2);
	}

ZAMStmt ZAMCompiler::L_In_VecVLC(const NameExpr* n, const ListExpr* l, const ConstExpr* c)
	{
	return CompileInExpr(n, l, c);
	}

ZAMStmt ZAMCompiler::CondVVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, const NameExpr* n4)
	{
	ZInstI z;
	z = GenInst(OP_COND_VVVV, n1, n2, n3, n4);
	z.SetType(n3->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CondVVVC(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_COND_VVVC, n1, n2, n3, c);
	z.SetType(n3->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CondVVCV(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c, const NameExpr* n3)
	{
	ZInstI z;
	z = GenInst(OP_COND_VVCV, n1, n2, c, n3);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Bool_Vec_CondVVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3, const NameExpr* n4)
	{
	ZInstI z;
	z = GenInst(OP_BOOL_VEC_COND_VVVV, n1, n2, n3, n4);
	z.SetType(n3->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CondC1VVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_CONDC1_VVC, n1, n2, c);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CondC2VVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_CONDC2_VVC, n1, n2, c);
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VCV_A, n1, c, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VCV_T, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTCVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_CVb_cond_A, c, n);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_CVb_cond_T, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VVC_A, n1, n2, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VVC_T, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VCb_cond_A, n, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VCb_cond_T, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VVV_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VVV_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VVV_vec_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VVV_vec_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LTVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LT_VVb_cond_A, n1, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LT_VVb_cond_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LT_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LT_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LT_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LT_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VCV_A, n1, c, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VCV_T, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LECVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_CVb_cond_A, c, n);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_CVb_cond_T, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VVC_A, n1, n2, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VVC_T, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VCb_cond_A, n, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VCb_cond_T, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VVV_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VVV_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VVV_vec_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VVV_vec_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::LEVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_LE_VVb_cond_A, n1, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_LE_VVb_cond_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_LE_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_LE_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_LE_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_LE_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VCV_PS, n1, c, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VCV_P, n1, c, n2);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VCV_F, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VCV_N, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VCV_A, n1, c, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VCV_T, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQCVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_CVb_cond_PS, c, n);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_CVb_cond_P, c, n);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_CVb_cond_F, c, n);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_CVb_cond_N, c, n);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_CVb_cond_A, c, n);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_CVb_cond_T, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVC_PS, n1, n2, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VVC_P, n1, n2, c);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VVC_F, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VVC_N, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VVC_A, n1, n2, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VVC_T, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VCb_cond_PS, n, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VCb_cond_P, n, c);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VCb_cond_F, n, c);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VCb_cond_N, n, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VCb_cond_A, n, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VCb_cond_T, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVV_PS, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VVV_P, n1, n2, n3);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VVV_F, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VVV_N, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VVV_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VVV_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VVV_vec_P, n1, n2, n3);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VVV_vec_F, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VVV_vec_N, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VVV_vec_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VVV_vec_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::EQVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVb_cond_PS, n1, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_EQ_VVb_cond_P, n1, n2);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_EQ_VVb_cond_F, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_EQ_VVb_cond_N, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_EQ_VVb_cond_A, n1, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_EQ_VVb_cond_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_EQ_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_EQ_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_EQ_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_EQ_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VCV_PS, n1, c, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VCV_P, n1, c, n2);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VCV_F, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VCV_N, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VCV_A, n1, c, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VCV_T, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NECVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_CVb_cond_PS, c, n);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_CVb_cond_P, c, n);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_CVb_cond_F, c, n);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_CVb_cond_N, c, n);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_CVb_cond_A, c, n);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_CVb_cond_T, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVC_PS, n1, n2, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VVC_P, n1, n2, c);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VVC_F, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VVC_N, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VVC_A, n1, n2, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VVC_T, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VCb_cond_PS, n, c);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VCb_cond_P, n, c);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VCb_cond_F, n, c);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VCb_cond_N, n, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VCb_cond_A, n, c);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VCb_cond_T, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVV_PS, n1, n2, n3);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VVV_P, n1, n2, n3);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VVV_F, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VVV_N, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VVV_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VVV_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VVV_vec_P, n1, n2, n3);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VVV_vec_F, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VVV_vec_N, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VVV_vec_A, n1, n2, n3);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VVV_vec_T, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NEVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_PATTERN && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVb_cond_PS, n1, n2);
	else if ( tag1 == TYPE_PATTERN && tag2 == TYPE_PATTERN )
		z = GenInst(OP_NE_VVb_cond_P, n1, n2);
	else if ( tag1 == TYPE_FUNC && tag2 == TYPE_FUNC )
		z = GenInst(OP_NE_VVb_cond_F, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET && i_t2 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_NE_VVb_cond_N, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_NE_VVb_cond_A, n1, n2);
	else if ( tag1 == TYPE_TABLE && tag2 == TYPE_TABLE )
		z = GenInst(OP_NE_VVb_cond_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_NE_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NE_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NE_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NE_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VCV_A, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GECVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_CVb_cond_A, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VVC_A, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VCb_cond_A, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VVV_A, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VVV_vec_A, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GEVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GE_VVb_cond_A, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GE_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GE_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GE_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GE_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVCV(const NameExpr* n1, const ConstExpr* c, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VCV_A, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VCV_S, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VCV_D, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VCV_U, n1, c, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VCV_I, n1, c, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTCVb_cond(const ConstExpr* c, const NameExpr* n)
	{
	ZInstI z;
	const auto& t = c->GetType();
	const auto& t2 = n->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_CVb_cond_A, c, n);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_CVb_cond_S, c, n);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_CVb_cond_D, c, n);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_CVb_cond_U, c, n);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_CVb_cond_I, c, n);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VVC_A, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VVC_S, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VVC_D, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VVC_U, n1, n2, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VVC_I, n1, n2, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVCb_cond(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	const auto& t2 = c->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VCb_cond_A, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VCb_cond_S, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VCb_cond_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VCb_cond_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VCb_cond_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVVV(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	const auto& t2 = n3->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VVV_A, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VVV_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VVV_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VVV_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VVV_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVVV_vec(const NameExpr* n1, const NameExpr* n2, const NameExpr* n3)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	const auto& t2 = n3->GetType()->Yield();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VVV_vec_A, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VVV_vec_S, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VVV_vec_D, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VVV_vec_U, n1, n2, n3);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VVV_vec_I, n1, n2, n3);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::GTVVb_cond(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	const auto& t2 = n2->GetType();
	auto tag2 = t2->Tag();
	auto i_t2 = t2->InternalType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_ADDR && i_t2 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_GT_VVb_cond_A, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING && i_t2 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_GT_VVb_cond_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE && i_t2 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_GT_VVb_cond_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED && i_t2 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_GT_VVb_cond_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT && i_t2 == TYPE_INTERNAL_INT )
		z = GenInst(OP_GT_VVb_cond_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ScheduleViHL(const NameExpr* n, int i, EventHandler* h, const ListExpr* l)
	{
	return CompileSchedule(n, nullptr, i, h, l);
	}

ZAMStmt ZAMCompiler::ScheduleCiHL(const ConstExpr* c, int i, EventHandler* h, const ListExpr* l)
	{
	return CompileSchedule(nullptr, c, i, h, l);
	}

ZAMStmt ZAMCompiler::EventHL(EventHandler* h, const ListExpr* l)
	{
	return CompileEvent(h, l);
	}

ZAMStmt ZAMCompiler::ReturnX()
	{
	ZInstI z;
	z = GenInst(OP_RETURN_X);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ReturnV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_RETURN_V, n);
	z.SetType(n->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ReturnC(const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_RETURN_C, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::When_ReturnX()
	{
	ZInstI z;
	z = GenInst(OP_WHEN_RETURN_X);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CheckAnyLenVi(const NameExpr* n, int i)
	{
	ZInstI z;
	z = GenInst(OP_CHECKANYLEN_Vi, n, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PrintO(OpaqueVals* v)
	{
	ZInstI z;
	z = ZInstI(OP_PRINT_O);
	z.aux = v->aux;
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Print1V(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_PRINT1_V, n);
	z.SetType(n->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Print1C(const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_PRINT1_C, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddStmtVO(const NameExpr* n, OpaqueVals* v)
	{
	ZInstI z;
	z = ZInstI(OP_ADDSTMT_VO, Frame1Slot(n, OP_ADDSTMT_VO));
	z.aux = v->aux;
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddStmt1VV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_ADDSTMT1_VV, n1, n2);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddStmt1VC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_ADDSTMT1_VC, n, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ClearTableV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CLEARTABLE_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ClearVectorV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_CLEARVECTOR_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DelTableVO(const NameExpr* n, OpaqueVals* v)
	{
	ZInstI z;
	z = ZInstI(OP_DELTABLE_VO, Frame1Slot(n, OP_DELTABLE_VO));
	z.aux = v->aux;
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DelFieldVi(const NameExpr* n, int i)
	{
	ZInstI z;
	z = GenInst(OP_DELFIELD_Vi, n, i);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::WhenV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_WHEN_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::When_TimeoutVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_WHEN_TIMEOUT_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::When_TimeoutVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_WHEN_TIMEOUT_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Should_Report_AssertVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_SHOULD_REPORT_ASSERT_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Report_AssertVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_REPORT_ASSERT_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Report_Assert_With_MessageVVC(const NameExpr* n1, const NameExpr* n2, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_REPORT_ASSERT_WITH_MESSAGE_VVC, n1, n2, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AssignVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = n->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_ASSIGN_VC_R, n, c);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_ASSIGN_VC_P, n, c);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_ASSIGN_VC_O, n, c);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_ASSIGN_VC_V, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ASSIGN_VC_U, n, c);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_ASSIGN_VC_t, n, c);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ASSIGN_VC_D, n, c);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_ASSIGN_VC_T, n, c);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_ASSIGN_VC_N, n, c);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_ASSIGN_VC_A, n, c);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_ASSIGN_VC_a, n, c);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_ASSIGN_VC_L, n, c);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_ASSIGN_VC_F, n, c);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ASSIGN_VC_S, n, c);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_ASSIGN_VC_f, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ASSIGN_VC_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AssignVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n1->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_ASSIGN_VV_R, n1, n2);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_ASSIGN_VV_P, n1, n2);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_ASSIGN_VV_O, n1, n2);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_ASSIGN_VV_V, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_ASSIGN_VV_U, n1, n2);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_ASSIGN_VV_t, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_ASSIGN_VV_D, n1, n2);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_ASSIGN_VV_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_ASSIGN_VV_N, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_ASSIGN_VV_A, n1, n2);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_ASSIGN_VV_a, n1, n2);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_ASSIGN_VV_L, n1, n2);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_ASSIGN_VV_F, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_ASSIGN_VV_S, n1, n2);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_ASSIGN_VV_f, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_ASSIGN_VV_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Field_LHS_AssignFCi(const FieldLHSAssignExpr* flhs, const ConstExpr* c, int i)
	{
	ZInstI z;
	auto n = flhs->GetOp1()->AsNameExpr();
	const auto& t = flhs->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_R, n, c, i);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_P, n, c, i);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_O, n, c, i);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_V, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_U, n, c, i);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_t, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_D, n, c, i);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_T, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_N, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_A, n, c, i);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_a, n, c, i);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_L, n, c, i);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_F, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_S, n, c, i);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_f, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCi_I, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n->GetType()), i /* type 3 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Field_LHS_AssignFVi(const FieldLHSAssignExpr* flhs, const NameExpr* n2, int i)
	{
	ZInstI z;
	auto n1 = flhs->GetOp1()->AsNameExpr();
	const auto& t = flhs->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_R, n1, n2, i);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_P, n1, n2, i);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_O, n1, n2, i);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_V, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_U, n1, n2, i);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_t, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_D, n1, n2, i);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_T, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_N, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_A, n1, n2, i);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_a, n1, n2, i);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_L, n1, n2, i);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_F, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_S, n1, n2, i);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_f, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVi_I, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 3 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Field_LHS_AssignFVii(const FieldLHSAssignExpr* flhs, const NameExpr* n2, int i1, int i2)
	{
	ZInstI z;
	auto n1 = flhs->GetOp1()->AsNameExpr();
	const auto& t = flhs->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_R, n1, n2, i1, i2);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_P, n1, n2, i1, i2);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_O, n1, n2, i1, i2);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_V, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_U, n1, n2, i1, i2);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_t, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_D, n1, n2, i1, i2);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_T, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_N, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_A, n1, n2, i1, i2);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_a, n1, n2, i1, i2);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_L, n1, n2, i1, i2);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_F, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_S, n1, n2, i1, i2);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_f, n1, n2, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FVii_I, n1, n2, i1, i2);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypesForFields(cast_intrusive<RecordType>(n1->GetType()), i2, cast_intrusive<RecordType>(n2->GetType()), i1 /* type 4 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::Field_LHS_AssignFCii(const FieldLHSAssignExpr* flhs, const ConstExpr* c, int i1, int i2)
	{
	ZInstI z;
	auto n = flhs->GetOp1()->AsNameExpr();
	const auto& t = flhs->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_RECORD )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_R, n, c, i1, i2);
	else if ( tag1 == TYPE_PATTERN )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_P, n, c, i1, i2);
	else if ( tag1 == TYPE_OPAQUE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_O, n, c, i1, i2);
	else if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_V, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_U, n, c, i1, i2);
	else if ( tag1 == TYPE_TYPE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_t, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_D, n, c, i1, i2);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_T, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_N, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_A, n, c, i1, i2);
	else if ( tag1 == TYPE_ANY )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_a, n, c, i1, i2);
	else if ( tag1 == TYPE_LIST )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_L, n, c, i1, i2);
	else if ( tag1 == TYPE_FUNC )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_F, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_S, n, c, i1, i2);
	else if ( tag1 == TYPE_FILE )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_f, n, c, i1, i2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_FIELD_LHS_ASSIGN_FCii_I, n, c, i1, i2);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypesForFields(cast_intrusive<RecordType>(n->GetType()), i2, cast_intrusive<RecordType>(c->GetType()), i1 /* type 4 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CloneVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_CLONE_VV, n1, n2);
	z.SetType(n1->GetType());
	z.SetType2(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SizeVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_SIZE_VV_V, n1, n2);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_SIZE_VV_T, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_SIZE_VV_S, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_SIZE_VV_N, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_SIZE_VV_A, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SIZE_VV_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SIZE_VV_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SIZE_VV_I, n1, n2);
	else
		z = GenInst(OP_SIZE_VV, n1, n2);
	z.SetType(n1->GetType());
	z.SetType2(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::SizeVVi_field(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( tag1 == TYPE_VECTOR )
		z = GenInst(OP_SIZE_VVi_field_V, n1, n2, i);
	else if ( tag1 == TYPE_TABLE )
		z = GenInst(OP_SIZE_VVi_field_T, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_STRING )
		z = GenInst(OP_SIZE_VVi_field_S, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_SUBNET )
		z = GenInst(OP_SIZE_VVi_field_N, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_ADDR )
		z = GenInst(OP_SIZE_VVi_field_A, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_SIZE_VVi_field_D, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_SIZE_VVi_field_U, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_SIZE_VVi_field_I, n1, n2, i);
	else
		z = GenInst(OP_SIZE_VVi_field, n1, n2, i);
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	z.SetType(n1->GetType());
	z.SetType2(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NotVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NOT_VC_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NotVCi_field(const NameExpr* n, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NOT_VCi_field_I, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NotVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NOT_VV_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NotVVi_field(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NOT_VVi_field_I, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ComplementVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_COMPLEMENT_VC_U, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ComplementVCi_field(const NameExpr* n, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_COMPLEMENT_VCi_field_U, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ComplementVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_COMPLEMENT_VV_U, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ComplementVVi_field(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_COMPLEMENT_VVi_field_U, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PositiveVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_POSITIVE_VC_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_POSITIVE_VC_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_POSITIVE_VC_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PositiveVCi_field(const NameExpr* n, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_POSITIVE_VCi_field_D, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_POSITIVE_VCi_field_U, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_POSITIVE_VCi_field_I, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PositiveVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_POSITIVE_VV_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_POSITIVE_VV_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_POSITIVE_VV_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PositiveVVi_field(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_POSITIVE_VVi_field_D, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_POSITIVE_VVi_field_U, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_POSITIVE_VVi_field_I, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::PositiveVV_vec(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_POSITIVE_VV_vec_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_POSITIVE_VV_vec_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_POSITIVE_VV_vec_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NegateVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NEGATE_VC_D, n, c);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NEGATE_VC_U, n, c);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NEGATE_VC_I, n, c);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NegateVCi_field(const NameExpr* n, const ConstExpr* c, int i)
	{
	ZInstI z;
	const auto& t = c->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NEGATE_VCi_field_D, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NEGATE_VCi_field_U, n, c, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NEGATE_VCi_field_I, n, c, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NegateVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NEGATE_VV_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NEGATE_VV_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NEGATE_VV_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NegateVVi_field(const NameExpr* n1, const NameExpr* n2, int i)
	{
	ZInstI z;
	const auto& t = n2->GetType();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NEGATE_VVi_field_D, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NEGATE_VVi_field_U, n1, n2, i);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NEGATE_VVi_field_I, n1, n2, i);
	else
		reporter->InternalError("bad tag when generating method core");
	z.TrackRecordTypeForField(cast_intrusive<RecordType>(n1->GetType()), i /* type 2 */);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::NegateVV_vec(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	const auto& t = n2->GetType()->Yield();
	auto tag1 = t->Tag();
	auto i_t1 = t->InternalType();
	if ( i_t1 == TYPE_INTERNAL_DOUBLE )
		z = GenInst(OP_NEGATE_VV_vec_D, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_UNSIGNED )
		z = GenInst(OP_NEGATE_VV_vec_U, n1, n2);
	else if ( i_t1 == TYPE_INTERNAL_INT )
		z = GenInst(OP_NEGATE_VV_vec_I, n1, n2);
	else
		reporter->InternalError("bad tag when generating method core");
	z.SetType(n1->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IncrIV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_INCRI_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::IncrUV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_INCRU_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DecrIV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_DECRI_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::DecrUV(const NameExpr* n)
	{
	ZInstI z;
	z = GenInst(OP_DECRU_V, n);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AppendToVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_APPENDTO_VC, n, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AppendToVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_APPENDTO_VV, n1, n2);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AppendToAnyVecVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_APPENDTOANYVEC_VC, n, c);
	z.SetType(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AppendToAnyVecVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_APPENDTOANYVEC_VV, n1, n2);
	z.SetType(n2->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ExtendPatternVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_EXTENDPATTERN_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::ExtendPatternVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_EXTENDPATTERN_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVecToVecVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_ADDVECTOVEC_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddVecToVecVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_ADDVECTOVEC_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddTableToTableVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_ADDTABLETOTABLE_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::AddTableToTableVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_ADDTABLETOTABLE_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RemoveTableFromTableVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_REMOVETABLEFROMTABLE_VC, n, c);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::RemoveTableFromTableVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_REMOVETABLEFROMTABLE_VV, n1, n2);
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CastVC(const NameExpr* n, const ConstExpr* c)
	{
	ZInstI z;
	z = GenInst(OP_CAST_VC, n, c);
	z.SetType(n->GetType());
	z.SetType2(c->GetType());
	return AddInst(z);
	}

ZAMStmt ZAMCompiler::CastVV(const NameExpr* n1, const NameExpr* n2)
	{
	ZInstI z;
	z = GenInst(OP_CAST_VV, n1, n2);
	z.SetType(n1->GetType());
	z.SetType2(n2->GetType());
	return AddInst(z);
	}

