// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_dhcp_dhcp_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_dhcp_dhcp_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/protocol/dhcp/types.bif.h"
#include "zeek/analyzer/protocol/dhcp/events.bif.h"

namespace binpac {

namespace DHCP {
class ContextDHCP;
class DHCP_Conn;
class DHCP_Flow;
// NOLINTNEXTLINE(performance-enum-size)
enum OP_type {
    BOOTREQUEST = 1,
    BOOTREPLY = 2,
};
class OptionValue;
class OptionValueWrapper;
class Option;
class DHCP_Message;
class Client_Identifier;
class Client_FQDN;
class Relay_Agent_SubOption;
} // namespace DHCP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace DHCP {

class ContextDHCP final {
public:
    ContextDHCP(DHCP_Conn* connection, DHCP_Flow* flow);
    ~ContextDHCP();

    // Member access functions
    DHCP_Conn* connection() const { return connection_; }
    DHCP_Flow* flow() const { return flow_; }

protected:
    DHCP_Conn* connection_;
    DHCP_Flow* flow_;
};


class DHCP_Conn final : public binpac::ConnectionAnalyzer {
public:
    DHCP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~DHCP_Conn() override;

    // Member access functions
    DHCP_Flow* upflow() const { return upflow_; }
    DHCP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

protected:
    DHCP_Flow* upflow_;
    DHCP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class DHCP_Flow final : public binpac::FlowAnalyzer {
public:
    DHCP_Flow(DHCP_Conn* connection, bool is_orig);
    ~DHCP_Flow() override;

    // Member access functions
    DHCP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    uint8 get_dhcp_msgtype(vector<Option*>* options);
    bool init_options();
    bool create_options(uint8 code);
    bool process_dhcp_message(DHCP_Message* msg);
    bool process_subnet_option(OptionValue* v);
    bool process_time_offset_option(OptionValue* v);
    bool process_router_option(OptionValue* v);
    bool process_timeserver_option(OptionValue* v);
    bool process_nameserver_option(OptionValue* v);
    bool process_dns_server_option(OptionValue* v);
    bool process_host_name_option(OptionValue* v);
    bool process_domain_name_option(OptionValue* v);
    bool process_forwarding_option(OptionValue* v);
    bool process_broadcast_address_option(OptionValue* v);
    bool process_ntpserver_option(OptionValue* v);
    bool process_vendor_specific_option(OptionValue* v);
    bool process_nbns_option(OptionValue* v);
    bool process_addr_request_option(OptionValue* v);
    bool process_lease_option(OptionValue* v);
    bool process_serv_id_option(OptionValue* v);
    bool process_par_req_list_option(OptionValue* v);
    bool process_message_option(OptionValue* v);
    bool process_max_message_size_option(OptionValue* v);
    bool process_renewal_time_option(OptionValue* v);
    bool process_rebinding_time_option(OptionValue* v);
    bool process_vendor_class_option(OptionValue* v);
    bool process_client_id_option(OptionValue* v);
    bool process_user_class_option(OptionValue* v);
    bool process_client_fqdn_option(OptionValue* v);
    uint8 get_dhcp_sumlen(uint8 len);
    bool process_relay_agent_inf_option(OptionValue* v);
    bool process_auto_config_option(OptionValue* v);
    bool process_auto_proxy_config_option(OptionValue* v);

protected:
    DHCP_Message* dataunit_;
    ContextDHCP* context_;

    // Additional members

		zeek::RecordValPtr options;
		zeek::VectorValPtr all_options;
	

		uint8 sum_len;
	
    DHCP_Conn* connection_;
    bool is_orig_;
};

extern int const MSG_TYPE_OPTION;

class OptionValue final {
public:
    OptionValue(uint8 code, uint8 length);
    ~OptionValue();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    uint8 msg_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)53):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-protocol.pac:13:msg_type", (int64)val_case_index(), "MSG_TYPE_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msg_type_;
    }
    bytestring const& other() const {
        return other_;
    }
    uint32 subnet() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:8:subnet", (int64)val_case_index(), "SUBNET_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return subnet_;
    }
    int32 time_offset() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:31:time_offset", (int64)val_case_index(), "TIME_OFFSET_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return time_offset_;
    }
    vector<uint32>* router_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:54:router_list", (int64)val_case_index(), "ROUTER_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return router_list_;
    }
    vector<uint32>* timeserver_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:88:timeserver_list", (int64)val_case_index(), "TIME_SERVER_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return timeserver_list_;
    }
    vector<uint32>* nameserver_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:122:nameserver_list", (int64)val_case_index(), "NAME_SERVER_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nameserver_list_;
    }
    vector<uint32>* dns_server_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:156:dns_server_list", (int64)val_case_index(), "DNS_SERVER_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dns_server_list_;
    }
    bytestring const& host_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:189:host_name", (int64)val_case_index(), "HOST_NAME_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return host_name_;
    }
    bytestring const& domain_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:214:domain_name", (int64)val_case_index(), "DOMAIN_NAME_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return domain_name_;
    }
    uint8 forwarding() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)19):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:247:forwarding", (int64)val_case_index(), "FORWARDING_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return forwarding_;
    }
    uint32 broadcast_address() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)28):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:271:broadcast_address", (int64)val_case_index(), "BROADCAST_ADDRESS_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return broadcast_address_;
    }
    vector<uint32>* ntpserver_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)42):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:295:ntpserver_list", (int64)val_case_index(), "NTP_SERVER_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ntpserver_list_;
    }
    bytestring const& vendor_specific() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)43):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:328:vendor_specific", (int64)val_case_index(), "VENDOR_SPECIFIC_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return vendor_specific_;
    }
    vector<uint32>* nbns() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)44):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:353:nbns", (int64)val_case_index(), "NBNS_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nbns_;
    }
    uint32 addr_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)50):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:386:addr_request", (int64)val_case_index(), "ADDR_REQUEST_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return addr_request_;
    }
    uint32 lease() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)51):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:410:lease", (int64)val_case_index(), "LEASE_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return lease_;
    }
    uint32 serv_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)54):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:435:serv_addr", (int64)val_case_index(), "SERV_ID_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return serv_addr_;
    }
    vector<uint8>* par_req_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)55):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:459:par_req_list", (int64)val_case_index(), "PAR_REQ_LIST_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return par_req_list_;
    }
    bytestring const& message() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)56):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:493:message", (int64)val_case_index(), "MESSAGE_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return message_;
    }
    uint16 max_msg_size() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)57):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:518:max_msg_size", (int64)val_case_index(), "MAX_MESSAGE_SIZE_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return max_msg_size_;
    }
    uint32 renewal_time() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)58):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:542:renewal_time", (int64)val_case_index(), "RENEWAL_TIME_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return renewal_time_;
    }
    uint32 rebinding_time() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)59):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:567:rebinding_time", (int64)val_case_index(), "REBINDING_TIME_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rebinding_time_;
    }
    bytestring const& vendor_class() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)60):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:592:vendor_class", (int64)val_case_index(), "VENDOR_CLASS_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return vendor_class_;
    }
    Client_Identifier* client_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)61):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:622:client_id", (int64)val_case_index(), "CLIENT_ID_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_id_;
    }
    bytestring const& user_class() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)77):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:659:user_class", (int64)val_case_index(), "USER_CLASS_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return user_class_;
    }
    Client_FQDN* client_fqdn() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)81):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:691:client_fqdn", (int64)val_case_index(), "CLIENT_FQDN_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return client_fqdn_;
    }
    vector<Relay_Agent_SubOption*>* relay_agent_inf() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)82):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:731:relay_agent_inf", (int64)val_case_index(), "RELAY_AGENT_INF_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return relay_agent_inf_;
    }
    uint8 auto_config() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)116):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:786:auto_config", (int64)val_case_index(), "AUTO_CONFIG_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auto_config_;
    }
    bytestring const& auto_proxy_config() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)252):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/dhcp/dhcp-options.pac:810:auto_proxy_config", (int64)val_case_index(), "AUTO_PROXY_CONFIG_OPTION");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return auto_proxy_config_;
    }
    uint8 code() const { return code_; }
    uint8 length() const { return length_; }

protected:
    uint8 val_case_index_;
    uint8 msg_type_;
    bytestring other_;
    uint32 subnet_;
    int32 time_offset_;
    vector<uint32>* router_list_;
    uint32 router_list__elem_;
    vector<uint32>* timeserver_list_;
    uint32 timeserver_list__elem_;
    vector<uint32>* nameserver_list_;
    uint32 nameserver_list__elem_;
    vector<uint32>* dns_server_list_;
    uint32 dns_server_list__elem_;
    bytestring host_name_;
    bytestring domain_name_;
    uint8 forwarding_;
    uint32 broadcast_address_;
    vector<uint32>* ntpserver_list_;
    uint32 ntpserver_list__elem_;
    bytestring vendor_specific_;
    vector<uint32>* nbns_;
    uint32 nbns__elem_;
    uint32 addr_request_;
    uint32 lease_;
    uint32 serv_addr_;
    vector<uint8>* par_req_list_;
    uint8 par_req_list__elem_;
    bytestring message_;
    uint16 max_msg_size_;
    uint32 renewal_time_;
    uint32 rebinding_time_;
    bytestring vendor_class_;
    Client_Identifier* client_id_;
    bytestring user_class_;
    Client_FQDN* client_fqdn_;
    vector<Relay_Agent_SubOption*>* relay_agent_inf_;
    Relay_Agent_SubOption* relay_agent_inf__elem_;
    uint8 auto_config_;
    bytestring auto_proxy_config_;
    uint8 code_;
    uint8 length_;
};


class OptionValueWrapper final {
public:
    OptionValueWrapper(uint8 code);
    ~OptionValueWrapper();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder);

    // Member access functions
    uint8 length() const { return length_; }
    OptionValue* value() const { return value_; }
    uint8 code() const { return code_; }

protected:
    uint8 length_;
    OptionValue* value_;
    uint8 code_;
};


class Option final {
public:
    Option();
    ~Option();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context, int t_byteorder);

    // Member access functions
    uint8 code() const { return code_; }
    uint8 data_case_index() const	{ return data_case_index_; }
    OptionValueWrapper* info() const {
        return info_;
    }
    int last() const { return last_; }
    int proc_create_options() const { return proc_create_options_; }
    int proc_subnet_option() const { BINPAC_ASSERT(has_proc_subnet_option()); return proc_subnet_option_; }
    bool has_proc_subnet_option() const { return has_proc_subnet_option_; }
    int proc_timeoffset_option() const { BINPAC_ASSERT(has_proc_timeoffset_option()); return proc_timeoffset_option_; }
    bool has_proc_timeoffset_option() const { return has_proc_timeoffset_option_; }
    int proc_router_option() const { BINPAC_ASSERT(has_proc_router_option()); return proc_router_option_; }
    bool has_proc_router_option() const { return has_proc_router_option_; }
    int proc_timeserver_option() const { BINPAC_ASSERT(has_proc_timeserver_option()); return proc_timeserver_option_; }
    bool has_proc_timeserver_option() const { return has_proc_timeserver_option_; }
    int proc_nameserver_option() const { BINPAC_ASSERT(has_proc_nameserver_option()); return proc_nameserver_option_; }
    bool has_proc_nameserver_option() const { return has_proc_nameserver_option_; }
    int proc_dns_server_option() const { BINPAC_ASSERT(has_proc_dns_server_option()); return proc_dns_server_option_; }
    bool has_proc_dns_server_option() const { return has_proc_dns_server_option_; }
    int proc_host_name_option() const { BINPAC_ASSERT(has_proc_host_name_option()); return proc_host_name_option_; }
    bool has_proc_host_name_option() const { return has_proc_host_name_option_; }
    int proc_domain_name_option() const { BINPAC_ASSERT(has_proc_domain_name_option()); return proc_domain_name_option_; }
    bool has_proc_domain_name_option() const { return has_proc_domain_name_option_; }
    int proc_forwarding_option() const { BINPAC_ASSERT(has_proc_forwarding_option()); return proc_forwarding_option_; }
    bool has_proc_forwarding_option() const { return has_proc_forwarding_option_; }
    int proc_broadcast_address_option() const { BINPAC_ASSERT(has_proc_broadcast_address_option()); return proc_broadcast_address_option_; }
    bool has_proc_broadcast_address_option() const { return has_proc_broadcast_address_option_; }
    int proc_ntpserver_option() const { BINPAC_ASSERT(has_proc_ntpserver_option()); return proc_ntpserver_option_; }
    bool has_proc_ntpserver_option() const { return has_proc_ntpserver_option_; }
    int proc_vendor_specific_option() const { BINPAC_ASSERT(has_proc_vendor_specific_option()); return proc_vendor_specific_option_; }
    bool has_proc_vendor_specific_option() const { return has_proc_vendor_specific_option_; }
    int proc_nbns_option() const { BINPAC_ASSERT(has_proc_nbns_option()); return proc_nbns_option_; }
    bool has_proc_nbns_option() const { return has_proc_nbns_option_; }
    int proc_addr_request_option() const { BINPAC_ASSERT(has_proc_addr_request_option()); return proc_addr_request_option_; }
    bool has_proc_addr_request_option() const { return has_proc_addr_request_option_; }
    int proc_lease_option() const { BINPAC_ASSERT(has_proc_lease_option()); return proc_lease_option_; }
    bool has_proc_lease_option() const { return has_proc_lease_option_; }
    int proc_serv_id_option() const { BINPAC_ASSERT(has_proc_serv_id_option()); return proc_serv_id_option_; }
    bool has_proc_serv_id_option() const { return has_proc_serv_id_option_; }
    int proc_par_req_list_option() const { BINPAC_ASSERT(has_proc_par_req_list_option()); return proc_par_req_list_option_; }
    bool has_proc_par_req_list_option() const { return has_proc_par_req_list_option_; }
    int proc_message_option() const { BINPAC_ASSERT(has_proc_message_option()); return proc_message_option_; }
    bool has_proc_message_option() const { return has_proc_message_option_; }
    int proc_max_message_size_option() const { BINPAC_ASSERT(has_proc_max_message_size_option()); return proc_max_message_size_option_; }
    bool has_proc_max_message_size_option() const { return has_proc_max_message_size_option_; }
    int proc_renewal_time_option() const { BINPAC_ASSERT(has_proc_renewal_time_option()); return proc_renewal_time_option_; }
    bool has_proc_renewal_time_option() const { return has_proc_renewal_time_option_; }
    int proc_rebinding_time_option() const { BINPAC_ASSERT(has_proc_rebinding_time_option()); return proc_rebinding_time_option_; }
    bool has_proc_rebinding_time_option() const { return has_proc_rebinding_time_option_; }
    int proc_vendor_class_option() const { BINPAC_ASSERT(has_proc_vendor_class_option()); return proc_vendor_class_option_; }
    bool has_proc_vendor_class_option() const { return has_proc_vendor_class_option_; }
    int proc_client_id_option() const { BINPAC_ASSERT(has_proc_client_id_option()); return proc_client_id_option_; }
    bool has_proc_client_id_option() const { return has_proc_client_id_option_; }
    int proc_user_class_option() const { BINPAC_ASSERT(has_proc_user_class_option()); return proc_user_class_option_; }
    bool has_proc_user_class_option() const { return has_proc_user_class_option_; }
    int proc_client_fqdn_option() const { BINPAC_ASSERT(has_proc_client_fqdn_option()); return proc_client_fqdn_option_; }
    bool has_proc_client_fqdn_option() const { return has_proc_client_fqdn_option_; }
    int proc_relay_agent_info_option() const { BINPAC_ASSERT(has_proc_relay_agent_info_option()); return proc_relay_agent_info_option_; }
    bool has_proc_relay_agent_info_option() const { return has_proc_relay_agent_info_option_; }
    int proc_auto_config_option() const { BINPAC_ASSERT(has_proc_auto_config_option()); return proc_auto_config_option_; }
    bool has_proc_auto_config_option() const { return has_proc_auto_config_option_; }
    int proc_auto_proxy_config_option() const { BINPAC_ASSERT(has_proc_auto_proxy_config_option()); return proc_auto_proxy_config_option_; }
    bool has_proc_auto_proxy_config_option() const { return has_proc_auto_proxy_config_option_; }

protected:
    uint8 code_;
    uint8 data_case_index_;
    OptionValueWrapper* info_;
    int last_;
    int proc_create_options_;
    int proc_subnet_option_;
    bool has_proc_subnet_option_;
    int proc_timeoffset_option_;
    bool has_proc_timeoffset_option_;
    int proc_router_option_;
    bool has_proc_router_option_;
    int proc_timeserver_option_;
    bool has_proc_timeserver_option_;
    int proc_nameserver_option_;
    bool has_proc_nameserver_option_;
    int proc_dns_server_option_;
    bool has_proc_dns_server_option_;
    int proc_host_name_option_;
    bool has_proc_host_name_option_;
    int proc_domain_name_option_;
    bool has_proc_domain_name_option_;
    int proc_forwarding_option_;
    bool has_proc_forwarding_option_;
    int proc_broadcast_address_option_;
    bool has_proc_broadcast_address_option_;
    int proc_ntpserver_option_;
    bool has_proc_ntpserver_option_;
    int proc_vendor_specific_option_;
    bool has_proc_vendor_specific_option_;
    int proc_nbns_option_;
    bool has_proc_nbns_option_;
    int proc_addr_request_option_;
    bool has_proc_addr_request_option_;
    int proc_lease_option_;
    bool has_proc_lease_option_;
    int proc_serv_id_option_;
    bool has_proc_serv_id_option_;
    int proc_par_req_list_option_;
    bool has_proc_par_req_list_option_;
    int proc_message_option_;
    bool has_proc_message_option_;
    int proc_max_message_size_option_;
    bool has_proc_max_message_size_option_;
    int proc_renewal_time_option_;
    bool has_proc_renewal_time_option_;
    int proc_rebinding_time_option_;
    bool has_proc_rebinding_time_option_;
    int proc_vendor_class_option_;
    bool has_proc_vendor_class_option_;
    int proc_client_id_option_;
    bool has_proc_client_id_option_;
    int proc_user_class_option_;
    bool has_proc_user_class_option_;
    int proc_client_fqdn_option_;
    bool has_proc_client_fqdn_option_;
    int proc_relay_agent_info_option_;
    bool has_proc_relay_agent_info_option_;
    int proc_auto_config_option_;
    bool has_proc_auto_config_option_;
    int proc_auto_proxy_config_option_;
    bool has_proc_auto_proxy_config_option_;
};


class DHCP_Message final {
public:
    DHCP_Message(bool is_orig);
    ~DHCP_Message();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context);

    // Member access functions
    uint8 op() const { return op_; }
    uint8 htype() const { return htype_; }
    uint8 hlen() const { return hlen_; }
    uint8 hops() const { return hops_; }
    uint32 xid() const { return xid_; }
    uint16 secs() const { return secs_; }
    uint16 flags() const { return flags_; }
    uint32 ciaddr() const { return ciaddr_; }
    uint32 yiaddr() const { return yiaddr_; }
    uint32 siaddr() const { return siaddr_; }
    uint32 giaddr() const { return giaddr_; }
    bytestring const& chaddr() const { return chaddr_; }
    bytestring const& sname() const { return sname_; }
    bytestring const& file_n() const { return file_n_; }
    uint32 cookie() const { return cookie_; }
    vector<Option*>* options() const { return options_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    int type() const { return type_; }
    int proc_dhcp_message() const { return proc_dhcp_message_; }

protected:
    uint8 op_;
    uint8 htype_;
    uint8 hlen_;
    uint8 hops_;
    uint32 xid_;
    uint16 secs_;
    uint16 flags_;
    uint32 ciaddr_;
    uint32 yiaddr_;
    uint32 siaddr_;
    uint32 giaddr_;
    bytestring chaddr_;
    bytestring sname_;
    bytestring file_n_;
    uint32 cookie_;
    vector<Option*>* options_;
    Option* options__elem_;
    bool is_orig_;
    int byteorder_;
    int type_;
    int proc_dhcp_message_;
};

extern int const SUBNET_OPTION;
extern int const TIME_OFFSET_OPTION;
extern int const ROUTER_OPTION;
extern int const TIME_SERVER_OPTION;
extern int const NAME_SERVER_OPTION;
extern int const DNS_SERVER_OPTION;
extern int const HOST_NAME_OPTION;
extern int const DOMAIN_NAME_OPTION;
extern int const FORWARDING_OPTION;
extern int const BROADCAST_ADDRESS_OPTION;
extern int const NTP_SERVER_OPTION;
extern int const VENDOR_SPECIFIC_OPTION;
extern int const NBNS_OPTION;
extern int const ADDR_REQUEST_OPTION;
extern int const LEASE_OPTION;
extern int const SERV_ID_OPTION;
extern int const PAR_REQ_LIST_OPTION;
extern int const MESSAGE_OPTION;
extern int const MAX_MESSAGE_SIZE_OPTION;
extern int const RENEWAL_TIME_OPTION;
extern int const REBINDING_TIME_OPTION;
extern int const VENDOR_CLASS_OPTION;
extern int const CLIENT_ID_OPTION;

class Client_Identifier final {
public:
    Client_Identifier(uint8 length);
    ~Client_Identifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 hwtype() const { return hwtype_; }
    bytestring const& hwaddr() const { return hwaddr_; }
    uint8 length() const { return length_; }

protected:
    uint8 hwtype_;
    bytestring hwaddr_;
    uint8 length_;
};

extern int const USER_CLASS_OPTION;
extern int const CLIENT_FQDN_OPTION;

class Client_FQDN final {
public:
    Client_FQDN(uint8 length);
    ~Client_FQDN();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 flags() const { return flags_; }
    uint8 rcode1() const { return rcode1_; }
    uint8 rcode2() const { return rcode2_; }
    bytestring const& domain_name() const { return domain_name_; }
    uint8 length() const { return length_; }

protected:
    uint8 flags_;
    uint8 rcode1_;
    uint8 rcode2_;
    bytestring domain_name_;
    uint8 length_;
};

extern int const RELAY_AGENT_INF_OPTION;

class Relay_Agent_SubOption final {
public:
    Relay_Agent_SubOption(uint8 tot_len);
    ~Relay_Agent_SubOption();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDHCP* t_context);

    // Member access functions
    uint8 code() const { return code_; }
    uint8 length() const { return length_; }
    bytestring const& value() const { return value_; }
    uint8 tot_len() const { return tot_len_; }
    uint8 sum_len() const { return sum_len_; }
    bool last() const { return last_; }

protected:
    uint8 code_;
    uint8 length_;
    bytestring value_;
    uint8 tot_len_;
    uint8 sum_len_;
    bool last_;
};

extern int const AUTO_CONFIG_OPTION;
extern int const AUTO_PROXY_CONFIG_OPTION;
} // namespace DHCP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_dhcp_dhcp_pac_h */
