// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/dnp3/dnp3_pac.h"

namespace binpac {






namespace DNP3 {
// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDNP3::ContextDNP3(DNP3_Conn* connection, DNP3_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ContextDNP3::~ContextDNP3() {
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_PDU::DNP3_PDU(bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    response_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_PDU::~DNP3_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool DNP3_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextDNP3* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                if ( ! request_ ) {
                    request_ = new DNP3_Request();
                }
                bool t_request_parsing_complete;
                t_request_parsing_complete = false;
                while ( ! t_request_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_request_parsing_complete = request_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_request_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_request_parsing_complete;
            }
            break;
        case false:
            // Parse "response"
            {
                if ( ! response_ ) {
                    response_ = new DNP3_Response();
                }
                bool t_response_parsing_complete;
                t_response_parsing_complete = false;
                while ( ! t_response_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_response_parsing_complete = response_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_response_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_response_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("DNP3_PDU", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Header_Block::Header_Block() {
    start_1_ = 0;
    start_2_ = 0;
    len_ = 0;
    ctrl_ = 0;
    dest_addr_ = 0;
    src_addr_ = 0;
    byteorder_ = littleendian;
    get_header_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Header_Block::~Header_Block() {
}

int Header_Block::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "Header_Block"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Header_Block",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_1"
    start_1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    // Evaluate '&enforce' attribute
    if (! ( start_1() == 0x05 ) ) {
        throw binpac::ExceptionEnforceViolation("Header_Block:start_1");
    }

    // Parse "start_2"
    start_2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));
    // Evaluate '&enforce' attribute
    if (! ( start_2() == 0x64 ) ) {
        throw binpac::ExceptionEnforceViolation("Header_Block:start_2");
    }

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "ctrl"
    ctrl_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "dest_addr"
    dest_addr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "src_addr"
    src_addr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Evaluate 'let' and 'withinput' fields
    get_header_ = t_context->flow()->get_dnp3_header_block(len(), ctrl(), dest_addr(), src_addr());
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Request::DNP3_Request() {
    addin_header_ = nullptr;
    app_header_ = nullptr;
    data_case_index_ = -1;
    read_requests_ = nullptr;
    read_requests__elem_ = nullptr;
    write_requests_ = nullptr;
    write_requests__elem_ = nullptr;
    select_requests_ = nullptr;
    select_requests__elem_ = nullptr;
    operate_requests_ = nullptr;
    operate_requests__elem_ = nullptr;
    direct_operate_requests_ = nullptr;
    direct_operate_requests__elem_ = nullptr;
    direct_operate_nr_requests_ = nullptr;
    direct_operate_nr_requests__elem_ = nullptr;
    immed_freeze_requests_ = nullptr;
    immed_freeze_requests__elem_ = nullptr;
    immed_freeze_nr_requests_ = nullptr;
    immed_freeze_nr_requests__elem_ = nullptr;
    freeze_clear_requests_ = nullptr;
    freeze_clear_requests__elem_ = nullptr;
    freeze_clear_nr_requests_ = nullptr;
    freeze_clear_nr_requests__elem_ = nullptr;
    freeze_time_requests_ = nullptr;
    freeze_time_requests__elem_ = nullptr;
    freeze_time_nr_requests_ = nullptr;
    freeze_time_nr_requests__elem_ = nullptr;
    initialize_appl_ = nullptr;
    initialize_appl__elem_ = nullptr;
    start_appl_ = nullptr;
    start_appl__elem_ = nullptr;
    stop_appl_ = nullptr;
    stop_appl__elem_ = nullptr;
    enable_unsolicited_ = nullptr;
    enable_unsolicited__elem_ = nullptr;
    disable_unsolicited_ = nullptr;
    disable_unsolicited__elem_ = nullptr;
    assign_class_ = nullptr;
    assign_class__elem_ = nullptr;
    open_file_ = nullptr;
    open_file__elem_ = nullptr;
    close_file_ = nullptr;
    close_file__elem_ = nullptr;
    delete_file_ = nullptr;
    delete_file__elem_ = nullptr;
    abort_file_ = nullptr;
    abort_file__elem_ = nullptr;
    get_file_info_ = nullptr;
    get_file_info__elem_ = nullptr;
    auth_file_ = nullptr;
    auth_file__elem_ = nullptr;
    active_config_ = nullptr;
    active_config__elem_ = nullptr;
    auth_req_ = nullptr;
    auth_req__elem_ = nullptr;
    auth_err_ = nullptr;
    auth_err__elem_ = nullptr;
    byteorder_ = bigendian;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Request::~DNP3_Request() {
    delete addin_header_;
    addin_header_ = nullptr;
    delete app_header_;
    app_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)0):
            // Clean up "none_confirm"
            {
            }
            break;
        case ((uint8)1):
            // Clean up "read_requests"
            {
                delete read_requests__elem_;
                read_requests__elem_ = nullptr;
                if ( read_requests() ) {
                    for ( auto* read_requests__elem_ : *read_requests() ) {
                        delete read_requests__elem_;
                        read_requests__elem_ = nullptr;
                    }
                }
                delete read_requests_;
            }
            break;
        case ((uint8)2):
            // Clean up "write_requests"
            {
                delete write_requests__elem_;
                write_requests__elem_ = nullptr;
                if ( write_requests() ) {
                    for ( auto* write_requests__elem_ : *write_requests() ) {
                        delete write_requests__elem_;
                        write_requests__elem_ = nullptr;
                    }
                }
                delete write_requests_;
            }
            break;
        case ((uint8)3):
            // Clean up "select_requests"
            {
                delete select_requests__elem_;
                select_requests__elem_ = nullptr;
                if ( select_requests() ) {
                    for ( auto* select_requests__elem_ : *select_requests() ) {
                        delete select_requests__elem_;
                        select_requests__elem_ = nullptr;
                    }
                }
                delete select_requests_;
            }
            break;
        case ((uint8)4):
            // Clean up "operate_requests"
            {
                delete operate_requests__elem_;
                operate_requests__elem_ = nullptr;
                if ( operate_requests() ) {
                    for ( auto* operate_requests__elem_ : *operate_requests() ) {
                        delete operate_requests__elem_;
                        operate_requests__elem_ = nullptr;
                    }
                }
                delete operate_requests_;
            }
            break;
        case ((uint8)5):
            // Clean up "direct_operate_requests"
            {
                delete direct_operate_requests__elem_;
                direct_operate_requests__elem_ = nullptr;
                if ( direct_operate_requests() ) {
                    for ( auto* direct_operate_requests__elem_ : *direct_operate_requests() ) {
                        delete direct_operate_requests__elem_;
                        direct_operate_requests__elem_ = nullptr;
                    }
                }
                delete direct_operate_requests_;
            }
            break;
        case ((uint8)6):
            // Clean up "direct_operate_nr_requests"
            {
                delete direct_operate_nr_requests__elem_;
                direct_operate_nr_requests__elem_ = nullptr;
                if ( direct_operate_nr_requests() ) {
                    for ( auto* direct_operate_nr_requests__elem_ : *direct_operate_nr_requests() ) {
                        delete direct_operate_nr_requests__elem_;
                        direct_operate_nr_requests__elem_ = nullptr;
                    }
                }
                delete direct_operate_nr_requests_;
            }
            break;
        case ((uint8)7):
            // Clean up "immed_freeze_requests"
            {
                delete immed_freeze_requests__elem_;
                immed_freeze_requests__elem_ = nullptr;
                if ( immed_freeze_requests() ) {
                    for ( auto* immed_freeze_requests__elem_ : *immed_freeze_requests() ) {
                        delete immed_freeze_requests__elem_;
                        immed_freeze_requests__elem_ = nullptr;
                    }
                }
                delete immed_freeze_requests_;
            }
            break;
        case ((uint8)8):
            // Clean up "immed_freeze_nr_requests"
            {
                delete immed_freeze_nr_requests__elem_;
                immed_freeze_nr_requests__elem_ = nullptr;
                if ( immed_freeze_nr_requests() ) {
                    for ( auto* immed_freeze_nr_requests__elem_ : *immed_freeze_nr_requests() ) {
                        delete immed_freeze_nr_requests__elem_;
                        immed_freeze_nr_requests__elem_ = nullptr;
                    }
                }
                delete immed_freeze_nr_requests_;
            }
            break;
        case ((uint8)9):
            // Clean up "freeze_clear_requests"
            {
                delete freeze_clear_requests__elem_;
                freeze_clear_requests__elem_ = nullptr;
                if ( freeze_clear_requests() ) {
                    for ( auto* freeze_clear_requests__elem_ : *freeze_clear_requests() ) {
                        delete freeze_clear_requests__elem_;
                        freeze_clear_requests__elem_ = nullptr;
                    }
                }
                delete freeze_clear_requests_;
            }
            break;
        case ((uint8)10):
            // Clean up "freeze_clear_nr_requests"
            {
                delete freeze_clear_nr_requests__elem_;
                freeze_clear_nr_requests__elem_ = nullptr;
                if ( freeze_clear_nr_requests() ) {
                    for ( auto* freeze_clear_nr_requests__elem_ : *freeze_clear_nr_requests() ) {
                        delete freeze_clear_nr_requests__elem_;
                        freeze_clear_nr_requests__elem_ = nullptr;
                    }
                }
                delete freeze_clear_nr_requests_;
            }
            break;
        case ((uint8)11):
            // Clean up "freeze_time_requests"
            {
                delete freeze_time_requests__elem_;
                freeze_time_requests__elem_ = nullptr;
                if ( freeze_time_requests() ) {
                    for ( auto* freeze_time_requests__elem_ : *freeze_time_requests() ) {
                        delete freeze_time_requests__elem_;
                        freeze_time_requests__elem_ = nullptr;
                    }
                }
                delete freeze_time_requests_;
            }
            break;
        case ((uint8)12):
            // Clean up "freeze_time_nr_requests"
            {
                delete freeze_time_nr_requests__elem_;
                freeze_time_nr_requests__elem_ = nullptr;
                if ( freeze_time_nr_requests() ) {
                    for ( auto* freeze_time_nr_requests__elem_ : *freeze_time_nr_requests() ) {
                        delete freeze_time_nr_requests__elem_;
                        freeze_time_nr_requests__elem_ = nullptr;
                    }
                }
                delete freeze_time_nr_requests_;
            }
            break;
        case ((uint8)13):
            // Clean up "cold_restart"
            {
            }
            break;
        case ((uint8)14):
            // Clean up "warm_restart"
            {
            }
            break;
        case ((uint8)15):
            // Clean up "initialize_data"
            {
            }
            break;
        case ((uint8)16):
            // Clean up "initialize_appl"
            {
                delete initialize_appl__elem_;
                initialize_appl__elem_ = nullptr;
                if ( initialize_appl() ) {
                    for ( auto* initialize_appl__elem_ : *initialize_appl() ) {
                        delete initialize_appl__elem_;
                        initialize_appl__elem_ = nullptr;
                    }
                }
                delete initialize_appl_;
            }
            break;
        case ((uint8)17):
            // Clean up "start_appl"
            {
                delete start_appl__elem_;
                start_appl__elem_ = nullptr;
                if ( start_appl() ) {
                    for ( auto* start_appl__elem_ : *start_appl() ) {
                        delete start_appl__elem_;
                        start_appl__elem_ = nullptr;
                    }
                }
                delete start_appl_;
            }
            break;
        case ((uint8)18):
            // Clean up "stop_appl"
            {
                delete stop_appl__elem_;
                stop_appl__elem_ = nullptr;
                if ( stop_appl() ) {
                    for ( auto* stop_appl__elem_ : *stop_appl() ) {
                        delete stop_appl__elem_;
                        stop_appl__elem_ = nullptr;
                    }
                }
                delete stop_appl_;
            }
            break;
        case ((uint8)19):
            // Clean up "save_config"
            {
            }
            break;
        case ((uint8)20):
            // Clean up "enable_unsolicited"
            {
                delete enable_unsolicited__elem_;
                enable_unsolicited__elem_ = nullptr;
                if ( enable_unsolicited() ) {
                    for ( auto* enable_unsolicited__elem_ : *enable_unsolicited() ) {
                        delete enable_unsolicited__elem_;
                        enable_unsolicited__elem_ = nullptr;
                    }
                }
                delete enable_unsolicited_;
            }
            break;
        case ((uint8)21):
            // Clean up "disable_unsolicited"
            {
                delete disable_unsolicited__elem_;
                disable_unsolicited__elem_ = nullptr;
                if ( disable_unsolicited() ) {
                    for ( auto* disable_unsolicited__elem_ : *disable_unsolicited() ) {
                        delete disable_unsolicited__elem_;
                        disable_unsolicited__elem_ = nullptr;
                    }
                }
                delete disable_unsolicited_;
            }
            break;
        case ((uint8)22):
            // Clean up "assign_class"
            {
                delete assign_class__elem_;
                assign_class__elem_ = nullptr;
                if ( assign_class() ) {
                    for ( auto* assign_class__elem_ : *assign_class() ) {
                        delete assign_class__elem_;
                        assign_class__elem_ = nullptr;
                    }
                }
                delete assign_class_;
            }
            break;
        case ((uint8)23):
            // Clean up "delay_measure"
            {
            }
            break;
        case ((uint8)24):
            // Clean up "record_cur_time"
            {
            }
            break;
        case ((uint8)25):
            // Clean up "open_file"
            {
                delete open_file__elem_;
                open_file__elem_ = nullptr;
                if ( open_file() ) {
                    for ( auto* open_file__elem_ : *open_file() ) {
                        delete open_file__elem_;
                        open_file__elem_ = nullptr;
                    }
                }
                delete open_file_;
            }
            break;
        case ((uint8)26):
            // Clean up "close_file"
            {
                delete close_file__elem_;
                close_file__elem_ = nullptr;
                if ( close_file() ) {
                    for ( auto* close_file__elem_ : *close_file() ) {
                        delete close_file__elem_;
                        close_file__elem_ = nullptr;
                    }
                }
                delete close_file_;
            }
            break;
        case ((uint8)27):
            // Clean up "delete_file"
            {
                delete delete_file__elem_;
                delete_file__elem_ = nullptr;
                if ( delete_file() ) {
                    for ( auto* delete_file__elem_ : *delete_file() ) {
                        delete delete_file__elem_;
                        delete_file__elem_ = nullptr;
                    }
                }
                delete delete_file_;
            }
            break;
        case ((uint8)30):
            // Clean up "abort_file"
            {
                delete abort_file__elem_;
                abort_file__elem_ = nullptr;
                if ( abort_file() ) {
                    for ( auto* abort_file__elem_ : *abort_file() ) {
                        delete abort_file__elem_;
                        abort_file__elem_ = nullptr;
                    }
                }
                delete abort_file_;
            }
            break;
        case ((uint8)28):
            // Clean up "get_file_info"
            {
                delete get_file_info__elem_;
                get_file_info__elem_ = nullptr;
                if ( get_file_info() ) {
                    for ( auto* get_file_info__elem_ : *get_file_info() ) {
                        delete get_file_info__elem_;
                        get_file_info__elem_ = nullptr;
                    }
                }
                delete get_file_info_;
            }
            break;
        case ((uint8)29):
            // Clean up "auth_file"
            {
                delete auth_file__elem_;
                auth_file__elem_ = nullptr;
                if ( auth_file() ) {
                    for ( auto* auth_file__elem_ : *auth_file() ) {
                        delete auth_file__elem_;
                        auth_file__elem_ = nullptr;
                    }
                }
                delete auth_file_;
            }
            break;
        case ((uint8)31):
            // Clean up "active_config"
            {
                delete active_config__elem_;
                active_config__elem_ = nullptr;
                if ( active_config() ) {
                    for ( auto* active_config__elem_ : *active_config() ) {
                        delete active_config__elem_;
                        active_config__elem_ = nullptr;
                    }
                }
                delete active_config_;
            }
            break;
        case ((uint8)32):
            // Clean up "auth_req"
            {
                delete auth_req__elem_;
                auth_req__elem_ = nullptr;
                if ( auth_req() ) {
                    for ( auto* auth_req__elem_ : *auth_req() ) {
                        delete auth_req__elem_;
                        auth_req__elem_ = nullptr;
                    }
                }
                delete auth_req_;
            }
            break;
        case ((uint8)33):
            // Clean up "auth_err"
            {
                delete auth_err__elem_;
                auth_err__elem_ = nullptr;
                if ( auth_err() ) {
                    for ( auto* auth_err__elem_ : *auth_err() ) {
                        delete auth_err__elem_;
                        auth_err__elem_ = nullptr;
                    }
                }
                delete auth_err_;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool DNP3_Request::ParseBuffer(flow_buffer_t t_flow_buffer, ContextDNP3* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(8, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "addin_header"
            addin_header_ = new Header_Block();
            addin_header_->Parse(t_begin_of_data, t_end_of_data, t_context);
            t_flow_buffer->GrowFrame(9 + addin_header()->len() - 5 - 1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "app_header"
                app_header_ = new DNP3_Application_Request_Header();
                int t_app_header__size;
                t_app_header__size = app_header_->Parse((t_begin_of_data + 8), t_end_of_data, t_context);

                const_byteptr const t_dataptr_after_app_header = (t_begin_of_data + 8) + (t_app_header__size);
                BINPAC_ASSERT(t_dataptr_after_app_header <= t_end_of_data);
                // Parse "data"
                int t_data__size;
                data_case_index_ =  ( app_header()->function_code() ) ;
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( data_case_index() ) {
                    case ((uint8)0):
                        // Parse "none_confirm"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)1):
                        // Parse "read_requests"
                        {
                            int t_read_requests__arraylength;
                            t_read_requests__arraylength = 0;
                            read_requests__elem_ = nullptr;
                            int t_read_requests__elem__it;
                            t_read_requests__elem__it = 0;
                            int t_read_requests__size;
                            read_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_read_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_read_requests__elem__it) {
                                // Check &until(read_requests__elem__dataptr >= end_of_data)
                                if ( t_read_requests__elem__dataptr >= t_end_of_data ) {
                                    read_requests__elem_ = nullptr;
                                    goto end_of_read_requests;
                                }
                                read_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_read_requests__elem__size;
                                t_read_requests__elem__size = read_requests__elem_->Parse(t_read_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                read_requests_->push_back(read_requests__elem_);
                                t_read_requests__elem__dataptr += t_read_requests__elem__size;
                                BINPAC_ASSERT(t_read_requests__elem__dataptr <= t_end_of_data);
                                read_requests__elem_ = nullptr;
                            }
                        end_of_read_requests: ;
                            t_read_requests__size = t_read_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_read_requests__size;
                        }
                        break;
                    case ((uint8)2):
                        // Parse "write_requests"
                        {
                            int t_write_requests__arraylength;
                            t_write_requests__arraylength = 0;
                            write_requests__elem_ = nullptr;
                            int t_write_requests__elem__it;
                            t_write_requests__elem__it = 0;
                            int t_write_requests__size;
                            write_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_write_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_write_requests__elem__it) {
                                // Check &until(write_requests__elem__dataptr >= end_of_data)
                                if ( t_write_requests__elem__dataptr >= t_end_of_data ) {
                                    write_requests__elem_ = nullptr;
                                    goto end_of_write_requests;
                                }
                                write_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_write_requests__elem__size;
                                t_write_requests__elem__size = write_requests__elem_->Parse(t_write_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                write_requests_->push_back(write_requests__elem_);
                                t_write_requests__elem__dataptr += t_write_requests__elem__size;
                                BINPAC_ASSERT(t_write_requests__elem__dataptr <= t_end_of_data);
                                write_requests__elem_ = nullptr;
                            }
                        end_of_write_requests: ;
                            t_write_requests__size = t_write_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_write_requests__size;
                        }
                        break;
                    case ((uint8)3):
                        // Parse "select_requests"
                        {
                            int t_select_requests__arraylength;
                            t_select_requests__arraylength = 0;
                            select_requests__elem_ = nullptr;
                            int t_select_requests__elem__it;
                            t_select_requests__elem__it = 0;
                            int t_select_requests__size;
                            select_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_select_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_select_requests__elem__it) {
                                // Check &until(select_requests__elem__dataptr >= end_of_data)
                                if ( t_select_requests__elem__dataptr >= t_end_of_data ) {
                                    select_requests__elem_ = nullptr;
                                    goto end_of_select_requests;
                                }
                                select_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_select_requests__elem__size;
                                t_select_requests__elem__size = select_requests__elem_->Parse(t_select_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                select_requests_->push_back(select_requests__elem_);
                                t_select_requests__elem__dataptr += t_select_requests__elem__size;
                                BINPAC_ASSERT(t_select_requests__elem__dataptr <= t_end_of_data);
                                select_requests__elem_ = nullptr;
                            }
                        end_of_select_requests: ;
                            t_select_requests__size = t_select_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_select_requests__size;
                        }
                        break;
                    case ((uint8)4):
                        // Parse "operate_requests"
                        {
                            int t_operate_requests__arraylength;
                            t_operate_requests__arraylength = 0;
                            operate_requests__elem_ = nullptr;
                            int t_operate_requests__elem__it;
                            t_operate_requests__elem__it = 0;
                            int t_operate_requests__size;
                            operate_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_operate_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_operate_requests__elem__it) {
                                // Check &until(operate_requests__elem__dataptr >= end_of_data)
                                if ( t_operate_requests__elem__dataptr >= t_end_of_data ) {
                                    operate_requests__elem_ = nullptr;
                                    goto end_of_operate_requests;
                                }
                                operate_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_operate_requests__elem__size;
                                t_operate_requests__elem__size = operate_requests__elem_->Parse(t_operate_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                operate_requests_->push_back(operate_requests__elem_);
                                t_operate_requests__elem__dataptr += t_operate_requests__elem__size;
                                BINPAC_ASSERT(t_operate_requests__elem__dataptr <= t_end_of_data);
                                operate_requests__elem_ = nullptr;
                            }
                        end_of_operate_requests: ;
                            t_operate_requests__size = t_operate_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_operate_requests__size;
                        }
                        break;
                    case ((uint8)5):
                        // Parse "direct_operate_requests"
                        {
                            int t_direct_operate_requests__arraylength;
                            t_direct_operate_requests__arraylength = 0;
                            direct_operate_requests__elem_ = nullptr;
                            int t_direct_operate_requests__elem__it;
                            t_direct_operate_requests__elem__it = 0;
                            int t_direct_operate_requests__size;
                            direct_operate_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_direct_operate_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_direct_operate_requests__elem__it) {
                                // Check &until(direct_operate_requests__elem__dataptr >= end_of_data)
                                if ( t_direct_operate_requests__elem__dataptr >= t_end_of_data ) {
                                    direct_operate_requests__elem_ = nullptr;
                                    goto end_of_direct_operate_requests;
                                }
                                direct_operate_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_direct_operate_requests__elem__size;
                                t_direct_operate_requests__elem__size = direct_operate_requests__elem_->Parse(t_direct_operate_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                direct_operate_requests_->push_back(direct_operate_requests__elem_);
                                t_direct_operate_requests__elem__dataptr += t_direct_operate_requests__elem__size;
                                BINPAC_ASSERT(t_direct_operate_requests__elem__dataptr <= t_end_of_data);
                                direct_operate_requests__elem_ = nullptr;
                            }
                        end_of_direct_operate_requests: ;
                            t_direct_operate_requests__size = t_direct_operate_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_direct_operate_requests__size;
                        }
                        break;
                    case ((uint8)6):
                        // Parse "direct_operate_nr_requests"
                        {
                            int t_direct_operate_nr_requests__arraylength;
                            t_direct_operate_nr_requests__arraylength = 0;
                            direct_operate_nr_requests__elem_ = nullptr;
                            int t_direct_operate_nr_requests__elem__it;
                            t_direct_operate_nr_requests__elem__it = 0;
                            int t_direct_operate_nr_requests__size;
                            direct_operate_nr_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_direct_operate_nr_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_direct_operate_nr_requests__elem__it) {
                                // Check &until(direct_operate_nr_requests__elem__dataptr >= end_of_data)
                                if ( t_direct_operate_nr_requests__elem__dataptr >= t_end_of_data ) {
                                    direct_operate_nr_requests__elem_ = nullptr;
                                    goto end_of_direct_operate_nr_requests;
                                }
                                direct_operate_nr_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_direct_operate_nr_requests__elem__size;
                                t_direct_operate_nr_requests__elem__size = direct_operate_nr_requests__elem_->Parse(t_direct_operate_nr_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                direct_operate_nr_requests_->push_back(direct_operate_nr_requests__elem_);
                                t_direct_operate_nr_requests__elem__dataptr += t_direct_operate_nr_requests__elem__size;
                                BINPAC_ASSERT(t_direct_operate_nr_requests__elem__dataptr <= t_end_of_data);
                                direct_operate_nr_requests__elem_ = nullptr;
                            }
                        end_of_direct_operate_nr_requests: ;
                            t_direct_operate_nr_requests__size = t_direct_operate_nr_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_direct_operate_nr_requests__size;
                        }
                        break;
                    case ((uint8)7):
                        // Parse "immed_freeze_requests"
                        {
                            int t_immed_freeze_requests__arraylength;
                            t_immed_freeze_requests__arraylength = 0;
                            immed_freeze_requests__elem_ = nullptr;
                            int t_immed_freeze_requests__elem__it;
                            t_immed_freeze_requests__elem__it = 0;
                            int t_immed_freeze_requests__size;
                            immed_freeze_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_immed_freeze_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_immed_freeze_requests__elem__it) {
                                // Check &until(immed_freeze_requests__elem__dataptr >= end_of_data)
                                if ( t_immed_freeze_requests__elem__dataptr >= t_end_of_data ) {
                                    immed_freeze_requests__elem_ = nullptr;
                                    goto end_of_immed_freeze_requests;
                                }
                                immed_freeze_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_immed_freeze_requests__elem__size;
                                t_immed_freeze_requests__elem__size = immed_freeze_requests__elem_->Parse(t_immed_freeze_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                immed_freeze_requests_->push_back(immed_freeze_requests__elem_);
                                t_immed_freeze_requests__elem__dataptr += t_immed_freeze_requests__elem__size;
                                BINPAC_ASSERT(t_immed_freeze_requests__elem__dataptr <= t_end_of_data);
                                immed_freeze_requests__elem_ = nullptr;
                            }
                        end_of_immed_freeze_requests: ;
                            t_immed_freeze_requests__size = t_immed_freeze_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_immed_freeze_requests__size;
                        }
                        break;
                    case ((uint8)8):
                        // Parse "immed_freeze_nr_requests"
                        {
                            int t_immed_freeze_nr_requests__arraylength;
                            t_immed_freeze_nr_requests__arraylength = 0;
                            immed_freeze_nr_requests__elem_ = nullptr;
                            int t_immed_freeze_nr_requests__elem__it;
                            t_immed_freeze_nr_requests__elem__it = 0;
                            int t_immed_freeze_nr_requests__size;
                            immed_freeze_nr_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_immed_freeze_nr_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_immed_freeze_nr_requests__elem__it) {
                                // Check &until(immed_freeze_nr_requests__elem__dataptr >= end_of_data)
                                if ( t_immed_freeze_nr_requests__elem__dataptr >= t_end_of_data ) {
                                    immed_freeze_nr_requests__elem_ = nullptr;
                                    goto end_of_immed_freeze_nr_requests;
                                }
                                immed_freeze_nr_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_immed_freeze_nr_requests__elem__size;
                                t_immed_freeze_nr_requests__elem__size = immed_freeze_nr_requests__elem_->Parse(t_immed_freeze_nr_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                immed_freeze_nr_requests_->push_back(immed_freeze_nr_requests__elem_);
                                t_immed_freeze_nr_requests__elem__dataptr += t_immed_freeze_nr_requests__elem__size;
                                BINPAC_ASSERT(t_immed_freeze_nr_requests__elem__dataptr <= t_end_of_data);
                                immed_freeze_nr_requests__elem_ = nullptr;
                            }
                        end_of_immed_freeze_nr_requests: ;
                            t_immed_freeze_nr_requests__size = t_immed_freeze_nr_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_immed_freeze_nr_requests__size;
                        }
                        break;
                    case ((uint8)9):
                        // Parse "freeze_clear_requests"
                        {
                            int t_freeze_clear_requests__arraylength;
                            t_freeze_clear_requests__arraylength = 0;
                            freeze_clear_requests__elem_ = nullptr;
                            int t_freeze_clear_requests__elem__it;
                            t_freeze_clear_requests__elem__it = 0;
                            int t_freeze_clear_requests__size;
                            freeze_clear_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_freeze_clear_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_freeze_clear_requests__elem__it) {
                                // Check &until(freeze_clear_requests__elem__dataptr >= end_of_data)
                                if ( t_freeze_clear_requests__elem__dataptr >= t_end_of_data ) {
                                    freeze_clear_requests__elem_ = nullptr;
                                    goto end_of_freeze_clear_requests;
                                }
                                freeze_clear_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_freeze_clear_requests__elem__size;
                                t_freeze_clear_requests__elem__size = freeze_clear_requests__elem_->Parse(t_freeze_clear_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                freeze_clear_requests_->push_back(freeze_clear_requests__elem_);
                                t_freeze_clear_requests__elem__dataptr += t_freeze_clear_requests__elem__size;
                                BINPAC_ASSERT(t_freeze_clear_requests__elem__dataptr <= t_end_of_data);
                                freeze_clear_requests__elem_ = nullptr;
                            }
                        end_of_freeze_clear_requests: ;
                            t_freeze_clear_requests__size = t_freeze_clear_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_freeze_clear_requests__size;
                        }
                        break;
                    case ((uint8)10):
                        // Parse "freeze_clear_nr_requests"
                        {
                            int t_freeze_clear_nr_requests__arraylength;
                            t_freeze_clear_nr_requests__arraylength = 0;
                            freeze_clear_nr_requests__elem_ = nullptr;
                            int t_freeze_clear_nr_requests__elem__it;
                            t_freeze_clear_nr_requests__elem__it = 0;
                            int t_freeze_clear_nr_requests__size;
                            freeze_clear_nr_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_freeze_clear_nr_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_freeze_clear_nr_requests__elem__it) {
                                // Check &until(freeze_clear_nr_requests__elem__dataptr >= end_of_data)
                                if ( t_freeze_clear_nr_requests__elem__dataptr >= t_end_of_data ) {
                                    freeze_clear_nr_requests__elem_ = nullptr;
                                    goto end_of_freeze_clear_nr_requests;
                                }
                                freeze_clear_nr_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_freeze_clear_nr_requests__elem__size;
                                t_freeze_clear_nr_requests__elem__size = freeze_clear_nr_requests__elem_->Parse(t_freeze_clear_nr_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                freeze_clear_nr_requests_->push_back(freeze_clear_nr_requests__elem_);
                                t_freeze_clear_nr_requests__elem__dataptr += t_freeze_clear_nr_requests__elem__size;
                                BINPAC_ASSERT(t_freeze_clear_nr_requests__elem__dataptr <= t_end_of_data);
                                freeze_clear_nr_requests__elem_ = nullptr;
                            }
                        end_of_freeze_clear_nr_requests: ;
                            t_freeze_clear_nr_requests__size = t_freeze_clear_nr_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_freeze_clear_nr_requests__size;
                        }
                        break;
                    case ((uint8)11):
                        // Parse "freeze_time_requests"
                        {
                            int t_freeze_time_requests__arraylength;
                            t_freeze_time_requests__arraylength = 0;
                            freeze_time_requests__elem_ = nullptr;
                            int t_freeze_time_requests__elem__it;
                            t_freeze_time_requests__elem__it = 0;
                            int t_freeze_time_requests__size;
                            freeze_time_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_freeze_time_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_freeze_time_requests__elem__it) {
                                // Check &until(freeze_time_requests__elem__dataptr >= end_of_data)
                                if ( t_freeze_time_requests__elem__dataptr >= t_end_of_data ) {
                                    freeze_time_requests__elem_ = nullptr;
                                    goto end_of_freeze_time_requests;
                                }
                                freeze_time_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_freeze_time_requests__elem__size;
                                t_freeze_time_requests__elem__size = freeze_time_requests__elem_->Parse(t_freeze_time_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                freeze_time_requests_->push_back(freeze_time_requests__elem_);
                                t_freeze_time_requests__elem__dataptr += t_freeze_time_requests__elem__size;
                                BINPAC_ASSERT(t_freeze_time_requests__elem__dataptr <= t_end_of_data);
                                freeze_time_requests__elem_ = nullptr;
                            }
                        end_of_freeze_time_requests: ;
                            t_freeze_time_requests__size = t_freeze_time_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_freeze_time_requests__size;
                        }
                        break;
                    case ((uint8)12):
                        // Parse "freeze_time_nr_requests"
                        {
                            int t_freeze_time_nr_requests__arraylength;
                            t_freeze_time_nr_requests__arraylength = 0;
                            freeze_time_nr_requests__elem_ = nullptr;
                            int t_freeze_time_nr_requests__elem__it;
                            t_freeze_time_nr_requests__elem__it = 0;
                            int t_freeze_time_nr_requests__size;
                            freeze_time_nr_requests_ = new vector<Request_Objects*>;
                            const_byteptr t_freeze_time_nr_requests__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_freeze_time_nr_requests__elem__it) {
                                // Check &until(freeze_time_nr_requests__elem__dataptr >= end_of_data)
                                if ( t_freeze_time_nr_requests__elem__dataptr >= t_end_of_data ) {
                                    freeze_time_nr_requests__elem_ = nullptr;
                                    goto end_of_freeze_time_nr_requests;
                                }
                                freeze_time_nr_requests__elem_ = new Request_Objects(app_header()->function_code());
                                int t_freeze_time_nr_requests__elem__size;
                                t_freeze_time_nr_requests__elem__size = freeze_time_nr_requests__elem_->Parse(t_freeze_time_nr_requests__elem__dataptr, t_end_of_data, t_context, byteorder());
                                freeze_time_nr_requests_->push_back(freeze_time_nr_requests__elem_);
                                t_freeze_time_nr_requests__elem__dataptr += t_freeze_time_nr_requests__elem__size;
                                BINPAC_ASSERT(t_freeze_time_nr_requests__elem__dataptr <= t_end_of_data);
                                freeze_time_nr_requests__elem_ = nullptr;
                            }
                        end_of_freeze_time_nr_requests: ;
                            t_freeze_time_nr_requests__size = t_freeze_time_nr_requests__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_freeze_time_nr_requests__size;
                        }
                        break;
                    case ((uint8)13):
                        // Parse "cold_restart"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)14):
                        // Parse "warm_restart"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)15):
                        // Parse "initialize_data"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)16):
                        // Parse "initialize_appl"
                        {
                            int t_initialize_appl__arraylength;
                            t_initialize_appl__arraylength = 0;
                            initialize_appl__elem_ = nullptr;
                            int t_initialize_appl__elem__it;
                            t_initialize_appl__elem__it = 0;
                            int t_initialize_appl__size;
                            initialize_appl_ = new vector<Request_Objects*>;
                            const_byteptr t_initialize_appl__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_initialize_appl__elem__it) {
                                // Check &until(initialize_appl__elem__dataptr >= end_of_data)
                                if ( t_initialize_appl__elem__dataptr >= t_end_of_data ) {
                                    initialize_appl__elem_ = nullptr;
                                    goto end_of_initialize_appl;
                                }
                                initialize_appl__elem_ = new Request_Objects(app_header()->function_code());
                                int t_initialize_appl__elem__size;
                                t_initialize_appl__elem__size = initialize_appl__elem_->Parse(t_initialize_appl__elem__dataptr, t_end_of_data, t_context, byteorder());
                                initialize_appl_->push_back(initialize_appl__elem_);
                                t_initialize_appl__elem__dataptr += t_initialize_appl__elem__size;
                                BINPAC_ASSERT(t_initialize_appl__elem__dataptr <= t_end_of_data);
                                initialize_appl__elem_ = nullptr;
                            }
                        end_of_initialize_appl: ;
                            t_initialize_appl__size = t_initialize_appl__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_initialize_appl__size;
                        }
                        break;
                    case ((uint8)17):
                        // Parse "start_appl"
                        {
                            int t_start_appl__arraylength;
                            t_start_appl__arraylength = 0;
                            start_appl__elem_ = nullptr;
                            int t_start_appl__elem__it;
                            t_start_appl__elem__it = 0;
                            int t_start_appl__size;
                            start_appl_ = new vector<Request_Objects*>;
                            const_byteptr t_start_appl__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_start_appl__elem__it) {
                                // Check &until(start_appl__elem__dataptr >= end_of_data)
                                if ( t_start_appl__elem__dataptr >= t_end_of_data ) {
                                    start_appl__elem_ = nullptr;
                                    goto end_of_start_appl;
                                }
                                start_appl__elem_ = new Request_Objects(app_header()->function_code());
                                int t_start_appl__elem__size;
                                t_start_appl__elem__size = start_appl__elem_->Parse(t_start_appl__elem__dataptr, t_end_of_data, t_context, byteorder());
                                start_appl_->push_back(start_appl__elem_);
                                t_start_appl__elem__dataptr += t_start_appl__elem__size;
                                BINPAC_ASSERT(t_start_appl__elem__dataptr <= t_end_of_data);
                                start_appl__elem_ = nullptr;
                            }
                        end_of_start_appl: ;
                            t_start_appl__size = t_start_appl__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_start_appl__size;
                        }
                        break;
                    case ((uint8)18):
                        // Parse "stop_appl"
                        {
                            int t_stop_appl__arraylength;
                            t_stop_appl__arraylength = 0;
                            stop_appl__elem_ = nullptr;
                            int t_stop_appl__elem__it;
                            t_stop_appl__elem__it = 0;
                            int t_stop_appl__size;
                            stop_appl_ = new vector<Request_Objects*>;
                            const_byteptr t_stop_appl__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_stop_appl__elem__it) {
                                // Check &until(stop_appl__elem__dataptr >= end_of_data)
                                if ( t_stop_appl__elem__dataptr >= t_end_of_data ) {
                                    stop_appl__elem_ = nullptr;
                                    goto end_of_stop_appl;
                                }
                                stop_appl__elem_ = new Request_Objects(app_header()->function_code());
                                int t_stop_appl__elem__size;
                                t_stop_appl__elem__size = stop_appl__elem_->Parse(t_stop_appl__elem__dataptr, t_end_of_data, t_context, byteorder());
                                stop_appl_->push_back(stop_appl__elem_);
                                t_stop_appl__elem__dataptr += t_stop_appl__elem__size;
                                BINPAC_ASSERT(t_stop_appl__elem__dataptr <= t_end_of_data);
                                stop_appl__elem_ = nullptr;
                            }
                        end_of_stop_appl: ;
                            t_stop_appl__size = t_stop_appl__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_stop_appl__size;
                        }
                        break;
                    case ((uint8)19):
                        // Parse "save_config"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)20):
                        // Parse "enable_unsolicited"
                        {
                            int t_enable_unsolicited__arraylength;
                            t_enable_unsolicited__arraylength = 0;
                            enable_unsolicited__elem_ = nullptr;
                            int t_enable_unsolicited__elem__it;
                            t_enable_unsolicited__elem__it = 0;
                            int t_enable_unsolicited__size;
                            enable_unsolicited_ = new vector<Request_Objects*>;
                            const_byteptr t_enable_unsolicited__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_enable_unsolicited__elem__it) {
                                // Check &until(enable_unsolicited__elem__dataptr >= end_of_data)
                                if ( t_enable_unsolicited__elem__dataptr >= t_end_of_data ) {
                                    enable_unsolicited__elem_ = nullptr;
                                    goto end_of_enable_unsolicited;
                                }
                                enable_unsolicited__elem_ = new Request_Objects(app_header()->function_code());
                                int t_enable_unsolicited__elem__size;
                                t_enable_unsolicited__elem__size = enable_unsolicited__elem_->Parse(t_enable_unsolicited__elem__dataptr, t_end_of_data, t_context, byteorder());
                                enable_unsolicited_->push_back(enable_unsolicited__elem_);
                                t_enable_unsolicited__elem__dataptr += t_enable_unsolicited__elem__size;
                                BINPAC_ASSERT(t_enable_unsolicited__elem__dataptr <= t_end_of_data);
                                enable_unsolicited__elem_ = nullptr;
                            }
                        end_of_enable_unsolicited: ;
                            t_enable_unsolicited__size = t_enable_unsolicited__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_enable_unsolicited__size;
                        }
                        break;
                    case ((uint8)21):
                        // Parse "disable_unsolicited"
                        {
                            int t_disable_unsolicited__arraylength;
                            t_disable_unsolicited__arraylength = 0;
                            disable_unsolicited__elem_ = nullptr;
                            int t_disable_unsolicited__elem__it;
                            t_disable_unsolicited__elem__it = 0;
                            int t_disable_unsolicited__size;
                            disable_unsolicited_ = new vector<Request_Objects*>;
                            const_byteptr t_disable_unsolicited__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_disable_unsolicited__elem__it) {
                                // Check &until(disable_unsolicited__elem__dataptr >= end_of_data)
                                if ( t_disable_unsolicited__elem__dataptr >= t_end_of_data ) {
                                    disable_unsolicited__elem_ = nullptr;
                                    goto end_of_disable_unsolicited;
                                }
                                disable_unsolicited__elem_ = new Request_Objects(app_header()->function_code());
                                int t_disable_unsolicited__elem__size;
                                t_disable_unsolicited__elem__size = disable_unsolicited__elem_->Parse(t_disable_unsolicited__elem__dataptr, t_end_of_data, t_context, byteorder());
                                disable_unsolicited_->push_back(disable_unsolicited__elem_);
                                t_disable_unsolicited__elem__dataptr += t_disable_unsolicited__elem__size;
                                BINPAC_ASSERT(t_disable_unsolicited__elem__dataptr <= t_end_of_data);
                                disable_unsolicited__elem_ = nullptr;
                            }
                        end_of_disable_unsolicited: ;
                            t_disable_unsolicited__size = t_disable_unsolicited__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_disable_unsolicited__size;
                        }
                        break;
                    case ((uint8)22):
                        // Parse "assign_class"
                        {
                            int t_assign_class__arraylength;
                            t_assign_class__arraylength = 0;
                            assign_class__elem_ = nullptr;
                            int t_assign_class__elem__it;
                            t_assign_class__elem__it = 0;
                            int t_assign_class__size;
                            assign_class_ = new vector<Request_Objects*>;
                            const_byteptr t_assign_class__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_assign_class__elem__it) {
                                // Check &until(assign_class__elem__dataptr >= end_of_data)
                                if ( t_assign_class__elem__dataptr >= t_end_of_data ) {
                                    assign_class__elem_ = nullptr;
                                    goto end_of_assign_class;
                                }
                                assign_class__elem_ = new Request_Objects(app_header()->function_code());
                                int t_assign_class__elem__size;
                                t_assign_class__elem__size = assign_class__elem_->Parse(t_assign_class__elem__dataptr, t_end_of_data, t_context, byteorder());
                                assign_class_->push_back(assign_class__elem_);
                                t_assign_class__elem__dataptr += t_assign_class__elem__size;
                                BINPAC_ASSERT(t_assign_class__elem__dataptr <= t_end_of_data);
                                assign_class__elem_ = nullptr;
                            }
                        end_of_assign_class: ;
                            t_assign_class__size = t_assign_class__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_assign_class__size;
                        }
                        break;
                    case ((uint8)23):
                        // Parse "delay_measure"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)24):
                        // Parse "record_cur_time"
                        {
                            t_data__size = 0;
                        }
                        break;
                    case ((uint8)25):
                        // Parse "open_file"
                        {
                            int t_open_file__arraylength;
                            t_open_file__arraylength = 0;
                            open_file__elem_ = nullptr;
                            int t_open_file__elem__it;
                            t_open_file__elem__it = 0;
                            int t_open_file__size;
                            open_file_ = new vector<Request_Objects*>;
                            const_byteptr t_open_file__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_open_file__elem__it) {
                                // Check &until(open_file__elem__dataptr >= end_of_data)
                                if ( t_open_file__elem__dataptr >= t_end_of_data ) {
                                    open_file__elem_ = nullptr;
                                    goto end_of_open_file;
                                }
                                open_file__elem_ = new Request_Objects(app_header()->function_code());
                                int t_open_file__elem__size;
                                t_open_file__elem__size = open_file__elem_->Parse(t_open_file__elem__dataptr, t_end_of_data, t_context, byteorder());
                                open_file_->push_back(open_file__elem_);
                                t_open_file__elem__dataptr += t_open_file__elem__size;
                                BINPAC_ASSERT(t_open_file__elem__dataptr <= t_end_of_data);
                                open_file__elem_ = nullptr;
                            }
                        end_of_open_file: ;
                            t_open_file__size = t_open_file__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_open_file__size;
                        }
                        break;
                    case ((uint8)26):
                        // Parse "close_file"
                        {
                            int t_close_file__arraylength;
                            t_close_file__arraylength = 0;
                            close_file__elem_ = nullptr;
                            int t_close_file__elem__it;
                            t_close_file__elem__it = 0;
                            int t_close_file__size;
                            close_file_ = new vector<Request_Objects*>;
                            const_byteptr t_close_file__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_close_file__elem__it) {
                                // Check &until(close_file__elem__dataptr >= end_of_data)
                                if ( t_close_file__elem__dataptr >= t_end_of_data ) {
                                    close_file__elem_ = nullptr;
                                    goto end_of_close_file;
                                }
                                close_file__elem_ = new Request_Objects(app_header()->function_code());
                                int t_close_file__elem__size;
                                t_close_file__elem__size = close_file__elem_->Parse(t_close_file__elem__dataptr, t_end_of_data, t_context, byteorder());
                                close_file_->push_back(close_file__elem_);
                                t_close_file__elem__dataptr += t_close_file__elem__size;
                                BINPAC_ASSERT(t_close_file__elem__dataptr <= t_end_of_data);
                                close_file__elem_ = nullptr;
                            }
                        end_of_close_file: ;
                            t_close_file__size = t_close_file__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_close_file__size;
                        }
                        break;
                    case ((uint8)27):
                        // Parse "delete_file"
                        {
                            int t_delete_file__arraylength;
                            t_delete_file__arraylength = 0;
                            delete_file__elem_ = nullptr;
                            int t_delete_file__elem__it;
                            t_delete_file__elem__it = 0;
                            int t_delete_file__size;
                            delete_file_ = new vector<Request_Objects*>;
                            const_byteptr t_delete_file__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_delete_file__elem__it) {
                                // Check &until(delete_file__elem__dataptr >= end_of_data)
                                if ( t_delete_file__elem__dataptr >= t_end_of_data ) {
                                    delete_file__elem_ = nullptr;
                                    goto end_of_delete_file;
                                }
                                delete_file__elem_ = new Request_Objects(app_header()->function_code());
                                int t_delete_file__elem__size;
                                t_delete_file__elem__size = delete_file__elem_->Parse(t_delete_file__elem__dataptr, t_end_of_data, t_context, byteorder());
                                delete_file_->push_back(delete_file__elem_);
                                t_delete_file__elem__dataptr += t_delete_file__elem__size;
                                BINPAC_ASSERT(t_delete_file__elem__dataptr <= t_end_of_data);
                                delete_file__elem_ = nullptr;
                            }
                        end_of_delete_file: ;
                            t_delete_file__size = t_delete_file__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_delete_file__size;
                        }
                        break;
                    case ((uint8)30):
                        // Parse "abort_file"
                        {
                            int t_abort_file__arraylength;
                            t_abort_file__arraylength = 0;
                            abort_file__elem_ = nullptr;
                            int t_abort_file__elem__it;
                            t_abort_file__elem__it = 0;
                            int t_abort_file__size;
                            abort_file_ = new vector<Request_Objects*>;
                            const_byteptr t_abort_file__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_abort_file__elem__it) {
                                // Check &until(abort_file__elem__dataptr >= end_of_data)
                                if ( t_abort_file__elem__dataptr >= t_end_of_data ) {
                                    abort_file__elem_ = nullptr;
                                    goto end_of_abort_file;
                                }
                                abort_file__elem_ = new Request_Objects(app_header()->function_code());
                                int t_abort_file__elem__size;
                                t_abort_file__elem__size = abort_file__elem_->Parse(t_abort_file__elem__dataptr, t_end_of_data, t_context, byteorder());
                                abort_file_->push_back(abort_file__elem_);
                                t_abort_file__elem__dataptr += t_abort_file__elem__size;
                                BINPAC_ASSERT(t_abort_file__elem__dataptr <= t_end_of_data);
                                abort_file__elem_ = nullptr;
                            }
                        end_of_abort_file: ;
                            t_abort_file__size = t_abort_file__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_abort_file__size;
                        }
                        break;
                    case ((uint8)28):
                        // Parse "get_file_info"
                        {
                            int t_get_file_info__arraylength;
                            t_get_file_info__arraylength = 0;
                            get_file_info__elem_ = nullptr;
                            int t_get_file_info__elem__it;
                            t_get_file_info__elem__it = 0;
                            int t_get_file_info__size;
                            get_file_info_ = new vector<Request_Objects*>;
                            const_byteptr t_get_file_info__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_get_file_info__elem__it) {
                                // Check &until(get_file_info__elem__dataptr >= end_of_data)
                                if ( t_get_file_info__elem__dataptr >= t_end_of_data ) {
                                    get_file_info__elem_ = nullptr;
                                    goto end_of_get_file_info;
                                }
                                get_file_info__elem_ = new Request_Objects(app_header()->function_code());
                                int t_get_file_info__elem__size;
                                t_get_file_info__elem__size = get_file_info__elem_->Parse(t_get_file_info__elem__dataptr, t_end_of_data, t_context, byteorder());
                                get_file_info_->push_back(get_file_info__elem_);
                                t_get_file_info__elem__dataptr += t_get_file_info__elem__size;
                                BINPAC_ASSERT(t_get_file_info__elem__dataptr <= t_end_of_data);
                                get_file_info__elem_ = nullptr;
                            }
                        end_of_get_file_info: ;
                            t_get_file_info__size = t_get_file_info__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_get_file_info__size;
                        }
                        break;
                    case ((uint8)29):
                        // Parse "auth_file"
                        {
                            int t_auth_file__arraylength;
                            t_auth_file__arraylength = 0;
                            auth_file__elem_ = nullptr;
                            int t_auth_file__elem__it;
                            t_auth_file__elem__it = 0;
                            int t_auth_file__size;
                            auth_file_ = new vector<Request_Objects*>;
                            const_byteptr t_auth_file__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_auth_file__elem__it) {
                                // Check &until(auth_file__elem__dataptr >= end_of_data)
                                if ( t_auth_file__elem__dataptr >= t_end_of_data ) {
                                    auth_file__elem_ = nullptr;
                                    goto end_of_auth_file;
                                }
                                auth_file__elem_ = new Request_Objects(app_header()->function_code());
                                int t_auth_file__elem__size;
                                t_auth_file__elem__size = auth_file__elem_->Parse(t_auth_file__elem__dataptr, t_end_of_data, t_context, byteorder());
                                auth_file_->push_back(auth_file__elem_);
                                t_auth_file__elem__dataptr += t_auth_file__elem__size;
                                BINPAC_ASSERT(t_auth_file__elem__dataptr <= t_end_of_data);
                                auth_file__elem_ = nullptr;
                            }
                        end_of_auth_file: ;
                            t_auth_file__size = t_auth_file__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_auth_file__size;
                        }
                        break;
                    case ((uint8)31):
                        // Parse "active_config"
                        {
                            int t_active_config__arraylength;
                            t_active_config__arraylength = 0;
                            active_config__elem_ = nullptr;
                            int t_active_config__elem__it;
                            t_active_config__elem__it = 0;
                            int t_active_config__size;
                            active_config_ = new vector<Request_Objects*>;
                            const_byteptr t_active_config__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_active_config__elem__it) {
                                // Check &until(active_config__elem__dataptr >= end_of_data)
                                if ( t_active_config__elem__dataptr >= t_end_of_data ) {
                                    active_config__elem_ = nullptr;
                                    goto end_of_active_config;
                                }
                                active_config__elem_ = new Request_Objects(app_header()->function_code());
                                int t_active_config__elem__size;
                                t_active_config__elem__size = active_config__elem_->Parse(t_active_config__elem__dataptr, t_end_of_data, t_context, byteorder());
                                active_config_->push_back(active_config__elem_);
                                t_active_config__elem__dataptr += t_active_config__elem__size;
                                BINPAC_ASSERT(t_active_config__elem__dataptr <= t_end_of_data);
                                active_config__elem_ = nullptr;
                            }
                        end_of_active_config: ;
                            t_active_config__size = t_active_config__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_active_config__size;
                        }
                        break;
                    case ((uint8)32):
                        // Parse "auth_req"
                        {
                            int t_auth_req__arraylength;
                            t_auth_req__arraylength = 0;
                            auth_req__elem_ = nullptr;
                            int t_auth_req__elem__it;
                            t_auth_req__elem__it = 0;
                            int t_auth_req__size;
                            auth_req_ = new vector<Request_Objects*>;
                            const_byteptr t_auth_req__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_auth_req__elem__it) {
                                // Check &until(auth_req__elem__dataptr >= end_of_data)
                                if ( t_auth_req__elem__dataptr >= t_end_of_data ) {
                                    auth_req__elem_ = nullptr;
                                    goto end_of_auth_req;
                                }
                                auth_req__elem_ = new Request_Objects(app_header()->function_code());
                                int t_auth_req__elem__size;
                                t_auth_req__elem__size = auth_req__elem_->Parse(t_auth_req__elem__dataptr, t_end_of_data, t_context, byteorder());
                                auth_req_->push_back(auth_req__elem_);
                                t_auth_req__elem__dataptr += t_auth_req__elem__size;
                                BINPAC_ASSERT(t_auth_req__elem__dataptr <= t_end_of_data);
                                auth_req__elem_ = nullptr;
                            }
                        end_of_auth_req: ;
                            t_auth_req__size = t_auth_req__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_auth_req__size;
                        }
                        break;
                    case ((uint8)33):
                        // Parse "auth_err"
                        {
                            int t_auth_err__arraylength;
                            t_auth_err__arraylength = 0;
                            auth_err__elem_ = nullptr;
                            int t_auth_err__elem__it;
                            t_auth_err__elem__it = 0;
                            int t_auth_err__size;
                            auth_err_ = new vector<Request_Objects*>;
                            const_byteptr t_auth_err__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_auth_err__elem__it) {
                                // Check &until(auth_err__elem__dataptr >= end_of_data)
                                if ( t_auth_err__elem__dataptr >= t_end_of_data ) {
                                    auth_err__elem_ = nullptr;
                                    goto end_of_auth_err;
                                }
                                auth_err__elem_ = new Request_Objects(app_header()->function_code());
                                int t_auth_err__elem__size;
                                t_auth_err__elem__size = auth_err__elem_->Parse(t_auth_err__elem__dataptr, t_end_of_data, t_context, byteorder());
                                auth_err_->push_back(auth_err__elem_);
                                t_auth_err__elem__dataptr += t_auth_err__elem__size;
                                BINPAC_ASSERT(t_auth_err__elem__dataptr <= t_end_of_data);
                                auth_err__elem_ = nullptr;
                            }
                        end_of_auth_err: ;
                            t_auth_err__size = t_auth_err__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_auth_err__size;
                        }
                        break;
                    default:
                        // Parse "unknown"
                        {
                            int t_unknown_string_length;
                            t_unknown_string_length = (t_end_of_data) - (t_dataptr_after_app_header);
                            int t_unknown__size;
                            t_unknown__size = t_unknown_string_length;
                            // check for negative sizes
                            if ( t_unknown_string_length < 0 )
                            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-protocol.pac:57", t_unknown_string_length);
                            unknown_.init(t_dataptr_after_app_header, t_unknown_string_length);
                            t_data__size = t_unknown__size;
                        }
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Debug_Byte::Debug_Byte() {
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Debug_Byte::~Debug_Byte() {
    debug_.free();
}

int Debug_Byte::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Parse "debug"
    int t_debug_string_length;
    t_debug_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_debug__size;
    t_debug__size = t_debug_string_length;
    // check for negative sizes
    if ( t_debug_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-protocol.pac:63", t_debug_string_length);
    debug_.init(t_begin_of_data, t_debug_string_length);

    int t_Debug_Byte__size;
    const_byteptr const t_dataptr_after_debug = t_begin_of_data + (t_debug__size);
    BINPAC_ASSERT(t_dataptr_after_debug <= t_end_of_data);
    t_Debug_Byte__size = t_dataptr_after_debug - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_debug_byte(debug());
    BINPAC_ASSERT(t_begin_of_data + (t_Debug_Byte__size) <= t_end_of_data);
    return t_Debug_Byte__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Response::DNP3_Response() {
    addin_header_ = nullptr;
    app_header_ = nullptr;
    data_case_index_ = -1;
    response_objects_ = nullptr;
    response_objects__elem_ = nullptr;
    unsolicited_response_objects_ = nullptr;
    unsolicited_response_objects__elem_ = nullptr;
    auth_response_ = nullptr;
    auth_response__elem_ = nullptr;
    unknown_ = nullptr;
    byteorder_ = bigendian;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Response::~DNP3_Response() {
    delete addin_header_;
    addin_header_ = nullptr;
    delete app_header_;
    app_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)129):
            // Clean up "response_objects"
            {
                delete response_objects__elem_;
                response_objects__elem_ = nullptr;
                if ( response_objects() ) {
                    for ( auto* response_objects__elem_ : *response_objects() ) {
                        delete response_objects__elem_;
                        response_objects__elem_ = nullptr;
                    }
                }
                delete response_objects_;
            }
            break;
        case ((uint8)130):
            // Clean up "unsolicited_response_objects"
            {
                delete unsolicited_response_objects__elem_;
                unsolicited_response_objects__elem_ = nullptr;
                if ( unsolicited_response_objects() ) {
                    for ( auto* unsolicited_response_objects__elem_ : *unsolicited_response_objects() ) {
                        delete unsolicited_response_objects__elem_;
                        unsolicited_response_objects__elem_ = nullptr;
                    }
                }
                delete unsolicited_response_objects_;
            }
            break;
        case ((uint8)131):
            // Clean up "auth_response"
            {
                delete auth_response__elem_;
                auth_response__elem_ = nullptr;
                if ( auth_response() ) {
                    for ( auto* auth_response__elem_ : *auth_response() ) {
                        delete auth_response__elem_;
                        auth_response__elem_ = nullptr;
                    }
                }
                delete auth_response_;
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool DNP3_Response::ParseBuffer(flow_buffer_t t_flow_buffer, ContextDNP3* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(8, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "addin_header"
            addin_header_ = new Header_Block();
            addin_header_->Parse(t_begin_of_data, t_end_of_data, t_context);
            t_flow_buffer->GrowFrame(9 + addin_header()->len() - 5 - 1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "app_header"
                app_header_ = new DNP3_Application_Response_Header();
                int t_app_header__size;
                t_app_header__size = app_header_->Parse((t_begin_of_data + 8), t_end_of_data, t_context, byteorder());

                const_byteptr const t_dataptr_after_app_header = (t_begin_of_data + 8) + (t_app_header__size);
                BINPAC_ASSERT(t_dataptr_after_app_header <= t_end_of_data);
                // Parse "data"
                int t_data__size;
                data_case_index_ =  ( app_header()->function_code() ) ;
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( data_case_index() ) {
                    case ((uint8)129):
                        // Parse "response_objects"
                        {
                            int t_response_objects__arraylength;
                            t_response_objects__arraylength = 0;
                            response_objects__elem_ = nullptr;
                            int t_response_objects__elem__it;
                            t_response_objects__elem__it = 0;
                            int t_response_objects__size;
                            response_objects_ = new vector<Response_Objects*>;
                            const_byteptr t_response_objects__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_response_objects__elem__it) {
                                // Check &until(response_objects__elem__dataptr >= end_of_data)
                                if ( t_response_objects__elem__dataptr >= t_end_of_data ) {
                                    response_objects__elem_ = nullptr;
                                    goto end_of_response_objects;
                                }
                                response_objects__elem_ = new Response_Objects(app_header()->function_code());
                                int t_response_objects__elem__size;
                                t_response_objects__elem__size = response_objects__elem_->Parse(t_response_objects__elem__dataptr, t_end_of_data, t_context, byteorder());
                                response_objects_->push_back(response_objects__elem_);
                                t_response_objects__elem__dataptr += t_response_objects__elem__size;
                                BINPAC_ASSERT(t_response_objects__elem__dataptr <= t_end_of_data);
                                response_objects__elem_ = nullptr;
                            }
                        end_of_response_objects: ;
                            t_response_objects__size = t_response_objects__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_response_objects__size;
                        }
                        break;
                    case ((uint8)130):
                        // Parse "unsolicited_response_objects"
                        {
                            int t_unsolicited_response_objects__arraylength;
                            t_unsolicited_response_objects__arraylength = 0;
                            unsolicited_response_objects__elem_ = nullptr;
                            int t_unsolicited_response_objects__elem__it;
                            t_unsolicited_response_objects__elem__it = 0;
                            int t_unsolicited_response_objects__size;
                            unsolicited_response_objects_ = new vector<Response_Objects*>;
                            const_byteptr t_unsolicited_response_objects__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_unsolicited_response_objects__elem__it) {
                                // Check &until(unsolicited_response_objects__elem__dataptr >= end_of_data)
                                if ( t_unsolicited_response_objects__elem__dataptr >= t_end_of_data ) {
                                    unsolicited_response_objects__elem_ = nullptr;
                                    goto end_of_unsolicited_response_objects;
                                }
                                unsolicited_response_objects__elem_ = new Response_Objects(app_header()->function_code());
                                int t_unsolicited_response_objects__elem__size;
                                t_unsolicited_response_objects__elem__size = unsolicited_response_objects__elem_->Parse(t_unsolicited_response_objects__elem__dataptr, t_end_of_data, t_context, byteorder());
                                unsolicited_response_objects_->push_back(unsolicited_response_objects__elem_);
                                t_unsolicited_response_objects__elem__dataptr += t_unsolicited_response_objects__elem__size;
                                BINPAC_ASSERT(t_unsolicited_response_objects__elem__dataptr <= t_end_of_data);
                                unsolicited_response_objects__elem_ = nullptr;
                            }
                        end_of_unsolicited_response_objects: ;
                            t_unsolicited_response_objects__size = t_unsolicited_response_objects__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_unsolicited_response_objects__size;
                        }
                        break;
                    case ((uint8)131):
                        // Parse "auth_response"
                        {
                            int t_auth_response__arraylength;
                            t_auth_response__arraylength = 0;
                            auth_response__elem_ = nullptr;
                            int t_auth_response__elem__it;
                            t_auth_response__elem__it = 0;
                            int t_auth_response__size;
                            auth_response_ = new vector<Response_Objects*>;
                            const_byteptr t_auth_response__elem__dataptr = t_dataptr_after_app_header;
                            for (; /* forever */; ++t_auth_response__elem__it) {
                                // Check &until(auth_response__elem__dataptr >= end_of_data)
                                if ( t_auth_response__elem__dataptr >= t_end_of_data ) {
                                    auth_response__elem_ = nullptr;
                                    goto end_of_auth_response;
                                }
                                auth_response__elem_ = new Response_Objects(app_header()->function_code());
                                int t_auth_response__elem__size;
                                t_auth_response__elem__size = auth_response__elem_->Parse(t_auth_response__elem__dataptr, t_end_of_data, t_context, byteorder());
                                auth_response_->push_back(auth_response__elem_);
                                t_auth_response__elem__dataptr += t_auth_response__elem__size;
                                BINPAC_ASSERT(t_auth_response__elem__dataptr <= t_end_of_data);
                                auth_response__elem_ = nullptr;
                            }
                        end_of_auth_response: ;
                            t_auth_response__size = t_auth_response__elem__dataptr - (t_dataptr_after_app_header);
                            // Evaluate 'let' and 'withinput' fields
                            t_data__size = t_auth_response__size;
                        }
                        break;
                    default:
                        // Parse "unknown"
                        {
                            unknown_ = new Debug_Byte();
                            int t_unknown__size;
                            t_unknown__size = unknown_->Parse(t_dataptr_after_app_header, t_end_of_data, t_context);
                            t_data__size = t_unknown__size;
                        }
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Application_Request_Header::DNP3_Application_Request_Header() {
    application_control_ = 0;
    function_code_ = 0;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Application_Request_Header::~DNP3_Application_Request_Header() {
    empty_.free();
}

int DNP3_Application_Request_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "DNP3_Application_Request_Header"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DNP3_Application_Request_Header",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 2;
        // Parse "empty"
        // Checking out-of-bound for "DNP3_Application_Request_Header:empty"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("DNP3_Application_Request_Header:empty",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + 0;
            int t_empty_string_length;
            t_empty_string_length = 0;
            int t_empty__size;
            t_empty__size = t_empty_string_length;
            empty_.init(t_begin_of_data, t_empty_string_length);
        }

        const_byteptr const t_dataptr_after_empty = t_begin_of_data + (0);
        BINPAC_ASSERT(t_dataptr_after_empty <= t_end_of_data);
        // Checking out-of-bound for "DNP3_Application_Request_Header:function_code"
        if ( (t_dataptr_after_empty + 1) + (1) > t_end_of_data || (t_dataptr_after_empty + 1) + (1) < (t_dataptr_after_empty + 1) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("DNP3_Application_Request_Header:function_code",
            	(((t_dataptr_after_empty + 1) - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "application_control"
        application_control_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_empty));

        // Parse "function_code"
        function_code_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_empty + 1)));

        int t_DNP3_Application_Request_Header__size;
        t_DNP3_Application_Request_Header__size = (t_dataptr_after_empty + 2) - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
        process_request_ = t_context->flow()->get_dnp3_application_request_header(application_control(), function_code());
    }
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Application_Response_Header::DNP3_Application_Response_Header() {
    application_control_ = 0;
    function_code_ = 0;
    internal_indications_ = 0;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Application_Response_Header::~DNP3_Application_Response_Header() {
    empty_.free();
}

int DNP3_Application_Response_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Checking out-of-bound for "DNP3_Application_Response_Header"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DNP3_Application_Response_Header",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 4;
        // Parse "empty"
        // Checking out-of-bound for "DNP3_Application_Response_Header:empty"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("DNP3_Application_Response_Header:empty",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + 0;
            int t_empty_string_length;
            t_empty_string_length = 0;
            int t_empty__size;
            t_empty__size = t_empty_string_length;
            empty_.init(t_begin_of_data, t_empty_string_length);
        }

        const_byteptr const t_dataptr_after_empty = t_begin_of_data + (0);
        BINPAC_ASSERT(t_dataptr_after_empty <= t_end_of_data);
        // Checking out-of-bound for "DNP3_Application_Response_Header:internal_indications"
        if ( (t_dataptr_after_empty + 2) + (2) > t_end_of_data || (t_dataptr_after_empty + 2) + (2) < (t_dataptr_after_empty + 2) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("DNP3_Application_Response_Header:internal_indications",
            	(((t_dataptr_after_empty + 2) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "application_control"
        application_control_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_empty));

        // Parse "function_code"
        function_code_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_empty + 1)));

        // Parse "internal_indications"
        internal_indications_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_empty + 2))));

        int t_DNP3_Application_Response_Header__size;
        t_DNP3_Application_Response_Header__size = (t_dataptr_after_empty + 4) - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
        process_request_ = t_context->flow()->get_dnp3_application_response_header(application_control(), function_code(), internal_indications());
    }
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Request_Objects::Request_Objects(uint8 function_code) {
    object_header_ = nullptr;
    data_case_index_ = -1;
    g12v1_objs_ = nullptr;
    g12v1_objs__elem_ = nullptr;
    g12v2_objs_ = nullptr;
    g12v2_objs__elem_ = nullptr;
    bocmd_PM_ = nullptr;
    bocmd_PM__elem_ = nullptr;
    g50v1_objs_ = nullptr;
    g50v1_objs__elem_ = nullptr;
    g50v2_objs_ = nullptr;
    g50v2_objs__elem_ = nullptr;
    g50v3_objs_ = nullptr;
    g50v3_objs__elem_ = nullptr;
    g51v1_objs_ = nullptr;
    g51v1_objs__elem_ = nullptr;
    g51v2_objs_ = nullptr;
    g51v2_objs__elem_ = nullptr;
    g52v1_objs_ = nullptr;
    g52v1_objs__elem_ = nullptr;
    g52v2_objs_ = nullptr;
    g52v2_objs__elem_ = nullptr;
    g70v1_objs_ = nullptr;
    g70v1_objs__elem_ = nullptr;
    g70v2_objs_ = nullptr;
    g70v2_objs__elem_ = nullptr;
    g70v3_objs_ = nullptr;
    g70v3_objs__elem_ = nullptr;
    g70v4_objs_ = nullptr;
    g70v4_objs__elem_ = nullptr;
    g70v5_objs_ = nullptr;
    g70v5_objs__elem_ = nullptr;
    g70v6_objs_ = nullptr;
    g70v6_objs__elem_ = nullptr;
    g70v7_objs_ = nullptr;
    g70v7_objs__elem_ = nullptr;
    g80v1_objs_ = nullptr;
    g80v1_objs__elem_ = nullptr;
    g120v1_objs_ = nullptr;
    g120v1_objs__elem_ = nullptr;
    g120v2_objs_ = nullptr;
    g120v2_objs__elem_ = nullptr;
    g120v3_objs_ = nullptr;
    g120v3_objs__elem_ = nullptr;
    g120v4_objs_ = nullptr;
    g120v4_objs__elem_ = nullptr;
    g120v5_objs_ = nullptr;
    g120v5_objs__elem_ = nullptr;
    g120v6_objs_ = nullptr;
    g120v6_objs__elem_ = nullptr;
    g120v7_objs_ = nullptr;
    g120v7_objs__elem_ = nullptr;
    g120v8_objs_ = nullptr;
    g120v8_objs__elem_ = nullptr;
    g120v9_objs_ = nullptr;
    g120v9_objs__elem_ = nullptr;
    g120v10_objs_ = nullptr;
    g120v10_objs__elem_ = nullptr;
    g120v11_objs_ = nullptr;
    g120v11_objs__elem_ = nullptr;
    g120v12_objs_ = nullptr;
    g120v12_objs__elem_ = nullptr;
    g120v13_objs_ = nullptr;
    g120v13_objs__elem_ = nullptr;
    g120v14_objs_ = nullptr;
    g120v14_objs__elem_ = nullptr;
    g120v15_objs_ = nullptr;
    g120v15_objs__elem_ = nullptr;
    dump_data_case_index_ = -1;
    function_code_ = function_code;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Request_Objects::~Request_Objects() {
    delete object_header_;
    object_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)3073):
            // Clean up "g12v1_objs"
            {
                delete g12v1_objs__elem_;
                g12v1_objs__elem_ = nullptr;
                if ( g12v1_objs() ) {
                    for ( auto* g12v1_objs__elem_ : *g12v1_objs() ) {
                        delete g12v1_objs__elem_;
                        g12v1_objs__elem_ = nullptr;
                    }
                }
                delete g12v1_objs_;
            }
            break;
        case ((uint16)3074):
            // Clean up "g12v2_objs"
            {
                delete g12v2_objs__elem_;
                g12v2_objs__elem_ = nullptr;
                if ( g12v2_objs() ) {
                    for ( auto* g12v2_objs__elem_ : *g12v2_objs() ) {
                        delete g12v2_objs__elem_;
                        g12v2_objs__elem_ = nullptr;
                    }
                }
                delete g12v2_objs_;
            }
            break;
        case ((uint16)3075):
            // Clean up "bocmd_PM"
            {
                delete bocmd_PM__elem_;
                bocmd_PM__elem_ = nullptr;
                if ( bocmd_PM() ) {
                    for ( auto* bocmd_PM__elem_ : *bocmd_PM() ) {
                        delete bocmd_PM__elem_;
                        bocmd_PM__elem_ = nullptr;
                    }
                }
                delete bocmd_PM_;
            }
            break;
        case ((uint16)12801):
            // Clean up "g50v1_objs"
            {
                delete g50v1_objs__elem_;
                g50v1_objs__elem_ = nullptr;
                if ( g50v1_objs() ) {
                    for ( auto* g50v1_objs__elem_ : *g50v1_objs() ) {
                        delete g50v1_objs__elem_;
                        g50v1_objs__elem_ = nullptr;
                    }
                }
                delete g50v1_objs_;
            }
            break;
        case ((uint16)12802):
            // Clean up "g50v2_objs"
            {
                delete g50v2_objs__elem_;
                g50v2_objs__elem_ = nullptr;
                if ( g50v2_objs() ) {
                    for ( auto* g50v2_objs__elem_ : *g50v2_objs() ) {
                        delete g50v2_objs__elem_;
                        g50v2_objs__elem_ = nullptr;
                    }
                }
                delete g50v2_objs_;
            }
            break;
        case ((uint16)12803):
            // Clean up "g50v3_objs"
            {
                delete g50v3_objs__elem_;
                g50v3_objs__elem_ = nullptr;
                if ( g50v3_objs() ) {
                    for ( auto* g50v3_objs__elem_ : *g50v3_objs() ) {
                        delete g50v3_objs__elem_;
                        g50v3_objs__elem_ = nullptr;
                    }
                }
                delete g50v3_objs_;
            }
            break;
        case ((uint16)13057):
            // Clean up "g51v1_objs"
            {
                delete g51v1_objs__elem_;
                g51v1_objs__elem_ = nullptr;
                if ( g51v1_objs() ) {
                    for ( auto* g51v1_objs__elem_ : *g51v1_objs() ) {
                        delete g51v1_objs__elem_;
                        g51v1_objs__elem_ = nullptr;
                    }
                }
                delete g51v1_objs_;
            }
            break;
        case ((uint16)13058):
            // Clean up "g51v2_objs"
            {
                delete g51v2_objs__elem_;
                g51v2_objs__elem_ = nullptr;
                if ( g51v2_objs() ) {
                    for ( auto* g51v2_objs__elem_ : *g51v2_objs() ) {
                        delete g51v2_objs__elem_;
                        g51v2_objs__elem_ = nullptr;
                    }
                }
                delete g51v2_objs_;
            }
            break;
        case ((uint16)13313):
            // Clean up "g52v1_objs"
            {
                delete g52v1_objs__elem_;
                g52v1_objs__elem_ = nullptr;
                if ( g52v1_objs() ) {
                    for ( auto* g52v1_objs__elem_ : *g52v1_objs() ) {
                        delete g52v1_objs__elem_;
                        g52v1_objs__elem_ = nullptr;
                    }
                }
                delete g52v1_objs_;
            }
            break;
        case ((uint16)13314):
            // Clean up "g52v2_objs"
            {
                delete g52v2_objs__elem_;
                g52v2_objs__elem_ = nullptr;
                if ( g52v2_objs() ) {
                    for ( auto* g52v2_objs__elem_ : *g52v2_objs() ) {
                        delete g52v2_objs__elem_;
                        g52v2_objs__elem_ = nullptr;
                    }
                }
                delete g52v2_objs_;
            }
            break;
        case ((uint16)17921):
            // Clean up "g70v1_objs"
            {
                delete g70v1_objs__elem_;
                g70v1_objs__elem_ = nullptr;
                if ( g70v1_objs() ) {
                    for ( auto* g70v1_objs__elem_ : *g70v1_objs() ) {
                        delete g70v1_objs__elem_;
                        g70v1_objs__elem_ = nullptr;
                    }
                }
                delete g70v1_objs_;
            }
            break;
        case ((uint16)17922):
            // Clean up "g70v2_objs"
            {
                delete g70v2_objs__elem_;
                g70v2_objs__elem_ = nullptr;
                if ( g70v2_objs() ) {
                    for ( auto* g70v2_objs__elem_ : *g70v2_objs() ) {
                        delete g70v2_objs__elem_;
                        g70v2_objs__elem_ = nullptr;
                    }
                }
                delete g70v2_objs_;
            }
            break;
        case ((uint16)17923):
            // Clean up "g70v3_objs"
            {
                delete g70v3_objs__elem_;
                g70v3_objs__elem_ = nullptr;
                if ( g70v3_objs() ) {
                    for ( auto* g70v3_objs__elem_ : *g70v3_objs() ) {
                        delete g70v3_objs__elem_;
                        g70v3_objs__elem_ = nullptr;
                    }
                }
                delete g70v3_objs_;
            }
            break;
        case ((uint16)17924):
            // Clean up "g70v4_objs"
            {
                delete g70v4_objs__elem_;
                g70v4_objs__elem_ = nullptr;
                if ( g70v4_objs() ) {
                    for ( auto* g70v4_objs__elem_ : *g70v4_objs() ) {
                        delete g70v4_objs__elem_;
                        g70v4_objs__elem_ = nullptr;
                    }
                }
                delete g70v4_objs_;
            }
            break;
        case ((uint16)17925):
            // Clean up "g70v5_objs"
            {
                delete g70v5_objs__elem_;
                g70v5_objs__elem_ = nullptr;
                if ( g70v5_objs() ) {
                    for ( auto* g70v5_objs__elem_ : *g70v5_objs() ) {
                        delete g70v5_objs__elem_;
                        g70v5_objs__elem_ = nullptr;
                    }
                }
                delete g70v5_objs_;
            }
            break;
        case ((uint16)17926):
            // Clean up "g70v6_objs"
            {
                delete g70v6_objs__elem_;
                g70v6_objs__elem_ = nullptr;
                if ( g70v6_objs() ) {
                    for ( auto* g70v6_objs__elem_ : *g70v6_objs() ) {
                        delete g70v6_objs__elem_;
                        g70v6_objs__elem_ = nullptr;
                    }
                }
                delete g70v6_objs_;
            }
            break;
        case ((uint16)17927):
            // Clean up "g70v7_objs"
            {
                delete g70v7_objs__elem_;
                g70v7_objs__elem_ = nullptr;
                if ( g70v7_objs() ) {
                    for ( auto* g70v7_objs__elem_ : *g70v7_objs() ) {
                        delete g70v7_objs__elem_;
                        g70v7_objs__elem_ = nullptr;
                    }
                }
                delete g70v7_objs_;
            }
            break;
        case ((uint16)20481):
            // Clean up "g80v1_objs"
            {
                delete g80v1_objs__elem_;
                g80v1_objs__elem_ = nullptr;
                if ( g80v1_objs() ) {
                    for ( auto* g80v1_objs__elem_ : *g80v1_objs() ) {
                        delete g80v1_objs__elem_;
                        g80v1_objs__elem_ = nullptr;
                    }
                }
                delete g80v1_objs_;
            }
            break;
        case ((uint16)30721):
            // Clean up "g120v1_objs"
            {
                delete g120v1_objs__elem_;
                g120v1_objs__elem_ = nullptr;
                if ( g120v1_objs() ) {
                    for ( auto* g120v1_objs__elem_ : *g120v1_objs() ) {
                        delete g120v1_objs__elem_;
                        g120v1_objs__elem_ = nullptr;
                    }
                }
                delete g120v1_objs_;
            }
            break;
        case ((uint16)30722):
            // Clean up "g120v2_objs"
            {
                delete g120v2_objs__elem_;
                g120v2_objs__elem_ = nullptr;
                if ( g120v2_objs() ) {
                    for ( auto* g120v2_objs__elem_ : *g120v2_objs() ) {
                        delete g120v2_objs__elem_;
                        g120v2_objs__elem_ = nullptr;
                    }
                }
                delete g120v2_objs_;
            }
            break;
        case ((uint16)30723):
            // Clean up "g120v3_objs"
            {
                delete g120v3_objs__elem_;
                g120v3_objs__elem_ = nullptr;
                if ( g120v3_objs() ) {
                    for ( auto* g120v3_objs__elem_ : *g120v3_objs() ) {
                        delete g120v3_objs__elem_;
                        g120v3_objs__elem_ = nullptr;
                    }
                }
                delete g120v3_objs_;
            }
            break;
        case ((uint16)30724):
            // Clean up "g120v4_objs"
            {
                delete g120v4_objs__elem_;
                g120v4_objs__elem_ = nullptr;
                if ( g120v4_objs() ) {
                    for ( auto* g120v4_objs__elem_ : *g120v4_objs() ) {
                        delete g120v4_objs__elem_;
                        g120v4_objs__elem_ = nullptr;
                    }
                }
                delete g120v4_objs_;
            }
            break;
        case ((uint16)30725):
            // Clean up "g120v5_objs"
            {
                delete g120v5_objs__elem_;
                g120v5_objs__elem_ = nullptr;
                if ( g120v5_objs() ) {
                    for ( auto* g120v5_objs__elem_ : *g120v5_objs() ) {
                        delete g120v5_objs__elem_;
                        g120v5_objs__elem_ = nullptr;
                    }
                }
                delete g120v5_objs_;
            }
            break;
        case ((uint16)30726):
            // Clean up "g120v6_objs"
            {
                delete g120v6_objs__elem_;
                g120v6_objs__elem_ = nullptr;
                if ( g120v6_objs() ) {
                    for ( auto* g120v6_objs__elem_ : *g120v6_objs() ) {
                        delete g120v6_objs__elem_;
                        g120v6_objs__elem_ = nullptr;
                    }
                }
                delete g120v6_objs_;
            }
            break;
        case ((uint16)30727):
            // Clean up "g120v7_objs"
            {
                delete g120v7_objs__elem_;
                g120v7_objs__elem_ = nullptr;
                if ( g120v7_objs() ) {
                    for ( auto* g120v7_objs__elem_ : *g120v7_objs() ) {
                        delete g120v7_objs__elem_;
                        g120v7_objs__elem_ = nullptr;
                    }
                }
                delete g120v7_objs_;
            }
            break;
        case ((uint16)30728):
            // Clean up "g120v8_objs"
            {
                delete g120v8_objs__elem_;
                g120v8_objs__elem_ = nullptr;
                if ( g120v8_objs() ) {
                    for ( auto* g120v8_objs__elem_ : *g120v8_objs() ) {
                        delete g120v8_objs__elem_;
                        g120v8_objs__elem_ = nullptr;
                    }
                }
                delete g120v8_objs_;
            }
            break;
        case ((uint16)30729):
            // Clean up "g120v9_objs"
            {
                delete g120v9_objs__elem_;
                g120v9_objs__elem_ = nullptr;
                if ( g120v9_objs() ) {
                    for ( auto* g120v9_objs__elem_ : *g120v9_objs() ) {
                        delete g120v9_objs__elem_;
                        g120v9_objs__elem_ = nullptr;
                    }
                }
                delete g120v9_objs_;
            }
            break;
        case ((uint16)30730):
            // Clean up "g120v10_objs"
            {
                delete g120v10_objs__elem_;
                g120v10_objs__elem_ = nullptr;
                if ( g120v10_objs() ) {
                    for ( auto* g120v10_objs__elem_ : *g120v10_objs() ) {
                        delete g120v10_objs__elem_;
                        g120v10_objs__elem_ = nullptr;
                    }
                }
                delete g120v10_objs_;
            }
            break;
        case ((uint16)30731):
            // Clean up "g120v11_objs"
            {
                delete g120v11_objs__elem_;
                g120v11_objs__elem_ = nullptr;
                if ( g120v11_objs() ) {
                    for ( auto* g120v11_objs__elem_ : *g120v11_objs() ) {
                        delete g120v11_objs__elem_;
                        g120v11_objs__elem_ = nullptr;
                    }
                }
                delete g120v11_objs_;
            }
            break;
        case ((uint16)30732):
            // Clean up "g120v12_objs"
            {
                delete g120v12_objs__elem_;
                g120v12_objs__elem_ = nullptr;
                if ( g120v12_objs() ) {
                    for ( auto* g120v12_objs__elem_ : *g120v12_objs() ) {
                        delete g120v12_objs__elem_;
                        g120v12_objs__elem_ = nullptr;
                    }
                }
                delete g120v12_objs_;
            }
            break;
        case ((uint16)30733):
            // Clean up "g120v13_objs"
            {
                delete g120v13_objs__elem_;
                g120v13_objs__elem_ = nullptr;
                if ( g120v13_objs() ) {
                    for ( auto* g120v13_objs__elem_ : *g120v13_objs() ) {
                        delete g120v13_objs__elem_;
                        g120v13_objs__elem_ = nullptr;
                    }
                }
                delete g120v13_objs_;
            }
            break;
        case ((uint16)30734):
            // Clean up "g120v14_objs"
            {
                delete g120v14_objs__elem_;
                g120v14_objs__elem_ = nullptr;
                if ( g120v14_objs() ) {
                    for ( auto* g120v14_objs__elem_ : *g120v14_objs() ) {
                        delete g120v14_objs__elem_;
                        g120v14_objs__elem_ = nullptr;
                    }
                }
                delete g120v14_objs_;
            }
            break;
        case ((uint16)30735):
            // Clean up "g120v15_objs"
            {
                delete g120v15_objs__elem_;
                g120v15_objs__elem_ = nullptr;
                if ( g120v15_objs() ) {
                    for ( auto* g120v15_objs__elem_ : *g120v15_objs() ) {
                        delete g120v15_objs__elem_;
                        g120v15_objs__elem_ = nullptr;
                    }
                }
                delete g120v15_objs_;
            }
            break;
        default:
            // Clean up "objects"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dump_data_case_index() ) {
        case ((uint8)25):
            // Clean up "open_file_dump"
            {
            }
            break;
        case ((uint8)26):
            // Clean up "close_file_dump"
            {
            }
            break;
        case ((uint8)27):
            // Clean up "delete_file_dump"
            {
            }
            break;
        case ((uint8)30):
            // Clean up "abort_file_dump"
            {
            }
            break;
        case ((uint8)28):
            // Clean up "get_file_info"
            {
            }
            break;
        case ((uint8)29):
            // Clean up "auth_file"
            {
            }
            break;
        case ((uint8)31):
            // Clean up "active_config"
            {
            }
            break;
        default:
            // Clean up "default_dump"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Request_Objects::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Parse "object_header"
    object_header_ = new Object_Header(function_code());
    int t_object_header__size;
    t_object_header__size = object_header_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    const_byteptr const t_dataptr_after_object_header = t_begin_of_data + (t_object_header__size);
    BINPAC_ASSERT(t_dataptr_after_object_header <= t_end_of_data);
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( object_header()->object_type_field() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)3073):
            // Parse "g12v1_objs"
            {
                int t_g12v1_objs__arraylength;
                t_g12v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g12v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g12v1_objs",
                      t_g12v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g12v1_objs
                if ( t_g12v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g12v1_objs",
                      t_g12v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g12v1_objs__elem_ = nullptr;
                int t_g12v1_objs__elem__it;
                t_g12v1_objs__elem__it = 0;
                int t_g12v1_objs__size;
                g12v1_objs_ = new vector<Request_Data_Object*>;
                g12v1_objs_->reserve(t_g12v1_objs__arraylength);
                const_byteptr t_g12v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g12v1_objs__elem__it < t_g12v1_objs__arraylength; ++t_g12v1_objs__elem__it) {
                    g12v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g12v1_objs__elem__size;
                    t_g12v1_objs__elem__size = g12v1_objs__elem_->Parse(t_g12v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g12v1_objs_->push_back(g12v1_objs__elem_);
                    t_g12v1_objs__elem__dataptr += t_g12v1_objs__elem__size;
                    BINPAC_ASSERT(t_g12v1_objs__elem__dataptr <= t_end_of_data);
                    g12v1_objs__elem_ = nullptr;
                }
            end_of_g12v1_objs: ;
                t_g12v1_objs__size = t_g12v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g12v1_objs__size;
            }
            break;
        case ((uint16)3074):
            // Parse "g12v2_objs"
            {
                int t_g12v2_objs__arraylength;
                t_g12v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g12v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g12v2_objs",
                      t_g12v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g12v2_objs
                if ( t_g12v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g12v2_objs",
                      t_g12v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g12v2_objs__elem_ = nullptr;
                int t_g12v2_objs__elem__it;
                t_g12v2_objs__elem__it = 0;
                int t_g12v2_objs__size;
                g12v2_objs_ = new vector<Request_Data_Object*>;
                g12v2_objs_->reserve(t_g12v2_objs__arraylength);
                const_byteptr t_g12v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g12v2_objs__elem__it < t_g12v2_objs__arraylength; ++t_g12v2_objs__elem__it) {
                    g12v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g12v2_objs__elem__size;
                    t_g12v2_objs__elem__size = g12v2_objs__elem_->Parse(t_g12v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g12v2_objs_->push_back(g12v2_objs__elem_);
                    t_g12v2_objs__elem__dataptr += t_g12v2_objs__elem__size;
                    BINPAC_ASSERT(t_g12v2_objs__elem__dataptr <= t_end_of_data);
                    g12v2_objs__elem_ = nullptr;
                }
            end_of_g12v2_objs: ;
                t_g12v2_objs__size = t_g12v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g12v2_objs__size;
            }
            break;
        case ((uint16)3075):
            // Parse "bocmd_PM"
            {
                int t_bocmd_PM__arraylength;
                t_bocmd_PM__arraylength =  ( object_header()->number_of_item() / 8 )  + 1 *  ( object_header()->number_of_item() >  (  ( object_header()->number_of_item() / 8 )  * 8 )  ) ;
                if ( t_bocmd_PM__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:bocmd_PM",
                      t_bocmd_PM__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:bocmd_PM
                if ( t_bocmd_PM__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:bocmd_PM",
                      t_bocmd_PM__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                bocmd_PM__elem_ = nullptr;
                int t_bocmd_PM__elem__it;
                t_bocmd_PM__elem__it = 0;
                int t_bocmd_PM__size;
                bocmd_PM_ = new vector<Request_Data_Object*>;
                bocmd_PM_->reserve(t_bocmd_PM__arraylength);
                const_byteptr t_bocmd_PM__elem__dataptr = t_dataptr_after_object_header;
                for (; t_bocmd_PM__elem__it < t_bocmd_PM__arraylength; ++t_bocmd_PM__elem__it) {
                    bocmd_PM__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_bocmd_PM__elem__size;
                    t_bocmd_PM__elem__size = bocmd_PM__elem_->Parse(t_bocmd_PM__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    bocmd_PM_->push_back(bocmd_PM__elem_);
                    t_bocmd_PM__elem__dataptr += t_bocmd_PM__elem__size;
                    BINPAC_ASSERT(t_bocmd_PM__elem__dataptr <= t_end_of_data);
                    bocmd_PM__elem_ = nullptr;
                }
            end_of_bocmd_PM: ;
                t_bocmd_PM__size = t_bocmd_PM__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_bocmd_PM__size;
            }
            break;
        case ((uint16)12801):
            // Parse "g50v1_objs"
            {
                int t_g50v1_objs__arraylength;
                t_g50v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g50v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v1_objs",
                      t_g50v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g50v1_objs
                if ( t_g50v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v1_objs",
                      t_g50v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g50v1_objs__elem_ = nullptr;
                int t_g50v1_objs__elem__it;
                t_g50v1_objs__elem__it = 0;
                int t_g50v1_objs__size;
                g50v1_objs_ = new vector<Request_Data_Object*>;
                g50v1_objs_->reserve(t_g50v1_objs__arraylength);
                const_byteptr t_g50v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g50v1_objs__elem__it < t_g50v1_objs__arraylength; ++t_g50v1_objs__elem__it) {
                    g50v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g50v1_objs__elem__size;
                    t_g50v1_objs__elem__size = g50v1_objs__elem_->Parse(t_g50v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g50v1_objs_->push_back(g50v1_objs__elem_);
                    t_g50v1_objs__elem__dataptr += t_g50v1_objs__elem__size;
                    BINPAC_ASSERT(t_g50v1_objs__elem__dataptr <= t_end_of_data);
                    g50v1_objs__elem_ = nullptr;
                }
            end_of_g50v1_objs: ;
                t_g50v1_objs__size = t_g50v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g50v1_objs__size;
            }
            break;
        case ((uint16)12802):
            // Parse "g50v2_objs"
            {
                int t_g50v2_objs__arraylength;
                t_g50v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g50v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v2_objs",
                      t_g50v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g50v2_objs
                if ( t_g50v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v2_objs",
                      t_g50v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g50v2_objs__elem_ = nullptr;
                int t_g50v2_objs__elem__it;
                t_g50v2_objs__elem__it = 0;
                int t_g50v2_objs__size;
                g50v2_objs_ = new vector<Request_Data_Object*>;
                g50v2_objs_->reserve(t_g50v2_objs__arraylength);
                const_byteptr t_g50v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g50v2_objs__elem__it < t_g50v2_objs__arraylength; ++t_g50v2_objs__elem__it) {
                    g50v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g50v2_objs__elem__size;
                    t_g50v2_objs__elem__size = g50v2_objs__elem_->Parse(t_g50v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g50v2_objs_->push_back(g50v2_objs__elem_);
                    t_g50v2_objs__elem__dataptr += t_g50v2_objs__elem__size;
                    BINPAC_ASSERT(t_g50v2_objs__elem__dataptr <= t_end_of_data);
                    g50v2_objs__elem_ = nullptr;
                }
            end_of_g50v2_objs: ;
                t_g50v2_objs__size = t_g50v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g50v2_objs__size;
            }
            break;
        case ((uint16)12803):
            // Parse "g50v3_objs"
            {
                int t_g50v3_objs__arraylength;
                t_g50v3_objs__arraylength = object_header()->number_of_item();
                if ( t_g50v3_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v3_objs",
                      t_g50v3_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g50v3_objs
                if ( t_g50v3_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g50v3_objs",
                      t_g50v3_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g50v3_objs__elem_ = nullptr;
                int t_g50v3_objs__elem__it;
                t_g50v3_objs__elem__it = 0;
                int t_g50v3_objs__size;
                g50v3_objs_ = new vector<Request_Data_Object*>;
                g50v3_objs_->reserve(t_g50v3_objs__arraylength);
                const_byteptr t_g50v3_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g50v3_objs__elem__it < t_g50v3_objs__arraylength; ++t_g50v3_objs__elem__it) {
                    g50v3_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g50v3_objs__elem__size;
                    t_g50v3_objs__elem__size = g50v3_objs__elem_->Parse(t_g50v3_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g50v3_objs_->push_back(g50v3_objs__elem_);
                    t_g50v3_objs__elem__dataptr += t_g50v3_objs__elem__size;
                    BINPAC_ASSERT(t_g50v3_objs__elem__dataptr <= t_end_of_data);
                    g50v3_objs__elem_ = nullptr;
                }
            end_of_g50v3_objs: ;
                t_g50v3_objs__size = t_g50v3_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g50v3_objs__size;
            }
            break;
        case ((uint16)13057):
            // Parse "g51v1_objs"
            {
                int t_g51v1_objs__arraylength;
                t_g51v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g51v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g51v1_objs",
                      t_g51v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g51v1_objs
                if ( t_g51v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g51v1_objs",
                      t_g51v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g51v1_objs__elem_ = nullptr;
                int t_g51v1_objs__elem__it;
                t_g51v1_objs__elem__it = 0;
                int t_g51v1_objs__size;
                g51v1_objs_ = new vector<Request_Data_Object*>;
                g51v1_objs_->reserve(t_g51v1_objs__arraylength);
                const_byteptr t_g51v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g51v1_objs__elem__it < t_g51v1_objs__arraylength; ++t_g51v1_objs__elem__it) {
                    g51v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g51v1_objs__elem__size;
                    t_g51v1_objs__elem__size = g51v1_objs__elem_->Parse(t_g51v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g51v1_objs_->push_back(g51v1_objs__elem_);
                    t_g51v1_objs__elem__dataptr += t_g51v1_objs__elem__size;
                    BINPAC_ASSERT(t_g51v1_objs__elem__dataptr <= t_end_of_data);
                    g51v1_objs__elem_ = nullptr;
                }
            end_of_g51v1_objs: ;
                t_g51v1_objs__size = t_g51v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g51v1_objs__size;
            }
            break;
        case ((uint16)13058):
            // Parse "g51v2_objs"
            {
                int t_g51v2_objs__arraylength;
                t_g51v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g51v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g51v2_objs",
                      t_g51v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g51v2_objs
                if ( t_g51v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g51v2_objs",
                      t_g51v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g51v2_objs__elem_ = nullptr;
                int t_g51v2_objs__elem__it;
                t_g51v2_objs__elem__it = 0;
                int t_g51v2_objs__size;
                g51v2_objs_ = new vector<Request_Data_Object*>;
                g51v2_objs_->reserve(t_g51v2_objs__arraylength);
                const_byteptr t_g51v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g51v2_objs__elem__it < t_g51v2_objs__arraylength; ++t_g51v2_objs__elem__it) {
                    g51v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g51v2_objs__elem__size;
                    t_g51v2_objs__elem__size = g51v2_objs__elem_->Parse(t_g51v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g51v2_objs_->push_back(g51v2_objs__elem_);
                    t_g51v2_objs__elem__dataptr += t_g51v2_objs__elem__size;
                    BINPAC_ASSERT(t_g51v2_objs__elem__dataptr <= t_end_of_data);
                    g51v2_objs__elem_ = nullptr;
                }
            end_of_g51v2_objs: ;
                t_g51v2_objs__size = t_g51v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g51v2_objs__size;
            }
            break;
        case ((uint16)13313):
            // Parse "g52v1_objs"
            {
                int t_g52v1_objs__arraylength;
                t_g52v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g52v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g52v1_objs",
                      t_g52v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g52v1_objs
                if ( t_g52v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g52v1_objs",
                      t_g52v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g52v1_objs__elem_ = nullptr;
                int t_g52v1_objs__elem__it;
                t_g52v1_objs__elem__it = 0;
                int t_g52v1_objs__size;
                g52v1_objs_ = new vector<Request_Data_Object*>;
                g52v1_objs_->reserve(t_g52v1_objs__arraylength);
                const_byteptr t_g52v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g52v1_objs__elem__it < t_g52v1_objs__arraylength; ++t_g52v1_objs__elem__it) {
                    g52v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g52v1_objs__elem__size;
                    t_g52v1_objs__elem__size = g52v1_objs__elem_->Parse(t_g52v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g52v1_objs_->push_back(g52v1_objs__elem_);
                    t_g52v1_objs__elem__dataptr += t_g52v1_objs__elem__size;
                    BINPAC_ASSERT(t_g52v1_objs__elem__dataptr <= t_end_of_data);
                    g52v1_objs__elem_ = nullptr;
                }
            end_of_g52v1_objs: ;
                t_g52v1_objs__size = t_g52v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g52v1_objs__size;
            }
            break;
        case ((uint16)13314):
            // Parse "g52v2_objs"
            {
                int t_g52v2_objs__arraylength;
                t_g52v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g52v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g52v2_objs",
                      t_g52v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g52v2_objs
                if ( t_g52v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g52v2_objs",
                      t_g52v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g52v2_objs__elem_ = nullptr;
                int t_g52v2_objs__elem__it;
                t_g52v2_objs__elem__it = 0;
                int t_g52v2_objs__size;
                g52v2_objs_ = new vector<Request_Data_Object*>;
                g52v2_objs_->reserve(t_g52v2_objs__arraylength);
                const_byteptr t_g52v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g52v2_objs__elem__it < t_g52v2_objs__arraylength; ++t_g52v2_objs__elem__it) {
                    g52v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g52v2_objs__elem__size;
                    t_g52v2_objs__elem__size = g52v2_objs__elem_->Parse(t_g52v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g52v2_objs_->push_back(g52v2_objs__elem_);
                    t_g52v2_objs__elem__dataptr += t_g52v2_objs__elem__size;
                    BINPAC_ASSERT(t_g52v2_objs__elem__dataptr <= t_end_of_data);
                    g52v2_objs__elem_ = nullptr;
                }
            end_of_g52v2_objs: ;
                t_g52v2_objs__size = t_g52v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g52v2_objs__size;
            }
            break;
        case ((uint16)17921):
            // Parse "g70v1_objs"
            {
                int t_g70v1_objs__arraylength;
                t_g70v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v1_objs",
                      t_g70v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v1_objs
                if ( t_g70v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v1_objs",
                      t_g70v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v1_objs__elem_ = nullptr;
                int t_g70v1_objs__elem__it;
                t_g70v1_objs__elem__it = 0;
                int t_g70v1_objs__size;
                g70v1_objs_ = new vector<Request_Data_Object*>;
                g70v1_objs_->reserve(t_g70v1_objs__arraylength);
                const_byteptr t_g70v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v1_objs__elem__it < t_g70v1_objs__arraylength; ++t_g70v1_objs__elem__it) {
                    g70v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v1_objs__elem__size;
                    t_g70v1_objs__elem__size = g70v1_objs__elem_->Parse(t_g70v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v1_objs_->push_back(g70v1_objs__elem_);
                    t_g70v1_objs__elem__dataptr += t_g70v1_objs__elem__size;
                    BINPAC_ASSERT(t_g70v1_objs__elem__dataptr <= t_end_of_data);
                    g70v1_objs__elem_ = nullptr;
                }
            end_of_g70v1_objs: ;
                t_g70v1_objs__size = t_g70v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v1_objs__size;
            }
            break;
        case ((uint16)17922):
            // Parse "g70v2_objs"
            {
                int t_g70v2_objs__arraylength;
                t_g70v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v2_objs",
                      t_g70v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v2_objs
                if ( t_g70v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v2_objs",
                      t_g70v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v2_objs__elem_ = nullptr;
                int t_g70v2_objs__elem__it;
                t_g70v2_objs__elem__it = 0;
                int t_g70v2_objs__size;
                g70v2_objs_ = new vector<Request_Data_Object*>;
                g70v2_objs_->reserve(t_g70v2_objs__arraylength);
                const_byteptr t_g70v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v2_objs__elem__it < t_g70v2_objs__arraylength; ++t_g70v2_objs__elem__it) {
                    g70v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v2_objs__elem__size;
                    t_g70v2_objs__elem__size = g70v2_objs__elem_->Parse(t_g70v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v2_objs_->push_back(g70v2_objs__elem_);
                    t_g70v2_objs__elem__dataptr += t_g70v2_objs__elem__size;
                    BINPAC_ASSERT(t_g70v2_objs__elem__dataptr <= t_end_of_data);
                    g70v2_objs__elem_ = nullptr;
                }
            end_of_g70v2_objs: ;
                t_g70v2_objs__size = t_g70v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v2_objs__size;
            }
            break;
        case ((uint16)17923):
            // Parse "g70v3_objs"
            {
                int t_g70v3_objs__arraylength;
                t_g70v3_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v3_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v3_objs",
                      t_g70v3_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v3_objs
                if ( t_g70v3_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v3_objs",
                      t_g70v3_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v3_objs__elem_ = nullptr;
                int t_g70v3_objs__elem__it;
                t_g70v3_objs__elem__it = 0;
                int t_g70v3_objs__size;
                g70v3_objs_ = new vector<Request_Data_Object*>;
                g70v3_objs_->reserve(t_g70v3_objs__arraylength);
                const_byteptr t_g70v3_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v3_objs__elem__it < t_g70v3_objs__arraylength; ++t_g70v3_objs__elem__it) {
                    g70v3_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v3_objs__elem__size;
                    t_g70v3_objs__elem__size = g70v3_objs__elem_->Parse(t_g70v3_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v3_objs_->push_back(g70v3_objs__elem_);
                    t_g70v3_objs__elem__dataptr += t_g70v3_objs__elem__size;
                    BINPAC_ASSERT(t_g70v3_objs__elem__dataptr <= t_end_of_data);
                    g70v3_objs__elem_ = nullptr;
                }
            end_of_g70v3_objs: ;
                t_g70v3_objs__size = t_g70v3_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v3_objs__size;
            }
            break;
        case ((uint16)17924):
            // Parse "g70v4_objs"
            {
                int t_g70v4_objs__arraylength;
                t_g70v4_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v4_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v4_objs",
                      t_g70v4_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v4_objs
                if ( t_g70v4_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v4_objs",
                      t_g70v4_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v4_objs__elem_ = nullptr;
                int t_g70v4_objs__elem__it;
                t_g70v4_objs__elem__it = 0;
                int t_g70v4_objs__size;
                g70v4_objs_ = new vector<Request_Data_Object*>;
                g70v4_objs_->reserve(t_g70v4_objs__arraylength);
                const_byteptr t_g70v4_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v4_objs__elem__it < t_g70v4_objs__arraylength; ++t_g70v4_objs__elem__it) {
                    g70v4_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v4_objs__elem__size;
                    t_g70v4_objs__elem__size = g70v4_objs__elem_->Parse(t_g70v4_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v4_objs_->push_back(g70v4_objs__elem_);
                    t_g70v4_objs__elem__dataptr += t_g70v4_objs__elem__size;
                    BINPAC_ASSERT(t_g70v4_objs__elem__dataptr <= t_end_of_data);
                    g70v4_objs__elem_ = nullptr;
                }
            end_of_g70v4_objs: ;
                t_g70v4_objs__size = t_g70v4_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v4_objs__size;
            }
            break;
        case ((uint16)17925):
            // Parse "g70v5_objs"
            {
                int t_g70v5_objs__arraylength;
                t_g70v5_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v5_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v5_objs",
                      t_g70v5_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v5_objs
                if ( t_g70v5_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v5_objs",
                      t_g70v5_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v5_objs__elem_ = nullptr;
                int t_g70v5_objs__elem__it;
                t_g70v5_objs__elem__it = 0;
                int t_g70v5_objs__size;
                g70v5_objs_ = new vector<Request_Data_Object*>;
                g70v5_objs_->reserve(t_g70v5_objs__arraylength);
                const_byteptr t_g70v5_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v5_objs__elem__it < t_g70v5_objs__arraylength; ++t_g70v5_objs__elem__it) {
                    g70v5_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v5_objs__elem__size;
                    t_g70v5_objs__elem__size = g70v5_objs__elem_->Parse(t_g70v5_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v5_objs_->push_back(g70v5_objs__elem_);
                    t_g70v5_objs__elem__dataptr += t_g70v5_objs__elem__size;
                    BINPAC_ASSERT(t_g70v5_objs__elem__dataptr <= t_end_of_data);
                    g70v5_objs__elem_ = nullptr;
                }
            end_of_g70v5_objs: ;
                t_g70v5_objs__size = t_g70v5_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v5_objs__size;
            }
            break;
        case ((uint16)17926):
            // Parse "g70v6_objs"
            {
                int t_g70v6_objs__arraylength;
                t_g70v6_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v6_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v6_objs",
                      t_g70v6_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v6_objs
                if ( t_g70v6_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v6_objs",
                      t_g70v6_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v6_objs__elem_ = nullptr;
                int t_g70v6_objs__elem__it;
                t_g70v6_objs__elem__it = 0;
                int t_g70v6_objs__size;
                g70v6_objs_ = new vector<Request_Data_Object*>;
                g70v6_objs_->reserve(t_g70v6_objs__arraylength);
                const_byteptr t_g70v6_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v6_objs__elem__it < t_g70v6_objs__arraylength; ++t_g70v6_objs__elem__it) {
                    g70v6_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v6_objs__elem__size;
                    t_g70v6_objs__elem__size = g70v6_objs__elem_->Parse(t_g70v6_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v6_objs_->push_back(g70v6_objs__elem_);
                    t_g70v6_objs__elem__dataptr += t_g70v6_objs__elem__size;
                    BINPAC_ASSERT(t_g70v6_objs__elem__dataptr <= t_end_of_data);
                    g70v6_objs__elem_ = nullptr;
                }
            end_of_g70v6_objs: ;
                t_g70v6_objs__size = t_g70v6_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v6_objs__size;
            }
            break;
        case ((uint16)17927):
            // Parse "g70v7_objs"
            {
                int t_g70v7_objs__arraylength;
                t_g70v7_objs__arraylength = object_header()->number_of_item();
                if ( t_g70v7_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v7_objs",
                      t_g70v7_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g70v7_objs
                if ( t_g70v7_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g70v7_objs",
                      t_g70v7_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g70v7_objs__elem_ = nullptr;
                int t_g70v7_objs__elem__it;
                t_g70v7_objs__elem__it = 0;
                int t_g70v7_objs__size;
                g70v7_objs_ = new vector<Request_Data_Object*>;
                g70v7_objs_->reserve(t_g70v7_objs__arraylength);
                const_byteptr t_g70v7_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g70v7_objs__elem__it < t_g70v7_objs__arraylength; ++t_g70v7_objs__elem__it) {
                    g70v7_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g70v7_objs__elem__size;
                    t_g70v7_objs__elem__size = g70v7_objs__elem_->Parse(t_g70v7_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g70v7_objs_->push_back(g70v7_objs__elem_);
                    t_g70v7_objs__elem__dataptr += t_g70v7_objs__elem__size;
                    BINPAC_ASSERT(t_g70v7_objs__elem__dataptr <= t_end_of_data);
                    g70v7_objs__elem_ = nullptr;
                }
            end_of_g70v7_objs: ;
                t_g70v7_objs__size = t_g70v7_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g70v7_objs__size;
            }
            break;
        case ((uint16)20481):
            // Parse "g80v1_objs"
            {
                int t_g80v1_objs__arraylength;
                t_g80v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g80v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g80v1_objs",
                      t_g80v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g80v1_objs
                if ( t_g80v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g80v1_objs",
                      t_g80v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g80v1_objs__elem_ = nullptr;
                int t_g80v1_objs__elem__it;
                t_g80v1_objs__elem__it = 0;
                int t_g80v1_objs__size;
                g80v1_objs_ = new vector<Request_Data_Object*>;
                g80v1_objs_->reserve(t_g80v1_objs__arraylength);
                const_byteptr t_g80v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g80v1_objs__elem__it < t_g80v1_objs__arraylength; ++t_g80v1_objs__elem__it) {
                    g80v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g80v1_objs__elem__size;
                    t_g80v1_objs__elem__size = g80v1_objs__elem_->Parse(t_g80v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g80v1_objs_->push_back(g80v1_objs__elem_);
                    t_g80v1_objs__elem__dataptr += t_g80v1_objs__elem__size;
                    BINPAC_ASSERT(t_g80v1_objs__elem__dataptr <= t_end_of_data);
                    g80v1_objs__elem_ = nullptr;
                }
            end_of_g80v1_objs: ;
                t_g80v1_objs__size = t_g80v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g80v1_objs__size;
            }
            break;
        case ((uint16)30721):
            // Parse "g120v1_objs"
            {
                int t_g120v1_objs__arraylength;
                t_g120v1_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v1_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v1_objs",
                      t_g120v1_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v1_objs
                if ( t_g120v1_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v1_objs",
                      t_g120v1_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v1_objs__elem_ = nullptr;
                int t_g120v1_objs__elem__it;
                t_g120v1_objs__elem__it = 0;
                int t_g120v1_objs__size;
                g120v1_objs_ = new vector<Request_Data_Object*>;
                g120v1_objs_->reserve(t_g120v1_objs__arraylength);
                const_byteptr t_g120v1_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v1_objs__elem__it < t_g120v1_objs__arraylength; ++t_g120v1_objs__elem__it) {
                    g120v1_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v1_objs__elem__size;
                    t_g120v1_objs__elem__size = g120v1_objs__elem_->Parse(t_g120v1_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v1_objs_->push_back(g120v1_objs__elem_);
                    t_g120v1_objs__elem__dataptr += t_g120v1_objs__elem__size;
                    BINPAC_ASSERT(t_g120v1_objs__elem__dataptr <= t_end_of_data);
                    g120v1_objs__elem_ = nullptr;
                }
            end_of_g120v1_objs: ;
                t_g120v1_objs__size = t_g120v1_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v1_objs__size;
            }
            break;
        case ((uint16)30722):
            // Parse "g120v2_objs"
            {
                int t_g120v2_objs__arraylength;
                t_g120v2_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v2_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v2_objs",
                      t_g120v2_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v2_objs
                if ( t_g120v2_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v2_objs",
                      t_g120v2_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v2_objs__elem_ = nullptr;
                int t_g120v2_objs__elem__it;
                t_g120v2_objs__elem__it = 0;
                int t_g120v2_objs__size;
                g120v2_objs_ = new vector<Request_Data_Object*>;
                g120v2_objs_->reserve(t_g120v2_objs__arraylength);
                const_byteptr t_g120v2_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v2_objs__elem__it < t_g120v2_objs__arraylength; ++t_g120v2_objs__elem__it) {
                    g120v2_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v2_objs__elem__size;
                    t_g120v2_objs__elem__size = g120v2_objs__elem_->Parse(t_g120v2_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v2_objs_->push_back(g120v2_objs__elem_);
                    t_g120v2_objs__elem__dataptr += t_g120v2_objs__elem__size;
                    BINPAC_ASSERT(t_g120v2_objs__elem__dataptr <= t_end_of_data);
                    g120v2_objs__elem_ = nullptr;
                }
            end_of_g120v2_objs: ;
                t_g120v2_objs__size = t_g120v2_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v2_objs__size;
            }
            break;
        case ((uint16)30723):
            // Parse "g120v3_objs"
            {
                int t_g120v3_objs__arraylength;
                t_g120v3_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v3_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v3_objs",
                      t_g120v3_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v3_objs
                if ( t_g120v3_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v3_objs",
                      t_g120v3_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v3_objs__elem_ = nullptr;
                int t_g120v3_objs__elem__it;
                t_g120v3_objs__elem__it = 0;
                int t_g120v3_objs__size;
                g120v3_objs_ = new vector<Request_Data_Object*>;
                g120v3_objs_->reserve(t_g120v3_objs__arraylength);
                const_byteptr t_g120v3_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v3_objs__elem__it < t_g120v3_objs__arraylength; ++t_g120v3_objs__elem__it) {
                    g120v3_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v3_objs__elem__size;
                    t_g120v3_objs__elem__size = g120v3_objs__elem_->Parse(t_g120v3_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v3_objs_->push_back(g120v3_objs__elem_);
                    t_g120v3_objs__elem__dataptr += t_g120v3_objs__elem__size;
                    BINPAC_ASSERT(t_g120v3_objs__elem__dataptr <= t_end_of_data);
                    g120v3_objs__elem_ = nullptr;
                }
            end_of_g120v3_objs: ;
                t_g120v3_objs__size = t_g120v3_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v3_objs__size;
            }
            break;
        case ((uint16)30724):
            // Parse "g120v4_objs"
            {
                int t_g120v4_objs__arraylength;
                t_g120v4_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v4_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v4_objs",
                      t_g120v4_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v4_objs
                if ( t_g120v4_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v4_objs",
                      t_g120v4_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v4_objs__elem_ = nullptr;
                int t_g120v4_objs__elem__it;
                t_g120v4_objs__elem__it = 0;
                int t_g120v4_objs__size;
                g120v4_objs_ = new vector<Request_Data_Object*>;
                g120v4_objs_->reserve(t_g120v4_objs__arraylength);
                const_byteptr t_g120v4_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v4_objs__elem__it < t_g120v4_objs__arraylength; ++t_g120v4_objs__elem__it) {
                    g120v4_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v4_objs__elem__size;
                    t_g120v4_objs__elem__size = g120v4_objs__elem_->Parse(t_g120v4_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v4_objs_->push_back(g120v4_objs__elem_);
                    t_g120v4_objs__elem__dataptr += t_g120v4_objs__elem__size;
                    BINPAC_ASSERT(t_g120v4_objs__elem__dataptr <= t_end_of_data);
                    g120v4_objs__elem_ = nullptr;
                }
            end_of_g120v4_objs: ;
                t_g120v4_objs__size = t_g120v4_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v4_objs__size;
            }
            break;
        case ((uint16)30725):
            // Parse "g120v5_objs"
            {
                int t_g120v5_objs__arraylength;
                t_g120v5_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v5_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v5_objs",
                      t_g120v5_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v5_objs
                if ( t_g120v5_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v5_objs",
                      t_g120v5_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v5_objs__elem_ = nullptr;
                int t_g120v5_objs__elem__it;
                t_g120v5_objs__elem__it = 0;
                int t_g120v5_objs__size;
                g120v5_objs_ = new vector<Request_Data_Object*>;
                g120v5_objs_->reserve(t_g120v5_objs__arraylength);
                const_byteptr t_g120v5_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v5_objs__elem__it < t_g120v5_objs__arraylength; ++t_g120v5_objs__elem__it) {
                    g120v5_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v5_objs__elem__size;
                    t_g120v5_objs__elem__size = g120v5_objs__elem_->Parse(t_g120v5_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v5_objs_->push_back(g120v5_objs__elem_);
                    t_g120v5_objs__elem__dataptr += t_g120v5_objs__elem__size;
                    BINPAC_ASSERT(t_g120v5_objs__elem__dataptr <= t_end_of_data);
                    g120v5_objs__elem_ = nullptr;
                }
            end_of_g120v5_objs: ;
                t_g120v5_objs__size = t_g120v5_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v5_objs__size;
            }
            break;
        case ((uint16)30726):
            // Parse "g120v6_objs"
            {
                int t_g120v6_objs__arraylength;
                t_g120v6_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v6_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v6_objs",
                      t_g120v6_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v6_objs
                if ( t_g120v6_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v6_objs",
                      t_g120v6_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v6_objs__elem_ = nullptr;
                int t_g120v6_objs__elem__it;
                t_g120v6_objs__elem__it = 0;
                int t_g120v6_objs__size;
                g120v6_objs_ = new vector<Request_Data_Object*>;
                g120v6_objs_->reserve(t_g120v6_objs__arraylength);
                const_byteptr t_g120v6_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v6_objs__elem__it < t_g120v6_objs__arraylength; ++t_g120v6_objs__elem__it) {
                    g120v6_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v6_objs__elem__size;
                    t_g120v6_objs__elem__size = g120v6_objs__elem_->Parse(t_g120v6_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v6_objs_->push_back(g120v6_objs__elem_);
                    t_g120v6_objs__elem__dataptr += t_g120v6_objs__elem__size;
                    BINPAC_ASSERT(t_g120v6_objs__elem__dataptr <= t_end_of_data);
                    g120v6_objs__elem_ = nullptr;
                }
            end_of_g120v6_objs: ;
                t_g120v6_objs__size = t_g120v6_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v6_objs__size;
            }
            break;
        case ((uint16)30727):
            // Parse "g120v7_objs"
            {
                int t_g120v7_objs__arraylength;
                t_g120v7_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v7_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v7_objs",
                      t_g120v7_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v7_objs
                if ( t_g120v7_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v7_objs",
                      t_g120v7_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v7_objs__elem_ = nullptr;
                int t_g120v7_objs__elem__it;
                t_g120v7_objs__elem__it = 0;
                int t_g120v7_objs__size;
                g120v7_objs_ = new vector<Request_Data_Object*>;
                g120v7_objs_->reserve(t_g120v7_objs__arraylength);
                const_byteptr t_g120v7_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v7_objs__elem__it < t_g120v7_objs__arraylength; ++t_g120v7_objs__elem__it) {
                    g120v7_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v7_objs__elem__size;
                    t_g120v7_objs__elem__size = g120v7_objs__elem_->Parse(t_g120v7_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v7_objs_->push_back(g120v7_objs__elem_);
                    t_g120v7_objs__elem__dataptr += t_g120v7_objs__elem__size;
                    BINPAC_ASSERT(t_g120v7_objs__elem__dataptr <= t_end_of_data);
                    g120v7_objs__elem_ = nullptr;
                }
            end_of_g120v7_objs: ;
                t_g120v7_objs__size = t_g120v7_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v7_objs__size;
            }
            break;
        case ((uint16)30728):
            // Parse "g120v8_objs"
            {
                int t_g120v8_objs__arraylength;
                t_g120v8_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v8_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v8_objs",
                      t_g120v8_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v8_objs
                if ( t_g120v8_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v8_objs",
                      t_g120v8_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v8_objs__elem_ = nullptr;
                int t_g120v8_objs__elem__it;
                t_g120v8_objs__elem__it = 0;
                int t_g120v8_objs__size;
                g120v8_objs_ = new vector<Request_Data_Object*>;
                g120v8_objs_->reserve(t_g120v8_objs__arraylength);
                const_byteptr t_g120v8_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v8_objs__elem__it < t_g120v8_objs__arraylength; ++t_g120v8_objs__elem__it) {
                    g120v8_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v8_objs__elem__size;
                    t_g120v8_objs__elem__size = g120v8_objs__elem_->Parse(t_g120v8_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v8_objs_->push_back(g120v8_objs__elem_);
                    t_g120v8_objs__elem__dataptr += t_g120v8_objs__elem__size;
                    BINPAC_ASSERT(t_g120v8_objs__elem__dataptr <= t_end_of_data);
                    g120v8_objs__elem_ = nullptr;
                }
            end_of_g120v8_objs: ;
                t_g120v8_objs__size = t_g120v8_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v8_objs__size;
            }
            break;
        case ((uint16)30729):
            // Parse "g120v9_objs"
            {
                int t_g120v9_objs__arraylength;
                t_g120v9_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v9_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v9_objs",
                      t_g120v9_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v9_objs
                if ( t_g120v9_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v9_objs",
                      t_g120v9_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v9_objs__elem_ = nullptr;
                int t_g120v9_objs__elem__it;
                t_g120v9_objs__elem__it = 0;
                int t_g120v9_objs__size;
                g120v9_objs_ = new vector<Request_Data_Object*>;
                g120v9_objs_->reserve(t_g120v9_objs__arraylength);
                const_byteptr t_g120v9_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v9_objs__elem__it < t_g120v9_objs__arraylength; ++t_g120v9_objs__elem__it) {
                    g120v9_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v9_objs__elem__size;
                    t_g120v9_objs__elem__size = g120v9_objs__elem_->Parse(t_g120v9_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v9_objs_->push_back(g120v9_objs__elem_);
                    t_g120v9_objs__elem__dataptr += t_g120v9_objs__elem__size;
                    BINPAC_ASSERT(t_g120v9_objs__elem__dataptr <= t_end_of_data);
                    g120v9_objs__elem_ = nullptr;
                }
            end_of_g120v9_objs: ;
                t_g120v9_objs__size = t_g120v9_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v9_objs__size;
            }
            break;
        case ((uint16)30730):
            // Parse "g120v10_objs"
            {
                int t_g120v10_objs__arraylength;
                t_g120v10_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v10_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v10_objs",
                      t_g120v10_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v10_objs
                if ( t_g120v10_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v10_objs",
                      t_g120v10_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v10_objs__elem_ = nullptr;
                int t_g120v10_objs__elem__it;
                t_g120v10_objs__elem__it = 0;
                int t_g120v10_objs__size;
                g120v10_objs_ = new vector<Request_Data_Object*>;
                g120v10_objs_->reserve(t_g120v10_objs__arraylength);
                const_byteptr t_g120v10_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v10_objs__elem__it < t_g120v10_objs__arraylength; ++t_g120v10_objs__elem__it) {
                    g120v10_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v10_objs__elem__size;
                    t_g120v10_objs__elem__size = g120v10_objs__elem_->Parse(t_g120v10_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v10_objs_->push_back(g120v10_objs__elem_);
                    t_g120v10_objs__elem__dataptr += t_g120v10_objs__elem__size;
                    BINPAC_ASSERT(t_g120v10_objs__elem__dataptr <= t_end_of_data);
                    g120v10_objs__elem_ = nullptr;
                }
            end_of_g120v10_objs: ;
                t_g120v10_objs__size = t_g120v10_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v10_objs__size;
            }
            break;
        case ((uint16)30731):
            // Parse "g120v11_objs"
            {
                int t_g120v11_objs__arraylength;
                t_g120v11_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v11_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v11_objs",
                      t_g120v11_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v11_objs
                if ( t_g120v11_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v11_objs",
                      t_g120v11_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v11_objs__elem_ = nullptr;
                int t_g120v11_objs__elem__it;
                t_g120v11_objs__elem__it = 0;
                int t_g120v11_objs__size;
                g120v11_objs_ = new vector<Request_Data_Object*>;
                g120v11_objs_->reserve(t_g120v11_objs__arraylength);
                const_byteptr t_g120v11_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v11_objs__elem__it < t_g120v11_objs__arraylength; ++t_g120v11_objs__elem__it) {
                    g120v11_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v11_objs__elem__size;
                    t_g120v11_objs__elem__size = g120v11_objs__elem_->Parse(t_g120v11_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v11_objs_->push_back(g120v11_objs__elem_);
                    t_g120v11_objs__elem__dataptr += t_g120v11_objs__elem__size;
                    BINPAC_ASSERT(t_g120v11_objs__elem__dataptr <= t_end_of_data);
                    g120v11_objs__elem_ = nullptr;
                }
            end_of_g120v11_objs: ;
                t_g120v11_objs__size = t_g120v11_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v11_objs__size;
            }
            break;
        case ((uint16)30732):
            // Parse "g120v12_objs"
            {
                int t_g120v12_objs__arraylength;
                t_g120v12_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v12_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v12_objs",
                      t_g120v12_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v12_objs
                if ( t_g120v12_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v12_objs",
                      t_g120v12_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v12_objs__elem_ = nullptr;
                int t_g120v12_objs__elem__it;
                t_g120v12_objs__elem__it = 0;
                int t_g120v12_objs__size;
                g120v12_objs_ = new vector<Request_Data_Object*>;
                g120v12_objs_->reserve(t_g120v12_objs__arraylength);
                const_byteptr t_g120v12_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v12_objs__elem__it < t_g120v12_objs__arraylength; ++t_g120v12_objs__elem__it) {
                    g120v12_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v12_objs__elem__size;
                    t_g120v12_objs__elem__size = g120v12_objs__elem_->Parse(t_g120v12_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v12_objs_->push_back(g120v12_objs__elem_);
                    t_g120v12_objs__elem__dataptr += t_g120v12_objs__elem__size;
                    BINPAC_ASSERT(t_g120v12_objs__elem__dataptr <= t_end_of_data);
                    g120v12_objs__elem_ = nullptr;
                }
            end_of_g120v12_objs: ;
                t_g120v12_objs__size = t_g120v12_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v12_objs__size;
            }
            break;
        case ((uint16)30733):
            // Parse "g120v13_objs"
            {
                int t_g120v13_objs__arraylength;
                t_g120v13_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v13_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v13_objs",
                      t_g120v13_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v13_objs
                if ( t_g120v13_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v13_objs",
                      t_g120v13_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v13_objs__elem_ = nullptr;
                int t_g120v13_objs__elem__it;
                t_g120v13_objs__elem__it = 0;
                int t_g120v13_objs__size;
                g120v13_objs_ = new vector<Request_Data_Object*>;
                g120v13_objs_->reserve(t_g120v13_objs__arraylength);
                const_byteptr t_g120v13_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v13_objs__elem__it < t_g120v13_objs__arraylength; ++t_g120v13_objs__elem__it) {
                    g120v13_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v13_objs__elem__size;
                    t_g120v13_objs__elem__size = g120v13_objs__elem_->Parse(t_g120v13_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v13_objs_->push_back(g120v13_objs__elem_);
                    t_g120v13_objs__elem__dataptr += t_g120v13_objs__elem__size;
                    BINPAC_ASSERT(t_g120v13_objs__elem__dataptr <= t_end_of_data);
                    g120v13_objs__elem_ = nullptr;
                }
            end_of_g120v13_objs: ;
                t_g120v13_objs__size = t_g120v13_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v13_objs__size;
            }
            break;
        case ((uint16)30734):
            // Parse "g120v14_objs"
            {
                int t_g120v14_objs__arraylength;
                t_g120v14_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v14_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v14_objs",
                      t_g120v14_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v14_objs
                if ( t_g120v14_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v14_objs",
                      t_g120v14_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v14_objs__elem_ = nullptr;
                int t_g120v14_objs__elem__it;
                t_g120v14_objs__elem__it = 0;
                int t_g120v14_objs__size;
                g120v14_objs_ = new vector<Request_Data_Object*>;
                g120v14_objs_->reserve(t_g120v14_objs__arraylength);
                const_byteptr t_g120v14_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v14_objs__elem__it < t_g120v14_objs__arraylength; ++t_g120v14_objs__elem__it) {
                    g120v14_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v14_objs__elem__size;
                    t_g120v14_objs__elem__size = g120v14_objs__elem_->Parse(t_g120v14_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v14_objs_->push_back(g120v14_objs__elem_);
                    t_g120v14_objs__elem__dataptr += t_g120v14_objs__elem__size;
                    BINPAC_ASSERT(t_g120v14_objs__elem__dataptr <= t_end_of_data);
                    g120v14_objs__elem_ = nullptr;
                }
            end_of_g120v14_objs: ;
                t_g120v14_objs__size = t_g120v14_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v14_objs__size;
            }
            break;
        case ((uint16)30735):
            // Parse "g120v15_objs"
            {
                int t_g120v15_objs__arraylength;
                t_g120v15_objs__arraylength = object_header()->number_of_item();
                if ( t_g120v15_objs__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v15_objs",
                      t_g120v15_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Request_Objects:g120v15_objs
                if ( t_g120v15_objs__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Request_Objects:g120v15_objs",
                      t_g120v15_objs__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                g120v15_objs__elem_ = nullptr;
                int t_g120v15_objs__elem__it;
                t_g120v15_objs__elem__it = 0;
                int t_g120v15_objs__size;
                g120v15_objs_ = new vector<Request_Data_Object*>;
                g120v15_objs_->reserve(t_g120v15_objs__arraylength);
                const_byteptr t_g120v15_objs__elem__dataptr = t_dataptr_after_object_header;
                for (; t_g120v15_objs__elem__it < t_g120v15_objs__arraylength; ++t_g120v15_objs__elem__it) {
                    g120v15_objs__elem_ = new Request_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_g120v15_objs__elem__size;
                    t_g120v15_objs__elem__size = g120v15_objs__elem_->Parse(t_g120v15_objs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    g120v15_objs_->push_back(g120v15_objs__elem_);
                    t_g120v15_objs__elem__dataptr += t_g120v15_objs__elem__size;
                    BINPAC_ASSERT(t_g120v15_objs__elem__dataptr <= t_end_of_data);
                    g120v15_objs__elem_ = nullptr;
                }
            end_of_g120v15_objs: ;
                t_g120v15_objs__size = t_g120v15_objs__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_g120v15_objs__size;
            }
            break;
        default:
            // Parse "objects"
            {
                t_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_data = t_dataptr_after_object_header + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    // Checking out-of-bound for "Request_Objects:dump_data"
    if ( t_dataptr_after_data + (0) > t_end_of_data || t_dataptr_after_data + (0) < t_dataptr_after_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Request_Objects:dump_data",
        	((t_dataptr_after_data - t_begin_of_data)) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dump_data"
    dump_data_case_index_ =  ( function_code() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dump_data_case_index() ) {
        case ((uint8)25):
            // Parse "open_file_dump"
            {
            }
            break;
        case ((uint8)26):
            // Parse "close_file_dump"
            {
            }
            break;
        case ((uint8)27):
            // Parse "delete_file_dump"
            {
            }
            break;
        case ((uint8)30):
            // Parse "abort_file_dump"
            {
            }
            break;
        case ((uint8)28):
            // Parse "get_file_info"
            {
            }
            break;
        case ((uint8)29):
            // Parse "auth_file"
            {
            }
            break;
        case ((uint8)31):
            // Parse "active_config"
            {
            }
            break;
        default:
            // Parse "default_dump"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Request_Objects__size;
    t_Request_Objects__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Request_Objects__size) <= t_end_of_data);
    return t_Request_Objects__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Response_Objects::Response_Objects(uint8 function_code) {
    object_header_ = nullptr;
    data_case_index_ = -1;
    biwoflag_ = nullptr;
    biwoflag__elem_ = nullptr;
    diwoflag_ = nullptr;
    diwoflag__elem_ = nullptr;
    bowoflag_ = nullptr;
    bowoflag__elem_ = nullptr;
    bocmd_PM_ = nullptr;
    bocmd_PM__elem_ = nullptr;
    objects_ = nullptr;
    objects__elem_ = nullptr;
    function_code_ = function_code;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Response_Objects::~Response_Objects() {
    delete object_header_;
    object_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)257):
            // Clean up "biwoflag"
            {
                delete biwoflag__elem_;
                biwoflag__elem_ = nullptr;
                if ( biwoflag() ) {
                    for ( auto* biwoflag__elem_ : *biwoflag() ) {
                        delete biwoflag__elem_;
                        biwoflag__elem_ = nullptr;
                    }
                }
                delete biwoflag_;
            }
            break;
        case ((uint16)769):
            // Clean up "diwoflag"
            {
                delete diwoflag__elem_;
                diwoflag__elem_ = nullptr;
                if ( diwoflag() ) {
                    for ( auto* diwoflag__elem_ : *diwoflag() ) {
                        delete diwoflag__elem_;
                        diwoflag__elem_ = nullptr;
                    }
                }
                delete diwoflag_;
            }
            break;
        case ((uint16)2561):
            // Clean up "bowoflag"
            {
                delete bowoflag__elem_;
                bowoflag__elem_ = nullptr;
                if ( bowoflag() ) {
                    for ( auto* bowoflag__elem_ : *bowoflag() ) {
                        delete bowoflag__elem_;
                        bowoflag__elem_ = nullptr;
                    }
                }
                delete bowoflag_;
            }
            break;
        case ((uint16)3075):
            // Clean up "bocmd_PM"
            {
                delete bocmd_PM__elem_;
                bocmd_PM__elem_ = nullptr;
                if ( bocmd_PM() ) {
                    for ( auto* bocmd_PM__elem_ : *bocmd_PM() ) {
                        delete bocmd_PM__elem_;
                        bocmd_PM__elem_ = nullptr;
                    }
                }
                delete bocmd_PM_;
            }
            break;
        default:
            // Clean up "objects"
            {
                delete objects__elem_;
                objects__elem_ = nullptr;
                if ( objects() ) {
                    for ( auto* objects__elem_ : *objects() ) {
                        delete objects__elem_;
                        objects__elem_ = nullptr;
                    }
                }
                delete objects_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Response_Objects::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Parse "object_header"
    object_header_ = new Object_Header(function_code());
    int t_object_header__size;
    t_object_header__size = object_header_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);

    const_byteptr const t_dataptr_after_object_header = t_begin_of_data + (t_object_header__size);
    BINPAC_ASSERT(t_dataptr_after_object_header <= t_end_of_data);
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( object_header()->object_type_field() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)257):
            // Parse "biwoflag"
            {
                int t_biwoflag__arraylength;
                t_biwoflag__arraylength =  ( object_header()->number_of_item() / 8 )  + 1 *  ( object_header()->number_of_item() >  (  ( object_header()->number_of_item() / 8 )  * 8 )  ) ;
                if ( t_biwoflag__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Response_Objects:biwoflag",
                      t_biwoflag__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Response_Objects:biwoflag
                if ( t_biwoflag__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Response_Objects:biwoflag",
                      t_biwoflag__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                biwoflag__elem_ = nullptr;
                int t_biwoflag__elem__it;
                t_biwoflag__elem__it = 0;
                int t_biwoflag__size;
                biwoflag_ = new vector<Response_Data_Object*>;
                biwoflag_->reserve(t_biwoflag__arraylength);
                const_byteptr t_biwoflag__elem__dataptr = t_dataptr_after_object_header;
                for (; t_biwoflag__elem__it < t_biwoflag__arraylength; ++t_biwoflag__elem__it) {
                    biwoflag__elem_ = new Response_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_biwoflag__elem__size;
                    t_biwoflag__elem__size = biwoflag__elem_->Parse(t_biwoflag__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    biwoflag_->push_back(biwoflag__elem_);
                    t_biwoflag__elem__dataptr += t_biwoflag__elem__size;
                    BINPAC_ASSERT(t_biwoflag__elem__dataptr <= t_end_of_data);
                    biwoflag__elem_ = nullptr;
                }
            end_of_biwoflag: ;
                t_biwoflag__size = t_biwoflag__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_biwoflag__size;
            }
            break;
        case ((uint16)769):
            // Parse "diwoflag"
            {
                int t_diwoflag__arraylength;
                t_diwoflag__arraylength =  ( object_header()->number_of_item() / 8 )  + 1 *  ( object_header()->number_of_item() >  (  ( object_header()->number_of_item() / 8 )  * 8 )  ) ;
                if ( t_diwoflag__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Response_Objects:diwoflag",
                      t_diwoflag__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Response_Objects:diwoflag
                if ( t_diwoflag__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Response_Objects:diwoflag",
                      t_diwoflag__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                diwoflag__elem_ = nullptr;
                int t_diwoflag__elem__it;
                t_diwoflag__elem__it = 0;
                int t_diwoflag__size;
                diwoflag_ = new vector<Response_Data_Object*>;
                diwoflag_->reserve(t_diwoflag__arraylength);
                const_byteptr t_diwoflag__elem__dataptr = t_dataptr_after_object_header;
                for (; t_diwoflag__elem__it < t_diwoflag__arraylength; ++t_diwoflag__elem__it) {
                    diwoflag__elem_ = new Response_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_diwoflag__elem__size;
                    t_diwoflag__elem__size = diwoflag__elem_->Parse(t_diwoflag__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    diwoflag_->push_back(diwoflag__elem_);
                    t_diwoflag__elem__dataptr += t_diwoflag__elem__size;
                    BINPAC_ASSERT(t_diwoflag__elem__dataptr <= t_end_of_data);
                    diwoflag__elem_ = nullptr;
                }
            end_of_diwoflag: ;
                t_diwoflag__size = t_diwoflag__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_diwoflag__size;
            }
            break;
        case ((uint16)2561):
            // Parse "bowoflag"
            {
                int t_bowoflag__arraylength;
                t_bowoflag__arraylength =  ( object_header()->number_of_item() / 8 )  + 1 *  ( object_header()->number_of_item() >  (  ( object_header()->number_of_item() / 8 )  * 8 )  ) ;
                if ( t_bowoflag__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Response_Objects:bowoflag",
                      t_bowoflag__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Response_Objects:bowoflag
                if ( t_bowoflag__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Response_Objects:bowoflag",
                      t_bowoflag__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                bowoflag__elem_ = nullptr;
                int t_bowoflag__elem__it;
                t_bowoflag__elem__it = 0;
                int t_bowoflag__size;
                bowoflag_ = new vector<Response_Data_Object*>;
                bowoflag_->reserve(t_bowoflag__arraylength);
                const_byteptr t_bowoflag__elem__dataptr = t_dataptr_after_object_header;
                for (; t_bowoflag__elem__it < t_bowoflag__arraylength; ++t_bowoflag__elem__it) {
                    bowoflag__elem_ = new Response_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_bowoflag__elem__size;
                    t_bowoflag__elem__size = bowoflag__elem_->Parse(t_bowoflag__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    bowoflag_->push_back(bowoflag__elem_);
                    t_bowoflag__elem__dataptr += t_bowoflag__elem__size;
                    BINPAC_ASSERT(t_bowoflag__elem__dataptr <= t_end_of_data);
                    bowoflag__elem_ = nullptr;
                }
            end_of_bowoflag: ;
                t_bowoflag__size = t_bowoflag__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_bowoflag__size;
            }
            break;
        case ((uint16)3075):
            // Parse "bocmd_PM"
            {
                int t_bocmd_PM__arraylength;
                t_bocmd_PM__arraylength =  ( object_header()->number_of_item() / 8 )  + 1 *  ( object_header()->number_of_item() >  (  ( object_header()->number_of_item() / 8 )  * 8 )  ) ;
                if ( t_bocmd_PM__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Response_Objects:bocmd_PM",
                      t_bocmd_PM__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Response_Objects:bocmd_PM
                if ( t_bocmd_PM__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Response_Objects:bocmd_PM",
                      t_bocmd_PM__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                bocmd_PM__elem_ = nullptr;
                int t_bocmd_PM__elem__it;
                t_bocmd_PM__elem__it = 0;
                int t_bocmd_PM__size;
                bocmd_PM_ = new vector<Response_Data_Object*>;
                bocmd_PM_->reserve(t_bocmd_PM__arraylength);
                const_byteptr t_bocmd_PM__elem__dataptr = t_dataptr_after_object_header;
                for (; t_bocmd_PM__elem__it < t_bocmd_PM__arraylength; ++t_bocmd_PM__elem__it) {
                    bocmd_PM__elem_ = new Response_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_bocmd_PM__elem__size;
                    t_bocmd_PM__elem__size = bocmd_PM__elem_->Parse(t_bocmd_PM__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    bocmd_PM_->push_back(bocmd_PM__elem_);
                    t_bocmd_PM__elem__dataptr += t_bocmd_PM__elem__size;
                    BINPAC_ASSERT(t_bocmd_PM__elem__dataptr <= t_end_of_data);
                    bocmd_PM__elem_ = nullptr;
                }
            end_of_bocmd_PM: ;
                t_bocmd_PM__size = t_bocmd_PM__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_bocmd_PM__size;
            }
            break;
        default:
            // Parse "objects"
            {
                int t_objects__arraylength;
                t_objects__arraylength = object_header()->number_of_item();
                if ( t_objects__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Response_Objects:objects",
                      t_objects__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Response_Objects:objects
                if ( t_objects__arraylength > ((t_end_of_data - t_dataptr_after_object_header) / 1) )
                    throw binpac::ExceptionOutOfBound("Response_Objects:objects",
                      t_objects__arraylength, (t_end_of_data) - (t_dataptr_after_object_header));
                objects__elem_ = nullptr;
                int t_objects__elem__it;
                t_objects__elem__it = 0;
                int t_objects__size;
                objects_ = new vector<Response_Data_Object*>;
                objects_->reserve(t_objects__arraylength);
                const_byteptr t_objects__elem__dataptr = t_dataptr_after_object_header;
                for (; t_objects__elem__it < t_objects__arraylength; ++t_objects__elem__it) {
                    objects__elem_ = new Response_Data_Object(function_code(), object_header()->qualifier_field(), object_header()->object_type_field());
                    int t_objects__elem__size;
                    t_objects__elem__size = objects__elem_->Parse(t_objects__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    objects_->push_back(objects__elem_);
                    t_objects__elem__dataptr += t_objects__elem__size;
                    BINPAC_ASSERT(t_objects__elem__dataptr <= t_end_of_data);
                    objects__elem_ = nullptr;
                }
            end_of_objects: ;
                t_objects__size = t_objects__elem__dataptr - (t_dataptr_after_object_header);
                // Evaluate 'let' and 'withinput' fields
                t_data__size = t_objects__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Response_Objects__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_object_header + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Response_Objects__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Response_Objects__size) <= t_end_of_data);
    return t_Response_Objects__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Object_Header::Object_Header(uint8 function_code) {
    object_type_field_ = 0;
    qualifier_field_ = 0;
    range_field_case_index_ = -1;
    range_field_0_ = nullptr;
    range_field_1_ = nullptr;
    range_field_2_ = nullptr;
    range_field_3_ = nullptr;
    range_field_4_ = nullptr;
    range_field_5_ = nullptr;
    range_field_7_ = 0;
    range_field_8_ = 0;
    range_field_9_ = 0;
    range_field_b_ = 0;
    dump_data_case_index_ = -1;
    function_code_ = function_code;
    number_of_item_ = 0;
    rf_value_low_ = 0;
    rf_value_high_ = 0;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Object_Header::~Object_Header() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( range_field_case_index() ) {
        case ((int)0):
            // Clean up "range_field_0"
            {
                delete range_field_0_;
                range_field_0_ = nullptr;
            }
            break;
        case ((int)1):
            // Clean up "range_field_1"
            {
                delete range_field_1_;
                range_field_1_ = nullptr;
            }
            break;
        case ((int)2):
            // Clean up "range_field_2"
            {
                delete range_field_2_;
                range_field_2_ = nullptr;
            }
            break;
        case ((int)3):
            // Clean up "range_field_3"
            {
                delete range_field_3_;
                range_field_3_ = nullptr;
            }
            break;
        case ((int)4):
            // Clean up "range_field_4"
            {
                delete range_field_4_;
                range_field_4_ = nullptr;
            }
            break;
        case ((int)5):
            // Clean up "range_field_5"
            {
                delete range_field_5_;
                range_field_5_ = nullptr;
            }
            break;
        case ((int)6):
            // Clean up "range_field_6"
            {
            }
            break;
        case ((int)7):
            // Clean up "range_field_7"
            {
            }
            break;
        case ((int)8):
            // Clean up "range_field_8"
            {
            }
            break;
        case ((int)9):
            // Clean up "range_field_9"
            {
            }
            break;
        case ((int)11):
            // Clean up "range_field_b"
            {
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dump_data_case_index() ) {
        case ((int)15360):
            // Clean up "dump_3c"
            {
            }
            break;
        default:
            // Clean up "dump_def"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Object_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Checking out-of-bound for "Object_Header:qualifier_field"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Object_Header:qualifier_field",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "object_type_field"
    object_type_field_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "qualifier_field"
    qualifier_field_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "range_field"
    int t_range_field__size;
    range_field_case_index_ =  ( qualifier_field() & 0x0f ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( range_field_case_index() ) {
        case ((int)0):
            // Parse "range_field_0"
            {
                range_field_0_ = new Range_Field_0();
                range_field_0_->Parse((t_begin_of_data + 3), t_end_of_data);
                t_range_field__size = 2;
            }
            break;
        case ((int)1):
            // Parse "range_field_1"
            {
                range_field_1_ = new Range_Field_1();
                range_field_1_->Parse((t_begin_of_data + 3), t_end_of_data);
                t_range_field__size = 4;
            }
            break;
        case ((int)2):
            // Parse "range_field_2"
            {
                range_field_2_ = new Range_Field_2();
                range_field_2_->Parse((t_begin_of_data + 3), t_end_of_data);
                t_range_field__size = 8;
            }
            break;
        case ((int)3):
            // Parse "range_field_3"
            {
                range_field_3_ = new Range_Field_3();
                range_field_3_->Parse((t_begin_of_data + 3), t_end_of_data);
                t_range_field__size = 2;
            }
            break;
        case ((int)4):
            // Parse "range_field_4"
            {
                range_field_4_ = new Range_Field_4();
                range_field_4_->Parse((t_begin_of_data + 3), t_end_of_data, t_byteorder);
                t_range_field__size = 4;
            }
            break;
        case ((int)5):
            // Parse "range_field_5"
            {
                range_field_5_ = new Range_Field_5();
                range_field_5_->Parse((t_begin_of_data + 3), t_end_of_data, t_byteorder);
                t_range_field__size = 8;
            }
            break;
        case ((int)6):
            // Parse "range_field_6"
            {
                t_range_field__size = 0;
            }
            break;
        case ((int)7):
            // Parse "range_field_7"
            {
                // Checking out-of-bound for "Object_Header:range_field_7"
                if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Object_Header:range_field_7",
                    	(3) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                range_field_7_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));
                t_range_field__size = 1;
            }
            break;
        case ((int)8):
            // Parse "range_field_8"
            {
                // Checking out-of-bound for "Object_Header:range_field_8"
                if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Object_Header:range_field_8",
                    	(3) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                range_field_8_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));
                t_range_field__size = 2;
            }
            break;
        case ((int)9):
            // Parse "range_field_9"
            {
                // Checking out-of-bound for "Object_Header:range_field_9"
                if ( (t_begin_of_data + 3) + (4) > t_end_of_data || (t_begin_of_data + 3) + (4) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Object_Header:range_field_9",
                    	(3) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                range_field_9_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));
                t_range_field__size = 4;
            }
            break;
        case ((int)11):
            // Parse "range_field_b"
            {
                // Checking out-of-bound for "Object_Header:range_field_b"
                if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Object_Header:range_field_b",
                    	(3) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                range_field_b_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));
                t_range_field__size = 1;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - ((t_begin_of_data + 3));
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-protocol.pac:186", t_unknown_string_length);
                unknown_.init((t_begin_of_data + 3), t_unknown_string_length);
                t_range_field__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_range_field = (t_begin_of_data + 3) + (t_range_field__size);
    BINPAC_ASSERT(t_dataptr_after_range_field <= t_end_of_data);
    // Checking out-of-bound for "Object_Header:dump_data"
    if ( t_dataptr_after_range_field + (0) > t_end_of_data || t_dataptr_after_range_field + (0) < t_dataptr_after_range_field ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Object_Header:dump_data",
        	((t_dataptr_after_range_field - t_begin_of_data)) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dump_data"
    dump_data_case_index_ =  ( object_type_field() & 0xff00 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dump_data_case_index() ) {
        case ((int)15360):
            // Parse "dump_3c"
            {
            }
            break;
        default:
            // Parse "dump_def"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Object_Header__size;
    t_Object_Header__size = t_dataptr_after_range_field - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    int t_t_var_001;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch (  ( qualifier_field() & 0x0f )  ) {
        case ((int)0):
            t_t_var_001 =  ( range_field_0()->stop_index() - range_field_0()->start_index() + 1 ) ;
            break;
        case ((int)1):
            t_t_var_001 =  ( range_field_1()->stop_index() - range_field_1()->start_index() + 1 ) ;
            break;
        case ((int)2):
            t_t_var_001 =  ( range_field_2()->stop_index() - range_field_2()->start_index() + 1 ) ;
            break;
        case ((int)7):
            t_t_var_001 = range_field_7();
            break;
        case ((int)8):
            t_t_var_001 =  ( range_field_8() & 0x0ff )  * 0x100 +  ( range_field_8() / 0x100 ) ;
            break;
        case ((int)9):
            t_t_var_001 =  ( range_field_9() & 0x000000ff )  * 0x1000000 +  ( range_field_9() & 0x0000ff00 )  * 0x100 +  ( range_field_9() & 0x00ff0000 )  / 0x100 +  ( range_field_9() & 0xff000000 )  / 0x1000000;
            break;
        case ((int)11):
            t_t_var_001 = range_field_b();
            break;
        default:
            t_t_var_001 = 0;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    number_of_item_ = t_t_var_001;
    int t_t_var_002;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch (  ( qualifier_field() & 0x0f )  ) {
        case ((int)0):
            t_t_var_002 = 0 + range_field_0()->start_index();
            break;
        case ((int)1):
            t_t_var_002 = range_field_1()->start_index();
            break;
        case ((int)2):
            t_t_var_002 = range_field_2()->start_index();
            break;
        case ((int)3):
            t_t_var_002 = range_field_3()->start_addr();
            break;
        case ((int)4):
            t_t_var_002 = range_field_4()->start_addr();
            break;
        case ((int)5):
            t_t_var_002 = range_field_5()->start_addr();
            break;
        case ((int)6):
            t_t_var_002 = 0xffff;
            break;
        case ((int)7):
            t_t_var_002 = range_field_7();
            break;
        case ((int)8):
            t_t_var_002 = range_field_8();
            break;
        case ((int)9):
            t_t_var_002 = range_field_9();
            break;
        case ((int)11):
            t_t_var_002 = range_field_b();
            break;
        default:
            t_t_var_002 = 0;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    rf_value_low_ = t_t_var_002;
    int t_t_var_003;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch (  ( qualifier_field() & 0x0f )  ) {
        case ((int)0):
            t_t_var_003 = 0 + range_field_0()->stop_index();
            break;
        case ((int)1):
            t_t_var_003 = range_field_1()->stop_index();
            break;
        case ((int)2):
            t_t_var_003 = range_field_2()->stop_index();
            break;
        case ((int)3):
            t_t_var_003 = range_field_3()->stop_addr();
            break;
        case ((int)4):
            t_t_var_003 = range_field_4()->stop_addr();
            break;
        case ((int)5):
            t_t_var_003 = range_field_5()->stop_addr();
            break;
        case ((int)6):
            t_t_var_003 = 0xffff;
            break;
        default:
            t_t_var_003 = 0;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    rf_value_high_ = t_t_var_003;
    process_request_ = t_context->flow()->get_dnp3_object_header(object_type_field(), qualifier_field(), number_of_item(), rf_value_low(), rf_value_high());
    BINPAC_ASSERT(t_begin_of_data + (t_Object_Header__size) <= t_end_of_data);
    return t_Object_Header__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_0::Range_Field_0() {
    start_index_ = 0;
    stop_index_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_0::~Range_Field_0() {
}

int Range_Field_0::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Range_Field_0"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_0",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_index"
    start_index_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "stop_index"
    stop_index_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_1::Range_Field_1() {
    start_index_ = 0;
    stop_index_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_1::~Range_Field_1() {
}

int Range_Field_1::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Range_Field_1"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_1",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_index"
    start_index_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "stop_index"
    stop_index_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_2::Range_Field_2() {
    start_index_ = 0;
    stop_index_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_2::~Range_Field_2() {
}

int Range_Field_2::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Range_Field_2"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_2",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_index"
    start_index_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "stop_index"
    stop_index_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_3::Range_Field_3() {
    start_addr_ = 0;
    stop_addr_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_3::~Range_Field_3() {
}

int Range_Field_3::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Range_Field_3"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_3",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_addr"
    start_addr_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "stop_addr"
    stop_addr_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_4::Range_Field_4() {
    start_addr_ = 0;
    stop_addr_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_4::~Range_Field_4() {
}

int Range_Field_4::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "Range_Field_4"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_4",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_addr"
    start_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "stop_addr"
    stop_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_5::Range_Field_5() {
    start_addr_ = 0;
    stop_addr_ = 0;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Range_Field_5::~Range_Field_5() {
}

int Range_Field_5::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "Range_Field_5"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Range_Field_5",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "start_addr"
    start_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "stop_addr"
    stop_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Prefix_Type::Prefix_Type(uint8 qualifier_field) {
    prefix_case_index_ = -1;
    prefix8_ = 0;
    prefix16_ = 0;
    prefix32_ = 0;
    object_size8_ = 0;
    object_size16_ = 0;
    object_size32_ = 0;
    qualifier_field_ = qualifier_field;
    byteorder_ = littleendian;
    prefix_value_ = 0;
    prefix_called_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Prefix_Type::~Prefix_Type() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( prefix_case_index() ) {
        case ((int)0):
            // Clean up "none"
            {
            }
            break;
        case ((int)16):
            // Clean up "prefix8"
            {
            }
            break;
        case ((int)32):
            // Clean up "prefix16"
            {
            }
            break;
        case ((int)48):
            // Clean up "prefix32"
            {
            }
            break;
        case ((int)64):
            // Clean up "object_size8"
            {
            }
            break;
        case ((int)80):
            // Clean up "object_size16"
            {
            }
            break;
        case ((int)96):
            // Clean up "object_size32"
            {
            }
            break;
        default:
            // Clean up "unknownprefix"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Prefix_Type::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Parse "prefix"
    int t_prefix__size;
    prefix_case_index_ =  ( qualifier_field() & 0xf0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( prefix_case_index() ) {
        case ((int)0):
            // Parse "none"
            {
                t_prefix__size = 0;
            }
            break;
        case ((int)16):
            // Parse "prefix8"
            {
                // Checking out-of-bound for "Prefix_Type:prefix8"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:prefix8",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                prefix8_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
                t_prefix__size = 1;
            }
            break;
        case ((int)32):
            // Parse "prefix16"
            {
                // Checking out-of-bound for "Prefix_Type:prefix16"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:prefix16",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                prefix16_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_prefix__size = 2;
            }
            break;
        case ((int)48):
            // Parse "prefix32"
            {
                // Checking out-of-bound for "Prefix_Type:prefix32"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:prefix32",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                prefix32_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_prefix__size = 4;
            }
            break;
        case ((int)64):
            // Parse "object_size8"
            {
                // Checking out-of-bound for "Prefix_Type:object_size8"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:object_size8",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                object_size8_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
                t_prefix__size = 1;
            }
            break;
        case ((int)80):
            // Parse "object_size16"
            {
                // Checking out-of-bound for "Prefix_Type:object_size16"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:object_size16",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                object_size16_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
                t_prefix__size = 2;
            }
            break;
        case ((int)96):
            // Parse "object_size32"
            {
                // Checking out-of-bound for "Prefix_Type:object_size32"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Prefix_Type:object_size32",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                object_size32_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
                t_prefix__size = 4;
            }
            break;
        default:
            // Parse "unknownprefix"
            {
                t_prefix__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Prefix_Type__size;
    const_byteptr const t_dataptr_after_prefix = t_begin_of_data + (t_prefix__size);
    BINPAC_ASSERT(t_dataptr_after_prefix <= t_end_of_data);
    t_Prefix_Type__size = t_dataptr_after_prefix - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    int t_t_var_004;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch (  ( qualifier_field() & 0xf0 )  ) {
        case ((int)0):
            t_t_var_004 = 0;
            break;
        case ((int)16):
            t_t_var_004 = prefix8();
            break;
        case ((int)32):
            t_t_var_004 = prefix16();
            break;
        case ((int)48):
            t_t_var_004 = prefix32();
            break;
        case ((int)64):
            t_t_var_004 = object_size8();
            break;
        case ((int)80):
            t_t_var_004 = object_size16();
            break;
        case ((int)96):
            t_t_var_004 = object_size32();
            break;
        default:
            t_t_var_004 = 0x0;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    prefix_value_ = t_t_var_004;
    prefix_called_ = t_context->flow()->get_dnp3_object_prefix(prefix_value());
    BINPAC_ASSERT(t_begin_of_data + (t_Prefix_Type__size) <= t_end_of_data);
    return t_Prefix_Type__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Request_Data_Object::Request_Data_Object(uint8 function_code, uint8 qualifier_field, uint16 object_type_field) {
    prefix_ = nullptr;
    data_case_index_ = -1;
    attrib211_ = nullptr;
    attrib212_ = nullptr;
    attrib213_ = nullptr;
    attrib214_ = nullptr;
    attrib215_ = nullptr;
    attrib216_ = nullptr;
    attrib217_ = nullptr;
    attrib218_ = nullptr;
    attrib219_ = nullptr;
    attrib220_ = nullptr;
    attrib221_ = nullptr;
    attrib222_ = nullptr;
    attrib223_ = nullptr;
    attrib224_ = nullptr;
    attrib225_ = nullptr;
    attrib226_ = nullptr;
    attrib227_ = nullptr;
    attrib228_ = nullptr;
    attrib229_ = nullptr;
    attrib230_ = nullptr;
    attrib231_ = nullptr;
    attrib232_ = nullptr;
    attrib233_ = nullptr;
    attrib234_ = nullptr;
    attrib235_ = nullptr;
    attrib236_ = nullptr;
    attrib237_ = nullptr;
    attrib238_ = nullptr;
    attrib239_ = nullptr;
    attrib240_ = nullptr;
    attrib241_ = nullptr;
    attrib242_ = nullptr;
    attrib243_ = nullptr;
    attrib245_ = nullptr;
    attrib246_ = nullptr;
    attrib247_ = nullptr;
    attrib248_ = nullptr;
    attrib249_ = nullptr;
    attrib250_ = nullptr;
    attrib252_ = nullptr;
    attrib254_ = nullptr;
    attrib255_ = nullptr;
    bocmd_CROB_ = nullptr;
    bocmd_PCB_ = nullptr;
    bocmd_PM_ = 0;
    time_abs_ = nullptr;
    time_interval_ = nullptr;
    time_abs_last_ = nullptr;
    time_abs_sync_ = nullptr;
    time_abs_unsync_ = nullptr;
    time_coarse_ = 0;
    time_fine_ = 0;
    file_control_id_ = nullptr;
    file_control_auth_ = nullptr;
    file_control_cmd_ = nullptr;
    file_control_cmd_status_ = nullptr;
    file_trans_ = nullptr;
    file_trans_status_ = nullptr;
    file_desc_ = nullptr;
    priregobj_ = nullptr;
    priregobjdesc_ = nullptr;
    desc_ele_ = nullptr;
    desc_ele86_ = nullptr;
    cha_ = 0;
    point_index_attr_ = nullptr;
    present_value_ = nullptr;
    snapshot_ = nullptr;
    activate_conf_ = nullptr;
    bcd_small_ = 0;
    bcd_medium_ = 0;
    bcd_large_ = nullptr;
    unsigned_integer_ = 0;
    challenge_ = nullptr;
    reply_ = nullptr;
    aggrRequest_ = nullptr;
    sessionKeyRequest_ = 0;
    status_ = nullptr;
    keyChange_ = nullptr;
    error_ = nullptr;
    user_cert_ = nullptr;
    mac_ = nullptr;
    user_status_change_ = nullptr;
    update_key_req_ = nullptr;
    update_key_rep_ = nullptr;
    update_key_ = nullptr;
    update_key_sig_ = nullptr;
    update_key_con_ = nullptr;
    unmatched_ = nullptr;
    function_code_ = function_code;
    qualifier_field_ = qualifier_field;
    object_type_field_ = object_type_field;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Request_Data_Object::~Request_Data_Object() {
    delete prefix_;
    prefix_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)211):
            // Clean up "attrib211"
            {
                delete attrib211_;
                attrib211_ = nullptr;
            }
            break;
        case ((uint16)212):
            // Clean up "attrib212"
            {
                delete attrib212_;
                attrib212_ = nullptr;
            }
            break;
        case ((uint16)213):
            // Clean up "attrib213"
            {
                delete attrib213_;
                attrib213_ = nullptr;
            }
            break;
        case ((uint16)214):
            // Clean up "attrib214"
            {
                delete attrib214_;
                attrib214_ = nullptr;
            }
            break;
        case ((uint16)215):
            // Clean up "attrib215"
            {
                delete attrib215_;
                attrib215_ = nullptr;
            }
            break;
        case ((uint16)216):
            // Clean up "attrib216"
            {
                delete attrib216_;
                attrib216_ = nullptr;
            }
            break;
        case ((uint16)217):
            // Clean up "attrib217"
            {
                delete attrib217_;
                attrib217_ = nullptr;
            }
            break;
        case ((uint16)218):
            // Clean up "attrib218"
            {
                delete attrib218_;
                attrib218_ = nullptr;
            }
            break;
        case ((uint16)219):
            // Clean up "attrib219"
            {
                delete attrib219_;
                attrib219_ = nullptr;
            }
            break;
        case ((uint16)220):
            // Clean up "attrib220"
            {
                delete attrib220_;
                attrib220_ = nullptr;
            }
            break;
        case ((uint16)221):
            // Clean up "attrib221"
            {
                delete attrib221_;
                attrib221_ = nullptr;
            }
            break;
        case ((uint16)222):
            // Clean up "attrib222"
            {
                delete attrib222_;
                attrib222_ = nullptr;
            }
            break;
        case ((uint16)223):
            // Clean up "attrib223"
            {
                delete attrib223_;
                attrib223_ = nullptr;
            }
            break;
        case ((uint16)224):
            // Clean up "attrib224"
            {
                delete attrib224_;
                attrib224_ = nullptr;
            }
            break;
        case ((uint16)225):
            // Clean up "attrib225"
            {
                delete attrib225_;
                attrib225_ = nullptr;
            }
            break;
        case ((uint16)226):
            // Clean up "attrib226"
            {
                delete attrib226_;
                attrib226_ = nullptr;
            }
            break;
        case ((uint16)227):
            // Clean up "attrib227"
            {
                delete attrib227_;
                attrib227_ = nullptr;
            }
            break;
        case ((uint16)228):
            // Clean up "attrib228"
            {
                delete attrib228_;
                attrib228_ = nullptr;
            }
            break;
        case ((uint16)229):
            // Clean up "attrib229"
            {
                delete attrib229_;
                attrib229_ = nullptr;
            }
            break;
        case ((uint16)230):
            // Clean up "attrib230"
            {
                delete attrib230_;
                attrib230_ = nullptr;
            }
            break;
        case ((uint16)231):
            // Clean up "attrib231"
            {
                delete attrib231_;
                attrib231_ = nullptr;
            }
            break;
        case ((uint16)232):
            // Clean up "attrib232"
            {
                delete attrib232_;
                attrib232_ = nullptr;
            }
            break;
        case ((uint16)233):
            // Clean up "attrib233"
            {
                delete attrib233_;
                attrib233_ = nullptr;
            }
            break;
        case ((uint16)234):
            // Clean up "attrib234"
            {
                delete attrib234_;
                attrib234_ = nullptr;
            }
            break;
        case ((uint16)235):
            // Clean up "attrib235"
            {
                delete attrib235_;
                attrib235_ = nullptr;
            }
            break;
        case ((uint16)236):
            // Clean up "attrib236"
            {
                delete attrib236_;
                attrib236_ = nullptr;
            }
            break;
        case ((uint16)237):
            // Clean up "attrib237"
            {
                delete attrib237_;
                attrib237_ = nullptr;
            }
            break;
        case ((uint16)238):
            // Clean up "attrib238"
            {
                delete attrib238_;
                attrib238_ = nullptr;
            }
            break;
        case ((uint16)239):
            // Clean up "attrib239"
            {
                delete attrib239_;
                attrib239_ = nullptr;
            }
            break;
        case ((uint16)240):
            // Clean up "attrib240"
            {
                delete attrib240_;
                attrib240_ = nullptr;
            }
            break;
        case ((uint16)241):
            // Clean up "attrib241"
            {
                delete attrib241_;
                attrib241_ = nullptr;
            }
            break;
        case ((uint16)242):
            // Clean up "attrib242"
            {
                delete attrib242_;
                attrib242_ = nullptr;
            }
            break;
        case ((uint16)243):
            // Clean up "attrib243"
            {
                delete attrib243_;
                attrib243_ = nullptr;
            }
            break;
        case ((uint16)245):
            // Clean up "attrib245"
            {
                delete attrib245_;
                attrib245_ = nullptr;
            }
            break;
        case ((uint16)246):
            // Clean up "attrib246"
            {
                delete attrib246_;
                attrib246_ = nullptr;
            }
            break;
        case ((uint16)247):
            // Clean up "attrib247"
            {
                delete attrib247_;
                attrib247_ = nullptr;
            }
            break;
        case ((uint16)248):
            // Clean up "attrib248"
            {
                delete attrib248_;
                attrib248_ = nullptr;
            }
            break;
        case ((uint16)249):
            // Clean up "attrib249"
            {
                delete attrib249_;
                attrib249_ = nullptr;
            }
            break;
        case ((uint16)250):
            // Clean up "attrib250"
            {
                delete attrib250_;
                attrib250_ = nullptr;
            }
            break;
        case ((uint16)252):
            // Clean up "attrib252"
            {
                delete attrib252_;
                attrib252_ = nullptr;
            }
            break;
        case ((uint16)254):
            // Clean up "attrib254"
            {
                delete attrib254_;
                attrib254_ = nullptr;
            }
            break;
        case ((uint16)255):
            // Clean up "attrib255"
            {
                delete attrib255_;
                attrib255_ = nullptr;
            }
            break;
        case ((uint16)256):
            // Clean up "bi_default"
            {
            }
            break;
        case ((uint16)257):
            // Clean up "bi_packed"
            {
            }
            break;
        case ((uint16)258):
            // Clean up "bi_flag"
            {
            }
            break;
        case ((uint16)512):
            // Clean up "biedefault"
            {
            }
            break;
        case ((uint16)513):
            // Clean up "biewotime"
            {
            }
            break;
        case ((uint16)514):
            // Clean up "biewatime"
            {
            }
            break;
        case ((uint16)515):
            // Clean up "biewrtime"
            {
            }
            break;
        case ((uint16)768):
            // Clean up "dbiDefault"
            {
            }
            break;
        case ((uint16)769):
            // Clean up "dbibytes"
            {
            }
            break;
        case ((uint16)770):
            // Clean up "dbiflag"
            {
            }
            break;
        case ((uint16)1024):
            // Clean up "dbieDefault"
            {
            }
            break;
        case ((uint16)1025):
            // Clean up "dbieatime"
            {
            }
            break;
        case ((uint16)1026):
            // Clean up "dbiertime"
            {
            }
            break;
        case ((uint16)2560):
            // Clean up "boDefault"
            {
            }
            break;
        case ((uint16)2561):
            // Clean up "bowoflag"
            {
            }
            break;
        case ((uint16)2562):
            // Clean up "bowflag"
            {
            }
            break;
        case ((uint16)2816):
            // Clean up "bowDefault"
            {
            }
            break;
        case ((uint16)2817):
            // Clean up "boewflag"
            {
            }
            break;
        case ((uint16)2818):
            // Clean up "boewatime"
            {
            }
            break;
        case ((uint16)3073):
            // Clean up "bocmd_CROB"
            {
                delete bocmd_CROB_;
                bocmd_CROB_ = nullptr;
            }
            break;
        case ((uint16)3074):
            // Clean up "bocmd_PCB"
            {
                delete bocmd_PCB_;
                bocmd_PCB_ = nullptr;
            }
            break;
        case ((uint16)3075):
            // Clean up "bocmd_PM"
            {
            }
            break;
        case ((uint16)3328):
            // Clean up "boceDefault"
            {
            }
            break;
        case ((uint16)3329):
            // Clean up "boceFlag"
            {
            }
            break;
        case ((uint16)3330):
            // Clean up "boceAtime"
            {
            }
            break;
        case ((uint16)5120):
            // Clean up "counter_default"
            {
            }
            break;
        case ((uint16)5121):
            // Clean up "counter_32_wflag"
            {
            }
            break;
        case ((uint16)5122):
            // Clean up "counter_16_wflag"
            {
            }
            break;
        case ((uint16)5123):
            // Clean up "counter_32_wflag_delta"
            {
            }
            break;
        case ((uint16)5124):
            // Clean up "counter_16_wflag_delta"
            {
            }
            break;
        case ((uint16)5125):
            // Clean up "counter_32_woflag"
            {
            }
            break;
        case ((uint16)5126):
            // Clean up "counter_16_woflag"
            {
            }
            break;
        case ((uint16)5127):
            // Clean up "counter_32_woflag_delta"
            {
            }
            break;
        case ((uint16)5128):
            // Clean up "counter_16_woflag_delta"
            {
            }
            break;
        case ((uint16)5376):
            // Clean up "f_counter_default"
            {
            }
            break;
        case ((uint16)5377):
            // Clean up "f_counter_32_wflag"
            {
            }
            break;
        case ((uint16)5378):
            // Clean up "f_counter_16_wflag"
            {
            }
            break;
        case ((uint16)5379):
            // Clean up "f_counter_32_wflag_delta"
            {
            }
            break;
        case ((uint16)5380):
            // Clean up "f_counter_16_wflag_delta"
            {
            }
            break;
        case ((uint16)5381):
            // Clean up "f_counter_32_wflag_time"
            {
            }
            break;
        case ((uint16)5382):
            // Clean up "f_counter_16_wflag_time"
            {
            }
            break;
        case ((uint16)5383):
            // Clean up "f_counter_32_wflag_time_delta"
            {
            }
            break;
        case ((uint16)5384):
            // Clean up "f_counter_16_wflag_time_delta"
            {
            }
            break;
        case ((uint16)5385):
            // Clean up "f_counter_32_woflag"
            {
            }
            break;
        case ((uint16)5386):
            // Clean up "f_counter_16_woflag"
            {
            }
            break;
        case ((uint16)5387):
            // Clean up "f_counter_32_woflag_delta"
            {
            }
            break;
        case ((uint16)5388):
            // Clean up "f_counter_16_woflag_delta"
            {
            }
            break;
        case ((uint16)5632):
            // Clean up "counter_event_default"
            {
            }
            break;
        case ((uint16)5633):
            // Clean up "counter_event_32_wflag"
            {
            }
            break;
        case ((uint16)5634):
            // Clean up "counter_event_16_wflag"
            {
            }
            break;
        case ((uint16)5635):
            // Clean up "counter_event_32_wflag_delta"
            {
            }
            break;
        case ((uint16)5636):
            // Clean up "counter_event_16_wflag_delta"
            {
            }
            break;
        case ((uint16)5637):
            // Clean up "counter_event_32_wflag_time"
            {
            }
            break;
        case ((uint16)5638):
            // Clean up "counter_event_16_wflag_time"
            {
            }
            break;
        case ((uint16)5639):
            // Clean up "counter_event_32_wflag_time_delta"
            {
            }
            break;
        case ((uint16)5640):
            // Clean up "counter_event_16_wflag_time_delat"
            {
            }
            break;
        case ((uint16)5888):
            // Clean up "f_counter_event_default"
            {
            }
            break;
        case ((uint16)5889):
            // Clean up "f_counter_event_32_wflag"
            {
            }
            break;
        case ((uint16)5890):
            // Clean up "f_counter_event_16_wflag"
            {
            }
            break;
        case ((uint16)5891):
            // Clean up "f_counter_event_32_wflag_delta"
            {
            }
            break;
        case ((uint16)5892):
            // Clean up "f_counter_event_16_wflag_delta"
            {
            }
            break;
        case ((uint16)5893):
            // Clean up "f_counter_event_32_wflag_time"
            {
            }
            break;
        case ((uint16)5894):
            // Clean up "f_counter_event_16_wflag_time"
            {
            }
            break;
        case ((uint16)5895):
            // Clean up "f_counter_event_32_wflag_time_delta"
            {
            }
            break;
        case ((uint16)5896):
            // Clean up "f_counter_event_16_wflag_time_delat"
            {
            }
            break;
        case ((uint16)7680):
            // Clean up "ai_default"
            {
            }
            break;
        case ((uint16)7681):
            // Clean up "ai_32_wflag"
            {
            }
            break;
        case ((uint16)7682):
            // Clean up "ai_16_wflag"
            {
            }
            break;
        case ((uint16)7683):
            // Clean up "ai_32_woflag"
            {
            }
            break;
        case ((uint16)7684):
            // Clean up "ai_16_woflag"
            {
            }
            break;
        case ((uint16)7685):
            // Clean up "ai_sp_wflag"
            {
            }
            break;
        case ((uint16)7686):
            // Clean up "ai_dp_wflag"
            {
            }
            break;
        case ((uint16)7936):
            // Clean up "f_ai_default"
            {
            }
            break;
        case ((uint16)7937):
            // Clean up "f_ai_32_wflag"
            {
            }
            break;
        case ((uint16)7938):
            // Clean up "f_ai_16_wflag"
            {
            }
            break;
        case ((uint16)7939):
            // Clean up "f_ai_32_wtime"
            {
            }
            break;
        case ((uint16)7940):
            // Clean up "f_ai_16_wtime"
            {
            }
            break;
        case ((uint16)7941):
            // Clean up "f_ai_32_woflag"
            {
            }
            break;
        case ((uint16)7942):
            // Clean up "f_ai_16_woflag"
            {
            }
            break;
        case ((uint16)7943):
            // Clean up "f_ai_sp_wflag"
            {
            }
            break;
        case ((uint16)7944):
            // Clean up "f_ai_dp_wflag"
            {
            }
            break;
        case ((uint16)8192):
            // Clean up "aie_default"
            {
            }
            break;
        case ((uint16)8193):
            // Clean up "ai32wotime"
            {
            }
            break;
        case ((uint16)8194):
            // Clean up "ai16wotime"
            {
            }
            break;
        case ((uint16)8195):
            // Clean up "ai32wtime"
            {
            }
            break;
        case ((uint16)8196):
            // Clean up "ai16wtime"
            {
            }
            break;
        case ((uint16)8197):
            // Clean up "aispwotime"
            {
            }
            break;
        case ((uint16)8198):
            // Clean up "aidpwotime"
            {
            }
            break;
        case ((uint16)8199):
            // Clean up "aispwtime"
            {
            }
            break;
        case ((uint16)8200):
            // Clean up "aidpwtime"
            {
            }
            break;
        case ((uint16)8448):
            // Clean up "f_aie_default"
            {
            }
            break;
        case ((uint16)8449):
            // Clean up "f_aie_32_wotime"
            {
            }
            break;
        case ((uint16)8450):
            // Clean up "f_aie_16_wotime"
            {
            }
            break;
        case ((uint16)8451):
            // Clean up "f_aie_32_wtime"
            {
            }
            break;
        case ((uint16)8452):
            // Clean up "f_aie_16_wtime"
            {
            }
            break;
        case ((uint16)8453):
            // Clean up "f_aie_sp_wotime"
            {
            }
            break;
        case ((uint16)8454):
            // Clean up "f_aie_dp_wotime"
            {
            }
            break;
        case ((uint16)8455):
            // Clean up "f_aie_sp_wtime"
            {
            }
            break;
        case ((uint16)8456):
            // Clean up "f_aie_dp_wtime"
            {
            }
            break;
        case ((uint16)8704):
            // Clean up "ai_dead"
            {
            }
            break;
        case ((uint16)8705):
            // Clean up "ai_dead_16"
            {
            }
            break;
        case ((uint16)8706):
            // Clean up "ai_dead_32"
            {
            }
            break;
        case ((uint16)8707):
            // Clean up "ai_dead_sp"
            {
            }
            break;
        case ((uint16)10240):
            // Clean up "aos_default"
            {
            }
            break;
        case ((uint16)10241):
            // Clean up "aos_32"
            {
            }
            break;
        case ((uint16)10242):
            // Clean up "aos_16"
            {
            }
            break;
        case ((uint16)10243):
            // Clean up "aos_sp"
            {
            }
            break;
        case ((uint16)10244):
            // Clean up "aos_dp"
            {
            }
            break;
        case ((uint16)10497):
            // Clean up "ao_32"
            {
            }
            break;
        case ((uint16)10498):
            // Clean up "ao_16"
            {
            }
            break;
        case ((uint16)10499):
            // Clean up "ao_sp"
            {
            }
            break;
        case ((uint16)10500):
            // Clean up "ao_dp"
            {
            }
            break;
        case ((uint16)10752):
            // Clean up "aoe_default"
            {
            }
            break;
        case ((uint16)10753):
            // Clean up "aoe32wotime"
            {
            }
            break;
        case ((uint16)10754):
            // Clean up "aoe16wotime"
            {
            }
            break;
        case ((uint16)10755):
            // Clean up "aoe32wtime"
            {
            }
            break;
        case ((uint16)10756):
            // Clean up "aoe16wtime"
            {
            }
            break;
        case ((uint16)10757):
            // Clean up "aoespwotime"
            {
            }
            break;
        case ((uint16)10758):
            // Clean up "aoedpwotime"
            {
            }
            break;
        case ((uint16)10759):
            // Clean up "aoespwtime"
            {
            }
            break;
        case ((uint16)10760):
            // Clean up "aoedpwtime"
            {
            }
            break;
        case ((uint16)11008):
            // Clean up "aoce_default"
            {
            }
            break;
        case ((uint16)11009):
            // Clean up "aoce32wotime"
            {
            }
            break;
        case ((uint16)11010):
            // Clean up "aoce16wotime"
            {
            }
            break;
        case ((uint16)11011):
            // Clean up "aoce32wtime"
            {
            }
            break;
        case ((uint16)11012):
            // Clean up "aoce16wtime"
            {
            }
            break;
        case ((uint16)11013):
            // Clean up "aocespwotime"
            {
            }
            break;
        case ((uint16)11014):
            // Clean up "aocedpwotime"
            {
            }
            break;
        case ((uint16)11015):
            // Clean up "aocespwtime"
            {
            }
            break;
        case ((uint16)11016):
            // Clean up "aocedpwtime"
            {
            }
            break;
        case ((uint16)12800):
            // Clean up "time_default"
            {
            }
            break;
        case ((uint16)12801):
            // Clean up "time_abs"
            {
                delete time_abs_;
                time_abs_ = nullptr;
            }
            break;
        case ((uint16)12802):
            // Clean up "time_interval"
            {
                delete time_interval_;
                time_interval_ = nullptr;
            }
            break;
        case ((uint16)12803):
            // Clean up "time_abs_last"
            {
                delete time_abs_last_;
                time_abs_last_ = nullptr;
            }
            break;
        case ((uint16)13057):
            // Clean up "time_abs_sync"
            {
                delete time_abs_sync_;
                time_abs_sync_ = nullptr;
            }
            break;
        case ((uint16)13058):
            // Clean up "time_abs_unsync"
            {
                delete time_abs_unsync_;
                time_abs_unsync_ = nullptr;
            }
            break;
        case ((uint16)13313):
            // Clean up "time_coarse"
            {
            }
            break;
        case ((uint16)13314):
            // Clean up "time_fine"
            {
            }
            break;
        case ((uint16)15361):
            // Clean up "class0data"
            {
            }
            break;
        case ((uint16)15362):
            // Clean up "class1data"
            {
            }
            break;
        case ((uint16)15363):
            // Clean up "class2data"
            {
            }
            break;
        case ((uint16)15364):
            // Clean up "class3data"
            {
            }
            break;
        case ((uint16)17921):
            // Clean up "file_control_id"
            {
                delete file_control_id_;
                file_control_id_ = nullptr;
            }
            break;
        case ((uint16)17922):
            // Clean up "file_control_auth"
            {
                delete file_control_auth_;
                file_control_auth_ = nullptr;
            }
            break;
        case ((uint16)17923):
            // Clean up "file_control_cmd"
            {
                delete file_control_cmd_;
                file_control_cmd_ = nullptr;
            }
            break;
        case ((uint16)17924):
            // Clean up "file_control_cmd_status"
            {
                delete file_control_cmd_status_;
                file_control_cmd_status_ = nullptr;
            }
            break;
        case ((uint16)17925):
            // Clean up "file_trans"
            {
                delete file_trans_;
                file_trans_ = nullptr;
            }
            break;
        case ((uint16)17926):
            // Clean up "file_trans_status"
            {
                delete file_trans_status_;
                file_trans_status_ = nullptr;
            }
            break;
        case ((uint16)17927):
            // Clean up "file_desc"
            {
                delete file_desc_;
                file_desc_ = nullptr;
            }
            break;
        case ((uint16)20481):
            // Clean up "iin"
            {
                iin_.free();
            }
            break;
        case ((uint16)20737):
            // Clean up "dev_store"
            {
            }
            break;
        case ((uint16)20993):
            // Clean up "dev_profile"
            {
            }
            break;
        case ((uint16)21249):
            // Clean up "priregobj"
            {
                delete priregobj_;
                priregobj_ = nullptr;
            }
            break;
        case ((uint16)21250):
            // Clean up "priregobjdesc"
            {
                delete priregobjdesc_;
                priregobjdesc_ = nullptr;
            }
            break;
        case ((uint16)21761):
            // Clean up "desc_ele"
            {
                delete desc_ele_;
                desc_ele_ = nullptr;
            }
            break;
        case ((uint16)22017):
            // Clean up "desc_ele86"
            {
                delete desc_ele86_;
                desc_ele86_ = nullptr;
            }
            break;
        case ((uint16)22018):
            // Clean up "cha"
            {
            }
            break;
        case ((uint16)22019):
            // Clean up "point_index_attr"
            {
                delete point_index_attr_;
                point_index_attr_ = nullptr;
            }
            break;
        case ((uint16)22273):
            // Clean up "present_value"
            {
                delete present_value_;
                present_value_ = nullptr;
            }
            break;
        case ((uint16)22529):
            // Clean up "snapshot"
            {
                delete snapshot_;
                snapshot_ = nullptr;
            }
            break;
        case ((uint16)23297):
            // Clean up "activate_conf"
            {
                delete activate_conf_;
                activate_conf_ = nullptr;
            }
            break;
        case ((uint16)25857):
            // Clean up "bcd_small"
            {
            }
            break;
        case ((uint16)25858):
            // Clean up "bcd_medium"
            {
            }
            break;
        case ((uint16)25859):
            // Clean up "bcd_large"
            {
                delete bcd_large_;
                bcd_large_ = nullptr;
            }
            break;
        case ((uint16)26113):
            // Clean up "unsigned_integer"
            {
            }
            break;
        case ((uint16)30721):
            // Clean up "challenge"
            {
                delete challenge_;
                challenge_ = nullptr;
            }
            break;
        case ((uint16)30722):
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
        case ((uint16)30723):
            // Clean up "aggrRequest"
            {
                delete aggrRequest_;
                aggrRequest_ = nullptr;
            }
            break;
        case ((uint16)30724):
            // Clean up "sessionKeyRequest"
            {
            }
            break;
        case ((uint16)30725):
            // Clean up "status"
            {
                delete status_;
                status_ = nullptr;
            }
            break;
        case ((uint16)30726):
            // Clean up "keyChange"
            {
                delete keyChange_;
                keyChange_ = nullptr;
            }
            break;
        case ((uint16)30727):
            // Clean up "error"
            {
                delete error_;
                error_ = nullptr;
            }
            break;
        case ((uint16)30728):
            // Clean up "user_cert"
            {
                delete user_cert_;
                user_cert_ = nullptr;
            }
            break;
        case ((uint16)30729):
            // Clean up "mac"
            {
                delete mac_;
                mac_ = nullptr;
            }
            break;
        case ((uint16)30730):
            // Clean up "user_status_change"
            {
                delete user_status_change_;
                user_status_change_ = nullptr;
            }
            break;
        case ((uint16)30731):
            // Clean up "update_key_req"
            {
                delete update_key_req_;
                update_key_req_ = nullptr;
            }
            break;
        case ((uint16)30732):
            // Clean up "update_key_rep"
            {
                delete update_key_rep_;
                update_key_rep_ = nullptr;
            }
            break;
        case ((uint16)30733):
            // Clean up "update_key"
            {
                delete update_key_;
                update_key_ = nullptr;
            }
            break;
        case ((uint16)30734):
            // Clean up "update_key_sig"
            {
                delete update_key_sig_;
                update_key_sig_ = nullptr;
            }
            break;
        case ((uint16)30735):
            // Clean up "update_key_con"
            {
                delete update_key_con_;
                update_key_con_ = nullptr;
            }
            break;
        default:
            // Clean up "unmatched"
            {
                delete unmatched_;
                unmatched_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Request_Data_Object::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Parse "prefix"
    prefix_ = new Prefix_Type(qualifier_field());
    int t_prefix__size;
    t_prefix__size = prefix_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_prefix = t_begin_of_data + (t_prefix__size);
    BINPAC_ASSERT(t_dataptr_after_prefix <= t_end_of_data);
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( object_type_field() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)211):
            // Parse "attrib211"
            {
                attrib211_ = new AttributeCommon();
                int t_attrib211__size;
                t_attrib211__size = attrib211_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib211__size;
            }
            break;
        case ((uint16)212):
            // Parse "attrib212"
            {
                attrib212_ = new AttributeCommon();
                int t_attrib212__size;
                t_attrib212__size = attrib212_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib212__size;
            }
            break;
        case ((uint16)213):
            // Parse "attrib213"
            {
                attrib213_ = new AttributeCommon();
                int t_attrib213__size;
                t_attrib213__size = attrib213_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib213__size;
            }
            break;
        case ((uint16)214):
            // Parse "attrib214"
            {
                attrib214_ = new AttributeCommon();
                int t_attrib214__size;
                t_attrib214__size = attrib214_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib214__size;
            }
            break;
        case ((uint16)215):
            // Parse "attrib215"
            {
                attrib215_ = new AttributeCommon();
                int t_attrib215__size;
                t_attrib215__size = attrib215_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib215__size;
            }
            break;
        case ((uint16)216):
            // Parse "attrib216"
            {
                attrib216_ = new AttributeCommon();
                int t_attrib216__size;
                t_attrib216__size = attrib216_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib216__size;
            }
            break;
        case ((uint16)217):
            // Parse "attrib217"
            {
                attrib217_ = new AttributeCommon();
                int t_attrib217__size;
                t_attrib217__size = attrib217_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib217__size;
            }
            break;
        case ((uint16)218):
            // Parse "attrib218"
            {
                attrib218_ = new AttributeCommon();
                int t_attrib218__size;
                t_attrib218__size = attrib218_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib218__size;
            }
            break;
        case ((uint16)219):
            // Parse "attrib219"
            {
                attrib219_ = new AttributeCommon();
                int t_attrib219__size;
                t_attrib219__size = attrib219_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib219__size;
            }
            break;
        case ((uint16)220):
            // Parse "attrib220"
            {
                attrib220_ = new AttributeCommon();
                int t_attrib220__size;
                t_attrib220__size = attrib220_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib220__size;
            }
            break;
        case ((uint16)221):
            // Parse "attrib221"
            {
                attrib221_ = new AttributeCommon();
                int t_attrib221__size;
                t_attrib221__size = attrib221_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib221__size;
            }
            break;
        case ((uint16)222):
            // Parse "attrib222"
            {
                attrib222_ = new AttributeCommon();
                int t_attrib222__size;
                t_attrib222__size = attrib222_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib222__size;
            }
            break;
        case ((uint16)223):
            // Parse "attrib223"
            {
                attrib223_ = new AttributeCommon();
                int t_attrib223__size;
                t_attrib223__size = attrib223_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib223__size;
            }
            break;
        case ((uint16)224):
            // Parse "attrib224"
            {
                attrib224_ = new AttributeCommon();
                int t_attrib224__size;
                t_attrib224__size = attrib224_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib224__size;
            }
            break;
        case ((uint16)225):
            // Parse "attrib225"
            {
                attrib225_ = new AttributeCommon();
                int t_attrib225__size;
                t_attrib225__size = attrib225_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib225__size;
            }
            break;
        case ((uint16)226):
            // Parse "attrib226"
            {
                attrib226_ = new AttributeCommon();
                int t_attrib226__size;
                t_attrib226__size = attrib226_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib226__size;
            }
            break;
        case ((uint16)227):
            // Parse "attrib227"
            {
                attrib227_ = new AttributeCommon();
                int t_attrib227__size;
                t_attrib227__size = attrib227_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib227__size;
            }
            break;
        case ((uint16)228):
            // Parse "attrib228"
            {
                attrib228_ = new AttributeCommon();
                int t_attrib228__size;
                t_attrib228__size = attrib228_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib228__size;
            }
            break;
        case ((uint16)229):
            // Parse "attrib229"
            {
                attrib229_ = new AttributeCommon();
                int t_attrib229__size;
                t_attrib229__size = attrib229_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib229__size;
            }
            break;
        case ((uint16)230):
            // Parse "attrib230"
            {
                attrib230_ = new AttributeCommon();
                int t_attrib230__size;
                t_attrib230__size = attrib230_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib230__size;
            }
            break;
        case ((uint16)231):
            // Parse "attrib231"
            {
                attrib231_ = new AttributeCommon();
                int t_attrib231__size;
                t_attrib231__size = attrib231_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib231__size;
            }
            break;
        case ((uint16)232):
            // Parse "attrib232"
            {
                attrib232_ = new AttributeCommon();
                int t_attrib232__size;
                t_attrib232__size = attrib232_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib232__size;
            }
            break;
        case ((uint16)233):
            // Parse "attrib233"
            {
                attrib233_ = new AttributeCommon();
                int t_attrib233__size;
                t_attrib233__size = attrib233_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib233__size;
            }
            break;
        case ((uint16)234):
            // Parse "attrib234"
            {
                attrib234_ = new AttributeCommon();
                int t_attrib234__size;
                t_attrib234__size = attrib234_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib234__size;
            }
            break;
        case ((uint16)235):
            // Parse "attrib235"
            {
                attrib235_ = new AttributeCommon();
                int t_attrib235__size;
                t_attrib235__size = attrib235_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib235__size;
            }
            break;
        case ((uint16)236):
            // Parse "attrib236"
            {
                attrib236_ = new AttributeCommon();
                int t_attrib236__size;
                t_attrib236__size = attrib236_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib236__size;
            }
            break;
        case ((uint16)237):
            // Parse "attrib237"
            {
                attrib237_ = new AttributeCommon();
                int t_attrib237__size;
                t_attrib237__size = attrib237_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib237__size;
            }
            break;
        case ((uint16)238):
            // Parse "attrib238"
            {
                attrib238_ = new AttributeCommon();
                int t_attrib238__size;
                t_attrib238__size = attrib238_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib238__size;
            }
            break;
        case ((uint16)239):
            // Parse "attrib239"
            {
                attrib239_ = new AttributeCommon();
                int t_attrib239__size;
                t_attrib239__size = attrib239_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib239__size;
            }
            break;
        case ((uint16)240):
            // Parse "attrib240"
            {
                attrib240_ = new AttributeCommon();
                int t_attrib240__size;
                t_attrib240__size = attrib240_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib240__size;
            }
            break;
        case ((uint16)241):
            // Parse "attrib241"
            {
                attrib241_ = new AttributeCommon();
                int t_attrib241__size;
                t_attrib241__size = attrib241_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib241__size;
            }
            break;
        case ((uint16)242):
            // Parse "attrib242"
            {
                attrib242_ = new AttributeCommon();
                int t_attrib242__size;
                t_attrib242__size = attrib242_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib242__size;
            }
            break;
        case ((uint16)243):
            // Parse "attrib243"
            {
                attrib243_ = new AttributeCommon();
                int t_attrib243__size;
                t_attrib243__size = attrib243_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib243__size;
            }
            break;
        case ((uint16)245):
            // Parse "attrib245"
            {
                attrib245_ = new AttributeCommon();
                int t_attrib245__size;
                t_attrib245__size = attrib245_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib245__size;
            }
            break;
        case ((uint16)246):
            // Parse "attrib246"
            {
                attrib246_ = new AttributeCommon();
                int t_attrib246__size;
                t_attrib246__size = attrib246_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib246__size;
            }
            break;
        case ((uint16)247):
            // Parse "attrib247"
            {
                attrib247_ = new AttributeCommon();
                int t_attrib247__size;
                t_attrib247__size = attrib247_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib247__size;
            }
            break;
        case ((uint16)248):
            // Parse "attrib248"
            {
                attrib248_ = new AttributeCommon();
                int t_attrib248__size;
                t_attrib248__size = attrib248_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib248__size;
            }
            break;
        case ((uint16)249):
            // Parse "attrib249"
            {
                attrib249_ = new AttributeCommon();
                int t_attrib249__size;
                t_attrib249__size = attrib249_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib249__size;
            }
            break;
        case ((uint16)250):
            // Parse "attrib250"
            {
                attrib250_ = new AttributeCommon();
                int t_attrib250__size;
                t_attrib250__size = attrib250_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib250__size;
            }
            break;
        case ((uint16)252):
            // Parse "attrib252"
            {
                attrib252_ = new AttributeCommon();
                int t_attrib252__size;
                t_attrib252__size = attrib252_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib252__size;
            }
            break;
        case ((uint16)254):
            // Parse "attrib254"
            {
                attrib254_ = new AttributeCommon();
                int t_attrib254__size;
                t_attrib254__size = attrib254_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib254__size;
            }
            break;
        case ((uint16)255):
            // Parse "attrib255"
            {
                attrib255_ = new AttributeCommon();
                int t_attrib255__size;
                t_attrib255__size = attrib255_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib255__size;
            }
            break;
        case ((uint16)256):
            // Parse "bi_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)257):
            // Parse "bi_packed"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)258):
            // Parse "bi_flag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)512):
            // Parse "biedefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)513):
            // Parse "biewotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)514):
            // Parse "biewatime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)515):
            // Parse "biewrtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)768):
            // Parse "dbiDefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)769):
            // Parse "dbibytes"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)770):
            // Parse "dbiflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)1024):
            // Parse "dbieDefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)1025):
            // Parse "dbieatime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)1026):
            // Parse "dbiertime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2560):
            // Parse "boDefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2561):
            // Parse "bowoflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2562):
            // Parse "bowflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2816):
            // Parse "bowDefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2817):
            // Parse "boewflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)2818):
            // Parse "boewatime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)3073):
            // Parse "bocmd_CROB"
            {
                bocmd_CROB_ = new CROB();
                bocmd_CROB_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 11;
            }
            break;
        case ((uint16)3074):
            // Parse "bocmd_PCB"
            {
                bocmd_PCB_ = new PCB();
                bocmd_PCB_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 11;
            }
            break;
        case ((uint16)3075):
            // Parse "bocmd_PM"
            {
                // Checking out-of-bound for "Request_Data_Object:bocmd_PM"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:bocmd_PM",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bocmd_PM_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)3328):
            // Parse "boceDefault"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)3329):
            // Parse "boceFlag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)3330):
            // Parse "boceAtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5120):
            // Parse "counter_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5121):
            // Parse "counter_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5122):
            // Parse "counter_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5123):
            // Parse "counter_32_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5124):
            // Parse "counter_16_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5125):
            // Parse "counter_32_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5126):
            // Parse "counter_16_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5127):
            // Parse "counter_32_woflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5128):
            // Parse "counter_16_woflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5376):
            // Parse "f_counter_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5377):
            // Parse "f_counter_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5378):
            // Parse "f_counter_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5379):
            // Parse "f_counter_32_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5380):
            // Parse "f_counter_16_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5381):
            // Parse "f_counter_32_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5382):
            // Parse "f_counter_16_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5383):
            // Parse "f_counter_32_wflag_time_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5384):
            // Parse "f_counter_16_wflag_time_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5385):
            // Parse "f_counter_32_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5386):
            // Parse "f_counter_16_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5387):
            // Parse "f_counter_32_woflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5388):
            // Parse "f_counter_16_woflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5632):
            // Parse "counter_event_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5633):
            // Parse "counter_event_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5634):
            // Parse "counter_event_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5635):
            // Parse "counter_event_32_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5636):
            // Parse "counter_event_16_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5637):
            // Parse "counter_event_32_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5638):
            // Parse "counter_event_16_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5639):
            // Parse "counter_event_32_wflag_time_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5640):
            // Parse "counter_event_16_wflag_time_delat"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5888):
            // Parse "f_counter_event_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5889):
            // Parse "f_counter_event_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5890):
            // Parse "f_counter_event_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5891):
            // Parse "f_counter_event_32_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5892):
            // Parse "f_counter_event_16_wflag_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5893):
            // Parse "f_counter_event_32_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5894):
            // Parse "f_counter_event_16_wflag_time"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5895):
            // Parse "f_counter_event_32_wflag_time_delta"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)5896):
            // Parse "f_counter_event_16_wflag_time_delat"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7680):
            // Parse "ai_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7681):
            // Parse "ai_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7682):
            // Parse "ai_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7683):
            // Parse "ai_32_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7684):
            // Parse "ai_16_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7685):
            // Parse "ai_sp_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7686):
            // Parse "ai_dp_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7936):
            // Parse "f_ai_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7937):
            // Parse "f_ai_32_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7938):
            // Parse "f_ai_16_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7939):
            // Parse "f_ai_32_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7940):
            // Parse "f_ai_16_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7941):
            // Parse "f_ai_32_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7942):
            // Parse "f_ai_16_woflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7943):
            // Parse "f_ai_sp_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)7944):
            // Parse "f_ai_dp_wflag"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8192):
            // Parse "aie_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8193):
            // Parse "ai32wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8194):
            // Parse "ai16wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8195):
            // Parse "ai32wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8196):
            // Parse "ai16wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8197):
            // Parse "aispwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8198):
            // Parse "aidpwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8199):
            // Parse "aispwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8200):
            // Parse "aidpwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8448):
            // Parse "f_aie_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8449):
            // Parse "f_aie_32_wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8450):
            // Parse "f_aie_16_wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8451):
            // Parse "f_aie_32_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8452):
            // Parse "f_aie_16_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8453):
            // Parse "f_aie_sp_wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8454):
            // Parse "f_aie_dp_wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8455):
            // Parse "f_aie_sp_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8456):
            // Parse "f_aie_dp_wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8704):
            // Parse "ai_dead"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8705):
            // Parse "ai_dead_16"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8706):
            // Parse "ai_dead_32"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)8707):
            // Parse "ai_dead_sp"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10240):
            // Parse "aos_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10241):
            // Parse "aos_32"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10242):
            // Parse "aos_16"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10243):
            // Parse "aos_sp"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10244):
            // Parse "aos_dp"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10497):
            // Parse "ao_32"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10498):
            // Parse "ao_16"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10499):
            // Parse "ao_sp"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10500):
            // Parse "ao_dp"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10752):
            // Parse "aoe_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10753):
            // Parse "aoe32wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10754):
            // Parse "aoe16wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10755):
            // Parse "aoe32wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10756):
            // Parse "aoe16wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10757):
            // Parse "aoespwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10758):
            // Parse "aoedpwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10759):
            // Parse "aoespwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)10760):
            // Parse "aoedpwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11008):
            // Parse "aoce_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11009):
            // Parse "aoce32wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11010):
            // Parse "aoce16wotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11011):
            // Parse "aoce32wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11012):
            // Parse "aoce16wtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11013):
            // Parse "aocespwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11014):
            // Parse "aocedpwotime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11015):
            // Parse "aocespwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)11016):
            // Parse "aocedpwtime"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)12800):
            // Parse "time_default"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)12801):
            // Parse "time_abs"
            {
                time_abs_ = new AbsTime();
                int t_time_abs__size;
                t_time_abs__size = time_abs_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs__size;
            }
            break;
        case ((uint16)12802):
            // Parse "time_interval"
            {
                time_interval_ = new AbsTimeInterval();
                int t_time_interval__size;
                t_time_interval__size = time_interval_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_interval__size;
            }
            break;
        case ((uint16)12803):
            // Parse "time_abs_last"
            {
                time_abs_last_ = new Last_AbsTime();
                int t_time_abs_last__size;
                t_time_abs_last__size = time_abs_last_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_last__size;
            }
            break;
        case ((uint16)13057):
            // Parse "time_abs_sync"
            {
                time_abs_sync_ = new AbsTime();
                int t_time_abs_sync__size;
                t_time_abs_sync__size = time_abs_sync_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_sync__size;
            }
            break;
        case ((uint16)13058):
            // Parse "time_abs_unsync"
            {
                time_abs_unsync_ = new AbsTime();
                int t_time_abs_unsync__size;
                t_time_abs_unsync__size = time_abs_unsync_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_unsync__size;
            }
            break;
        case ((uint16)13313):
            // Parse "time_coarse"
            {
                // Checking out-of-bound for "Request_Data_Object:time_coarse"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:time_coarse",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                time_coarse_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)13314):
            // Parse "time_fine"
            {
                // Checking out-of-bound for "Request_Data_Object:time_fine"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:time_fine",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                time_fine_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)15361):
            // Parse "class0data"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)15362):
            // Parse "class1data"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)15363):
            // Parse "class2data"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)15364):
            // Parse "class3data"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)17921):
            // Parse "file_control_id"
            {
                file_control_id_ = new File_Control_ID();
                int t_file_control_id__size;
                t_file_control_id__size = file_control_id_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_id__size;
            }
            break;
        case ((uint16)17922):
            // Parse "file_control_auth"
            {
                file_control_auth_ = new File_Control_Auth_Wrap(function_code());
                int t_file_control_auth__size;
                t_file_control_auth__size = file_control_auth_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_auth__size;
            }
            break;
        case ((uint16)17923):
            // Parse "file_control_cmd"
            {
                file_control_cmd_ = new File_Control_Cmd();
                int t_file_control_cmd__size;
                t_file_control_cmd__size = file_control_cmd_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_cmd__size;
            }
            break;
        case ((uint16)17924):
            // Parse "file_control_cmd_status"
            {
                file_control_cmd_status_ = new File_Control_Cmd_Status(prefix()->prefix_value());
                int t_file_control_cmd_status__size;
                t_file_control_cmd_status__size = file_control_cmd_status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_cmd_status__size;
            }
            break;
        case ((uint16)17925):
            // Parse "file_trans"
            {
                file_trans_ = new File_Transport(prefix()->prefix_value());
                int t_file_trans__size;
                t_file_trans__size = file_trans_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_file_trans__size;
            }
            break;
        case ((uint16)17926):
            // Parse "file_trans_status"
            {
                file_trans_status_ = new File_Transport_Status(prefix()->prefix_value());
                int t_file_trans_status__size;
                t_file_trans_status__size = file_trans_status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_trans_status__size;
            }
            break;
        case ((uint16)17927):
            // Parse "file_desc"
            {
                file_desc_ = new File_Desc();
                int t_file_desc__size;
                t_file_desc__size = file_desc_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_desc__size;
            }
            break;
        case ((uint16)20481):
            // Parse "iin"
            {
                int t_iin_string_length;
                t_iin_string_length = (t_end_of_data) - (t_dataptr_after_prefix);
                int t_iin__size;
                t_iin__size = t_iin_string_length;
                // check for negative sizes
                if ( t_iin_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:275", t_iin_string_length);
                iin_.init(t_dataptr_after_prefix, t_iin_string_length);
                t_data__size = t_iin__size;
            }
            break;
        case ((uint16)20737):
            // Parse "dev_store"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)20993):
            // Parse "dev_profile"
            {
                t_data__size = 0;
            }
            break;
        case ((uint16)21249):
            // Parse "priregobj"
            {
                priregobj_ = new PrivRegObj();
                int t_priregobj__size;
                t_priregobj__size = priregobj_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_priregobj__size;
            }
            break;
        case ((uint16)21250):
            // Parse "priregobjdesc"
            {
                priregobjdesc_ = new PrivRegObjDesc();
                int t_priregobjdesc__size;
                t_priregobjdesc__size = priregobjdesc_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_priregobjdesc__size;
            }
            break;
        case ((uint16)21761):
            // Parse "desc_ele"
            {
                desc_ele_ = new DescEle();
                desc_ele_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)22017):
            // Parse "desc_ele86"
            {
                desc_ele86_ = new DescEle();
                desc_ele86_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)22018):
            // Parse "cha"
            {
                // Checking out-of-bound for "Request_Data_Object:cha"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:cha",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                cha_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)22019):
            // Parse "point_index_attr"
            {
                point_index_attr_ = new Debug_Byte();
                int t_point_index_attr__size;
                t_point_index_attr__size = point_index_attr_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_point_index_attr__size;
            }
            break;
        case ((uint16)22273):
            // Parse "present_value"
            {
                present_value_ = new Debug_Byte();
                int t_present_value__size;
                t_present_value__size = present_value_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_present_value__size;
            }
            break;
        case ((uint16)22529):
            // Parse "snapshot"
            {
                snapshot_ = new Debug_Byte();
                int t_snapshot__size;
                t_snapshot__size = snapshot_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_snapshot__size;
            }
            break;
        case ((uint16)23297):
            // Parse "activate_conf"
            {
                activate_conf_ = new ActivateConf();
                int t_activate_conf__size;
                t_activate_conf__size = activate_conf_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_activate_conf__size;
            }
            break;
        case ((uint16)25857):
            // Parse "bcd_small"
            {
                // Checking out-of-bound for "Request_Data_Object:bcd_small"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:bcd_small",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bcd_small_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)25858):
            // Parse "bcd_medium"
            {
                // Checking out-of-bound for "Request_Data_Object:bcd_medium"
                if ( t_dataptr_after_prefix + (4) > t_end_of_data || t_dataptr_after_prefix + (4) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:bcd_medium",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bcd_medium_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_prefix)));
                t_data__size = 4;
            }
            break;
        case ((uint16)25859):
            // Parse "bcd_large"
            {
                bcd_large_ = new BCD_Large();
                bcd_large_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 8;
            }
            break;
        case ((uint16)26113):
            // Parse "unsigned_integer"
            {
                // Checking out-of-bound for "Request_Data_Object:unsigned_integer"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:unsigned_integer",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                unsigned_integer_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)30721):
            // Parse "challenge"
            {
                challenge_ = new AuthChallenge(prefix()->prefix_value());
                int t_challenge__size;
                t_challenge__size = challenge_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_challenge__size;
            }
            break;
        case ((uint16)30722):
            // Parse "reply"
            {
                reply_ = new AuthReply(prefix()->prefix_value());
                int t_reply__size;
                t_reply__size = reply_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_reply__size;
            }
            break;
        case ((uint16)30723):
            // Parse "aggrRequest"
            {
                aggrRequest_ = new AuthAggrRequest(prefix()->prefix_value());
                aggrRequest_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 6;
            }
            break;
        case ((uint16)30724):
            // Parse "sessionKeyRequest"
            {
                // Checking out-of-bound for "Request_Data_Object:sessionKeyRequest"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Request_Data_Object:sessionKeyRequest",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                sessionKeyRequest_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)30725):
            // Parse "status"
            {
                status_ = new AuthSessionKeyStatus(prefix()->prefix_value());
                int t_status__size;
                t_status__size = status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_status__size;
            }
            break;
        case ((uint16)30726):
            // Parse "keyChange"
            {
                keyChange_ = new AuthSessionKeyChange(prefix()->prefix_value());
                int t_keyChange__size;
                t_keyChange__size = keyChange_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_keyChange__size;
            }
            break;
        case ((uint16)30727):
            // Parse "error"
            {
                error_ = new AuthError(prefix()->prefix_value());
                int t_error__size;
                t_error__size = error_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_error__size;
            }
            break;
        case ((uint16)30728):
            // Parse "user_cert"
            {
                user_cert_ = new UserCert(prefix()->prefix_value());
                int t_user_cert__size;
                t_user_cert__size = user_cert_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_user_cert__size;
            }
            break;
        case ((uint16)30729):
            // Parse "mac"
            {
                mac_ = new MAC(prefix()->prefix_value());
                int t_mac__size;
                t_mac__size = mac_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_mac__size;
            }
            break;
        case ((uint16)30730):
            // Parse "user_status_change"
            {
                user_status_change_ = new UserStatusChange(prefix()->prefix_value());
                int t_user_status_change__size;
                t_user_status_change__size = user_status_change_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_user_status_change__size;
            }
            break;
        case ((uint16)30731):
            // Parse "update_key_req"
            {
                update_key_req_ = new UpdateKeyReq(prefix()->prefix_value());
                int t_update_key_req__size;
                t_update_key_req__size = update_key_req_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_req__size;
            }
            break;
        case ((uint16)30732):
            // Parse "update_key_rep"
            {
                update_key_rep_ = new UpdateKeyRep(prefix()->prefix_value());
                int t_update_key_rep__size;
                t_update_key_rep__size = update_key_rep_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_rep__size;
            }
            break;
        case ((uint16)30733):
            // Parse "update_key"
            {
                update_key_ = new UpdateKey(prefix()->prefix_value());
                int t_update_key__size;
                t_update_key__size = update_key_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key__size;
            }
            break;
        case ((uint16)30734):
            // Parse "update_key_sig"
            {
                update_key_sig_ = new UpdateKeySig(prefix()->prefix_value());
                int t_update_key_sig__size;
                t_update_key_sig__size = update_key_sig_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_sig__size;
            }
            break;
        case ((uint16)30735):
            // Parse "update_key_con"
            {
                update_key_con_ = new UpdateKeyCon(prefix()->prefix_value());
                int t_update_key_con__size;
                t_update_key_con__size = update_key_con_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_con__size;
            }
            break;
        default:
            // Parse "unmatched"
            {
                unmatched_ = new Default_Wrap(object_type_field());
                int t_unmatched__size;
                t_unmatched__size = unmatched_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_unmatched__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Request_Data_Object__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_prefix + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Request_Data_Object__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Request_Data_Object__size) <= t_end_of_data);
    return t_Request_Data_Object__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Response_Data_Object::Response_Data_Object(uint8 function_code, uint8 qualifier_field, uint16 object_type_field) {
    prefix_ = nullptr;
    data_case_index_ = -1;
    attrib211_ = nullptr;
    attrib212_ = nullptr;
    attrib213_ = nullptr;
    attrib214_ = nullptr;
    attrib215_ = nullptr;
    attrib216_ = nullptr;
    attrib217_ = nullptr;
    attrib218_ = nullptr;
    attrib219_ = nullptr;
    attrib220_ = nullptr;
    attrib221_ = nullptr;
    attrib222_ = nullptr;
    attrib223_ = nullptr;
    attrib224_ = nullptr;
    attrib225_ = nullptr;
    attrib226_ = nullptr;
    attrib227_ = nullptr;
    attrib228_ = nullptr;
    attrib229_ = nullptr;
    attrib230_ = nullptr;
    attrib231_ = nullptr;
    attrib232_ = nullptr;
    attrib233_ = nullptr;
    attrib234_ = nullptr;
    attrib235_ = nullptr;
    attrib236_ = nullptr;
    attrib237_ = nullptr;
    attrib238_ = nullptr;
    attrib239_ = nullptr;
    attrib240_ = nullptr;
    attrib241_ = nullptr;
    attrib242_ = nullptr;
    attrib243_ = nullptr;
    attrib245_ = nullptr;
    attrib246_ = nullptr;
    attrib247_ = nullptr;
    attrib248_ = nullptr;
    attrib249_ = nullptr;
    attrib250_ = nullptr;
    attrib252_ = nullptr;
    attrib254_ = nullptr;
    attrib255_ = nullptr;
    biwoflag_ = 0;
    biwflag_ = 0;
    biewoflag_ = 0;
    biewatime_ = nullptr;
    biewrtime_ = nullptr;
    dbiflag_ = 0;
    dbieatime_ = nullptr;
    dbiertime_ = nullptr;
    bowoflag_ = 0;
    bowflag_ = 0;
    boewflag_ = 0;
    boewatime_ = nullptr;
    bocmd_CROB_ = nullptr;
    bocmd_PCB_ = nullptr;
    bocmd_PM_ = 0;
    boceFlag_ = 0;
    boceAtime_ = nullptr;
    counter_32_wflag_ = nullptr;
    counter_16_wflag_ = nullptr;
    counter_32_wflag_delta_ = nullptr;
    counter_16_wflag_delta_ = nullptr;
    counter_32_woflag_ = nullptr;
    counter_16_woflag_ = nullptr;
    counter_32_woflag_delta_ = nullptr;
    counter_16_woflag_delta_ = nullptr;
    f_counter_32_wflag_ = nullptr;
    f_counter_16_wflag_ = nullptr;
    f_counter_32_wflag_delta_ = nullptr;
    f_counter_16_wflag_delta_ = nullptr;
    f_counter_32_wflag_time_ = nullptr;
    f_counter_16_wflag_time_ = nullptr;
    f_counter_32_wflag_time_delta_ = nullptr;
    f_counter_16_wflag_time_delta_ = nullptr;
    f_counter_32_woflag_ = nullptr;
    f_counter_16_woflag_ = nullptr;
    f_counter_32_woflag_delta_ = nullptr;
    f_counter_16_woflag_delta_ = nullptr;
    counter_event_32_wflag_ = nullptr;
    counter_event_16_wflag_ = nullptr;
    counter_event_32_wflag_delta_ = nullptr;
    counter_event_16_wflag_delta_ = nullptr;
    counter_event_32_wflag_time_ = nullptr;
    counter_event_16_wflag_time_ = nullptr;
    counter_event_32_wflag_time_delta_ = nullptr;
    counter_event_16_wflag_time_delat_ = nullptr;
    f_counter_event_32_wflag_ = nullptr;
    f_counter_event_16_wflag_ = nullptr;
    f_counter_event_32_wflag_delta_ = nullptr;
    f_counter_event_16_wflag_delta_ = nullptr;
    f_counter_event_32_wflag_time_ = nullptr;
    f_counter_event_16_wflag_time_ = nullptr;
    f_counter_event_32_wflag_time_delta_ = nullptr;
    f_counter_event_16_wflag_time_delat_ = nullptr;
    ai_32_wflag_ = nullptr;
    ai_16_wflag_ = nullptr;
    ai_32_woflag_ = nullptr;
    ai_16_woflag_ = nullptr;
    ai_sp_wflag_ = nullptr;
    ai_dp_wflag_ = nullptr;
    f_ai_32_wflag_ = nullptr;
    f_ai_16_wflag_ = nullptr;
    f_ai_32_wtime_ = nullptr;
    f_ai_16_wtime_ = nullptr;
    f_ai_32_woflag_ = nullptr;
    f_ai_16_woflag_ = nullptr;
    f_ai_sp_wflag_ = nullptr;
    f_ai_dp_wflag_ = nullptr;
    ai32wotime_ = nullptr;
    ai16wotime_ = nullptr;
    ai32wtime_ = nullptr;
    ai16wtime_ = nullptr;
    aispwotime_ = nullptr;
    aidpwotime_ = nullptr;
    aispwtime_ = nullptr;
    aidpwtime_ = nullptr;
    faie_32_wotime_ = nullptr;
    faie_16_wotime_ = nullptr;
    faie_32_wtime_ = nullptr;
    faie_16_wtime_ = nullptr;
    faie_sp_wotime_ = nullptr;
    faie_dp_wotime_ = nullptr;
    faie_sp_wtime_ = nullptr;
    faie_dp_wtime_ = nullptr;
    ai_dead_16_ = 0;
    ai_dead_32_ = 0;
    ai_dead_sp_ = 0;
    aos_32_ = nullptr;
    aos_16_ = nullptr;
    aos_sp_ = nullptr;
    aos_dp_ = nullptr;
    ao_32_ = nullptr;
    ao_16_ = nullptr;
    ao_sp_ = nullptr;
    ao_dp_ = nullptr;
    aoe32wotime_ = nullptr;
    aoe16wotime_ = nullptr;
    aoe32wtime_ = nullptr;
    aoe16wtime_ = nullptr;
    aoespwotime_ = nullptr;
    aoedpwotime_ = nullptr;
    aoespwtime_ = nullptr;
    aoedpwtime_ = nullptr;
    aoce32wotime_ = nullptr;
    aoce16wotime_ = nullptr;
    aoce32wtime_ = nullptr;
    aoce16wtime_ = nullptr;
    aocespwotime_ = nullptr;
    aocedpwotime_ = nullptr;
    aocespwtime_ = nullptr;
    aocedpwtime_ = nullptr;
    time_abs_ = nullptr;
    time_interval_ = nullptr;
    time_abs_last_ = nullptr;
    time_abs_sync_ = nullptr;
    time_abs_unsync_ = nullptr;
    time_coarse_ = 0;
    time_fine_ = 0;
    file_control_id_ = nullptr;
    file_control_auth_ = nullptr;
    file_control_cmd_ = nullptr;
    file_control_cmd_status_ = nullptr;
    file_trans_ = nullptr;
    file_trans_status_ = nullptr;
    file_desc_ = nullptr;
    iin_ = 0;
    dev_store_ = nullptr;
    dev_profile_ = nullptr;
    priregobj_ = nullptr;
    priregobjdesc_ = nullptr;
    desc_ele_ = nullptr;
    desc_ele86_ = nullptr;
    cha_ = 0;
    point_index_attr_ = nullptr;
    present_value_ = nullptr;
    snapshot_ = nullptr;
    activate_conf_ = nullptr;
    bcd_small_ = 0;
    bcd_medium_ = 0;
    bcd_large_ = nullptr;
    unsigned_integer_ = 0;
    challenge_ = nullptr;
    reply_ = nullptr;
    aggrRequest_ = nullptr;
    sessionKeyRequest_ = 0;
    status_ = nullptr;
    keyChange_ = nullptr;
    error_ = nullptr;
    user_cert_ = nullptr;
    mac_ = nullptr;
    user_status_change_ = nullptr;
    update_key_req_ = nullptr;
    update_key_rep_ = nullptr;
    update_key_ = nullptr;
    update_key_sig_ = nullptr;
    update_key_con_ = nullptr;
    unmatched_ = nullptr;
    function_code_ = function_code;
    qualifier_field_ = qualifier_field;
    object_type_field_ = object_type_field;
    data_value_ = 0;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Response_Data_Object::~Response_Data_Object() {
    delete prefix_;
    prefix_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)211):
            // Clean up "attrib211"
            {
                delete attrib211_;
                attrib211_ = nullptr;
            }
            break;
        case ((uint16)212):
            // Clean up "attrib212"
            {
                delete attrib212_;
                attrib212_ = nullptr;
            }
            break;
        case ((uint16)213):
            // Clean up "attrib213"
            {
                delete attrib213_;
                attrib213_ = nullptr;
            }
            break;
        case ((uint16)214):
            // Clean up "attrib214"
            {
                delete attrib214_;
                attrib214_ = nullptr;
            }
            break;
        case ((uint16)215):
            // Clean up "attrib215"
            {
                delete attrib215_;
                attrib215_ = nullptr;
            }
            break;
        case ((uint16)216):
            // Clean up "attrib216"
            {
                delete attrib216_;
                attrib216_ = nullptr;
            }
            break;
        case ((uint16)217):
            // Clean up "attrib217"
            {
                delete attrib217_;
                attrib217_ = nullptr;
            }
            break;
        case ((uint16)218):
            // Clean up "attrib218"
            {
                delete attrib218_;
                attrib218_ = nullptr;
            }
            break;
        case ((uint16)219):
            // Clean up "attrib219"
            {
                delete attrib219_;
                attrib219_ = nullptr;
            }
            break;
        case ((uint16)220):
            // Clean up "attrib220"
            {
                delete attrib220_;
                attrib220_ = nullptr;
            }
            break;
        case ((uint16)221):
            // Clean up "attrib221"
            {
                delete attrib221_;
                attrib221_ = nullptr;
            }
            break;
        case ((uint16)222):
            // Clean up "attrib222"
            {
                delete attrib222_;
                attrib222_ = nullptr;
            }
            break;
        case ((uint16)223):
            // Clean up "attrib223"
            {
                delete attrib223_;
                attrib223_ = nullptr;
            }
            break;
        case ((uint16)224):
            // Clean up "attrib224"
            {
                delete attrib224_;
                attrib224_ = nullptr;
            }
            break;
        case ((uint16)225):
            // Clean up "attrib225"
            {
                delete attrib225_;
                attrib225_ = nullptr;
            }
            break;
        case ((uint16)226):
            // Clean up "attrib226"
            {
                delete attrib226_;
                attrib226_ = nullptr;
            }
            break;
        case ((uint16)227):
            // Clean up "attrib227"
            {
                delete attrib227_;
                attrib227_ = nullptr;
            }
            break;
        case ((uint16)228):
            // Clean up "attrib228"
            {
                delete attrib228_;
                attrib228_ = nullptr;
            }
            break;
        case ((uint16)229):
            // Clean up "attrib229"
            {
                delete attrib229_;
                attrib229_ = nullptr;
            }
            break;
        case ((uint16)230):
            // Clean up "attrib230"
            {
                delete attrib230_;
                attrib230_ = nullptr;
            }
            break;
        case ((uint16)231):
            // Clean up "attrib231"
            {
                delete attrib231_;
                attrib231_ = nullptr;
            }
            break;
        case ((uint16)232):
            // Clean up "attrib232"
            {
                delete attrib232_;
                attrib232_ = nullptr;
            }
            break;
        case ((uint16)233):
            // Clean up "attrib233"
            {
                delete attrib233_;
                attrib233_ = nullptr;
            }
            break;
        case ((uint16)234):
            // Clean up "attrib234"
            {
                delete attrib234_;
                attrib234_ = nullptr;
            }
            break;
        case ((uint16)235):
            // Clean up "attrib235"
            {
                delete attrib235_;
                attrib235_ = nullptr;
            }
            break;
        case ((uint16)236):
            // Clean up "attrib236"
            {
                delete attrib236_;
                attrib236_ = nullptr;
            }
            break;
        case ((uint16)237):
            // Clean up "attrib237"
            {
                delete attrib237_;
                attrib237_ = nullptr;
            }
            break;
        case ((uint16)238):
            // Clean up "attrib238"
            {
                delete attrib238_;
                attrib238_ = nullptr;
            }
            break;
        case ((uint16)239):
            // Clean up "attrib239"
            {
                delete attrib239_;
                attrib239_ = nullptr;
            }
            break;
        case ((uint16)240):
            // Clean up "attrib240"
            {
                delete attrib240_;
                attrib240_ = nullptr;
            }
            break;
        case ((uint16)241):
            // Clean up "attrib241"
            {
                delete attrib241_;
                attrib241_ = nullptr;
            }
            break;
        case ((uint16)242):
            // Clean up "attrib242"
            {
                delete attrib242_;
                attrib242_ = nullptr;
            }
            break;
        case ((uint16)243):
            // Clean up "attrib243"
            {
                delete attrib243_;
                attrib243_ = nullptr;
            }
            break;
        case ((uint16)245):
            // Clean up "attrib245"
            {
                delete attrib245_;
                attrib245_ = nullptr;
            }
            break;
        case ((uint16)246):
            // Clean up "attrib246"
            {
                delete attrib246_;
                attrib246_ = nullptr;
            }
            break;
        case ((uint16)247):
            // Clean up "attrib247"
            {
                delete attrib247_;
                attrib247_ = nullptr;
            }
            break;
        case ((uint16)248):
            // Clean up "attrib248"
            {
                delete attrib248_;
                attrib248_ = nullptr;
            }
            break;
        case ((uint16)249):
            // Clean up "attrib249"
            {
                delete attrib249_;
                attrib249_ = nullptr;
            }
            break;
        case ((uint16)250):
            // Clean up "attrib250"
            {
                delete attrib250_;
                attrib250_ = nullptr;
            }
            break;
        case ((uint16)252):
            // Clean up "attrib252"
            {
                delete attrib252_;
                attrib252_ = nullptr;
            }
            break;
        case ((uint16)254):
            // Clean up "attrib254"
            {
                delete attrib254_;
                attrib254_ = nullptr;
            }
            break;
        case ((uint16)255):
            // Clean up "attrib255"
            {
                delete attrib255_;
                attrib255_ = nullptr;
            }
            break;
        case ((uint16)257):
            // Clean up "biwoflag"
            {
            }
            break;
        case ((uint16)258):
            // Clean up "biwflag"
            {
            }
            break;
        case ((uint16)513):
            // Clean up "biewoflag"
            {
            }
            break;
        case ((uint16)514):
            // Clean up "biewatime"
            {
                delete biewatime_;
                biewatime_ = nullptr;
            }
            break;
        case ((uint16)515):
            // Clean up "biewrtime"
            {
                delete biewrtime_;
                biewrtime_ = nullptr;
            }
            break;
        case ((uint16)769):
            // Clean up "dbibytes"
            {
                dbibytes_.free();
            }
            break;
        case ((uint16)770):
            // Clean up "dbiflag"
            {
            }
            break;
        case ((uint16)1025):
            // Clean up "dbieatime"
            {
                delete dbieatime_;
                dbieatime_ = nullptr;
            }
            break;
        case ((uint16)1026):
            // Clean up "dbiertime"
            {
                delete dbiertime_;
                dbiertime_ = nullptr;
            }
            break;
        case ((uint16)2561):
            // Clean up "bowoflag"
            {
            }
            break;
        case ((uint16)2562):
            // Clean up "bowflag"
            {
            }
            break;
        case ((uint16)2817):
            // Clean up "boewflag"
            {
            }
            break;
        case ((uint16)2818):
            // Clean up "boewatime"
            {
                delete boewatime_;
                boewatime_ = nullptr;
            }
            break;
        case ((uint16)3073):
            // Clean up "bocmd_CROB"
            {
                delete bocmd_CROB_;
                bocmd_CROB_ = nullptr;
            }
            break;
        case ((uint16)3074):
            // Clean up "bocmd_PCB"
            {
                delete bocmd_PCB_;
                bocmd_PCB_ = nullptr;
            }
            break;
        case ((uint16)3075):
            // Clean up "bocmd_PM"
            {
            }
            break;
        case ((uint16)3329):
            // Clean up "boceFlag"
            {
            }
            break;
        case ((uint16)3330):
            // Clean up "boceAtime"
            {
                delete boceAtime_;
                boceAtime_ = nullptr;
            }
            break;
        case ((uint16)5121):
            // Clean up "counter_32_wflag"
            {
                delete counter_32_wflag_;
                counter_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)5122):
            // Clean up "counter_16_wflag"
            {
                delete counter_16_wflag_;
                counter_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)5123):
            // Clean up "counter_32_wflag_delta"
            {
                delete counter_32_wflag_delta_;
                counter_32_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5124):
            // Clean up "counter_16_wflag_delta"
            {
                delete counter_16_wflag_delta_;
                counter_16_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5125):
            // Clean up "counter_32_woflag"
            {
                delete counter_32_woflag_;
                counter_32_woflag_ = nullptr;
            }
            break;
        case ((uint16)5126):
            // Clean up "counter_16_woflag"
            {
                delete counter_16_woflag_;
                counter_16_woflag_ = nullptr;
            }
            break;
        case ((uint16)5127):
            // Clean up "counter_32_woflag_delta"
            {
                delete counter_32_woflag_delta_;
                counter_32_woflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5128):
            // Clean up "counter_16_woflag_delta"
            {
                delete counter_16_woflag_delta_;
                counter_16_woflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5377):
            // Clean up "f_counter_32_wflag"
            {
                delete f_counter_32_wflag_;
                f_counter_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)5378):
            // Clean up "f_counter_16_wflag"
            {
                delete f_counter_16_wflag_;
                f_counter_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)5379):
            // Clean up "f_counter_32_wflag_delta"
            {
                delete f_counter_32_wflag_delta_;
                f_counter_32_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5380):
            // Clean up "f_counter_16_wflag_delta"
            {
                delete f_counter_16_wflag_delta_;
                f_counter_16_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5381):
            // Clean up "f_counter_32_wflag_time"
            {
                delete f_counter_32_wflag_time_;
                f_counter_32_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5382):
            // Clean up "f_counter_16_wflag_time"
            {
                delete f_counter_16_wflag_time_;
                f_counter_16_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5383):
            // Clean up "f_counter_32_wflag_time_delta"
            {
                delete f_counter_32_wflag_time_delta_;
                f_counter_32_wflag_time_delta_ = nullptr;
            }
            break;
        case ((uint16)5384):
            // Clean up "f_counter_16_wflag_time_delta"
            {
                delete f_counter_16_wflag_time_delta_;
                f_counter_16_wflag_time_delta_ = nullptr;
            }
            break;
        case ((uint16)5385):
            // Clean up "f_counter_32_woflag"
            {
                delete f_counter_32_woflag_;
                f_counter_32_woflag_ = nullptr;
            }
            break;
        case ((uint16)5386):
            // Clean up "f_counter_16_woflag"
            {
                delete f_counter_16_woflag_;
                f_counter_16_woflag_ = nullptr;
            }
            break;
        case ((uint16)5387):
            // Clean up "f_counter_32_woflag_delta"
            {
                delete f_counter_32_woflag_delta_;
                f_counter_32_woflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5388):
            // Clean up "f_counter_16_woflag_delta"
            {
                delete f_counter_16_woflag_delta_;
                f_counter_16_woflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5633):
            // Clean up "counter_event_32_wflag"
            {
                delete counter_event_32_wflag_;
                counter_event_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)5634):
            // Clean up "counter_event_16_wflag"
            {
                delete counter_event_16_wflag_;
                counter_event_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)5635):
            // Clean up "counter_event_32_wflag_delta"
            {
                delete counter_event_32_wflag_delta_;
                counter_event_32_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5636):
            // Clean up "counter_event_16_wflag_delta"
            {
                delete counter_event_16_wflag_delta_;
                counter_event_16_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5637):
            // Clean up "counter_event_32_wflag_time"
            {
                delete counter_event_32_wflag_time_;
                counter_event_32_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5638):
            // Clean up "counter_event_16_wflag_time"
            {
                delete counter_event_16_wflag_time_;
                counter_event_16_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5639):
            // Clean up "counter_event_32_wflag_time_delta"
            {
                delete counter_event_32_wflag_time_delta_;
                counter_event_32_wflag_time_delta_ = nullptr;
            }
            break;
        case ((uint16)5640):
            // Clean up "counter_event_16_wflag_time_delat"
            {
                delete counter_event_16_wflag_time_delat_;
                counter_event_16_wflag_time_delat_ = nullptr;
            }
            break;
        case ((uint16)5889):
            // Clean up "f_counter_event_32_wflag"
            {
                delete f_counter_event_32_wflag_;
                f_counter_event_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)5890):
            // Clean up "f_counter_event_16_wflag"
            {
                delete f_counter_event_16_wflag_;
                f_counter_event_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)5891):
            // Clean up "f_counter_event_32_wflag_delta"
            {
                delete f_counter_event_32_wflag_delta_;
                f_counter_event_32_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5892):
            // Clean up "f_counter_event_16_wflag_delta"
            {
                delete f_counter_event_16_wflag_delta_;
                f_counter_event_16_wflag_delta_ = nullptr;
            }
            break;
        case ((uint16)5893):
            // Clean up "f_counter_event_32_wflag_time"
            {
                delete f_counter_event_32_wflag_time_;
                f_counter_event_32_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5894):
            // Clean up "f_counter_event_16_wflag_time"
            {
                delete f_counter_event_16_wflag_time_;
                f_counter_event_16_wflag_time_ = nullptr;
            }
            break;
        case ((uint16)5895):
            // Clean up "f_counter_event_32_wflag_time_delta"
            {
                delete f_counter_event_32_wflag_time_delta_;
                f_counter_event_32_wflag_time_delta_ = nullptr;
            }
            break;
        case ((uint16)5896):
            // Clean up "f_counter_event_16_wflag_time_delat"
            {
                delete f_counter_event_16_wflag_time_delat_;
                f_counter_event_16_wflag_time_delat_ = nullptr;
            }
            break;
        case ((uint16)7681):
            // Clean up "ai_32_wflag"
            {
                delete ai_32_wflag_;
                ai_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)7682):
            // Clean up "ai_16_wflag"
            {
                delete ai_16_wflag_;
                ai_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)7683):
            // Clean up "ai_32_woflag"
            {
                delete ai_32_woflag_;
                ai_32_woflag_ = nullptr;
            }
            break;
        case ((uint16)7684):
            // Clean up "ai_16_woflag"
            {
                delete ai_16_woflag_;
                ai_16_woflag_ = nullptr;
            }
            break;
        case ((uint16)7685):
            // Clean up "ai_sp_wflag"
            {
                delete ai_sp_wflag_;
                ai_sp_wflag_ = nullptr;
            }
            break;
        case ((uint16)7686):
            // Clean up "ai_dp_wflag"
            {
                delete ai_dp_wflag_;
                ai_dp_wflag_ = nullptr;
            }
            break;
        case ((uint16)7937):
            // Clean up "f_ai_32_wflag"
            {
                delete f_ai_32_wflag_;
                f_ai_32_wflag_ = nullptr;
            }
            break;
        case ((uint16)7938):
            // Clean up "f_ai_16_wflag"
            {
                delete f_ai_16_wflag_;
                f_ai_16_wflag_ = nullptr;
            }
            break;
        case ((uint16)7939):
            // Clean up "f_ai_32_wtime"
            {
                delete f_ai_32_wtime_;
                f_ai_32_wtime_ = nullptr;
            }
            break;
        case ((uint16)7940):
            // Clean up "f_ai_16_wtime"
            {
                delete f_ai_16_wtime_;
                f_ai_16_wtime_ = nullptr;
            }
            break;
        case ((uint16)7941):
            // Clean up "f_ai_32_woflag"
            {
                delete f_ai_32_woflag_;
                f_ai_32_woflag_ = nullptr;
            }
            break;
        case ((uint16)7942):
            // Clean up "f_ai_16_woflag"
            {
                delete f_ai_16_woflag_;
                f_ai_16_woflag_ = nullptr;
            }
            break;
        case ((uint16)7943):
            // Clean up "f_ai_sp_wflag"
            {
                delete f_ai_sp_wflag_;
                f_ai_sp_wflag_ = nullptr;
            }
            break;
        case ((uint16)7944):
            // Clean up "f_ai_dp_wflag"
            {
                delete f_ai_dp_wflag_;
                f_ai_dp_wflag_ = nullptr;
            }
            break;
        case ((uint16)8193):
            // Clean up "ai32wotime"
            {
                delete ai32wotime_;
                ai32wotime_ = nullptr;
            }
            break;
        case ((uint16)8194):
            // Clean up "ai16wotime"
            {
                delete ai16wotime_;
                ai16wotime_ = nullptr;
            }
            break;
        case ((uint16)8195):
            // Clean up "ai32wtime"
            {
                delete ai32wtime_;
                ai32wtime_ = nullptr;
            }
            break;
        case ((uint16)8196):
            // Clean up "ai16wtime"
            {
                delete ai16wtime_;
                ai16wtime_ = nullptr;
            }
            break;
        case ((uint16)8197):
            // Clean up "aispwotime"
            {
                delete aispwotime_;
                aispwotime_ = nullptr;
            }
            break;
        case ((uint16)8198):
            // Clean up "aidpwotime"
            {
                delete aidpwotime_;
                aidpwotime_ = nullptr;
            }
            break;
        case ((uint16)8199):
            // Clean up "aispwtime"
            {
                delete aispwtime_;
                aispwtime_ = nullptr;
            }
            break;
        case ((uint16)8200):
            // Clean up "aidpwtime"
            {
                delete aidpwtime_;
                aidpwtime_ = nullptr;
            }
            break;
        case ((uint16)8449):
            // Clean up "faie_32_wotime"
            {
                delete faie_32_wotime_;
                faie_32_wotime_ = nullptr;
            }
            break;
        case ((uint16)8450):
            // Clean up "faie_16_wotime"
            {
                delete faie_16_wotime_;
                faie_16_wotime_ = nullptr;
            }
            break;
        case ((uint16)8451):
            // Clean up "faie_32_wtime"
            {
                delete faie_32_wtime_;
                faie_32_wtime_ = nullptr;
            }
            break;
        case ((uint16)8452):
            // Clean up "faie_16_wtime"
            {
                delete faie_16_wtime_;
                faie_16_wtime_ = nullptr;
            }
            break;
        case ((uint16)8453):
            // Clean up "faie_sp_wotime"
            {
                delete faie_sp_wotime_;
                faie_sp_wotime_ = nullptr;
            }
            break;
        case ((uint16)8454):
            // Clean up "faie_dp_wotime"
            {
                delete faie_dp_wotime_;
                faie_dp_wotime_ = nullptr;
            }
            break;
        case ((uint16)8455):
            // Clean up "faie_sp_wtime"
            {
                delete faie_sp_wtime_;
                faie_sp_wtime_ = nullptr;
            }
            break;
        case ((uint16)8456):
            // Clean up "faie_dp_wtime"
            {
                delete faie_dp_wtime_;
                faie_dp_wtime_ = nullptr;
            }
            break;
        case ((uint16)8705):
            // Clean up "ai_dead_16"
            {
            }
            break;
        case ((uint16)8706):
            // Clean up "ai_dead_32"
            {
            }
            break;
        case ((uint16)8707):
            // Clean up "ai_dead_sp"
            {
            }
            break;
        case ((uint16)10241):
            // Clean up "aos_32"
            {
                delete aos_32_;
                aos_32_ = nullptr;
            }
            break;
        case ((uint16)10242):
            // Clean up "aos_16"
            {
                delete aos_16_;
                aos_16_ = nullptr;
            }
            break;
        case ((uint16)10243):
            // Clean up "aos_sp"
            {
                delete aos_sp_;
                aos_sp_ = nullptr;
            }
            break;
        case ((uint16)10244):
            // Clean up "aos_dp"
            {
                delete aos_dp_;
                aos_dp_ = nullptr;
            }
            break;
        case ((uint16)10497):
            // Clean up "ao_32"
            {
                delete ao_32_;
                ao_32_ = nullptr;
            }
            break;
        case ((uint16)10498):
            // Clean up "ao_16"
            {
                delete ao_16_;
                ao_16_ = nullptr;
            }
            break;
        case ((uint16)10499):
            // Clean up "ao_sp"
            {
                delete ao_sp_;
                ao_sp_ = nullptr;
            }
            break;
        case ((uint16)10500):
            // Clean up "ao_dp"
            {
                delete ao_dp_;
                ao_dp_ = nullptr;
            }
            break;
        case ((uint16)10753):
            // Clean up "aoe32wotime"
            {
                delete aoe32wotime_;
                aoe32wotime_ = nullptr;
            }
            break;
        case ((uint16)10754):
            // Clean up "aoe16wotime"
            {
                delete aoe16wotime_;
                aoe16wotime_ = nullptr;
            }
            break;
        case ((uint16)10755):
            // Clean up "aoe32wtime"
            {
                delete aoe32wtime_;
                aoe32wtime_ = nullptr;
            }
            break;
        case ((uint16)10756):
            // Clean up "aoe16wtime"
            {
                delete aoe16wtime_;
                aoe16wtime_ = nullptr;
            }
            break;
        case ((uint16)10757):
            // Clean up "aoespwotime"
            {
                delete aoespwotime_;
                aoespwotime_ = nullptr;
            }
            break;
        case ((uint16)10758):
            // Clean up "aoedpwotime"
            {
                delete aoedpwotime_;
                aoedpwotime_ = nullptr;
            }
            break;
        case ((uint16)10759):
            // Clean up "aoespwtime"
            {
                delete aoespwtime_;
                aoespwtime_ = nullptr;
            }
            break;
        case ((uint16)10760):
            // Clean up "aoedpwtime"
            {
                delete aoedpwtime_;
                aoedpwtime_ = nullptr;
            }
            break;
        case ((uint16)11009):
            // Clean up "aoce32wotime"
            {
                delete aoce32wotime_;
                aoce32wotime_ = nullptr;
            }
            break;
        case ((uint16)11010):
            // Clean up "aoce16wotime"
            {
                delete aoce16wotime_;
                aoce16wotime_ = nullptr;
            }
            break;
        case ((uint16)11011):
            // Clean up "aoce32wtime"
            {
                delete aoce32wtime_;
                aoce32wtime_ = nullptr;
            }
            break;
        case ((uint16)11012):
            // Clean up "aoce16wtime"
            {
                delete aoce16wtime_;
                aoce16wtime_ = nullptr;
            }
            break;
        case ((uint16)11013):
            // Clean up "aocespwotime"
            {
                delete aocespwotime_;
                aocespwotime_ = nullptr;
            }
            break;
        case ((uint16)11014):
            // Clean up "aocedpwotime"
            {
                delete aocedpwotime_;
                aocedpwotime_ = nullptr;
            }
            break;
        case ((uint16)11015):
            // Clean up "aocespwtime"
            {
                delete aocespwtime_;
                aocespwtime_ = nullptr;
            }
            break;
        case ((uint16)11016):
            // Clean up "aocedpwtime"
            {
                delete aocedpwtime_;
                aocedpwtime_ = nullptr;
            }
            break;
        case ((uint16)12801):
            // Clean up "time_abs"
            {
                delete time_abs_;
                time_abs_ = nullptr;
            }
            break;
        case ((uint16)12802):
            // Clean up "time_interval"
            {
                delete time_interval_;
                time_interval_ = nullptr;
            }
            break;
        case ((uint16)12803):
            // Clean up "time_abs_last"
            {
                delete time_abs_last_;
                time_abs_last_ = nullptr;
            }
            break;
        case ((uint16)13057):
            // Clean up "time_abs_sync"
            {
                delete time_abs_sync_;
                time_abs_sync_ = nullptr;
            }
            break;
        case ((uint16)13058):
            // Clean up "time_abs_unsync"
            {
                delete time_abs_unsync_;
                time_abs_unsync_ = nullptr;
            }
            break;
        case ((uint16)13313):
            // Clean up "time_coarse"
            {
            }
            break;
        case ((uint16)13314):
            // Clean up "time_fine"
            {
            }
            break;
        case ((uint16)17921):
            // Clean up "file_control_id"
            {
                delete file_control_id_;
                file_control_id_ = nullptr;
            }
            break;
        case ((uint16)17922):
            // Clean up "file_control_auth"
            {
                delete file_control_auth_;
                file_control_auth_ = nullptr;
            }
            break;
        case ((uint16)17923):
            // Clean up "file_control_cmd"
            {
                delete file_control_cmd_;
                file_control_cmd_ = nullptr;
            }
            break;
        case ((uint16)17924):
            // Clean up "file_control_cmd_status"
            {
                delete file_control_cmd_status_;
                file_control_cmd_status_ = nullptr;
            }
            break;
        case ((uint16)17925):
            // Clean up "file_trans"
            {
                delete file_trans_;
                file_trans_ = nullptr;
            }
            break;
        case ((uint16)17926):
            // Clean up "file_trans_status"
            {
                delete file_trans_status_;
                file_trans_status_ = nullptr;
            }
            break;
        case ((uint16)17927):
            // Clean up "file_desc"
            {
                delete file_desc_;
                file_desc_ = nullptr;
            }
            break;
        case ((uint16)20481):
            // Clean up "iin"
            {
            }
            break;
        case ((uint16)20737):
            // Clean up "dev_store"
            {
                delete dev_store_;
                dev_store_ = nullptr;
            }
            break;
        case ((uint16)20993):
            // Clean up "dev_profile"
            {
                delete dev_profile_;
                dev_profile_ = nullptr;
            }
            break;
        case ((uint16)21249):
            // Clean up "priregobj"
            {
                delete priregobj_;
                priregobj_ = nullptr;
            }
            break;
        case ((uint16)21250):
            // Clean up "priregobjdesc"
            {
                delete priregobjdesc_;
                priregobjdesc_ = nullptr;
            }
            break;
        case ((uint16)21761):
            // Clean up "desc_ele"
            {
                delete desc_ele_;
                desc_ele_ = nullptr;
            }
            break;
        case ((uint16)22017):
            // Clean up "desc_ele86"
            {
                delete desc_ele86_;
                desc_ele86_ = nullptr;
            }
            break;
        case ((uint16)22018):
            // Clean up "cha"
            {
            }
            break;
        case ((uint16)22019):
            // Clean up "point_index_attr"
            {
                delete point_index_attr_;
                point_index_attr_ = nullptr;
            }
            break;
        case ((uint16)22273):
            // Clean up "present_value"
            {
                delete present_value_;
                present_value_ = nullptr;
            }
            break;
        case ((uint16)22529):
            // Clean up "snapshot"
            {
                delete snapshot_;
                snapshot_ = nullptr;
            }
            break;
        case ((uint16)23297):
            // Clean up "activate_conf"
            {
                delete activate_conf_;
                activate_conf_ = nullptr;
            }
            break;
        case ((uint16)25857):
            // Clean up "bcd_small"
            {
            }
            break;
        case ((uint16)25858):
            // Clean up "bcd_medium"
            {
            }
            break;
        case ((uint16)25859):
            // Clean up "bcd_large"
            {
                delete bcd_large_;
                bcd_large_ = nullptr;
            }
            break;
        case ((uint16)26113):
            // Clean up "unsigned_integer"
            {
            }
            break;
        case ((uint16)30721):
            // Clean up "challenge"
            {
                delete challenge_;
                challenge_ = nullptr;
            }
            break;
        case ((uint16)30722):
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
        case ((uint16)30723):
            // Clean up "aggrRequest"
            {
                delete aggrRequest_;
                aggrRequest_ = nullptr;
            }
            break;
        case ((uint16)30724):
            // Clean up "sessionKeyRequest"
            {
            }
            break;
        case ((uint16)30725):
            // Clean up "status"
            {
                delete status_;
                status_ = nullptr;
            }
            break;
        case ((uint16)30726):
            // Clean up "keyChange"
            {
                delete keyChange_;
                keyChange_ = nullptr;
            }
            break;
        case ((uint16)30727):
            // Clean up "error"
            {
                delete error_;
                error_ = nullptr;
            }
            break;
        case ((uint16)30728):
            // Clean up "user_cert"
            {
                delete user_cert_;
                user_cert_ = nullptr;
            }
            break;
        case ((uint16)30729):
            // Clean up "mac"
            {
                delete mac_;
                mac_ = nullptr;
            }
            break;
        case ((uint16)30730):
            // Clean up "user_status_change"
            {
                delete user_status_change_;
                user_status_change_ = nullptr;
            }
            break;
        case ((uint16)30731):
            // Clean up "update_key_req"
            {
                delete update_key_req_;
                update_key_req_ = nullptr;
            }
            break;
        case ((uint16)30732):
            // Clean up "update_key_rep"
            {
                delete update_key_rep_;
                update_key_rep_ = nullptr;
            }
            break;
        case ((uint16)30733):
            // Clean up "update_key"
            {
                delete update_key_;
                update_key_ = nullptr;
            }
            break;
        case ((uint16)30734):
            // Clean up "update_key_sig"
            {
                delete update_key_sig_;
                update_key_sig_ = nullptr;
            }
            break;
        case ((uint16)30735):
            // Clean up "update_key_con"
            {
                delete update_key_con_;
                update_key_con_ = nullptr;
            }
            break;
        default:
            // Clean up "unmatched"
            {
                delete unmatched_;
                unmatched_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Response_Data_Object::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context, int t_byteorder) {
    // Parse "prefix"
    prefix_ = new Prefix_Type(qualifier_field());
    int t_prefix__size;
    t_prefix__size = prefix_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_prefix = t_begin_of_data + (t_prefix__size);
    BINPAC_ASSERT(t_dataptr_after_prefix <= t_end_of_data);
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( object_type_field() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)211):
            // Parse "attrib211"
            {
                attrib211_ = new AttributeCommon();
                int t_attrib211__size;
                t_attrib211__size = attrib211_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib211__size;
            }
            break;
        case ((uint16)212):
            // Parse "attrib212"
            {
                attrib212_ = new AttributeCommon();
                int t_attrib212__size;
                t_attrib212__size = attrib212_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib212__size;
            }
            break;
        case ((uint16)213):
            // Parse "attrib213"
            {
                attrib213_ = new AttributeCommon();
                int t_attrib213__size;
                t_attrib213__size = attrib213_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib213__size;
            }
            break;
        case ((uint16)214):
            // Parse "attrib214"
            {
                attrib214_ = new AttributeCommon();
                int t_attrib214__size;
                t_attrib214__size = attrib214_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib214__size;
            }
            break;
        case ((uint16)215):
            // Parse "attrib215"
            {
                attrib215_ = new AttributeCommon();
                int t_attrib215__size;
                t_attrib215__size = attrib215_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib215__size;
            }
            break;
        case ((uint16)216):
            // Parse "attrib216"
            {
                attrib216_ = new AttributeCommon();
                int t_attrib216__size;
                t_attrib216__size = attrib216_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib216__size;
            }
            break;
        case ((uint16)217):
            // Parse "attrib217"
            {
                attrib217_ = new AttributeCommon();
                int t_attrib217__size;
                t_attrib217__size = attrib217_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib217__size;
            }
            break;
        case ((uint16)218):
            // Parse "attrib218"
            {
                attrib218_ = new AttributeCommon();
                int t_attrib218__size;
                t_attrib218__size = attrib218_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib218__size;
            }
            break;
        case ((uint16)219):
            // Parse "attrib219"
            {
                attrib219_ = new AttributeCommon();
                int t_attrib219__size;
                t_attrib219__size = attrib219_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib219__size;
            }
            break;
        case ((uint16)220):
            // Parse "attrib220"
            {
                attrib220_ = new AttributeCommon();
                int t_attrib220__size;
                t_attrib220__size = attrib220_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib220__size;
            }
            break;
        case ((uint16)221):
            // Parse "attrib221"
            {
                attrib221_ = new AttributeCommon();
                int t_attrib221__size;
                t_attrib221__size = attrib221_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib221__size;
            }
            break;
        case ((uint16)222):
            // Parse "attrib222"
            {
                attrib222_ = new AttributeCommon();
                int t_attrib222__size;
                t_attrib222__size = attrib222_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib222__size;
            }
            break;
        case ((uint16)223):
            // Parse "attrib223"
            {
                attrib223_ = new AttributeCommon();
                int t_attrib223__size;
                t_attrib223__size = attrib223_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib223__size;
            }
            break;
        case ((uint16)224):
            // Parse "attrib224"
            {
                attrib224_ = new AttributeCommon();
                int t_attrib224__size;
                t_attrib224__size = attrib224_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib224__size;
            }
            break;
        case ((uint16)225):
            // Parse "attrib225"
            {
                attrib225_ = new AttributeCommon();
                int t_attrib225__size;
                t_attrib225__size = attrib225_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib225__size;
            }
            break;
        case ((uint16)226):
            // Parse "attrib226"
            {
                attrib226_ = new AttributeCommon();
                int t_attrib226__size;
                t_attrib226__size = attrib226_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib226__size;
            }
            break;
        case ((uint16)227):
            // Parse "attrib227"
            {
                attrib227_ = new AttributeCommon();
                int t_attrib227__size;
                t_attrib227__size = attrib227_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib227__size;
            }
            break;
        case ((uint16)228):
            // Parse "attrib228"
            {
                attrib228_ = new AttributeCommon();
                int t_attrib228__size;
                t_attrib228__size = attrib228_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib228__size;
            }
            break;
        case ((uint16)229):
            // Parse "attrib229"
            {
                attrib229_ = new AttributeCommon();
                int t_attrib229__size;
                t_attrib229__size = attrib229_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib229__size;
            }
            break;
        case ((uint16)230):
            // Parse "attrib230"
            {
                attrib230_ = new AttributeCommon();
                int t_attrib230__size;
                t_attrib230__size = attrib230_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib230__size;
            }
            break;
        case ((uint16)231):
            // Parse "attrib231"
            {
                attrib231_ = new AttributeCommon();
                int t_attrib231__size;
                t_attrib231__size = attrib231_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib231__size;
            }
            break;
        case ((uint16)232):
            // Parse "attrib232"
            {
                attrib232_ = new AttributeCommon();
                int t_attrib232__size;
                t_attrib232__size = attrib232_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib232__size;
            }
            break;
        case ((uint16)233):
            // Parse "attrib233"
            {
                attrib233_ = new AttributeCommon();
                int t_attrib233__size;
                t_attrib233__size = attrib233_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib233__size;
            }
            break;
        case ((uint16)234):
            // Parse "attrib234"
            {
                attrib234_ = new AttributeCommon();
                int t_attrib234__size;
                t_attrib234__size = attrib234_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib234__size;
            }
            break;
        case ((uint16)235):
            // Parse "attrib235"
            {
                attrib235_ = new AttributeCommon();
                int t_attrib235__size;
                t_attrib235__size = attrib235_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib235__size;
            }
            break;
        case ((uint16)236):
            // Parse "attrib236"
            {
                attrib236_ = new AttributeCommon();
                int t_attrib236__size;
                t_attrib236__size = attrib236_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib236__size;
            }
            break;
        case ((uint16)237):
            // Parse "attrib237"
            {
                attrib237_ = new AttributeCommon();
                int t_attrib237__size;
                t_attrib237__size = attrib237_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib237__size;
            }
            break;
        case ((uint16)238):
            // Parse "attrib238"
            {
                attrib238_ = new AttributeCommon();
                int t_attrib238__size;
                t_attrib238__size = attrib238_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib238__size;
            }
            break;
        case ((uint16)239):
            // Parse "attrib239"
            {
                attrib239_ = new AttributeCommon();
                int t_attrib239__size;
                t_attrib239__size = attrib239_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib239__size;
            }
            break;
        case ((uint16)240):
            // Parse "attrib240"
            {
                attrib240_ = new AttributeCommon();
                int t_attrib240__size;
                t_attrib240__size = attrib240_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib240__size;
            }
            break;
        case ((uint16)241):
            // Parse "attrib241"
            {
                attrib241_ = new AttributeCommon();
                int t_attrib241__size;
                t_attrib241__size = attrib241_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib241__size;
            }
            break;
        case ((uint16)242):
            // Parse "attrib242"
            {
                attrib242_ = new AttributeCommon();
                int t_attrib242__size;
                t_attrib242__size = attrib242_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib242__size;
            }
            break;
        case ((uint16)243):
            // Parse "attrib243"
            {
                attrib243_ = new AttributeCommon();
                int t_attrib243__size;
                t_attrib243__size = attrib243_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib243__size;
            }
            break;
        case ((uint16)245):
            // Parse "attrib245"
            {
                attrib245_ = new AttributeCommon();
                int t_attrib245__size;
                t_attrib245__size = attrib245_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib245__size;
            }
            break;
        case ((uint16)246):
            // Parse "attrib246"
            {
                attrib246_ = new AttributeCommon();
                int t_attrib246__size;
                t_attrib246__size = attrib246_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib246__size;
            }
            break;
        case ((uint16)247):
            // Parse "attrib247"
            {
                attrib247_ = new AttributeCommon();
                int t_attrib247__size;
                t_attrib247__size = attrib247_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib247__size;
            }
            break;
        case ((uint16)248):
            // Parse "attrib248"
            {
                attrib248_ = new AttributeCommon();
                int t_attrib248__size;
                t_attrib248__size = attrib248_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib248__size;
            }
            break;
        case ((uint16)249):
            // Parse "attrib249"
            {
                attrib249_ = new AttributeCommon();
                int t_attrib249__size;
                t_attrib249__size = attrib249_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib249__size;
            }
            break;
        case ((uint16)250):
            // Parse "attrib250"
            {
                attrib250_ = new AttributeCommon();
                int t_attrib250__size;
                t_attrib250__size = attrib250_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib250__size;
            }
            break;
        case ((uint16)252):
            // Parse "attrib252"
            {
                attrib252_ = new AttributeCommon();
                int t_attrib252__size;
                t_attrib252__size = attrib252_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib252__size;
            }
            break;
        case ((uint16)254):
            // Parse "attrib254"
            {
                attrib254_ = new AttributeCommon();
                int t_attrib254__size;
                t_attrib254__size = attrib254_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib254__size;
            }
            break;
        case ((uint16)255):
            // Parse "attrib255"
            {
                attrib255_ = new AttributeCommon();
                int t_attrib255__size;
                t_attrib255__size = attrib255_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_attrib255__size;
            }
            break;
        case ((uint16)257):
            // Parse "biwoflag"
            {
                // Checking out-of-bound for "Response_Data_Object:biwoflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:biwoflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                biwoflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)258):
            // Parse "biwflag"
            {
                // Checking out-of-bound for "Response_Data_Object:biwflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:biwflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                biwflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)513):
            // Parse "biewoflag"
            {
                // Checking out-of-bound for "Response_Data_Object:biewoflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:biewoflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                biewoflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)514):
            // Parse "biewatime"
            {
                biewatime_ = new BinInEveAtime();
                int t_biewatime__size;
                t_biewatime__size = biewatime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_biewatime__size;
            }
            break;
        case ((uint16)515):
            // Parse "biewrtime"
            {
                biewrtime_ = new BinInEveRtime();
                biewrtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)769):
            // Parse "dbibytes"
            {
                int t_dbibytes_string_length;
                t_dbibytes_string_length = (t_end_of_data) - (t_dataptr_after_prefix);
                int t_dbibytes__size;
                t_dbibytes__size = t_dbibytes_string_length;
                // check for negative sizes
                if ( t_dbibytes_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:394", t_dbibytes_string_length);
                dbibytes_.init(t_dataptr_after_prefix, t_dbibytes_string_length);
                t_data__size = t_dbibytes__size;
            }
            break;
        case ((uint16)770):
            // Parse "dbiflag"
            {
                // Checking out-of-bound for "Response_Data_Object:dbiflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:dbiflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                dbiflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)1025):
            // Parse "dbieatime"
            {
                dbieatime_ = new DoubleInEveAtime();
                int t_dbieatime__size;
                t_dbieatime__size = dbieatime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_dbieatime__size;
            }
            break;
        case ((uint16)1026):
            // Parse "dbiertime"
            {
                dbiertime_ = new DoubleInEveRtime();
                dbiertime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)2561):
            // Parse "bowoflag"
            {
                // Checking out-of-bound for "Response_Data_Object:bowoflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:bowoflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bowoflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)2562):
            // Parse "bowflag"
            {
                // Checking out-of-bound for "Response_Data_Object:bowflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:bowflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bowflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)2817):
            // Parse "boewflag"
            {
                // Checking out-of-bound for "Response_Data_Object:boewflag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:boewflag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                boewflag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)2818):
            // Parse "boewatime"
            {
                boewatime_ = new BinOutEveAtime();
                int t_boewatime__size;
                t_boewatime__size = boewatime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_boewatime__size;
            }
            break;
        case ((uint16)3073):
            // Parse "bocmd_CROB"
            {
                bocmd_CROB_ = new CROB();
                bocmd_CROB_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 11;
            }
            break;
        case ((uint16)3074):
            // Parse "bocmd_PCB"
            {
                bocmd_PCB_ = new PCB();
                bocmd_PCB_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 11;
            }
            break;
        case ((uint16)3075):
            // Parse "bocmd_PM"
            {
                // Checking out-of-bound for "Response_Data_Object:bocmd_PM"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:bocmd_PM",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bocmd_PM_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)3329):
            // Parse "boceFlag"
            {
                // Checking out-of-bound for "Response_Data_Object:boceFlag"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:boceFlag",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                boceFlag_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)3330):
            // Parse "boceAtime"
            {
                boceAtime_ = new BinOutCmdEveAtime();
                int t_boceAtime__size;
                t_boceAtime__size = boceAtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_boceAtime__size;
            }
            break;
        case ((uint16)5121):
            // Parse "counter_32_wflag"
            {
                counter_32_wflag_ = new Counter32wFlag();
                counter_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)5122):
            // Parse "counter_16_wflag"
            {
                counter_16_wflag_ = new Counter16wFlag();
                counter_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)5123):
            // Parse "counter_32_wflag_delta"
            {
                counter_32_wflag_delta_ = new Debug_Byte();
                int t_counter_32_wflag_delta__size;
                t_counter_32_wflag_delta__size = counter_32_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_32_wflag_delta__size;
            }
            break;
        case ((uint16)5124):
            // Parse "counter_16_wflag_delta"
            {
                counter_16_wflag_delta_ = new Debug_Byte();
                int t_counter_16_wflag_delta__size;
                t_counter_16_wflag_delta__size = counter_16_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_16_wflag_delta__size;
            }
            break;
        case ((uint16)5125):
            // Parse "counter_32_woflag"
            {
                counter_32_woflag_ = new Counter32woFlag();
                counter_32_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 4;
            }
            break;
        case ((uint16)5126):
            // Parse "counter_16_woflag"
            {
                counter_16_woflag_ = new Counter16woFlag();
                counter_16_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 2;
            }
            break;
        case ((uint16)5127):
            // Parse "counter_32_woflag_delta"
            {
                counter_32_woflag_delta_ = new Debug_Byte();
                int t_counter_32_woflag_delta__size;
                t_counter_32_woflag_delta__size = counter_32_woflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_32_woflag_delta__size;
            }
            break;
        case ((uint16)5128):
            // Parse "counter_16_woflag_delta"
            {
                counter_16_woflag_delta_ = new Debug_Byte();
                int t_counter_16_woflag_delta__size;
                t_counter_16_woflag_delta__size = counter_16_woflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_16_woflag_delta__size;
            }
            break;
        case ((uint16)5377):
            // Parse "f_counter_32_wflag"
            {
                f_counter_32_wflag_ = new FrozenCounter32wFlag();
                f_counter_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)5378):
            // Parse "f_counter_16_wflag"
            {
                f_counter_16_wflag_ = new FrozenCounter16wFlag();
                f_counter_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)5379):
            // Parse "f_counter_32_wflag_delta"
            {
                f_counter_32_wflag_delta_ = new Debug_Byte();
                int t_f_counter_32_wflag_delta__size;
                t_f_counter_32_wflag_delta__size = f_counter_32_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_32_wflag_delta__size;
            }
            break;
        case ((uint16)5380):
            // Parse "f_counter_16_wflag_delta"
            {
                f_counter_16_wflag_delta_ = new Debug_Byte();
                int t_f_counter_16_wflag_delta__size;
                t_f_counter_16_wflag_delta__size = f_counter_16_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_16_wflag_delta__size;
            }
            break;
        case ((uint16)5381):
            // Parse "f_counter_32_wflag_time"
            {
                f_counter_32_wflag_time_ = new FrozenCounter32wFlagTime();
                int t_f_counter_32_wflag_time__size;
                t_f_counter_32_wflag_time__size = f_counter_32_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_32_wflag_time__size;
            }
            break;
        case ((uint16)5382):
            // Parse "f_counter_16_wflag_time"
            {
                f_counter_16_wflag_time_ = new FrozenCounter16wFlagTime();
                int t_f_counter_16_wflag_time__size;
                t_f_counter_16_wflag_time__size = f_counter_16_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_16_wflag_time__size;
            }
            break;
        case ((uint16)5383):
            // Parse "f_counter_32_wflag_time_delta"
            {
                f_counter_32_wflag_time_delta_ = new Debug_Byte();
                int t_f_counter_32_wflag_time_delta__size;
                t_f_counter_32_wflag_time_delta__size = f_counter_32_wflag_time_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_32_wflag_time_delta__size;
            }
            break;
        case ((uint16)5384):
            // Parse "f_counter_16_wflag_time_delta"
            {
                f_counter_16_wflag_time_delta_ = new Debug_Byte();
                int t_f_counter_16_wflag_time_delta__size;
                t_f_counter_16_wflag_time_delta__size = f_counter_16_wflag_time_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_16_wflag_time_delta__size;
            }
            break;
        case ((uint16)5385):
            // Parse "f_counter_32_woflag"
            {
                f_counter_32_woflag_ = new FrozenCounter32woFlag();
                f_counter_32_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 4;
            }
            break;
        case ((uint16)5386):
            // Parse "f_counter_16_woflag"
            {
                f_counter_16_woflag_ = new FrozenCounter16woFlag();
                f_counter_16_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 2;
            }
            break;
        case ((uint16)5387):
            // Parse "f_counter_32_woflag_delta"
            {
                f_counter_32_woflag_delta_ = new Debug_Byte();
                int t_f_counter_32_woflag_delta__size;
                t_f_counter_32_woflag_delta__size = f_counter_32_woflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_32_woflag_delta__size;
            }
            break;
        case ((uint16)5388):
            // Parse "f_counter_16_woflag_delta"
            {
                f_counter_16_woflag_delta_ = new Debug_Byte();
                int t_f_counter_16_woflag_delta__size;
                t_f_counter_16_woflag_delta__size = f_counter_16_woflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_16_woflag_delta__size;
            }
            break;
        case ((uint16)5633):
            // Parse "counter_event_32_wflag"
            {
                counter_event_32_wflag_ = new CounterEve32wFlag();
                counter_event_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)5634):
            // Parse "counter_event_16_wflag"
            {
                counter_event_16_wflag_ = new CounterEve16wFlag();
                counter_event_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)5635):
            // Parse "counter_event_32_wflag_delta"
            {
                counter_event_32_wflag_delta_ = new Debug_Byte();
                int t_counter_event_32_wflag_delta__size;
                t_counter_event_32_wflag_delta__size = counter_event_32_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_event_32_wflag_delta__size;
            }
            break;
        case ((uint16)5636):
            // Parse "counter_event_16_wflag_delta"
            {
                counter_event_16_wflag_delta_ = new Debug_Byte();
                int t_counter_event_16_wflag_delta__size;
                t_counter_event_16_wflag_delta__size = counter_event_16_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_event_16_wflag_delta__size;
            }
            break;
        case ((uint16)5637):
            // Parse "counter_event_32_wflag_time"
            {
                counter_event_32_wflag_time_ = new CounterEve32wFlagTime();
                int t_counter_event_32_wflag_time__size;
                t_counter_event_32_wflag_time__size = counter_event_32_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_counter_event_32_wflag_time__size;
            }
            break;
        case ((uint16)5638):
            // Parse "counter_event_16_wflag_time"
            {
                counter_event_16_wflag_time_ = new CounterEve16wFlagTime();
                int t_counter_event_16_wflag_time__size;
                t_counter_event_16_wflag_time__size = counter_event_16_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_counter_event_16_wflag_time__size;
            }
            break;
        case ((uint16)5639):
            // Parse "counter_event_32_wflag_time_delta"
            {
                counter_event_32_wflag_time_delta_ = new Debug_Byte();
                int t_counter_event_32_wflag_time_delta__size;
                t_counter_event_32_wflag_time_delta__size = counter_event_32_wflag_time_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_event_32_wflag_time_delta__size;
            }
            break;
        case ((uint16)5640):
            // Parse "counter_event_16_wflag_time_delat"
            {
                counter_event_16_wflag_time_delat_ = new Debug_Byte();
                int t_counter_event_16_wflag_time_delat__size;
                t_counter_event_16_wflag_time_delat__size = counter_event_16_wflag_time_delat_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_counter_event_16_wflag_time_delat__size;
            }
            break;
        case ((uint16)5889):
            // Parse "f_counter_event_32_wflag"
            {
                f_counter_event_32_wflag_ = new CounterEve32wFlag();
                f_counter_event_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)5890):
            // Parse "f_counter_event_16_wflag"
            {
                f_counter_event_16_wflag_ = new CounterEve16wFlag();
                f_counter_event_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)5891):
            // Parse "f_counter_event_32_wflag_delta"
            {
                f_counter_event_32_wflag_delta_ = new Debug_Byte();
                int t_f_counter_event_32_wflag_delta__size;
                t_f_counter_event_32_wflag_delta__size = f_counter_event_32_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_event_32_wflag_delta__size;
            }
            break;
        case ((uint16)5892):
            // Parse "f_counter_event_16_wflag_delta"
            {
                f_counter_event_16_wflag_delta_ = new Debug_Byte();
                int t_f_counter_event_16_wflag_delta__size;
                t_f_counter_event_16_wflag_delta__size = f_counter_event_16_wflag_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_event_16_wflag_delta__size;
            }
            break;
        case ((uint16)5893):
            // Parse "f_counter_event_32_wflag_time"
            {
                f_counter_event_32_wflag_time_ = new CounterEve32wFlagTime();
                int t_f_counter_event_32_wflag_time__size;
                t_f_counter_event_32_wflag_time__size = f_counter_event_32_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_f_counter_event_32_wflag_time__size;
            }
            break;
        case ((uint16)5894):
            // Parse "f_counter_event_16_wflag_time"
            {
                f_counter_event_16_wflag_time_ = new CounterEve16wFlagTime();
                int t_f_counter_event_16_wflag_time__size;
                t_f_counter_event_16_wflag_time__size = f_counter_event_16_wflag_time_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_f_counter_event_16_wflag_time__size;
            }
            break;
        case ((uint16)5895):
            // Parse "f_counter_event_32_wflag_time_delta"
            {
                f_counter_event_32_wflag_time_delta_ = new Debug_Byte();
                int t_f_counter_event_32_wflag_time_delta__size;
                t_f_counter_event_32_wflag_time_delta__size = f_counter_event_32_wflag_time_delta_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_event_32_wflag_time_delta__size;
            }
            break;
        case ((uint16)5896):
            // Parse "f_counter_event_16_wflag_time_delat"
            {
                f_counter_event_16_wflag_time_delat_ = new Debug_Byte();
                int t_f_counter_event_16_wflag_time_delat__size;
                t_f_counter_event_16_wflag_time_delat__size = f_counter_event_16_wflag_time_delat_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_counter_event_16_wflag_time_delat__size;
            }
            break;
        case ((uint16)7681):
            // Parse "ai_32_wflag"
            {
                ai_32_wflag_ = new AnalogInput32wFlag();
                ai_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)7682):
            // Parse "ai_16_wflag"
            {
                ai_16_wflag_ = new AnalogInput16wFlag();
                ai_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)7683):
            // Parse "ai_32_woflag"
            {
                ai_32_woflag_ = new AnalogInput32woFlag();
                ai_32_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 4;
            }
            break;
        case ((uint16)7684):
            // Parse "ai_16_woflag"
            {
                ai_16_woflag_ = new AnalogInput16woFlag();
                ai_16_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 2;
            }
            break;
        case ((uint16)7685):
            // Parse "ai_sp_wflag"
            {
                ai_sp_wflag_ = new AnalogInputSPwFlag();
                ai_sp_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)7686):
            // Parse "ai_dp_wflag"
            {
                ai_dp_wflag_ = new AnalogInputDPwFlag();
                ai_dp_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 9;
            }
            break;
        case ((uint16)7937):
            // Parse "f_ai_32_wflag"
            {
                f_ai_32_wflag_ = new FrozenAnalogInput32wFlag();
                f_ai_32_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)7938):
            // Parse "f_ai_16_wflag"
            {
                f_ai_16_wflag_ = new FrozenAnalogInput16wFlag();
                f_ai_16_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)7939):
            // Parse "f_ai_32_wtime"
            {
                f_ai_32_wtime_ = new FrozenAnalogInput32wTime();
                int t_f_ai_32_wtime__size;
                t_f_ai_32_wtime__size = f_ai_32_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_ai_32_wtime__size;
            }
            break;
        case ((uint16)7940):
            // Parse "f_ai_16_wtime"
            {
                f_ai_16_wtime_ = new FrozenAnalogInput16wTime();
                int t_f_ai_16_wtime__size;
                t_f_ai_16_wtime__size = f_ai_16_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_f_ai_16_wtime__size;
            }
            break;
        case ((uint16)7941):
            // Parse "f_ai_32_woflag"
            {
                f_ai_32_woflag_ = new FrozenAnalogInput32woFlag();
                f_ai_32_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 4;
            }
            break;
        case ((uint16)7942):
            // Parse "f_ai_16_woflag"
            {
                f_ai_16_woflag_ = new FrozenAnalogInput16woFlag();
                f_ai_16_woflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 2;
            }
            break;
        case ((uint16)7943):
            // Parse "f_ai_sp_wflag"
            {
                f_ai_sp_wflag_ = new FrozenAnalogInputSPwFlag();
                f_ai_sp_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)7944):
            // Parse "f_ai_dp_wflag"
            {
                f_ai_dp_wflag_ = new FrozenAnalogInputDPwFlag();
                f_ai_dp_wflag_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 9;
            }
            break;
        case ((uint16)8193):
            // Parse "ai32wotime"
            {
                ai32wotime_ = new AnalogInput32woTime();
                ai32wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)8194):
            // Parse "ai16wotime"
            {
                ai16wotime_ = new AnalogInput16woTime();
                ai16wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)8195):
            // Parse "ai32wtime"
            {
                ai32wtime_ = new AnalogInput32wTime();
                int t_ai32wtime__size;
                t_ai32wtime__size = ai32wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_ai32wtime__size;
            }
            break;
        case ((uint16)8196):
            // Parse "ai16wtime"
            {
                ai16wtime_ = new AnalogInput16wTime();
                int t_ai16wtime__size;
                t_ai16wtime__size = ai16wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_ai16wtime__size;
            }
            break;
        case ((uint16)8197):
            // Parse "aispwotime"
            {
                aispwotime_ = new AnalogInputSPwoTime();
                aispwotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)8198):
            // Parse "aidpwotime"
            {
                aidpwotime_ = new AnalogInputDPwoTime();
                aidpwotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 9;
            }
            break;
        case ((uint16)8199):
            // Parse "aispwtime"
            {
                aispwtime_ = new AnalogInputSPwTime();
                int t_aispwtime__size;
                t_aispwtime__size = aispwtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_aispwtime__size;
            }
            break;
        case ((uint16)8200):
            // Parse "aidpwtime"
            {
                aidpwtime_ = new AnalogInputDPwTime();
                int t_aidpwtime__size;
                t_aidpwtime__size = aidpwtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_aidpwtime__size;
            }
            break;
        case ((uint16)8449):
            // Parse "faie_32_wotime"
            {
                faie_32_wotime_ = new FrozenAnaInputEve32woTime();
                faie_32_wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)8450):
            // Parse "faie_16_wotime"
            {
                faie_16_wotime_ = new FrozenAnaInputEve16woTime();
                faie_16_wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 3;
            }
            break;
        case ((uint16)8451):
            // Parse "faie_32_wtime"
            {
                faie_32_wtime_ = new FrozenAnaInputEve32wTime();
                int t_faie_32_wtime__size;
                t_faie_32_wtime__size = faie_32_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_faie_32_wtime__size;
            }
            break;
        case ((uint16)8452):
            // Parse "faie_16_wtime"
            {
                faie_16_wtime_ = new FrozenAnaInputEve16wTime();
                int t_faie_16_wtime__size;
                t_faie_16_wtime__size = faie_16_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_faie_16_wtime__size;
            }
            break;
        case ((uint16)8453):
            // Parse "faie_sp_wotime"
            {
                faie_sp_wotime_ = new FrozenAnaInputEveSPwoTime();
                faie_sp_wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 5;
            }
            break;
        case ((uint16)8454):
            // Parse "faie_dp_wotime"
            {
                faie_dp_wotime_ = new FrozenAnaInputEveDPwoTime();
                faie_dp_wotime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = 9;
            }
            break;
        case ((uint16)8455):
            // Parse "faie_sp_wtime"
            {
                faie_sp_wtime_ = new FrozenAnaInputEveSPwTime();
                int t_faie_sp_wtime__size;
                t_faie_sp_wtime__size = faie_sp_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_faie_sp_wtime__size;
            }
            break;
        case ((uint16)8456):
            // Parse "faie_dp_wtime"
            {
                faie_dp_wtime_ = new FrozenAnaInputEveDPwTime();
                int t_faie_dp_wtime__size;
                t_faie_dp_wtime__size = faie_dp_wtime_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_faie_dp_wtime__size;
            }
            break;
        case ((uint16)8705):
            // Parse "ai_dead_16"
            {
                // Checking out-of-bound for "Response_Data_Object:ai_dead_16"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:ai_dead_16",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                ai_dead_16_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)8706):
            // Parse "ai_dead_32"
            {
                // Checking out-of-bound for "Response_Data_Object:ai_dead_32"
                if ( t_dataptr_after_prefix + (4) > t_end_of_data || t_dataptr_after_prefix + (4) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:ai_dead_32",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                ai_dead_32_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_prefix)));
                t_data__size = 4;
            }
            break;
        case ((uint16)8707):
            // Parse "ai_dead_sp"
            {
                // Checking out-of-bound for "Response_Data_Object:ai_dead_sp"
                if ( t_dataptr_after_prefix + (4) > t_end_of_data || t_dataptr_after_prefix + (4) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:ai_dead_sp",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                ai_dead_sp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_prefix)));
                t_data__size = 4;
            }
            break;
        case ((uint16)10241):
            // Parse "aos_32"
            {
                aos_32_ = new AnaOutStatus32();
                aos_32_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10242):
            // Parse "aos_16"
            {
                aos_16_ = new AnaOutStatus16();
                aos_16_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)10243):
            // Parse "aos_sp"
            {
                aos_sp_ = new AnaOutStatusSP();
                aos_sp_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10244):
            // Parse "aos_dp"
            {
                aos_dp_ = new AnaOutStatusDP();
                aos_dp_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 9;
            }
            break;
        case ((uint16)10497):
            // Parse "ao_32"
            {
                ao_32_ = new AnaOut32();
                ao_32_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10498):
            // Parse "ao_16"
            {
                ao_16_ = new AnaOut16();
                ao_16_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)10499):
            // Parse "ao_sp"
            {
                ao_sp_ = new AnaOutSP();
                ao_sp_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10500):
            // Parse "ao_dp"
            {
                ao_dp_ = new AnaOutDP();
                ao_dp_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 9;
            }
            break;
        case ((uint16)10753):
            // Parse "aoe32wotime"
            {
                aoe32wotime_ = new AnaOutEve32woTime();
                aoe32wotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10754):
            // Parse "aoe16wotime"
            {
                aoe16wotime_ = new AnaOutEve16woTime();
                aoe16wotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)10755):
            // Parse "aoe32wtime"
            {
                aoe32wtime_ = new AnaOutEve32wTime();
                int t_aoe32wtime__size;
                t_aoe32wtime__size = aoe32wtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoe32wtime__size;
            }
            break;
        case ((uint16)10756):
            // Parse "aoe16wtime"
            {
                aoe16wtime_ = new AnaOutEve16wTime();
                int t_aoe16wtime__size;
                t_aoe16wtime__size = aoe16wtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoe16wtime__size;
            }
            break;
        case ((uint16)10757):
            // Parse "aoespwotime"
            {
                aoespwotime_ = new AnaOutEveSPwoTime();
                aoespwotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)10758):
            // Parse "aoedpwotime"
            {
                aoedpwotime_ = new AnaOutEveDPwoTime();
                aoedpwotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 9;
            }
            break;
        case ((uint16)10759):
            // Parse "aoespwtime"
            {
                aoespwtime_ = new AnaOutEveSPwTime();
                int t_aoespwtime__size;
                t_aoespwtime__size = aoespwtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoespwtime__size;
            }
            break;
        case ((uint16)10760):
            // Parse "aoedpwtime"
            {
                aoedpwtime_ = new AnaOutEveDPwTime();
                int t_aoedpwtime__size;
                t_aoedpwtime__size = aoedpwtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoedpwtime__size;
            }
            break;
        case ((uint16)11009):
            // Parse "aoce32wotime"
            {
                aoce32wotime_ = new AnaOutEve32woTime();
                aoce32wotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)11010):
            // Parse "aoce16wotime"
            {
                aoce16wotime_ = new AnaOutEve16woTime();
                aoce16wotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)11011):
            // Parse "aoce32wtime"
            {
                aoce32wtime_ = new AnaOutEve32wTime();
                int t_aoce32wtime__size;
                t_aoce32wtime__size = aoce32wtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoce32wtime__size;
            }
            break;
        case ((uint16)11012):
            // Parse "aoce16wtime"
            {
                aoce16wtime_ = new AnaOutEve16wTime();
                int t_aoce16wtime__size;
                t_aoce16wtime__size = aoce16wtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aoce16wtime__size;
            }
            break;
        case ((uint16)11013):
            // Parse "aocespwotime"
            {
                aocespwotime_ = new AnaOutEveSPwoTime();
                aocespwotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)11014):
            // Parse "aocedpwotime"
            {
                aocedpwotime_ = new AnaOutEveDPwoTime();
                aocedpwotime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 9;
            }
            break;
        case ((uint16)11015):
            // Parse "aocespwtime"
            {
                aocespwtime_ = new AnaOutEveSPwTime();
                int t_aocespwtime__size;
                t_aocespwtime__size = aocespwtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aocespwtime__size;
            }
            break;
        case ((uint16)11016):
            // Parse "aocedpwtime"
            {
                aocedpwtime_ = new AnaOutEveDPwTime();
                int t_aocedpwtime__size;
                t_aocedpwtime__size = aocedpwtime_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_aocedpwtime__size;
            }
            break;
        case ((uint16)12801):
            // Parse "time_abs"
            {
                time_abs_ = new AbsTime();
                int t_time_abs__size;
                t_time_abs__size = time_abs_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs__size;
            }
            break;
        case ((uint16)12802):
            // Parse "time_interval"
            {
                time_interval_ = new AbsTimeInterval();
                int t_time_interval__size;
                t_time_interval__size = time_interval_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_interval__size;
            }
            break;
        case ((uint16)12803):
            // Parse "time_abs_last"
            {
                time_abs_last_ = new Last_AbsTime();
                int t_time_abs_last__size;
                t_time_abs_last__size = time_abs_last_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_last__size;
            }
            break;
        case ((uint16)13057):
            // Parse "time_abs_sync"
            {
                time_abs_sync_ = new AbsTime();
                int t_time_abs_sync__size;
                t_time_abs_sync__size = time_abs_sync_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_sync__size;
            }
            break;
        case ((uint16)13058):
            // Parse "time_abs_unsync"
            {
                time_abs_unsync_ = new AbsTime();
                int t_time_abs_unsync__size;
                t_time_abs_unsync__size = time_abs_unsync_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_time_abs_unsync__size;
            }
            break;
        case ((uint16)13313):
            // Parse "time_coarse"
            {
                // Checking out-of-bound for "Response_Data_Object:time_coarse"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:time_coarse",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                time_coarse_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)13314):
            // Parse "time_fine"
            {
                // Checking out-of-bound for "Response_Data_Object:time_fine"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:time_fine",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                time_fine_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)17921):
            // Parse "file_control_id"
            {
                file_control_id_ = new File_Control_ID();
                int t_file_control_id__size;
                t_file_control_id__size = file_control_id_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_id__size;
            }
            break;
        case ((uint16)17922):
            // Parse "file_control_auth"
            {
                file_control_auth_ = new File_Control_Auth();
                int t_file_control_auth__size;
                t_file_control_auth__size = file_control_auth_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_auth__size;
            }
            break;
        case ((uint16)17923):
            // Parse "file_control_cmd"
            {
                file_control_cmd_ = new File_Control_Cmd();
                int t_file_control_cmd__size;
                t_file_control_cmd__size = file_control_cmd_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_cmd__size;
            }
            break;
        case ((uint16)17924):
            // Parse "file_control_cmd_status"
            {
                file_control_cmd_status_ = new File_Control_Cmd_Status(prefix()->prefix_value());
                int t_file_control_cmd_status__size;
                t_file_control_cmd_status__size = file_control_cmd_status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_control_cmd_status__size;
            }
            break;
        case ((uint16)17925):
            // Parse "file_trans"
            {
                file_trans_ = new File_Transport(prefix()->prefix_value());
                int t_file_trans__size;
                t_file_trans__size = file_trans_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_file_trans__size;
            }
            break;
        case ((uint16)17926):
            // Parse "file_trans_status"
            {
                file_trans_status_ = new File_Transport_Status(prefix()->prefix_value());
                int t_file_trans_status__size;
                t_file_trans_status__size = file_trans_status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_trans_status__size;
            }
            break;
        case ((uint16)17927):
            // Parse "file_desc"
            {
                file_desc_ = new File_Desc();
                int t_file_desc__size;
                t_file_desc__size = file_desc_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_file_desc__size;
            }
            break;
        case ((uint16)20481):
            // Parse "iin"
            {
                // Checking out-of-bound for "Response_Data_Object:iin"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:iin",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                iin_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)20737):
            // Parse "dev_store"
            {
                dev_store_ = new Dev_Store();
                dev_store_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 3;
            }
            break;
        case ((uint16)20993):
            // Parse "dev_profile"
            {
                dev_profile_ = new Dev_Profile();
                int t_dev_profile__size;
                t_dev_profile__size = dev_profile_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_dev_profile__size;
            }
            break;
        case ((uint16)21249):
            // Parse "priregobj"
            {
                priregobj_ = new PrivRegObj();
                int t_priregobj__size;
                t_priregobj__size = priregobj_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_priregobj__size;
            }
            break;
        case ((uint16)21250):
            // Parse "priregobjdesc"
            {
                priregobjdesc_ = new PrivRegObjDesc();
                int t_priregobjdesc__size;
                t_priregobjdesc__size = priregobjdesc_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_priregobjdesc__size;
            }
            break;
        case ((uint16)21761):
            // Parse "desc_ele"
            {
                desc_ele_ = new DescEle();
                desc_ele_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)22017):
            // Parse "desc_ele86"
            {
                desc_ele86_ = new DescEle();
                desc_ele86_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 5;
            }
            break;
        case ((uint16)22018):
            // Parse "cha"
            {
                // Checking out-of-bound for "Response_Data_Object:cha"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:cha",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                cha_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)22019):
            // Parse "point_index_attr"
            {
                point_index_attr_ = new Debug_Byte();
                int t_point_index_attr__size;
                t_point_index_attr__size = point_index_attr_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_point_index_attr__size;
            }
            break;
        case ((uint16)22273):
            // Parse "present_value"
            {
                present_value_ = new Debug_Byte();
                int t_present_value__size;
                t_present_value__size = present_value_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_present_value__size;
            }
            break;
        case ((uint16)22529):
            // Parse "snapshot"
            {
                snapshot_ = new Debug_Byte();
                int t_snapshot__size;
                t_snapshot__size = snapshot_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_snapshot__size;
            }
            break;
        case ((uint16)23297):
            // Parse "activate_conf"
            {
                activate_conf_ = new ActivateConf();
                int t_activate_conf__size;
                t_activate_conf__size = activate_conf_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_activate_conf__size;
            }
            break;
        case ((uint16)25857):
            // Parse "bcd_small"
            {
                // Checking out-of-bound for "Response_Data_Object:bcd_small"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:bcd_small",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bcd_small_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)25858):
            // Parse "bcd_medium"
            {
                // Checking out-of-bound for "Response_Data_Object:bcd_medium"
                if ( t_dataptr_after_prefix + (4) > t_end_of_data || t_dataptr_after_prefix + (4) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:bcd_medium",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                bcd_medium_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_prefix)));
                t_data__size = 4;
            }
            break;
        case ((uint16)25859):
            // Parse "bcd_large"
            {
                bcd_large_ = new BCD_Large();
                bcd_large_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 8;
            }
            break;
        case ((uint16)26113):
            // Parse "unsigned_integer"
            {
                // Checking out-of-bound for "Response_Data_Object:unsigned_integer"
                if ( t_dataptr_after_prefix + (1) > t_end_of_data || t_dataptr_after_prefix + (1) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:unsigned_integer",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                unsigned_integer_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_prefix));
                t_data__size = 1;
            }
            break;
        case ((uint16)30721):
            // Parse "challenge"
            {
                challenge_ = new AuthChallenge(prefix()->prefix_value());
                int t_challenge__size;
                t_challenge__size = challenge_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_challenge__size;
            }
            break;
        case ((uint16)30722):
            // Parse "reply"
            {
                reply_ = new AuthReply(prefix()->prefix_value());
                int t_reply__size;
                t_reply__size = reply_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_reply__size;
            }
            break;
        case ((uint16)30723):
            // Parse "aggrRequest"
            {
                aggrRequest_ = new AuthAggrRequest(prefix()->prefix_value());
                aggrRequest_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = 6;
            }
            break;
        case ((uint16)30724):
            // Parse "sessionKeyRequest"
            {
                // Checking out-of-bound for "Response_Data_Object:sessionKeyRequest"
                if ( t_dataptr_after_prefix + (2) > t_end_of_data || t_dataptr_after_prefix + (2) < t_dataptr_after_prefix ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Response_Data_Object:sessionKeyRequest",
                    	((t_dataptr_after_prefix - t_begin_of_data)) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                sessionKeyRequest_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_prefix)));
                t_data__size = 2;
            }
            break;
        case ((uint16)30725):
            // Parse "status"
            {
                status_ = new AuthSessionKeyStatus(prefix()->prefix_value());
                int t_status__size;
                t_status__size = status_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_status__size;
            }
            break;
        case ((uint16)30726):
            // Parse "keyChange"
            {
                keyChange_ = new AuthSessionKeyChange(prefix()->prefix_value());
                int t_keyChange__size;
                t_keyChange__size = keyChange_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_keyChange__size;
            }
            break;
        case ((uint16)30727):
            // Parse "error"
            {
                error_ = new AuthError(prefix()->prefix_value());
                int t_error__size;
                t_error__size = error_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_error__size;
            }
            break;
        case ((uint16)30728):
            // Parse "user_cert"
            {
                user_cert_ = new UserCert(prefix()->prefix_value());
                int t_user_cert__size;
                t_user_cert__size = user_cert_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_user_cert__size;
            }
            break;
        case ((uint16)30729):
            // Parse "mac"
            {
                mac_ = new MAC(prefix()->prefix_value());
                int t_mac__size;
                t_mac__size = mac_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_mac__size;
            }
            break;
        case ((uint16)30730):
            // Parse "user_status_change"
            {
                user_status_change_ = new UserStatusChange(prefix()->prefix_value());
                int t_user_status_change__size;
                t_user_status_change__size = user_status_change_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_user_status_change__size;
            }
            break;
        case ((uint16)30731):
            // Parse "update_key_req"
            {
                update_key_req_ = new UpdateKeyReq(prefix()->prefix_value());
                int t_update_key_req__size;
                t_update_key_req__size = update_key_req_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_req__size;
            }
            break;
        case ((uint16)30732):
            // Parse "update_key_rep"
            {
                update_key_rep_ = new UpdateKeyRep(prefix()->prefix_value());
                int t_update_key_rep__size;
                t_update_key_rep__size = update_key_rep_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_rep__size;
            }
            break;
        case ((uint16)30733):
            // Parse "update_key"
            {
                update_key_ = new UpdateKey(prefix()->prefix_value());
                int t_update_key__size;
                t_update_key__size = update_key_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key__size;
            }
            break;
        case ((uint16)30734):
            // Parse "update_key_sig"
            {
                update_key_sig_ = new UpdateKeySig(prefix()->prefix_value());
                int t_update_key_sig__size;
                t_update_key_sig__size = update_key_sig_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_sig__size;
            }
            break;
        case ((uint16)30735):
            // Parse "update_key_con"
            {
                update_key_con_ = new UpdateKeyCon(prefix()->prefix_value());
                int t_update_key_con__size;
                t_update_key_con__size = update_key_con_->Parse(t_dataptr_after_prefix, t_end_of_data);
                t_data__size = t_update_key_con__size;
            }
            break;
        default:
            // Parse "unmatched"
            {
                unmatched_ = new Default_Wrap(object_type_field());
                int t_unmatched__size;
                t_unmatched__size = unmatched_->Parse(t_dataptr_after_prefix, t_end_of_data, t_context);
                t_data__size = t_unmatched__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Response_Data_Object__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_prefix + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Response_Data_Object__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    int t_t_var_005;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch (  ( object_type_field() )  ) {
        case ((uint16)257):
            t_t_var_005 = biwoflag();
            break;
        case ((uint16)258):
            t_t_var_005 = biwflag();
            break;
        case ((uint16)2561):
            t_t_var_005 = bowoflag();
            break;
        case ((uint16)2562):
            t_t_var_005 = bowflag();
            break;
        default:
            t_t_var_005 = 0xff;
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    data_value_ = t_t_var_005;
    process_request_ = t_context->flow()->get_dnp3_response_data_object(data_value());
    BINPAC_ASSERT(t_begin_of_data + (t_Response_Data_Object__size) <= t_end_of_data);
    return t_Response_Data_Object__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Default_Wrap::Default_Wrap(uint32 obj_type) {
    unresolved_case_index_ = -1;
    unknown_ = nullptr;
    obj_type_ = obj_type;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Default_Wrap::~Default_Wrap() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( unresolved_case_index() ) {
        case ((int)28160):
            // Clean up "oct_str"
            {
                oct_str_.free();
            }
            break;
        case ((int)28416):
            // Clean up "oct_str_eve"
            {
                oct_str_eve_.free();
            }
            break;
        case ((int)28672):
            // Clean up "vir_ter_out_blk"
            {
                vir_ter_out_blk_.free();
            }
            break;
        case ((int)28928):
            // Clean up "vir_ter_eve"
            {
                vir_ter_eve_.free();
            }
            break;
        default:
            // Clean up "unknown"
            {
                delete unknown_;
                unknown_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Default_Wrap::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Parse "unresolved"
    int t_unresolved__size;
    unresolved_case_index_ =  ( obj_type() & 0xFF00 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( unresolved_case_index() ) {
        case ((int)28160):
            // Parse "oct_str"
            {
                int t_oct_str__size;
                t_oct_str__size =  ( obj_type() & 0x00FF ) ;
                // Checking out-of-bound for "Default_Wrap:oct_str"
                if ( t_begin_of_data + (t_oct_str__size) > t_end_of_data || t_begin_of_data + (t_oct_str__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Default_Wrap:oct_str",
                    	(0) + (t_oct_str__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_oct_str__size;
                    int t_oct_str_string_length;
                    t_oct_str_string_length =  ( obj_type() & 0x00FF ) ;
                    // check for negative sizes
                    if ( t_oct_str_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:634", t_oct_str_string_length);
                    oct_str_.init(t_begin_of_data, t_oct_str_string_length);
                }
                t_unresolved__size = t_oct_str__size;
            }
            break;
        case ((int)28416):
            // Parse "oct_str_eve"
            {
                int t_oct_str_eve__size;
                t_oct_str_eve__size =  ( obj_type() & 0x00FF ) ;
                // Checking out-of-bound for "Default_Wrap:oct_str_eve"
                if ( t_begin_of_data + (t_oct_str_eve__size) > t_end_of_data || t_begin_of_data + (t_oct_str_eve__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Default_Wrap:oct_str_eve",
                    	(0) + (t_oct_str_eve__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_oct_str_eve__size;
                    int t_oct_str_eve_string_length;
                    t_oct_str_eve_string_length =  ( obj_type() & 0x00FF ) ;
                    // check for negative sizes
                    if ( t_oct_str_eve_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:635", t_oct_str_eve_string_length);
                    oct_str_eve_.init(t_begin_of_data, t_oct_str_eve_string_length);
                }
                t_unresolved__size = t_oct_str_eve__size;
            }
            break;
        case ((int)28672):
            // Parse "vir_ter_out_blk"
            {
                int t_vir_ter_out_blk__size;
                t_vir_ter_out_blk__size =  ( obj_type() & 0x00FF ) ;
                // Checking out-of-bound for "Default_Wrap:vir_ter_out_blk"
                if ( t_begin_of_data + (t_vir_ter_out_blk__size) > t_end_of_data || t_begin_of_data + (t_vir_ter_out_blk__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Default_Wrap:vir_ter_out_blk",
                    	(0) + (t_vir_ter_out_blk__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_vir_ter_out_blk__size;
                    int t_vir_ter_out_blk_string_length;
                    t_vir_ter_out_blk_string_length =  ( obj_type() & 0x00FF ) ;
                    // check for negative sizes
                    if ( t_vir_ter_out_blk_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:636", t_vir_ter_out_blk_string_length);
                    vir_ter_out_blk_.init(t_begin_of_data, t_vir_ter_out_blk_string_length);
                }
                t_unresolved__size = t_vir_ter_out_blk__size;
            }
            break;
        case ((int)28928):
            // Parse "vir_ter_eve"
            {
                int t_vir_ter_eve__size;
                t_vir_ter_eve__size =  ( obj_type() & 0x00FF ) ;
                // Checking out-of-bound for "Default_Wrap:vir_ter_eve"
                if ( t_begin_of_data + (t_vir_ter_eve__size) > t_end_of_data || t_begin_of_data + (t_vir_ter_eve__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Default_Wrap:vir_ter_eve",
                    	(0) + (t_vir_ter_eve__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_vir_ter_eve__size;
                    int t_vir_ter_eve_string_length;
                    t_vir_ter_eve_string_length =  ( obj_type() & 0x00FF ) ;
                    // check for negative sizes
                    if ( t_vir_ter_eve_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:637", t_vir_ter_eve_string_length);
                    vir_ter_eve_.init(t_begin_of_data, t_vir_ter_eve_string_length);
                }
                t_unresolved__size = t_vir_ter_eve__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                unknown_ = new Debug_Byte();
                int t_unknown__size;
                t_unknown__size = unknown_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_unresolved__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Default_Wrap__size;
    const_byteptr const t_dataptr_after_unresolved = t_begin_of_data + (t_unresolved__size);
    BINPAC_ASSERT(t_dataptr_after_unresolved <= t_end_of_data);
    t_Default_Wrap__size = t_dataptr_after_unresolved - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Default_Wrap__size) <= t_end_of_data);
    return t_Default_Wrap__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AttributeCommon::AttributeCommon() {
    data_type_code_ = 0;
    leng_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AttributeCommon::~AttributeCommon() {
    attribute_obj_.free();
}

int AttributeCommon::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AttributeCommon:leng"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AttributeCommon:leng",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "data_type_code"
    data_type_code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "leng"
    leng_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "attribute_obj"
    int t_attribute_obj__size;
    t_attribute_obj__size = leng();
    // Checking out-of-bound for "AttributeCommon:attribute_obj"
    if ( (t_begin_of_data + 2) + (t_attribute_obj__size) > t_end_of_data || (t_begin_of_data + 2) + (t_attribute_obj__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AttributeCommon:attribute_obj",
        	(2) + (t_attribute_obj__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_attribute_obj__size;
        int t_attribute_obj_string_length;
        t_attribute_obj_string_length = leng();
        // check for negative sizes
        if ( t_attribute_obj_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:652", t_attribute_obj_string_length);
        attribute_obj_.init((t_begin_of_data + 2), t_attribute_obj_string_length);
    }

    int t_AttributeCommon__size;
    const_byteptr const t_dataptr_after_attribute_obj = (t_begin_of_data + 2) + (t_attribute_obj__size);
    BINPAC_ASSERT(t_dataptr_after_attribute_obj <= t_end_of_data);
    t_AttributeCommon__size = t_dataptr_after_attribute_obj - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_attribute_common(data_type_code(), leng(), attribute_obj());
    BINPAC_ASSERT(t_begin_of_data + (t_AttributeCommon__size) <= t_end_of_data);
    return t_AttributeCommon__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinInEveAtime::BinInEveAtime() {
    flag_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinInEveAtime::~BinInEveAtime() {
    time48_.free();
}

int BinInEveAtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "BinInEveAtime:flag"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinInEveAtime:flag",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time48"
    // Checking out-of-bound for "BinInEveAtime:time48"
    if ( (t_begin_of_data + 1) + (6) > t_end_of_data || (t_begin_of_data + 1) + (6) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinInEveAtime:time48",
        	(1) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 1), t_time48_string_length);
    }

    int t_BinInEveAtime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 1) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_BinInEveAtime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinInEveAtime__size) <= t_end_of_data);
    return t_BinInEveAtime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinInEveRtime::BinInEveRtime() {
    flag_ = 0;
    time16_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinInEveRtime::~BinInEveRtime() {
}

int BinInEveRtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "BinInEveRtime"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinInEveRtime",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time16"
    time16_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DoubleInEveAtime::DoubleInEveAtime() {
    flag_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DoubleInEveAtime::~DoubleInEveAtime() {
    time48_.free();
}

int DoubleInEveAtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "DoubleInEveAtime:flag"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DoubleInEveAtime:flag",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time48"
    // Checking out-of-bound for "DoubleInEveAtime:time48"
    if ( (t_begin_of_data + 1) + (6) > t_end_of_data || (t_begin_of_data + 1) + (6) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DoubleInEveAtime:time48",
        	(1) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 1), t_time48_string_length);
    }

    int t_DoubleInEveAtime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 1) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_DoubleInEveAtime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_DoubleInEveAtime__size) <= t_end_of_data);
    return t_DoubleInEveAtime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DoubleInEveRtime::DoubleInEveRtime() {
    flag_ = 0;
    time16_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DoubleInEveRtime::~DoubleInEveRtime() {
}

int DoubleInEveRtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "DoubleInEveRtime"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DoubleInEveRtime",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time16"
    time16_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinOutEveAtime::BinOutEveAtime() {
    flag_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinOutEveAtime::~BinOutEveAtime() {
    time48_.free();
}

int BinOutEveAtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "BinOutEveAtime:flag"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinOutEveAtime:flag",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time48"
    // Checking out-of-bound for "BinOutEveAtime:time48"
    if ( (t_begin_of_data + 1) + (6) > t_end_of_data || (t_begin_of_data + 1) + (6) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinOutEveAtime:time48",
        	(1) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 1), t_time48_string_length);
    }

    int t_BinOutEveAtime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 1) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_BinOutEveAtime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinOutEveAtime__size) <= t_end_of_data);
    return t_BinOutEveAtime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CROB::CROB() {
    control_code_ = 0;
    count_ = 0;
    on_time_ = 0;
    off_time_ = 0;
    status_code_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CROB::~CROB() {
}

int CROB::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "CROB"
    if ( t_begin_of_data + (11) > t_end_of_data || t_begin_of_data + (11) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CROB",
        	(0) + (11), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "control_code"
    control_code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count"
    count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "on_time"
    on_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "off_time"
    off_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 6))));

    // Parse "status_code"
    status_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 10)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_crob(control_code(), count(), on_time(), off_time(), status_code());
    BINPAC_ASSERT(t_begin_of_data + (11) <= t_end_of_data);
    return 11;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PCB::PCB() {
    control_code_ = 0;
    count_ = 0;
    on_time_ = 0;
    off_time_ = 0;
    status_code_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PCB::~PCB() {
}

int PCB::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "PCB"
    if ( t_begin_of_data + (11) > t_end_of_data || t_begin_of_data + (11) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PCB",
        	(0) + (11), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "control_code"
    control_code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count"
    count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "on_time"
    on_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "off_time"
    off_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 6))));

    // Parse "status_code"
    status_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 10)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_pcb(control_code(), count(), on_time(), off_time(), status_code());
    BINPAC_ASSERT(t_begin_of_data + (11) <= t_end_of_data);
    return 11;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinOutCmdEveAtime::BinOutCmdEveAtime() {
    flag_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BinOutCmdEveAtime::~BinOutCmdEveAtime() {
    time48_.free();
}

int BinOutCmdEveAtime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "BinOutCmdEveAtime:flag"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinOutCmdEveAtime:flag",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "time48"
    // Checking out-of-bound for "BinOutCmdEveAtime:time48"
    if ( (t_begin_of_data + 1) + (6) > t_end_of_data || (t_begin_of_data + 1) + (6) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BinOutCmdEveAtime:time48",
        	(1) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 1), t_time48_string_length);
    }

    int t_BinOutCmdEveAtime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 1) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_BinOutCmdEveAtime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_BinOutCmdEveAtime__size) <= t_end_of_data);
    return t_BinOutCmdEveAtime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter32wFlag::Counter32wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter32wFlag::~Counter32wFlag() {
}

int Counter32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "Counter32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Counter32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_counter_32wFlag(flag(), count_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter16wFlag::Counter16wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter16wFlag::~Counter16wFlag() {
}

int Counter16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "Counter16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Counter16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_counter_16wFlag(flag(), count_value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter32woFlag::Counter32woFlag() {
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter32woFlag::~Counter32woFlag() {
}

int Counter32woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "Counter32woFlag"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Counter32woFlag",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_counter_32woFlag(count_value());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter16woFlag::Counter16woFlag() {
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Counter16woFlag::~Counter16woFlag() {
}

int Counter16woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "Counter16woFlag"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Counter16woFlag",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_counter_16woFlag(count_value());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32wFlag::FrozenCounter32wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32wFlag::~FrozenCounter32wFlag() {
}

int FrozenCounter32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_32wFlag(flag(), count_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16wFlag::FrozenCounter16wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16wFlag::~FrozenCounter16wFlag() {
}

int FrozenCounter16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_16wFlag(flag(), count_value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32wFlagTime::FrozenCounter32wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32wFlagTime::~FrozenCounter32wFlagTime() {
    time48_.free();
}

int FrozenCounter32wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter32wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter32wFlagTime:count_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenCounter32wFlagTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter32wFlagTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenCounter32wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenCounter32wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_32wFlagTime(flag(), count_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenCounter32wFlagTime__size) <= t_end_of_data);
    return t_FrozenCounter32wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16wFlagTime::FrozenCounter16wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16wFlagTime::~FrozenCounter16wFlagTime() {
    time48_.free();
}

int FrozenCounter16wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter16wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter16wFlagTime:count_value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenCounter16wFlagTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter16wFlagTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_FrozenCounter16wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenCounter16wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_16wFlagTime(flag(), count_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenCounter16wFlagTime__size) <= t_end_of_data);
    return t_FrozenCounter16wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32woFlag::FrozenCounter32woFlag() {
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter32woFlag::~FrozenCounter32woFlag() {
}

int FrozenCounter32woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter32woFlag"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter32woFlag",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_32woFlag(count_value());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16woFlag::FrozenCounter16woFlag() {
    count_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounter16woFlag::~FrozenCounter16woFlag() {
}

int FrozenCounter16woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenCounter16woFlag"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounter16woFlag",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_counter_16woFlag(count_value());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve32wFlag::CounterEve32wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve32wFlag::~CounterEve32wFlag() {
}

int CounterEve32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "CounterEve32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve16wFlag::CounterEve16wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve16wFlag::~CounterEve16wFlag() {
}

int CounterEve16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "CounterEve16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve32wFlagTime::CounterEve32wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve32wFlagTime::~CounterEve32wFlagTime() {
    time48_.free();
}

int CounterEve32wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "CounterEve32wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve32wFlagTime:count_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "CounterEve32wFlagTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve32wFlagTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_CounterEve32wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_CounterEve32wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CounterEve32wFlagTime__size) <= t_end_of_data);
    return t_CounterEve32wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve16wFlagTime::CounterEve16wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
CounterEve16wFlagTime::~CounterEve16wFlagTime() {
    time48_.free();
}

int CounterEve16wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "CounterEve16wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve16wFlagTime:count_value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "CounterEve16wFlagTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CounterEve16wFlagTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_CounterEve16wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_CounterEve16wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CounterEve16wFlagTime__size) <= t_end_of_data);
    return t_CounterEve16wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve32wFlag::FrozenCounterEve32wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve32wFlag::~FrozenCounterEve32wFlag() {
}

int FrozenCounterEve32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FrozenCounterEve32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve16wFlag::FrozenCounterEve16wFlag() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve16wFlag::~FrozenCounterEve16wFlag() {
}

int FrozenCounterEve16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FrozenCounterEve16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve32wFlagTime::FrozenCounterEve32wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve32wFlagTime::~FrozenCounterEve32wFlagTime() {
    time48_.free();
}

int FrozenCounterEve32wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FrozenCounterEve32wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve32wFlagTime:count_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenCounterEve32wFlagTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve32wFlagTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenCounterEve32wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenCounterEve32wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenCounterEve32wFlagTime__size) <= t_end_of_data);
    return t_FrozenCounterEve32wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve16wFlagTime::FrozenCounterEve16wFlagTime() {
    flag_ = 0;
    count_value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenCounterEve16wFlagTime::~FrozenCounterEve16wFlagTime() {
    time48_.free();
}

int FrozenCounterEve16wFlagTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "FrozenCounterEve16wFlagTime:count_value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve16wFlagTime:count_value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "count_value"
    count_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenCounterEve16wFlagTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenCounterEve16wFlagTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_FrozenCounterEve16wFlagTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenCounterEve16wFlagTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenCounterEve16wFlagTime__size) <= t_end_of_data);
    return t_FrozenCounterEve16wFlagTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32wFlag::AnalogInput32wFlag() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32wFlag::~AnalogInput32wFlag() {
}

int AnalogInput32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_32wFlag(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16wFlag::AnalogInput16wFlag() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16wFlag::~AnalogInput16wFlag() {
}

int AnalogInput16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_16wFlag(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32woFlag::AnalogInput32woFlag() {
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32woFlag::~AnalogInput32woFlag() {
}

int AnalogInput32woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput32woFlag"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput32woFlag",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_32woFlag(value());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16woFlag::AnalogInput16woFlag() {
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16woFlag::~AnalogInput16woFlag() {
}

int AnalogInput16woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput16woFlag"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput16woFlag",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_16woFlag(value());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwFlag::AnalogInputSPwFlag() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwFlag::~AnalogInputSPwFlag() {
}

int AnalogInputSPwFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputSPwFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputSPwFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_SPwFlag(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwFlag::AnalogInputDPwFlag() {
    flag_ = 0;
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwFlag::~AnalogInputDPwFlag() {
}

int AnalogInputDPwFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputDPwFlag"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputDPwFlag",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_DPwFlag(flag(), value_low(), value_high());
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32wFlag::FrozenAnalogInput32wFlag() {
    flag_ = 0;
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32wFlag::~FrozenAnalogInput32wFlag() {
}

int FrozenAnalogInput32wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput32wFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput32wFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_32wFlag(flag(), frozen_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16wFlag::FrozenAnalogInput16wFlag() {
    flag_ = 0;
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16wFlag::~FrozenAnalogInput16wFlag() {
}

int FrozenAnalogInput16wFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput16wFlag"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput16wFlag",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_16wFlag(flag(), frozen_value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32wTime::FrozenAnalogInput32wTime() {
    flag_ = 0;
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32wTime::~FrozenAnalogInput32wTime() {
    time48_.free();
}

int FrozenAnalogInput32wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput32wTime:frozen_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput32wTime:frozen_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnalogInput32wTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput32wTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenAnalogInput32wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnalogInput32wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_32wTime(flag(), frozen_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnalogInput32wTime__size) <= t_end_of_data);
    return t_FrozenAnalogInput32wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16wTime::FrozenAnalogInput16wTime() {
    flag_ = 0;
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16wTime::~FrozenAnalogInput16wTime() {
    time48_.free();
}

int FrozenAnalogInput16wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput16wTime:frozen_value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput16wTime:frozen_value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnalogInput16wTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput16wTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_FrozenAnalogInput16wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnalogInput16wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_16wTime(flag(), frozen_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnalogInput16wTime__size) <= t_end_of_data);
    return t_FrozenAnalogInput16wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32woFlag::FrozenAnalogInput32woFlag() {
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput32woFlag::~FrozenAnalogInput32woFlag() {
}

int FrozenAnalogInput32woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput32woFlag"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput32woFlag",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_32woFlag(frozen_value());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16woFlag::FrozenAnalogInput16woFlag() {
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInput16woFlag::~FrozenAnalogInput16woFlag() {
}

int FrozenAnalogInput16woFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInput16woFlag"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInput16woFlag",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_16woFlag(frozen_value());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInputSPwFlag::FrozenAnalogInputSPwFlag() {
    flag_ = 0;
    frozen_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInputSPwFlag::~FrozenAnalogInputSPwFlag() {
}

int FrozenAnalogInputSPwFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInputSPwFlag"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInputSPwFlag",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value"
    frozen_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_SPwFlag(flag(), frozen_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInputDPwFlag::FrozenAnalogInputDPwFlag() {
    flag_ = 0;
    frozen_value_low_ = 0;
    frozen_value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnalogInputDPwFlag::~FrozenAnalogInputDPwFlag() {
}

int FrozenAnalogInputDPwFlag::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnalogInputDPwFlag"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnalogInputDPwFlag",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "frozen_value_low"
    frozen_value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "frozen_value_high"
    frozen_value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_DPwFlag(flag(), frozen_value_low(), frozen_value_high());
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32woTime::AnalogInput32woTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32woTime::~AnalogInput32woTime() {
}

int AnalogInput32woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput32woTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput32woTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_32woTime(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16woTime::AnalogInput16woTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16woTime::~AnalogInput16woTime() {
}

int AnalogInput16woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput16woTime"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput16woTime",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_16woTime(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32wTime::AnalogInput32wTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput32wTime::~AnalogInput32wTime() {
    time48_.free();
}

int AnalogInput32wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput32wTime:value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput32wTime:value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnalogInput32wTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput32wTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_AnalogInput32wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnalogInput32wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_32wTime(flag(), value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_AnalogInput32wTime__size) <= t_end_of_data);
    return t_AnalogInput32wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16wTime::AnalogInput16wTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInput16wTime::~AnalogInput16wTime() {
    time48_.free();
}

int AnalogInput16wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInput16wTime:value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput16wTime:value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnalogInput16wTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInput16wTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_AnalogInput16wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnalogInput16wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_16wTime(flag(), value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_AnalogInput16wTime__size) <= t_end_of_data);
    return t_AnalogInput16wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwoTime::AnalogInputSPwoTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwoTime::~AnalogInputSPwoTime() {
}

int AnalogInputSPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputSPwoTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputSPwoTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_SPwoTime(flag(), value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwoTime::AnalogInputDPwoTime() {
    flag_ = 0;
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwoTime::~AnalogInputDPwoTime() {
}

int AnalogInputDPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputDPwoTime"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputDPwoTime",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_DPwoTime(flag(), value_low(), value_high());
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwTime::AnalogInputSPwTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputSPwTime::~AnalogInputSPwTime() {
    time48_.free();
}

int AnalogInputSPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputSPwTime:value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputSPwTime:value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnalogInputSPwTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputSPwTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_AnalogInputSPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnalogInputSPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_SPwTime(flag(), value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_AnalogInputSPwTime__size) <= t_end_of_data);
    return t_AnalogInputSPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwTime::AnalogInputDPwTime() {
    flag_ = 0;
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnalogInputDPwTime::~AnalogInputDPwTime() {
    time48_.free();
}

int AnalogInputDPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "AnalogInputDPwTime:value_high"
    if ( (t_begin_of_data + 5) + (4) > t_end_of_data || (t_begin_of_data + 5) + (4) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputDPwTime:value_high",
        	(5) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Parse "time48"
    // Checking out-of-bound for "AnalogInputDPwTime:time48"
    if ( (t_begin_of_data + 9) + (6) > t_end_of_data || (t_begin_of_data + 9) + (6) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnalogInputDPwTime:time48",
        	(9) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 9), t_time48_string_length);
    }

    int t_AnalogInputDPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 9) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnalogInputDPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_analog_input_event_DPwTime(flag(), value_low(), value_high(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_AnalogInputDPwTime__size) <= t_end_of_data);
    return t_AnalogInputDPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve32woTime::FrozenAnaInputEve32woTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve32woTime::~FrozenAnaInputEve32woTime() {
}

int FrozenAnaInputEve32woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEve32woTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve32woTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_32woTime(flag(), f_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve16woTime::FrozenAnaInputEve16woTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve16woTime::~FrozenAnaInputEve16woTime() {
}

int FrozenAnaInputEve16woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEve16woTime"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve16woTime",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_16woTime(flag(), f_value());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve32wTime::FrozenAnaInputEve32wTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve32wTime::~FrozenAnaInputEve32wTime() {
    time48_.free();
}

int FrozenAnaInputEve32wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEve32wTime:f_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve32wTime:f_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnaInputEve32wTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve32wTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenAnaInputEve32wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnaInputEve32wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_32wTime(flag(), f_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnaInputEve32wTime__size) <= t_end_of_data);
    return t_FrozenAnaInputEve32wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve16wTime::FrozenAnaInputEve16wTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEve16wTime::~FrozenAnaInputEve16wTime() {
    time48_.free();
}

int FrozenAnaInputEve16wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEve16wTime:f_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve16wTime:f_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnaInputEve16wTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEve16wTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenAnaInputEve16wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnaInputEve16wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_16wTime(flag(), f_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnaInputEve16wTime__size) <= t_end_of_data);
    return t_FrozenAnaInputEve16wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveSPwoTime::FrozenAnaInputEveSPwoTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveSPwoTime::~FrozenAnaInputEveSPwoTime() {
}

int FrozenAnaInputEveSPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEveSPwoTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveSPwoTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_SPwoTime(flag(), f_value());
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveDPwoTime::FrozenAnaInputEveDPwoTime() {
    flag_ = 0;
    f_value_low_ = 0;
    f_value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveDPwoTime::~FrozenAnaInputEveDPwoTime() {
}

int FrozenAnaInputEveDPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEveDPwoTime"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveDPwoTime",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value_low"
    f_value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "f_value_high"
    f_value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_DPwoTime(flag(), f_value_low(), f_value_high());
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveSPwTime::FrozenAnaInputEveSPwTime() {
    flag_ = 0;
    f_value_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveSPwTime::~FrozenAnaInputEveSPwTime() {
    time48_.free();
}

int FrozenAnaInputEveSPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEveSPwTime:f_value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveSPwTime:f_value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value"
    f_value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnaInputEveSPwTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveSPwTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_FrozenAnaInputEveSPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnaInputEveSPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_SPwTime(flag(), f_value(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnaInputEveSPwTime__size) <= t_end_of_data);
    return t_FrozenAnaInputEveSPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveDPwTime::FrozenAnaInputEveDPwTime() {
    flag_ = 0;
    f_value_low_ = 0;
    f_value_high_ = 0;
    byteorder_ = littleendian;
    process_request_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
FrozenAnaInputEveDPwTime::~FrozenAnaInputEveDPwTime() {
    time48_.free();
}

int FrozenAnaInputEveDPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "FrozenAnaInputEveDPwTime:f_value_high"
    if ( (t_begin_of_data + 5) + (4) > t_end_of_data || (t_begin_of_data + 5) + (4) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveDPwTime:f_value_high",
        	(5) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "f_value_low"
    f_value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "f_value_high"
    f_value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Parse "time48"
    // Checking out-of-bound for "FrozenAnaInputEveDPwTime:time48"
    if ( (t_begin_of_data + 9) + (6) > t_end_of_data || (t_begin_of_data + 9) + (6) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("FrozenAnaInputEveDPwTime:time48",
        	(9) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 9), t_time48_string_length);
    }

    int t_FrozenAnaInputEveDPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 9) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_FrozenAnaInputEveDPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    process_request_ = t_context->flow()->get_dnp3_frozen_analog_input_event_DPwTime(flag(), f_value_low(), f_value_high(), time48());
    BINPAC_ASSERT(t_begin_of_data + (t_FrozenAnaInputEveDPwTime__size) <= t_end_of_data);
    return t_FrozenAnaInputEveDPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatus32::AnaOutStatus32() {
    flag_ = 0;
    status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatus32::~AnaOutStatus32() {
}

int AnaOutStatus32::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutStatus32"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutStatus32",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatus16::AnaOutStatus16() {
    flag_ = 0;
    status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatus16::~AnaOutStatus16() {
}

int AnaOutStatus16::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutStatus16"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutStatus16",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatusSP::AnaOutStatusSP() {
    flag_ = 0;
    status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatusSP::~AnaOutStatusSP() {
}

int AnaOutStatusSP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutStatusSP"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutStatusSP",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatusDP::AnaOutStatusDP() {
    flag_ = 0;
    status_low_ = 0;
    status_high_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutStatusDP::~AnaOutStatusDP() {
}

int AnaOutStatusDP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutStatusDP"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutStatusDP",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status_low"
    status_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "status_high"
    status_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOut32::AnaOut32() {
    value_ = 0;
    con_status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOut32::~AnaOut32() {
}

int AnaOut32::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOut32"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOut32",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>(t_begin_of_data)));

    // Parse "con_status"
    con_status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOut16::AnaOut16() {
    value_ = 0;
    con_status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOut16::~AnaOut16() {
}

int AnaOut16::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOut16"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOut16",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>(t_begin_of_data)));

    // Parse "con_status"
    con_status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutSP::AnaOutSP() {
    value_ = 0;
    con_status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutSP::~AnaOutSP() {
}

int AnaOutSP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutSP"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutSP",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "con_status"
    con_status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutDP::AnaOutDP() {
    value_low_ = 0;
    value_high_ = 0;
    con_status_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutDP::~AnaOutDP() {
}

int AnaOutDP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutDP"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutDP",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "con_status"
    con_status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve32woTime::AnaOutEve32woTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve32woTime::~AnaOutEve32woTime() {
}

int AnaOutEve32woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEve32woTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve32woTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve16woTime::AnaOutEve16woTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve16woTime::~AnaOutEve16woTime() {
}

int AnaOutEve16woTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEve16woTime"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve16woTime",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve32wTime::AnaOutEve32wTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve32wTime::~AnaOutEve32wTime() {
    time48_.free();
}

int AnaOutEve32wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEve32wTime:value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve32wTime:value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnaOutEve32wTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve32wTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_AnaOutEve32wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnaOutEve32wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AnaOutEve32wTime__size) <= t_end_of_data);
    return t_AnaOutEve32wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve16wTime::AnaOutEve16wTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEve16wTime::~AnaOutEve16wTime() {
    time48_.free();
}

int AnaOutEve16wTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEve16wTime:value"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve16wTime:value",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<int16 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnaOutEve16wTime:time48"
    if ( (t_begin_of_data + 3) + (6) > t_end_of_data || (t_begin_of_data + 3) + (6) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEve16wTime:time48",
        	(3) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 3), t_time48_string_length);
    }

    int t_AnaOutEve16wTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 3) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnaOutEve16wTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AnaOutEve16wTime__size) <= t_end_of_data);
    return t_AnaOutEve16wTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveSPwoTime::AnaOutEveSPwoTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveSPwoTime::~AnaOutEveSPwoTime() {
}

int AnaOutEveSPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEveSPwoTime"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveSPwoTime",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveDPwoTime::AnaOutEveDPwoTime() {
    flag_ = 0;
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveDPwoTime::~AnaOutEveDPwoTime() {
}

int AnaOutEveDPwoTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEveDPwoTime"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveDPwoTime",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveSPwTime::AnaOutEveSPwTime() {
    flag_ = 0;
    value_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveSPwTime::~AnaOutEveSPwTime() {
    time48_.free();
}

int AnaOutEveSPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEveSPwTime:value"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveSPwTime:value",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value"
    value_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "time48"
    // Checking out-of-bound for "AnaOutEveSPwTime:time48"
    if ( (t_begin_of_data + 5) + (6) > t_end_of_data || (t_begin_of_data + 5) + (6) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveSPwTime:time48",
        	(5) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 5), t_time48_string_length);
    }

    int t_AnaOutEveSPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 5) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnaOutEveSPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AnaOutEveSPwTime__size) <= t_end_of_data);
    return t_AnaOutEveSPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveDPwTime::AnaOutEveDPwTime() {
    flag_ = 0;
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AnaOutEveDPwTime::~AnaOutEveDPwTime() {
    time48_.free();
}

int AnaOutEveDPwTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AnaOutEveDPwTime:value_high"
    if ( (t_begin_of_data + 5) + (4) > t_end_of_data || (t_begin_of_data + 5) + (4) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveDPwTime:value_high",
        	(5) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flag"
    flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Parse "time48"
    // Checking out-of-bound for "AnaOutEveDPwTime:time48"
    if ( (t_begin_of_data + 9) + (6) > t_end_of_data || (t_begin_of_data + 9) + (6) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AnaOutEveDPwTime:time48",
        	(9) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init((t_begin_of_data + 9), t_time48_string_length);
    }

    int t_AnaOutEveDPwTime__size;
    const_byteptr const t_dataptr_after_time48 = (t_begin_of_data + 9) + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AnaOutEveDPwTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AnaOutEveDPwTime__size) <= t_end_of_data);
    return t_AnaOutEveDPwTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AbsTime::AbsTime() {
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AbsTime::~AbsTime() {
    time48_.free();
}

int AbsTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "time48"
    // Checking out-of-bound for "AbsTime:time48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AbsTime:time48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init(t_begin_of_data, t_time48_string_length);
    }

    int t_AbsTime__size;
    const_byteptr const t_dataptr_after_time48 = t_begin_of_data + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_AbsTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AbsTime__size) <= t_end_of_data);
    return t_AbsTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AbsTimeInterval::AbsTimeInterval() {
    interval_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AbsTimeInterval::~AbsTimeInterval() {
    time48_.free();
}

int AbsTimeInterval::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "time48"
    // Checking out-of-bound for "AbsTimeInterval:time48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AbsTimeInterval:time48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init(t_begin_of_data, t_time48_string_length);
    }

    const_byteptr const t_dataptr_after_time48 = t_begin_of_data + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    // Checking out-of-bound for "AbsTimeInterval:interval"
    if ( t_dataptr_after_time48 + (4) > t_end_of_data || t_dataptr_after_time48 + (4) < t_dataptr_after_time48 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AbsTimeInterval:interval",
        	((t_dataptr_after_time48 - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "interval"
    interval_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_time48)));

    int t_AbsTimeInterval__size;
    t_AbsTimeInterval__size = (t_dataptr_after_time48 + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AbsTimeInterval__size) <= t_end_of_data);
    return t_AbsTimeInterval__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Last_AbsTime::Last_AbsTime() {
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Last_AbsTime::~Last_AbsTime() {
    time48_.free();
}

int Last_AbsTime::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "time48"
    // Checking out-of-bound for "Last_AbsTime:time48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Last_AbsTime:time48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 6;
        int t_time48_string_length;
        t_time48_string_length = 6;
        int t_time48__size;
        t_time48__size = t_time48_string_length;
        time48_.init(t_begin_of_data, t_time48_string_length);
    }

    int t_Last_AbsTime__size;
    const_byteptr const t_dataptr_after_time48 = t_begin_of_data + (6);
    BINPAC_ASSERT(t_dataptr_after_time48 <= t_end_of_data);
    t_Last_AbsTime__size = t_dataptr_after_time48 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Last_AbsTime__size) <= t_end_of_data);
    return t_Last_AbsTime__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Record_Obj::Record_Obj() {
    record_size_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Record_Obj::~Record_Obj() {
    record_oct_.free();
}

int Record_Obj::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Record_Obj:record_size"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Record_Obj:record_size",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "record_size"
    record_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "record_oct"
    int t_record_oct__size;
    t_record_oct__size = record_size();
    // Checking out-of-bound for "Record_Obj:record_oct"
    if ( (t_begin_of_data + 2) + (t_record_oct__size) > t_end_of_data || (t_begin_of_data + 2) + (t_record_oct__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Record_Obj:record_oct",
        	(2) + (t_record_oct__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_record_oct__size;
        int t_record_oct_string_length;
        t_record_oct_string_length = record_size();
        // check for negative sizes
        if ( t_record_oct_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1170", t_record_oct_string_length);
        record_oct_.init((t_begin_of_data + 2), t_record_oct_string_length);
    }

    int t_Record_Obj__size;
    const_byteptr const t_dataptr_after_record_oct = (t_begin_of_data + 2) + (t_record_oct__size);
    BINPAC_ASSERT(t_dataptr_after_record_oct <= t_end_of_data);
    t_Record_Obj__size = t_dataptr_after_record_oct - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Record_Obj__size) <= t_end_of_data);
    return t_Record_Obj__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_ID::File_Control_ID() {
    name_size_ = 0;
    type_code_ = 0;
    attr_code_ = 0;
    start_rec_ = 0;
    end_rec_ = 0;
    file_size_ = 0;
    permission_ = 0;
    file_id_ = 0;
    owner_id_ = 0;
    group_id_ = 0;
    function_code_ = 0;
    status_code_ = 0;
    records_ = nullptr;
    records__elem_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_ID::~File_Control_ID() {
    time_create_.free();
    file_name_.free();
    delete records__elem_;
    records__elem_ = nullptr;
    if ( records() ) {
        for ( auto* records__elem_ : *records() ) {
            delete records__elem_;
            records__elem_ = nullptr;
        }
    }
    delete records_;
}

int File_Control_ID::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Control_ID:file_size"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_ID:file_size",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "name_size"
    name_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "type_code"
    type_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "attr_code"
    attr_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "start_rec"
    start_rec_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "end_rec"
    end_rec_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "file_size"
    file_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "time_create"
    // Checking out-of-bound for "File_Control_ID:time_create"
    if ( (t_begin_of_data + 12) + (6) > t_end_of_data || (t_begin_of_data + 12) + (6) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_ID:time_create",
        	(12) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 12) + 6;
        int t_time_create_string_length;
        t_time_create_string_length = 6;
        int t_time_create__size;
        t_time_create__size = t_time_create_string_length;
        time_create_.init((t_begin_of_data + 12), t_time_create_string_length);
    }

    const_byteptr const t_dataptr_after_time_create = (t_begin_of_data + 12) + (6);
    BINPAC_ASSERT(t_dataptr_after_time_create <= t_end_of_data);
    // Checking out-of-bound for "File_Control_ID:status_code"
    if ( (t_dataptr_after_time_create + 15) + (1) > t_end_of_data || (t_dataptr_after_time_create + 15) + (1) < (t_dataptr_after_time_create + 15) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_ID:status_code",
        	(((t_dataptr_after_time_create + 15) - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "permission"
    permission_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_time_create)));

    // Parse "file_id"
    file_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_time_create + 2))));

    // Parse "owner_id"
    owner_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_time_create + 6))));

    // Parse "group_id"
    group_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_time_create + 10))));

    // Parse "function_code"
    function_code_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_time_create + 14)));

    // Parse "status_code"
    status_code_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_time_create + 15)));

    // Parse "file_name"
    int t_file_name__size;
    t_file_name__size = name_size();
    // Checking out-of-bound for "File_Control_ID:file_name"
    if ( (t_dataptr_after_time_create + 16) + (t_file_name__size) > t_end_of_data || (t_dataptr_after_time_create + 16) + (t_file_name__size) < (t_dataptr_after_time_create + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_ID:file_name",
        	(((t_dataptr_after_time_create + 16) - t_begin_of_data)) + (t_file_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_time_create + 16) + t_file_name__size;
        int t_file_name_string_length;
        t_file_name_string_length = name_size();
        // check for negative sizes
        if ( t_file_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1187", t_file_name_string_length);
        file_name_.init((t_dataptr_after_time_create + 16), t_file_name_string_length);
    }

    const_byteptr const t_dataptr_after_file_name = (t_dataptr_after_time_create + 16) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    // Parse "records"
    int t_records__arraylength;
    t_records__arraylength = 0;
    records__elem_ = nullptr;
    int t_records__elem__it;
    t_records__elem__it = 0;
    int t_records__size;
    records_ = new vector<Record_Obj*>;
    const_byteptr t_records__elem__dataptr = t_dataptr_after_file_name;
    for (; /* forever */; ++t_records__elem__it) {
        // Check &until(records__elem__dataptr >= end_of_data)
        if ( t_records__elem__dataptr >= t_end_of_data ) {
            records__elem_ = nullptr;
            goto end_of_records;
        }
        records__elem_ = new Record_Obj();
        int t_records__elem__size;
        t_records__elem__size = records__elem_->Parse(t_records__elem__dataptr, t_end_of_data);
        records_->push_back(records__elem_);
        t_records__elem__dataptr += t_records__elem__size;
        BINPAC_ASSERT(t_records__elem__dataptr <= t_end_of_data);
        records__elem_ = nullptr;
    }
end_of_records: ;
    t_records__size = t_records__elem__dataptr - (t_dataptr_after_file_name);
    // Evaluate 'let' and 'withinput' fields

    int t_File_Control_ID__size;
    const_byteptr const t_dataptr_after_records = t_dataptr_after_file_name + (t_records__size);
    BINPAC_ASSERT(t_dataptr_after_records <= t_end_of_data);
    t_File_Control_ID__size = t_dataptr_after_records - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_ID__size) <= t_end_of_data);
    return t_File_Control_ID__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Auth_Wrap::File_Control_Auth_Wrap(uint8 fc) {
    data_case_index_ = -1;
    auth_file_ = nullptr;
    fc_ = fc;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Auth_Wrap::~File_Control_Auth_Wrap() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)29):
            // Clean up "auth_file"
            {
                delete auth_file_;
                auth_file_ = nullptr;
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int File_Control_Auth_Wrap::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( fc() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)29):
            // Parse "auth_file"
            {
                auth_file_ = new File_Control_Auth();
                int t_auth_file__size;
                t_auth_file__size = auth_file_->Parse(t_begin_of_data, t_end_of_data);
                t_data__size = t_auth_file__size;
            }
            break;
        default:
            // Parse "null"
            {
                t_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_File_Control_Auth_Wrap__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_File_Control_Auth_Wrap__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Auth_Wrap__size) <= t_end_of_data);
    return t_File_Control_Auth_Wrap__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Auth::File_Control_Auth() {
    usr_name_offset_ = 0;
    usr_name_size_ = 0;
    pwd_offset_ = 0;
    pwd_size_ = 0;
    auth_key_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Auth::~File_Control_Auth() {
    usr_name_.free();
    pwd_.free();
}

int File_Control_Auth::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Control_Auth:auth_key"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Auth:auth_key",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "usr_name_offset"
    usr_name_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "usr_name_size"
    usr_name_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "pwd_offset"
    pwd_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "pwd_size"
    pwd_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "auth_key"
    auth_key_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "usr_name"
    int t_usr_name__size;
    t_usr_name__size = usr_name_size();
    // Checking out-of-bound for "File_Control_Auth:usr_name"
    if ( (t_begin_of_data + 12) + (t_usr_name__size) > t_end_of_data || (t_begin_of_data + 12) + (t_usr_name__size) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Auth:usr_name",
        	(12) + (t_usr_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 12) + t_usr_name__size;
        int t_usr_name_string_length;
        t_usr_name_string_length = usr_name_size();
        // check for negative sizes
        if ( t_usr_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1205", t_usr_name_string_length);
        usr_name_.init((t_begin_of_data + 12), t_usr_name_string_length);
    }

    const_byteptr const t_dataptr_after_usr_name = (t_begin_of_data + 12) + (t_usr_name__size);
    BINPAC_ASSERT(t_dataptr_after_usr_name <= t_end_of_data);
    // Parse "pwd"
    int t_pwd__size;
    t_pwd__size = pwd_size();
    // Checking out-of-bound for "File_Control_Auth:pwd"
    if ( t_dataptr_after_usr_name + (t_pwd__size) > t_end_of_data || t_dataptr_after_usr_name + (t_pwd__size) < t_dataptr_after_usr_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Auth:pwd",
        	((t_dataptr_after_usr_name - t_begin_of_data)) + (t_pwd__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_usr_name + t_pwd__size;
        int t_pwd_string_length;
        t_pwd_string_length = pwd_size();
        // check for negative sizes
        if ( t_pwd_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1206", t_pwd_string_length);
        pwd_.init(t_dataptr_after_usr_name, t_pwd_string_length);
    }

    int t_File_Control_Auth__size;
    const_byteptr const t_dataptr_after_pwd = t_dataptr_after_usr_name + (t_pwd__size);
    BINPAC_ASSERT(t_dataptr_after_pwd <= t_end_of_data);
    t_File_Control_Auth__size = t_dataptr_after_pwd - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Auth__size) <= t_end_of_data);
    return t_File_Control_Auth__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Wrap::File_Control_Cmd_Wrap(uint8 function_code) {
    data_obj_case_index_ = -1;
    fc_cmd_open_ = nullptr;
    fc_cmd_del_ = nullptr;
    function_code_ = function_code;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Wrap::~File_Control_Cmd_Wrap() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_obj_case_index() ) {
        case ((uint8)25):
            // Clean up "fc_cmd_open"
            {
                delete fc_cmd_open_;
                fc_cmd_open_ = nullptr;
            }
            break;
        case ((uint8)27):
            // Clean up "fc_cmd_del"
            {
                delete fc_cmd_del_;
                fc_cmd_del_ = nullptr;
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int File_Control_Cmd_Wrap::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "data_obj"
    int t_data_obj__size;
    data_obj_case_index_ =  ( function_code() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_obj_case_index() ) {
        case ((uint8)25):
            // Parse "fc_cmd_open"
            {
                fc_cmd_open_ = new File_Control_Cmd();
                int t_fc_cmd_open__size;
                t_fc_cmd_open__size = fc_cmd_open_->Parse(t_begin_of_data, t_end_of_data);
                t_data_obj__size = t_fc_cmd_open__size;
            }
            break;
        case ((uint8)27):
            // Parse "fc_cmd_del"
            {
                fc_cmd_del_ = new File_Control_Cmd();
                int t_fc_cmd_del__size;
                t_fc_cmd_del__size = fc_cmd_del_->Parse(t_begin_of_data, t_end_of_data);
                t_data_obj__size = t_fc_cmd_del__size;
            }
            break;
        default:
            // Parse "null"
            {
                t_data_obj__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_File_Control_Cmd_Wrap__size;
    const_byteptr const t_dataptr_after_data_obj = t_begin_of_data + (t_data_obj__size);
    BINPAC_ASSERT(t_dataptr_after_data_obj <= t_end_of_data);
    t_File_Control_Cmd_Wrap__size = t_dataptr_after_data_obj - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Cmd_Wrap__size) <= t_end_of_data);
    return t_File_Control_Cmd_Wrap__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd::File_Control_Cmd() {
    name_offset_ = 0;
    name_size_ = 0;
    permission_ = 0;
    auth_key_ = 0;
    file_size_ = 0;
    op_mode_ = 0;
    max_block_size_ = 0;
    req_id_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd::~File_Control_Cmd() {
    time_create_.free();
    file_name_.free();
}

int File_Control_Cmd::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Control_Cmd:name_size"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd:name_size",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "name_offset"
    name_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "name_size"
    name_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "time_create"
    // Checking out-of-bound for "File_Control_Cmd:time_create"
    if ( (t_begin_of_data + 4) + (6) > t_end_of_data || (t_begin_of_data + 4) + (6) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd:time_create",
        	(4) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + 6;
        int t_time_create_string_length;
        t_time_create_string_length = 6;
        int t_time_create__size;
        t_time_create__size = t_time_create_string_length;
        time_create_.init((t_begin_of_data + 4), t_time_create_string_length);
    }

    const_byteptr const t_dataptr_after_time_create = (t_begin_of_data + 4) + (6);
    BINPAC_ASSERT(t_dataptr_after_time_create <= t_end_of_data);
    // Checking out-of-bound for "File_Control_Cmd:req_id"
    if ( (t_dataptr_after_time_create + 14) + (2) > t_end_of_data || (t_dataptr_after_time_create + 14) + (2) < (t_dataptr_after_time_create + 14) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd:req_id",
        	(((t_dataptr_after_time_create + 14) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "permission"
    permission_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_time_create)));

    // Parse "auth_key"
    auth_key_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_time_create + 2))));

    // Parse "file_size"
    file_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_time_create + 6))));

    // Parse "op_mode"
    op_mode_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_time_create + 10))));

    // Parse "max_block_size"
    max_block_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_time_create + 12))));

    // Parse "req_id"
    req_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_time_create + 14))));

    // Parse "file_name"
    int t_file_name__size;
    t_file_name__size = name_size();
    // Checking out-of-bound for "File_Control_Cmd:file_name"
    if ( (t_dataptr_after_time_create + 16) + (t_file_name__size) > t_end_of_data || (t_dataptr_after_time_create + 16) + (t_file_name__size) < (t_dataptr_after_time_create + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd:file_name",
        	(((t_dataptr_after_time_create + 16) - t_begin_of_data)) + (t_file_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_time_create + 16) + t_file_name__size;
        int t_file_name_string_length;
        t_file_name_string_length = name_size();
        // check for negative sizes
        if ( t_file_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1229", t_file_name_string_length);
        file_name_.init((t_dataptr_after_time_create + 16), t_file_name_string_length);
    }

    int t_File_Control_Cmd__size;
    const_byteptr const t_dataptr_after_file_name = (t_dataptr_after_time_create + 16) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_File_Control_Cmd__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Cmd__size) <= t_end_of_data);
    return t_File_Control_Cmd__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Status_Wrap::File_Control_Cmd_Status_Wrap(uint8 function_code, uint32 obj_size) {
    data_obj_case_index_ = -1;
    abort_ = nullptr;
    fc_cmd_status_ = nullptr;
    function_code_ = function_code;
    obj_size_ = obj_size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Status_Wrap::~File_Control_Cmd_Status_Wrap() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_obj_case_index() ) {
        case ((uint8)30):
            // Clean up "abort"
            {
                delete abort_;
                abort_ = nullptr;
            }
            break;
        case ((uint8)129):
            // Clean up "fc_cmd_status"
            {
                delete fc_cmd_status_;
                fc_cmd_status_ = nullptr;
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int File_Control_Cmd_Status_Wrap::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "data_obj"
    int t_data_obj__size;
    data_obj_case_index_ =  ( function_code() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_obj_case_index() ) {
        case ((uint8)30):
            // Parse "abort"
            {
                abort_ = new File_Control_Cmd_Status(obj_size());
                int t_abort__size;
                t_abort__size = abort_->Parse(t_begin_of_data, t_end_of_data);
                t_data_obj__size = t_abort__size;
            }
            break;
        case ((uint8)129):
            // Parse "fc_cmd_status"
            {
                fc_cmd_status_ = new File_Control_Cmd_Status(obj_size());
                int t_fc_cmd_status__size;
                t_fc_cmd_status__size = fc_cmd_status_->Parse(t_begin_of_data, t_end_of_data);
                t_data_obj__size = t_fc_cmd_status__size;
            }
            break;
        default:
            // Parse "null"
            {
                t_data_obj__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_File_Control_Cmd_Status_Wrap__size;
    const_byteptr const t_dataptr_after_data_obj = t_begin_of_data + (t_data_obj__size);
    BINPAC_ASSERT(t_dataptr_after_data_obj <= t_end_of_data);
    t_File_Control_Cmd_Status_Wrap__size = t_dataptr_after_data_obj - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Cmd_Status_Wrap__size) <= t_end_of_data);
    return t_File_Control_Cmd_Status_Wrap__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Status::File_Control_Cmd_Status(uint32 obj_size) {
    file_handle_ = 0;
    file_size_ = 0;
    max_block_size_ = 0;
    req_id_ = 0;
    status_code_ = 0;
    obj_size_ = obj_size;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Control_Cmd_Status::~File_Control_Cmd_Status() {
    opt_text_.free();
}

int File_Control_Cmd_Status::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Control_Cmd_Status:status_code"
    if ( (t_begin_of_data + 12) + (1) > t_end_of_data || (t_begin_of_data + 12) + (1) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd_Status:status_code",
        	(12) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "file_handle"
    file_handle_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "file_size"
    file_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "max_block_size"
    max_block_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "req_id"
    req_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "status_code"
    status_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 12)));

    // Parse "opt_text"
    int t_opt_text__size;
    t_opt_text__size =  ( obj_size() - 8 - 4 - 1 ) ;
    // Checking out-of-bound for "File_Control_Cmd_Status:opt_text"
    if ( (t_begin_of_data + 13) + (t_opt_text__size) > t_end_of_data || (t_begin_of_data + 13) + (t_opt_text__size) < (t_begin_of_data + 13) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Control_Cmd_Status:opt_text",
        	(13) + (t_opt_text__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 13) + t_opt_text__size;
        int t_opt_text_string_length;
        t_opt_text_string_length =  ( obj_size() - 8 - 4 - 1 ) ;
        // check for negative sizes
        if ( t_opt_text_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1248", t_opt_text_string_length);
        opt_text_.init((t_begin_of_data + 13), t_opt_text_string_length);
    }

    int t_File_Control_Cmd_Status__size;
    const_byteptr const t_dataptr_after_opt_text = (t_begin_of_data + 13) + (t_opt_text__size);
    BINPAC_ASSERT(t_dataptr_after_opt_text <= t_end_of_data);
    t_File_Control_Cmd_Status__size = t_dataptr_after_opt_text - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Control_Cmd_Status__size) <= t_end_of_data);
    return t_File_Control_Cmd_Status__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Transport::File_Transport(uint32 obj_size) {
    file_handle_ = 0;
    block_num_ = 0;
    obj_size_ = obj_size;
    byteorder_ = littleendian;
    result_ = false;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Transport::~File_Transport() {
    file_data_.free();
}

int File_Transport::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextDNP3* t_context) {
    // Checking out-of-bound for "File_Transport:block_num"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Transport:block_num",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "file_handle"
    file_handle_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "block_num"
    block_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_data"
    int t_file_data__size;
    t_file_data__size =  ( obj_size() - 8 ) ;
    // Checking out-of-bound for "File_Transport:file_data"
    if ( (t_begin_of_data + 8) + (t_file_data__size) > t_end_of_data || (t_begin_of_data + 8) + (t_file_data__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Transport:file_data",
        	(8) + (t_file_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_file_data__size;
        int t_file_data_string_length;
        t_file_data_string_length =  ( obj_size() - 8 ) ;
        // check for negative sizes
        if ( t_file_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1256", t_file_data_string_length);
        file_data_.init((t_begin_of_data + 8), t_file_data_string_length);
    }

    int t_File_Transport__size;
    const_byteptr const t_dataptr_after_file_data = (t_begin_of_data + 8) + (t_file_data__size);
    BINPAC_ASSERT(t_dataptr_after_file_data <= t_end_of_data);
    t_File_Transport__size = t_dataptr_after_file_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    result_ = t_context->flow()->get_dnp3_file_transport(file_handle(), block_num(), file_data());
    BINPAC_ASSERT(t_begin_of_data + (t_File_Transport__size) <= t_end_of_data);
    return t_File_Transport__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Transport_Status::File_Transport_Status(uint32 obj_size) {
    file_handle_ = 0;
    block_num_ = 0;
    status_ = 0;
    obj_size_ = obj_size;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Transport_Status::~File_Transport_Status() {
    opt_text_.free();
}

int File_Transport_Status::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Transport_Status:status"
    if ( (t_begin_of_data + 8) + (1) > t_end_of_data || (t_begin_of_data + 8) + (1) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Transport_Status:status",
        	(8) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "file_handle"
    file_handle_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "block_num"
    block_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "status"
    status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "opt_text"
    int t_opt_text__size;
    t_opt_text__size =  ( obj_size() - 4 - 4 - 1 ) ;
    // Checking out-of-bound for "File_Transport_Status:opt_text"
    if ( (t_begin_of_data + 9) + (t_opt_text__size) > t_end_of_data || (t_begin_of_data + 9) + (t_opt_text__size) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Transport_Status:opt_text",
        	(9) + (t_opt_text__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + t_opt_text__size;
        int t_opt_text_string_length;
        t_opt_text_string_length =  ( obj_size() - 4 - 4 - 1 ) ;
        // check for negative sizes
        if ( t_opt_text_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1265", t_opt_text_string_length);
        opt_text_.init((t_begin_of_data + 9), t_opt_text_string_length);
    }

    int t_File_Transport_Status__size;
    const_byteptr const t_dataptr_after_opt_text = (t_begin_of_data + 9) + (t_opt_text__size);
    BINPAC_ASSERT(t_dataptr_after_opt_text <= t_end_of_data);
    t_File_Transport_Status__size = t_dataptr_after_opt_text - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Transport_Status__size) <= t_end_of_data);
    return t_File_Transport_Status__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Desc_Wrap::File_Desc_Wrap(uint8 function_code) {
    data_case_index_ = -1;
    get_file_info_ = nullptr;
    function_code_ = function_code;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Desc_Wrap::~File_Desc_Wrap() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)28):
            // Clean up "get_file_info"
            {
                delete get_file_info_;
                get_file_info_ = nullptr;
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int File_Desc_Wrap::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "data"
    int t_data__size;
    data_case_index_ =  ( function_code() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)28):
            // Parse "get_file_info"
            {
                get_file_info_ = new File_Desc();
                int t_get_file_info__size;
                t_get_file_info__size = get_file_info_->Parse(t_begin_of_data, t_end_of_data);
                t_data__size = t_get_file_info__size;
            }
            break;
        default:
            // Parse "null"
            {
                t_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_File_Desc_Wrap__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_File_Desc_Wrap__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Desc_Wrap__size) <= t_end_of_data);
    return t_File_Desc_Wrap__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Desc::File_Desc() {
    name_offset_ = 0;
    name_size_ = 0;
    type_ = 0;
    f_size_ = 0;
    time_create_low_ = 0;
    time_create_high_ = 0;
    permission_ = 0;
    req_id_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Desc::~File_Desc() {
    f_name_.free();
}

int File_Desc::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "File_Desc:req_id"
    if ( (t_begin_of_data + 18) + (2) > t_end_of_data || (t_begin_of_data + 18) + (2) < (t_begin_of_data + 18) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Desc:req_id",
        	(18) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "name_offset"
    name_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "name_size"
    name_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "type"
    type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "f_size"
    f_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 6))));

    // Parse "time_create_low"
    time_create_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "time_create_high"
    time_create_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "permission"
    permission_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 16))));

    // Parse "req_id"
    req_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 18))));

    // Parse "f_name"
    int t_f_name__size;
    t_f_name__size = name_size();
    // Checking out-of-bound for "File_Desc:f_name"
    if ( (t_begin_of_data + 20) + (t_f_name__size) > t_end_of_data || (t_begin_of_data + 20) + (t_f_name__size) < (t_begin_of_data + 20) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Desc:f_name",
        	(20) + (t_f_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 20) + t_f_name__size;
        int t_f_name_string_length;
        t_f_name_string_length = name_size();
        // check for negative sizes
        if ( t_f_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1285", t_f_name_string_length);
        f_name_.init((t_begin_of_data + 20), t_f_name_string_length);
    }

    int t_File_Desc__size;
    const_byteptr const t_dataptr_after_f_name = (t_begin_of_data + 20) + (t_f_name__size);
    BINPAC_ASSERT(t_dataptr_after_f_name <= t_end_of_data);
    t_File_Desc__size = t_dataptr_after_f_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Desc__size) <= t_end_of_data);
    return t_File_Desc__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Spec_Str::File_Spec_Str() {
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
File_Spec_Str::~File_Spec_Str() {
    f_spec_.free();
}

int File_Spec_Str::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "f_spec"
    int t_f_spec_string_length;
    t_f_spec_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_f_spec__size;
    t_f_spec__size = t_f_spec_string_length;
    // check for negative sizes
    if ( t_f_spec_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1290", t_f_spec_string_length);
    f_spec_.init(t_begin_of_data, t_f_spec_string_length);

    int t_File_Spec_Str__size;
    const_byteptr const t_dataptr_after_f_spec = t_begin_of_data + (t_f_spec__size);
    BINPAC_ASSERT(t_dataptr_after_f_spec <= t_end_of_data);
    t_File_Spec_Str__size = t_dataptr_after_f_spec - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_File_Spec_Str__size) <= t_end_of_data);
    return t_File_Spec_Str__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Store::Dev_Store() {
    overflow_ = 0;
    obj_group_ = 0;
    variation_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Store::~Dev_Store() {
}

int Dev_Store::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Dev_Store"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Dev_Store",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "overflow"
    overflow_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "obj_group"
    obj_group_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "variation"
    variation_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Profile::Dev_Profile() {
    fc_support_low_ = 0;
    fc_support_high_ = 0;
    count_ = 0;
    dev_headers_ = nullptr;
    dev_headers__elem_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Profile::~Dev_Profile() {
    delete dev_headers__elem_;
    dev_headers__elem_ = nullptr;
    if ( dev_headers() ) {
        for ( auto* dev_headers__elem_ : *dev_headers() ) {
            delete dev_headers__elem_;
            dev_headers__elem_ = nullptr;
        }
    }
    delete dev_headers_;
}

int Dev_Profile::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Dev_Profile:count"
    if ( (t_begin_of_data + 8) + (2) > t_end_of_data || (t_begin_of_data + 8) + (2) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Dev_Profile:count",
        	(8) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "fc_support_low"
    fc_support_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "fc_support_high"
    fc_support_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "count"
    count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "dev_headers"
    int t_dev_headers__arraylength;
    t_dev_headers__arraylength = count();
    if ( t_dev_headers__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("Dev_Profile:dev_headers",
          t_dev_headers__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: Dev_Profile:dev_headers
    if ( t_dev_headers__arraylength > ((t_end_of_data - (t_begin_of_data + 10)) / 4) )
        throw binpac::ExceptionOutOfBound("Dev_Profile:dev_headers",
          t_dev_headers__arraylength, (t_end_of_data) - ((t_begin_of_data + 10)));
    dev_headers__elem_ = nullptr;
    int t_dev_headers__elem__it;
    t_dev_headers__elem__it = 0;
    int t_dev_headers__size;
    dev_headers_ = new vector<Dev_Profile_OH*>;
    dev_headers_->reserve(t_dev_headers__arraylength);
    const_byteptr t_dev_headers__elem__dataptr = (t_begin_of_data + 10);
    for (; t_dev_headers__elem__it < t_dev_headers__arraylength; ++t_dev_headers__elem__it) {
        dev_headers__elem_ = new Dev_Profile_OH();
        dev_headers__elem_->Parse(t_dev_headers__elem__dataptr, t_end_of_data);
        dev_headers_->push_back(dev_headers__elem_);
        t_dev_headers__elem__dataptr += 4;
        BINPAC_ASSERT(t_dev_headers__elem__dataptr <= t_end_of_data);
        dev_headers__elem_ = nullptr;
    }
end_of_dev_headers: ;
    t_dev_headers__size = t_dev_headers__elem__dataptr - ((t_begin_of_data + 10));
    // Evaluate 'let' and 'withinput' fields

    int t_Dev_Profile__size;
    const_byteptr const t_dataptr_after_dev_headers = (t_begin_of_data + 10) + (t_dev_headers__size);
    BINPAC_ASSERT(t_dataptr_after_dev_headers <= t_end_of_data);
    t_Dev_Profile__size = t_dataptr_after_dev_headers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Dev_Profile__size) <= t_end_of_data);
    return t_Dev_Profile__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Profile_OH::Dev_Profile_OH() {
    group_ = 0;
    variation_ = 0;
    qualifier_ = 0;
    range_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
Dev_Profile_OH::~Dev_Profile_OH() {
}

int Dev_Profile_OH::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Dev_Profile_OH"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Dev_Profile_OH",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "group"
    group_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "variation"
    variation_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "qualifier"
    qualifier_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "range"
    range_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivRegObj::PrivRegObj() {
    vendor_ = 0;
    obj_id_ = 0;
    len_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivRegObj::~PrivRegObj() {
    data_objs_.free();
}

int PrivRegObj::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PrivRegObj:len"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PrivRegObj:len",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "vendor"
    vendor_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "obj_id"
    obj_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "len"
    len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "data_objs"
    int t_data_objs__size;
    t_data_objs__size = len();
    // Checking out-of-bound for "PrivRegObj:data_objs"
    if ( (t_begin_of_data + 8) + (t_data_objs__size) > t_end_of_data || (t_begin_of_data + 8) + (t_data_objs__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PrivRegObj:data_objs",
        	(8) + (t_data_objs__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_data_objs__size;
        int t_data_objs_string_length;
        t_data_objs_string_length = len();
        // check for negative sizes
        if ( t_data_objs_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1324", t_data_objs_string_length);
        data_objs_.init((t_begin_of_data + 8), t_data_objs_string_length);
    }

    int t_PrivRegObj__size;
    const_byteptr const t_dataptr_after_data_objs = (t_begin_of_data + 8) + (t_data_objs__size);
    BINPAC_ASSERT(t_dataptr_after_data_objs <= t_end_of_data);
    t_PrivRegObj__size = t_dataptr_after_data_objs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PrivRegObj__size) <= t_end_of_data);
    return t_PrivRegObj__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivRegObjDesc::PrivRegObjDesc() {
    vendor_ = 0;
    obj_id_ = 0;
    count_ = 0;
    data_objs_ = nullptr;
    data_objs__elem_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
PrivRegObjDesc::~PrivRegObjDesc() {
    delete data_objs__elem_;
    data_objs__elem_ = nullptr;
    if ( data_objs() ) {
        for ( auto* data_objs__elem_ : *data_objs() ) {
            delete data_objs__elem_;
            data_objs__elem_ = nullptr;
        }
    }
    delete data_objs_;
}

int PrivRegObjDesc::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PrivRegObjDesc:count"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PrivRegObjDesc:count",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "vendor"
    vendor_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "obj_id"
    obj_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "count"
    count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "data_objs"
    int t_data_objs__arraylength;
    t_data_objs__arraylength = count();
    if ( t_data_objs__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("PrivRegObjDesc:data_objs",
          t_data_objs__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: PrivRegObjDesc:data_objs
    if ( t_data_objs__arraylength > ((t_end_of_data - (t_begin_of_data + 8)) / 4) )
        throw binpac::ExceptionOutOfBound("PrivRegObjDesc:data_objs",
          t_data_objs__arraylength, (t_end_of_data) - ((t_begin_of_data + 8)));
    data_objs__elem_ = nullptr;
    int t_data_objs__elem__it;
    t_data_objs__elem__it = 0;
    int t_data_objs__size;
    data_objs_ = new vector<ObjDescSpec*>;
    data_objs_->reserve(t_data_objs__arraylength);
    const_byteptr t_data_objs__elem__dataptr = (t_begin_of_data + 8);
    for (; t_data_objs__elem__it < t_data_objs__arraylength; ++t_data_objs__elem__it) {
        data_objs__elem_ = new ObjDescSpec();
        data_objs__elem_->Parse(t_data_objs__elem__dataptr, t_end_of_data);
        data_objs_->push_back(data_objs__elem_);
        t_data_objs__elem__dataptr += 4;
        BINPAC_ASSERT(t_data_objs__elem__dataptr <= t_end_of_data);
        data_objs__elem_ = nullptr;
    }
end_of_data_objs: ;
    t_data_objs__size = t_data_objs__elem__dataptr - ((t_begin_of_data + 8));
    // Evaluate 'let' and 'withinput' fields

    int t_PrivRegObjDesc__size;
    const_byteptr const t_dataptr_after_data_objs = (t_begin_of_data + 8) + (t_data_objs__size);
    BINPAC_ASSERT(t_dataptr_after_data_objs <= t_end_of_data);
    t_PrivRegObjDesc__size = t_dataptr_after_data_objs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PrivRegObjDesc__size) <= t_end_of_data);
    return t_PrivRegObjDesc__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjDescSpec::ObjDescSpec() {
    obj_quantity_ = 0;
    obj_group_ = 0;
    obj_variation_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ObjDescSpec::~ObjDescSpec() {
}

int ObjDescSpec::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ObjDescSpec"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ObjDescSpec",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "obj_quantity"
    obj_quantity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "obj_group"
    obj_group_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "obj_variation"
    obj_variation_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DescEle::DescEle() {
    len_ = 0;
    desc_code_ = 0;
    data_type_ = 0;
    max_len_ = 0;
    ancillary_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DescEle::~DescEle() {
}

int DescEle::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "DescEle"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DescEle",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "desc_code"
    desc_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "data_type"
    data_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "max_len"
    max_len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "ancillary"
    ancillary_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
App_Id::App_Id(uint8 qualifier_field, uint16 object_size16) {
    app_id_case_index_ = -1;
    qualifier_field_ = qualifier_field;
    object_size16_ = object_size16;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
App_Id::~App_Id() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( app_id_case_index() ) {
        case ((uint8)91):
            // Clean up "app_name"
            {
                app_name_.free();
            }
            break;
        case ((uint8)6):
            // Clean up "all_app"
            {
            }
            break;
        default:
            // Clean up "illegal"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int App_Id::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "app_id"
    int t_app_id__size;
    app_id_case_index_ =  ( qualifier_field() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( app_id_case_index() ) {
        case ((uint8)91):
            // Parse "app_name"
            {
                int t_app_name__size;
                t_app_name__size = object_size16();
                // Checking out-of-bound for "App_Id:app_name"
                if ( t_begin_of_data + (t_app_name__size) > t_end_of_data || t_begin_of_data + (t_app_name__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("App_Id:app_name",
                    	(0) + (t_app_name__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_app_name__size;
                    int t_app_name_string_length;
                    t_app_name_string_length = object_size16();
                    // check for negative sizes
                    if ( t_app_name_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1365", t_app_name_string_length);
                    app_name_.init(t_begin_of_data, t_app_name_string_length);
                }
                t_app_id__size = t_app_name__size;
            }
            break;
        case ((uint8)6):
            // Parse "all_app"
            {
                t_app_id__size = 0;
            }
            break;
        default:
            // Parse "illegal"
            {
                t_app_id__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_App_Id__size;
    const_byteptr const t_dataptr_after_app_id = t_begin_of_data + (t_app_id__size);
    BINPAC_ASSERT(t_dataptr_after_app_id <= t_end_of_data);
    t_App_Id__size = t_dataptr_after_app_id - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_App_Id__size) <= t_end_of_data);
    return t_App_Id__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ActivateConf::ActivateConf() {
    time_delay_ = 0;
    count_ = 0;
    elements_ = nullptr;
    elements__elem_ = nullptr;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
ActivateConf::~ActivateConf() {
    delete elements__elem_;
    elements__elem_ = nullptr;
    if ( elements() ) {
        for ( auto* elements__elem_ : *elements() ) {
            delete elements__elem_;
            elements__elem_ = nullptr;
        }
    }
    delete elements_;
}

int ActivateConf::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ActivateConf:count"
    if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ActivateConf:count",
        	(4) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "time_delay"
    time_delay_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "count"
    count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "elements"
    int t_elements__arraylength;
    t_elements__arraylength = count();
    if ( t_elements__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ActivateConf:elements",
          t_elements__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: ActivateConf:elements
    if ( t_elements__arraylength > ((t_end_of_data - (t_begin_of_data + 5)) / 1) )
        throw binpac::ExceptionOutOfBound("ActivateConf:elements",
          t_elements__arraylength, (t_end_of_data) - ((t_begin_of_data + 5)));
    elements__elem_ = nullptr;
    int t_elements__elem__it;
    t_elements__elem__it = 0;
    int t_elements__size;
    elements_ = new vector<StatusEle*>;
    elements_->reserve(t_elements__arraylength);
    const_byteptr t_elements__elem__dataptr = (t_begin_of_data + 5);
    for (; t_elements__elem__it < t_elements__arraylength; ++t_elements__elem__it) {
        elements__elem_ = new StatusEle();
        int t_elements__elem__size;
        t_elements__elem__size = elements__elem_->Parse(t_elements__elem__dataptr, t_end_of_data);
        elements_->push_back(elements__elem_);
        t_elements__elem__dataptr += t_elements__elem__size;
        BINPAC_ASSERT(t_elements__elem__dataptr <= t_end_of_data);
        elements__elem_ = nullptr;
    }
end_of_elements: ;
    t_elements__size = t_elements__elem__dataptr - ((t_begin_of_data + 5));
    // Evaluate 'let' and 'withinput' fields

    int t_ActivateConf__size;
    const_byteptr const t_dataptr_after_elements = (t_begin_of_data + 5) + (t_elements__size);
    BINPAC_ASSERT(t_dataptr_after_elements <= t_end_of_data);
    t_ActivateConf__size = t_dataptr_after_elements - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ActivateConf__size) <= t_end_of_data);
    return t_ActivateConf__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
StatusEle::StatusEle() {
    len_ = 0;
    status_code_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
StatusEle::~StatusEle() {
    ancillary_.free();
}

int StatusEle::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "StatusEle:status_code"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("StatusEle:status_code",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status_code"
    status_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "ancillary"
    int t_ancillary__size;
    t_ancillary__size =  ( len() - 1 ) ;
    // Checking out-of-bound for "StatusEle:ancillary"
    if ( (t_begin_of_data + 2) + (t_ancillary__size) > t_end_of_data || (t_begin_of_data + 2) + (t_ancillary__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("StatusEle:ancillary",
        	(2) + (t_ancillary__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_ancillary__size;
        int t_ancillary_string_length;
        t_ancillary_string_length =  ( len() - 1 ) ;
        // check for negative sizes
        if ( t_ancillary_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1381", t_ancillary_string_length);
        ancillary_.init((t_begin_of_data + 2), t_ancillary_string_length);
    }

    int t_StatusEle__size;
    const_byteptr const t_dataptr_after_ancillary = (t_begin_of_data + 2) + (t_ancillary__size);
    BINPAC_ASSERT(t_dataptr_after_ancillary <= t_end_of_data);
    t_StatusEle__size = t_dataptr_after_ancillary - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_StatusEle__size) <= t_end_of_data);
    return t_StatusEle__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BCD_Large::BCD_Large() {
    value_low_ = 0;
    value_high_ = 0;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
BCD_Large::~BCD_Large() {
}

int BCD_Large::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "BCD_Large"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("BCD_Large",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "value_low"
    value_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "value_high"
    value_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthChallenge::AuthChallenge(uint16 prefix) {
    cha_seq_num_ = 0;
    user_num_ = 0;
    mac_alg_ = 0;
    reason_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthChallenge::~AuthChallenge() {
    chan_data_.free();
}

int AuthChallenge::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthChallenge:reason"
    if ( (t_begin_of_data + 7) + (1) > t_end_of_data || (t_begin_of_data + 7) + (1) < (t_begin_of_data + 7) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthChallenge:reason",
        	(7) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cha_seq_num"
    cha_seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "mac_alg"
    mac_alg_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "reason"
    reason_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Parse "chan_data"
    int t_chan_data__size;
    t_chan_data__size =  ( prefix() - 8 ) ;
    // Checking out-of-bound for "AuthChallenge:chan_data"
    if ( (t_begin_of_data + 8) + (t_chan_data__size) > t_end_of_data || (t_begin_of_data + 8) + (t_chan_data__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthChallenge:chan_data",
        	(8) + (t_chan_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_chan_data__size;
        int t_chan_data_string_length;
        t_chan_data_string_length =  ( prefix() - 8 ) ;
        // check for negative sizes
        if ( t_chan_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1400", t_chan_data_string_length);
        chan_data_.init((t_begin_of_data + 8), t_chan_data_string_length);
    }

    int t_AuthChallenge__size;
    const_byteptr const t_dataptr_after_chan_data = (t_begin_of_data + 8) + (t_chan_data__size);
    BINPAC_ASSERT(t_dataptr_after_chan_data <= t_end_of_data);
    t_AuthChallenge__size = t_dataptr_after_chan_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthChallenge__size) <= t_end_of_data);
    return t_AuthChallenge__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthReply::AuthReply(uint16 prefix) {
    cha_seq_num_ = 0;
    user_num_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthReply::~AuthReply() {
    mac_.free();
}

int AuthReply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthReply:user_num"
    if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthReply:user_num",
        	(4) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cha_seq_num"
    cha_seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "mac"
    int t_mac__size;
    t_mac__size =  ( prefix() - 6 ) ;
    // Checking out-of-bound for "AuthReply:mac"
    if ( (t_begin_of_data + 6) + (t_mac__size) > t_end_of_data || (t_begin_of_data + 6) + (t_mac__size) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthReply:mac",
        	(6) + (t_mac__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 6) + t_mac__size;
        int t_mac_string_length;
        t_mac_string_length =  ( prefix() - 6 ) ;
        // check for negative sizes
        if ( t_mac_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1407", t_mac_string_length);
        mac_.init((t_begin_of_data + 6), t_mac_string_length);
    }

    int t_AuthReply__size;
    const_byteptr const t_dataptr_after_mac = (t_begin_of_data + 6) + (t_mac__size);
    BINPAC_ASSERT(t_dataptr_after_mac <= t_end_of_data);
    t_AuthReply__size = t_dataptr_after_mac - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthReply__size) <= t_end_of_data);
    return t_AuthReply__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthAggrRequest::AuthAggrRequest(uint16 prefix) {
    cha_seq_num_ = 0;
    user_num_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthAggrRequest::~AuthAggrRequest() {
}

int AuthAggrRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthAggrRequest"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthAggrRequest",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cha_seq_num"
    cha_seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthSessionKeyStatus::AuthSessionKeyStatus(uint16 prefix) {
    cha_seq_num_ = 0;
    user_num_ = 0;
    key_alg_ = 0;
    key_status_ = 0;
    mac_alg_ = 0;
    cha_data_len_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthSessionKeyStatus::~AuthSessionKeyStatus() {
    chan_data_.free();
    mac_.free();
}

int AuthSessionKeyStatus::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthSessionKeyStatus:cha_data_len"
    if ( (t_begin_of_data + 9) + (2) > t_end_of_data || (t_begin_of_data + 9) + (2) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthSessionKeyStatus:cha_data_len",
        	(9) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cha_seq_num"
    cha_seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "key_alg"
    key_alg_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "key_status"
    key_status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Parse "mac_alg"
    mac_alg_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "cha_data_len"
    cha_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "chan_data"
    int t_chan_data__size;
    t_chan_data__size = cha_data_len();
    // Checking out-of-bound for "AuthSessionKeyStatus:chan_data"
    if ( (t_begin_of_data + 11) + (t_chan_data__size) > t_end_of_data || (t_begin_of_data + 11) + (t_chan_data__size) < (t_begin_of_data + 11) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthSessionKeyStatus:chan_data",
        	(11) + (t_chan_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 11) + t_chan_data__size;
        int t_chan_data_string_length;
        t_chan_data_string_length = cha_data_len();
        // check for negative sizes
        if ( t_chan_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1424", t_chan_data_string_length);
        chan_data_.init((t_begin_of_data + 11), t_chan_data_string_length);
    }

    const_byteptr const t_dataptr_after_chan_data = (t_begin_of_data + 11) + (t_chan_data__size);
    BINPAC_ASSERT(t_dataptr_after_chan_data <= t_end_of_data);
    // Parse "mac"
    int t_mac__size;
    t_mac__size =  ( prefix() - 11 - cha_data_len() ) ;
    // Checking out-of-bound for "AuthSessionKeyStatus:mac"
    if ( t_dataptr_after_chan_data + (t_mac__size) > t_end_of_data || t_dataptr_after_chan_data + (t_mac__size) < t_dataptr_after_chan_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthSessionKeyStatus:mac",
        	((t_dataptr_after_chan_data - t_begin_of_data)) + (t_mac__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_chan_data + t_mac__size;
        int t_mac_string_length;
        t_mac_string_length =  ( prefix() - 11 - cha_data_len() ) ;
        // check for negative sizes
        if ( t_mac_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1425", t_mac_string_length);
        mac_.init(t_dataptr_after_chan_data, t_mac_string_length);
    }

    int t_AuthSessionKeyStatus__size;
    const_byteptr const t_dataptr_after_mac = t_dataptr_after_chan_data + (t_mac__size);
    BINPAC_ASSERT(t_dataptr_after_mac <= t_end_of_data);
    t_AuthSessionKeyStatus__size = t_dataptr_after_mac - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthSessionKeyStatus__size) <= t_end_of_data);
    return t_AuthSessionKeyStatus__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthSessionKeyChange::AuthSessionKeyChange(uint16 prefix) {
    key_change_num_ = 0;
    user_num_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthSessionKeyChange::~AuthSessionKeyChange() {
    key_wrap_data_.free();
}

int AuthSessionKeyChange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthSessionKeyChange:user_num"
    if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthSessionKeyChange:user_num",
        	(4) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "key_change_num"
    key_change_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "key_wrap_data"
    int t_key_wrap_data__size;
    t_key_wrap_data__size =  ( prefix() - 6 ) ;
    // Checking out-of-bound for "AuthSessionKeyChange:key_wrap_data"
    if ( (t_begin_of_data + 6) + (t_key_wrap_data__size) > t_end_of_data || (t_begin_of_data + 6) + (t_key_wrap_data__size) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthSessionKeyChange:key_wrap_data",
        	(6) + (t_key_wrap_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 6) + t_key_wrap_data__size;
        int t_key_wrap_data_string_length;
        t_key_wrap_data_string_length =  ( prefix() - 6 ) ;
        // check for negative sizes
        if ( t_key_wrap_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1432", t_key_wrap_data_string_length);
        key_wrap_data_.init((t_begin_of_data + 6), t_key_wrap_data_string_length);
    }

    int t_AuthSessionKeyChange__size;
    const_byteptr const t_dataptr_after_key_wrap_data = (t_begin_of_data + 6) + (t_key_wrap_data__size);
    BINPAC_ASSERT(t_dataptr_after_key_wrap_data <= t_end_of_data);
    t_AuthSessionKeyChange__size = t_dataptr_after_key_wrap_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthSessionKeyChange__size) <= t_end_of_data);
    return t_AuthSessionKeyChange__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthError::AuthError(uint16 prefix) {
    cha_seq_num_ = 0;
    user_num_ = 0;
    id_ = 0;
    error_code_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
AuthError::~AuthError() {
    time_error_.free();
    error_text_.free();
}

int AuthError::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "AuthError:error_code"
    if ( (t_begin_of_data + 8) + (1) > t_end_of_data || (t_begin_of_data + 8) + (1) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthError:error_code",
        	(8) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cha_seq_num"
    cha_seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "id"
    id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "error_code"
    error_code_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "time_error"
    // Checking out-of-bound for "AuthError:time_error"
    if ( (t_begin_of_data + 9) + (6) > t_end_of_data || (t_begin_of_data + 9) + (6) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthError:time_error",
        	(9) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 9) + 6;
        int t_time_error_string_length;
        t_time_error_string_length = 6;
        int t_time_error__size;
        t_time_error__size = t_time_error_string_length;
        time_error_.init((t_begin_of_data + 9), t_time_error_string_length);
    }

    const_byteptr const t_dataptr_after_time_error = (t_begin_of_data + 9) + (6);
    BINPAC_ASSERT(t_dataptr_after_time_error <= t_end_of_data);
    // Parse "error_text"
    int t_error_text__size;
    t_error_text__size =  ( prefix() - 15 ) ;
    // Checking out-of-bound for "AuthError:error_text"
    if ( t_dataptr_after_time_error + (t_error_text__size) > t_end_of_data || t_dataptr_after_time_error + (t_error_text__size) < t_dataptr_after_time_error ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("AuthError:error_text",
        	((t_dataptr_after_time_error - t_begin_of_data)) + (t_error_text__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_time_error + t_error_text__size;
        int t_error_text_string_length;
        t_error_text_string_length =  ( prefix() - 15 ) ;
        // check for negative sizes
        if ( t_error_text_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1442", t_error_text_string_length);
        error_text_.init(t_dataptr_after_time_error, t_error_text_string_length);
    }

    int t_AuthError__size;
    const_byteptr const t_dataptr_after_error_text = t_dataptr_after_time_error + (t_error_text__size);
    BINPAC_ASSERT(t_dataptr_after_error_text <= t_end_of_data);
    t_AuthError__size = t_dataptr_after_error_text - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_AuthError__size) <= t_end_of_data);
    return t_AuthError__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UserCert::UserCert(uint16 prefix) {
    method_ = 0;
    cert_type_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UserCert::~UserCert() {
    cert_text_.free();
}

int UserCert::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "UserCert:cert_type"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserCert:cert_type",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "method"
    method_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "cert_type"
    cert_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "cert_text"
    int t_cert_text__size;
    t_cert_text__size =  ( prefix() - 2 ) ;
    // Checking out-of-bound for "UserCert:cert_text"
    if ( (t_begin_of_data + 2) + (t_cert_text__size) > t_end_of_data || (t_begin_of_data + 2) + (t_cert_text__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserCert:cert_text",
        	(2) + (t_cert_text__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_cert_text__size;
        int t_cert_text_string_length;
        t_cert_text_string_length =  ( prefix() - 2 ) ;
        // check for negative sizes
        if ( t_cert_text_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1449", t_cert_text_string_length);
        cert_text_.init((t_begin_of_data + 2), t_cert_text_string_length);
    }

    int t_UserCert__size;
    const_byteptr const t_dataptr_after_cert_text = (t_begin_of_data + 2) + (t_cert_text__size);
    BINPAC_ASSERT(t_dataptr_after_cert_text <= t_end_of_data);
    t_UserCert__size = t_dataptr_after_cert_text - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UserCert__size) <= t_end_of_data);
    return t_UserCert__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MAC::MAC(uint16 prefix) {
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
MAC::~MAC() {
    mac_text_.free();
}

int MAC::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "mac_text"
    int t_mac_text__size;
    t_mac_text__size = prefix();
    // Checking out-of-bound for "MAC:mac_text"
    if ( t_begin_of_data + (t_mac_text__size) > t_end_of_data || t_begin_of_data + (t_mac_text__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("MAC:mac_text",
        	(0) + (t_mac_text__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_mac_text__size;
        int t_mac_text_string_length;
        t_mac_text_string_length = prefix();
        // check for negative sizes
        if ( t_mac_text_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1454", t_mac_text_string_length);
        mac_text_.init(t_begin_of_data, t_mac_text_string_length);
    }

    int t_MAC__size;
    const_byteptr const t_dataptr_after_mac_text = t_begin_of_data + (t_mac_text__size);
    BINPAC_ASSERT(t_dataptr_after_mac_text <= t_end_of_data);
    t_MAC__size = t_dataptr_after_mac_text - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_MAC__size) <= t_end_of_data);
    return t_MAC__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UserStatusChange::UserStatusChange(uint16 prefix) {
    method_ = 0;
    operation_ = 0;
    seq_num_ = 0;
    user_role_ = 0;
    user_role_exp_ = 0;
    user_name_len_ = 0;
    user_pubkey_len_ = 0;
    cert_data_len_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UserStatusChange::~UserStatusChange() {
    user_name_.free();
    user_pubkey_.free();
    cert_data_.free();
}

int UserStatusChange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "UserStatusChange:cert_data_len"
    if ( (t_begin_of_data + 14) + (2) > t_end_of_data || (t_begin_of_data + 14) + (2) < (t_begin_of_data + 14) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserStatusChange:cert_data_len",
        	(14) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "method"
    method_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "operation"
    operation_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "seq_num"
    seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "user_role"
    user_role_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "user_role_exp"
    user_role_exp_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "user_name_len"
    user_name_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "user_pubkey_len"
    user_pubkey_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 12))));

    // Parse "cert_data_len"
    cert_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "user_name"
    int t_user_name__size;
    t_user_name__size = user_name_len();
    // Checking out-of-bound for "UserStatusChange:user_name"
    if ( (t_begin_of_data + 16) + (t_user_name__size) > t_end_of_data || (t_begin_of_data + 16) + (t_user_name__size) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserStatusChange:user_name",
        	(16) + (t_user_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 16) + t_user_name__size;
        int t_user_name_string_length;
        t_user_name_string_length = user_name_len();
        // check for negative sizes
        if ( t_user_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1467", t_user_name_string_length);
        user_name_.init((t_begin_of_data + 16), t_user_name_string_length);
    }

    const_byteptr const t_dataptr_after_user_name = (t_begin_of_data + 16) + (t_user_name__size);
    BINPAC_ASSERT(t_dataptr_after_user_name <= t_end_of_data);
    // Parse "user_pubkey"
    int t_user_pubkey__size;
    t_user_pubkey__size = user_pubkey_len();
    // Checking out-of-bound for "UserStatusChange:user_pubkey"
    if ( t_dataptr_after_user_name + (t_user_pubkey__size) > t_end_of_data || t_dataptr_after_user_name + (t_user_pubkey__size) < t_dataptr_after_user_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserStatusChange:user_pubkey",
        	((t_dataptr_after_user_name - t_begin_of_data)) + (t_user_pubkey__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_user_name + t_user_pubkey__size;
        int t_user_pubkey_string_length;
        t_user_pubkey_string_length = user_pubkey_len();
        // check for negative sizes
        if ( t_user_pubkey_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1468", t_user_pubkey_string_length);
        user_pubkey_.init(t_dataptr_after_user_name, t_user_pubkey_string_length);
    }

    const_byteptr const t_dataptr_after_user_pubkey = t_dataptr_after_user_name + (t_user_pubkey__size);
    BINPAC_ASSERT(t_dataptr_after_user_pubkey <= t_end_of_data);
    // Parse "cert_data"
    int t_cert_data__size;
    t_cert_data__size = cert_data_len();
    // Checking out-of-bound for "UserStatusChange:cert_data"
    if ( t_dataptr_after_user_pubkey + (t_cert_data__size) > t_end_of_data || t_dataptr_after_user_pubkey + (t_cert_data__size) < t_dataptr_after_user_pubkey ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UserStatusChange:cert_data",
        	((t_dataptr_after_user_pubkey - t_begin_of_data)) + (t_cert_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_user_pubkey + t_cert_data__size;
        int t_cert_data_string_length;
        t_cert_data_string_length = cert_data_len();
        // check for negative sizes
        if ( t_cert_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1469", t_cert_data_string_length);
        cert_data_.init(t_dataptr_after_user_pubkey, t_cert_data_string_length);
    }

    int t_UserStatusChange__size;
    const_byteptr const t_dataptr_after_cert_data = t_dataptr_after_user_pubkey + (t_cert_data__size);
    BINPAC_ASSERT(t_dataptr_after_cert_data <= t_end_of_data);
    t_UserStatusChange__size = t_dataptr_after_cert_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UserStatusChange__size) <= t_end_of_data);
    return t_UserStatusChange__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyReq::UpdateKeyReq(uint16 prefix) {
    method_ = 0;
    user_name_len_ = 0;
    master_cha_data_len_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyReq::~UpdateKeyReq() {
    user_name_.free();
    master_cha_data_.free();
}

int UpdateKeyReq::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "UpdateKeyReq:master_cha_data_len"
    if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyReq:master_cha_data_len",
        	(3) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "method"
    method_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "user_name_len"
    user_name_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "master_cha_data_len"
    master_cha_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "user_name"
    int t_user_name__size;
    t_user_name__size = user_name_len();
    // Checking out-of-bound for "UpdateKeyReq:user_name"
    if ( (t_begin_of_data + 5) + (t_user_name__size) > t_end_of_data || (t_begin_of_data + 5) + (t_user_name__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyReq:user_name",
        	(5) + (t_user_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_user_name__size;
        int t_user_name_string_length;
        t_user_name_string_length = user_name_len();
        // check for negative sizes
        if ( t_user_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1477", t_user_name_string_length);
        user_name_.init((t_begin_of_data + 5), t_user_name_string_length);
    }

    const_byteptr const t_dataptr_after_user_name = (t_begin_of_data + 5) + (t_user_name__size);
    BINPAC_ASSERT(t_dataptr_after_user_name <= t_end_of_data);
    // Parse "master_cha_data"
    int t_master_cha_data__size;
    t_master_cha_data__size = master_cha_data_len();
    // Checking out-of-bound for "UpdateKeyReq:master_cha_data"
    if ( t_dataptr_after_user_name + (t_master_cha_data__size) > t_end_of_data || t_dataptr_after_user_name + (t_master_cha_data__size) < t_dataptr_after_user_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyReq:master_cha_data",
        	((t_dataptr_after_user_name - t_begin_of_data)) + (t_master_cha_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_user_name + t_master_cha_data__size;
        int t_master_cha_data_string_length;
        t_master_cha_data_string_length = master_cha_data_len();
        // check for negative sizes
        if ( t_master_cha_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1478", t_master_cha_data_string_length);
        master_cha_data_.init(t_dataptr_after_user_name, t_master_cha_data_string_length);
    }

    int t_UpdateKeyReq__size;
    const_byteptr const t_dataptr_after_master_cha_data = t_dataptr_after_user_name + (t_master_cha_data__size);
    BINPAC_ASSERT(t_dataptr_after_master_cha_data <= t_end_of_data);
    t_UpdateKeyReq__size = t_dataptr_after_master_cha_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UpdateKeyReq__size) <= t_end_of_data);
    return t_UpdateKeyReq__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyRep::UpdateKeyRep(uint16 prefix) {
    seq_num_ = 0;
    user_num_ = 0;
    user_name_len_ = 0;
    outstation_cha_data_len_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyRep::~UpdateKeyRep() {
    outstation_cha_data_.free();
}

int UpdateKeyRep::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "UpdateKeyRep:outstation_cha_data_len"
    if ( (t_begin_of_data + 8) + (2) > t_end_of_data || (t_begin_of_data + 8) + (2) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyRep:outstation_cha_data_len",
        	(8) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "seq_num"
    seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "user_name_len"
    user_name_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "outstation_cha_data_len"
    outstation_cha_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "outstation_cha_data"
    int t_outstation_cha_data__size;
    t_outstation_cha_data__size = outstation_cha_data_len();
    // Checking out-of-bound for "UpdateKeyRep:outstation_cha_data"
    if ( (t_begin_of_data + 10) + (t_outstation_cha_data__size) > t_end_of_data || (t_begin_of_data + 10) + (t_outstation_cha_data__size) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyRep:outstation_cha_data",
        	(10) + (t_outstation_cha_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 10) + t_outstation_cha_data__size;
        int t_outstation_cha_data_string_length;
        t_outstation_cha_data_string_length = outstation_cha_data_len();
        // check for negative sizes
        if ( t_outstation_cha_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1487", t_outstation_cha_data_string_length);
        outstation_cha_data_.init((t_begin_of_data + 10), t_outstation_cha_data_string_length);
    }

    int t_UpdateKeyRep__size;
    const_byteptr const t_dataptr_after_outstation_cha_data = (t_begin_of_data + 10) + (t_outstation_cha_data__size);
    BINPAC_ASSERT(t_dataptr_after_outstation_cha_data <= t_end_of_data);
    t_UpdateKeyRep__size = t_dataptr_after_outstation_cha_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UpdateKeyRep__size) <= t_end_of_data);
    return t_UpdateKeyRep__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKey::UpdateKey(uint16 prefix) {
    seq_num_ = 0;
    user_num_ = 0;
    update_key_len_ = 0;
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKey::~UpdateKey() {
    update_key_data_.free();
}

int UpdateKey::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "UpdateKey:update_key_len"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKey:update_key_len",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "seq_num"
    seq_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "user_num"
    user_num_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "update_key_len"
    update_key_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "update_key_data"
    int t_update_key_data__size;
    t_update_key_data__size = update_key_len();
    // Checking out-of-bound for "UpdateKey:update_key_data"
    if ( (t_begin_of_data + 8) + (t_update_key_data__size) > t_end_of_data || (t_begin_of_data + 8) + (t_update_key_data__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKey:update_key_data",
        	(8) + (t_update_key_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_update_key_data__size;
        int t_update_key_data_string_length;
        t_update_key_data_string_length = update_key_len();
        // check for negative sizes
        if ( t_update_key_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1495", t_update_key_data_string_length);
        update_key_data_.init((t_begin_of_data + 8), t_update_key_data_string_length);
    }

    int t_UpdateKey__size;
    const_byteptr const t_dataptr_after_update_key_data = (t_begin_of_data + 8) + (t_update_key_data__size);
    BINPAC_ASSERT(t_dataptr_after_update_key_data <= t_end_of_data);
    t_UpdateKey__size = t_dataptr_after_update_key_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UpdateKey__size) <= t_end_of_data);
    return t_UpdateKey__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeySig::UpdateKeySig(uint16 prefix) {
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeySig::~UpdateKeySig() {
    digital_sig_.free();
}

int UpdateKeySig::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "digital_sig"
    int t_digital_sig__size;
    t_digital_sig__size = prefix();
    // Checking out-of-bound for "UpdateKeySig:digital_sig"
    if ( t_begin_of_data + (t_digital_sig__size) > t_end_of_data || t_begin_of_data + (t_digital_sig__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeySig:digital_sig",
        	(0) + (t_digital_sig__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_digital_sig__size;
        int t_digital_sig_string_length;
        t_digital_sig_string_length = prefix();
        // check for negative sizes
        if ( t_digital_sig_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1500", t_digital_sig_string_length);
        digital_sig_.init(t_begin_of_data, t_digital_sig_string_length);
    }

    int t_UpdateKeySig__size;
    const_byteptr const t_dataptr_after_digital_sig = t_begin_of_data + (t_digital_sig__size);
    BINPAC_ASSERT(t_dataptr_after_digital_sig <= t_end_of_data);
    t_UpdateKeySig__size = t_dataptr_after_digital_sig - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UpdateKeySig__size) <= t_end_of_data);
    return t_UpdateKeySig__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyCon::UpdateKeyCon(uint16 prefix) {
    prefix_ = prefix;
    byteorder_ = littleendian;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
UpdateKeyCon::~UpdateKeyCon() {
    mac_.free();
}

int UpdateKeyCon::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "mac"
    int t_mac__size;
    t_mac__size = prefix();
    // Checking out-of-bound for "UpdateKeyCon:mac"
    if ( t_begin_of_data + (t_mac__size) > t_end_of_data || t_begin_of_data + (t_mac__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("UpdateKeyCon:mac",
        	(0) + (t_mac__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_mac__size;
        int t_mac_string_length;
        t_mac_string_length = prefix();
        // check for negative sizes
        if ( t_mac_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/dnp3/dnp3-objects.pac:1505", t_mac_string_length);
        mac_.init(t_begin_of_data, t_mac_string_length);
    }

    int t_UpdateKeyCon__size;
    const_byteptr const t_dataptr_after_mac = t_begin_of_data + (t_mac__size);
    BINPAC_ASSERT(t_dataptr_after_mac <= t_end_of_data);
    t_UpdateKeyCon__size = t_dataptr_after_mac - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_UpdateKeyCon__size) <= t_end_of_data);
    return t_UpdateKeyCon__size;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Conn::DNP3_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new DNP3_Flow(this, true);
    downflow_ = new DNP3_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Conn::~DNP3_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void DNP3_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void DNP3_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void DNP3_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}


    uint64 bytestring_to_time(const_bytestring time48)
        {
        /* In DNP3, a timestamp is represented by 6 bytes since epoch
           in milliseconds. The 6 bytes are stored in big endian format. */
        uint64 epochTime = 0;

        for ( int i = time48.length() - 1; i >= 0; i-- )
            epochTime = time48[i] + epochTime * 256;

        return epochTime;
        }
    
// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Flow::DNP3_Flow(DNP3_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

// NOLINTNEXTLINE(modernize-use-equals-default)
DNP3_Flow::~DNP3_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void DNP3_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new DNP3_PDU(is_orig());
                context_ = new ContextDNP3(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e; // NOLINT(bugprone-exception-copy-constructor-throws)
    }
}

void DNP3_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void DNP3_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool DNP3_Flow::get_dnp3_header_block(uint16 len, uint8 ctrl, uint16 dest_addr, uint16 src_addr) {

		if ( ::dnp3_header_block )
			{
			zeek::BifEvent::enqueue_dnp3_header_block(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), len, ctrl, dest_addr, src_addr);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_application_request_header(uint8 application_control, uint8 fc) {

		if ( ::dnp3_application_request_header )
			{
			zeek::BifEvent::enqueue_dnp3_application_request_header(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(),
				application_control,
				fc
				);
			}
		return true;
		
}

bool DNP3_Flow::get_dnp3_application_response_header(uint8 application_control, uint8 fc, uint16 iin) {

		if ( ::dnp3_application_response_header )
			{
			zeek::BifEvent::enqueue_dnp3_application_response_header(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(),
				application_control,
				fc,
				iin
				);
			}
		return true;
		
}

bool DNP3_Flow::get_dnp3_object_header(uint16 obj_type, uint8 qua_field, uint32 number, uint32 rf_low, uint32 rf_high) {

		if ( ::dnp3_object_header )
			{
			zeek::BifEvent::enqueue_dnp3_object_header(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), obj_type, qua_field, number, rf_low, rf_high);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_object_prefix(uint32 prefix_value) {

		if ( ::dnp3_object_prefix )
			{
			zeek::BifEvent::enqueue_dnp3_object_prefix(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), prefix_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_response_data_object(uint8 data_value) {

		if ( ::dnp3_response_data_object )
			{
			zeek::BifEvent::enqueue_dnp3_response_data_object(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), data_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_attribute_common(uint8 data_type_code, uint8 leng, const_bytestring const& attribute_obj) {

		if ( ::dnp3_attribute_common )
			{
			zeek::BifEvent::enqueue_dnp3_attribute_common(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), data_type_code, leng, to_stringval(attribute_obj) );
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_crob(uint8 control_code, uint8 count8, uint32 on_time, uint32 off_time, uint8 status_code) {

		if ( ::dnp3_crob )
			{
			zeek::BifEvent::enqueue_dnp3_crob(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), control_code, count8, on_time, off_time, status_code);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_pcb(uint8 control_code, uint8 count8, uint32 on_time, uint32 off_time, uint8 status_code) {

		if ( ::dnp3_pcb )
			{
			zeek::BifEvent::enqueue_dnp3_pcb(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), control_code, count8, on_time, off_time, status_code);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_counter_32wFlag(uint8 flag, uint32 count_value) {

		if ( ::dnp3_counter_32wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_counter_32wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_counter_16wFlag(uint8 flag, uint16 count_value) {

		if ( ::dnp3_counter_16wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_counter_16wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_counter_32woFlag(uint32 count_value) {

		if ( ::dnp3_counter_32woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_counter_32woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_counter_16woFlag(uint16 count_value) {

		if ( ::dnp3_counter_16woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_counter_16woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_32wFlag(uint8 flag, uint32 count_value) {

		if ( ::dnp3_frozen_counter_32wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_32wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_16wFlag(uint8 flag, uint16 count_value) {

		if ( ::dnp3_frozen_counter_16wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_16wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_32wFlagTime(uint8 flag, uint32 count_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_counter_32wFlagTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_32wFlagTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_16wFlagTime(uint8 flag, uint16 count_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_counter_16wFlagTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_16wFlagTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, count_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_32woFlag(uint32 count_value) {

		if ( ::dnp3_frozen_counter_32woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_32woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_counter_16woFlag(uint16 count_value) {

		if ( ::dnp3_frozen_counter_16woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_counter_16woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), count_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_32wFlag(uint8 flag, int32 value) {

		if ( ::dnp3_analog_input_32wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_32wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_16wFlag(uint8 flag, int16 value) {

		if ( ::dnp3_analog_input_16wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_16wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_32woFlag(int32 value) {

		if ( ::dnp3_analog_input_32woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_32woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_16woFlag(int16 value) {

		if ( ::dnp3_analog_input_16woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_16woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_SPwFlag(uint8 flag, uint32 value) {

		if ( ::dnp3_analog_input_SPwFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_SPwFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_DPwFlag(uint8 flag, uint32 value_low, uint32 value_high) {

		if ( ::dnp3_analog_input_DPwFlag )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_DPwFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value_low, value_high);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_32wFlag(uint8 flag, int32 frozen_value) {

		if ( ::dnp3_frozen_analog_input_32wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_32wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_16wFlag(uint8 flag, int16 frozen_value) {

		if ( ::dnp3_frozen_analog_input_16wFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_16wFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_32wTime(uint8 flag, int32 frozen_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_32wTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_32wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_16wTime(uint8 flag, int16 frozen_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_16wTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_16wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_32woFlag(int32 frozen_value) {

		if ( ::dnp3_frozen_analog_input_32woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_32woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_16woFlag(int16 frozen_value) {

		if ( ::dnp3_frozen_analog_input_16woFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_16woFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_SPwFlag(uint8 flag, uint32 frozen_value) {

		if ( ::dnp3_frozen_analog_input_SPwFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_SPwFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_DPwFlag(uint8 flag, uint32 frozen_value_low, uint32 frozen_value_high) {

		if ( ::dnp3_frozen_analog_input_DPwFlag )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_DPwFlag(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value_low, frozen_value_high);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_32woTime(uint8 flag, int32 value) {

		if ( ::dnp3_analog_input_event_32woTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_32woTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_16woTime(uint8 flag, int16 value) {

		if ( ::dnp3_analog_input_event_16woTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_16woTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_32wTime(uint8 flag, int32 value, const_bytestring const& time48) {

		if ( ::dnp3_analog_input_event_32wTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_32wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_16wTime(uint8 flag, int16 value, const_bytestring const& time48) {

		if ( ::dnp3_analog_input_event_16wTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_16wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_SPwoTime(uint8 flag, uint32 value) {

		if ( ::dnp3_analog_input_event_SPwoTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_SPwoTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_DPwoTime(uint8 flag, uint32 value_low, uint32 value_high) {

		if ( ::dnp3_analog_input_event_DPwoTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_DPwoTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value_low, value_high);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_SPwTime(uint8 flag, uint32 value, const_bytestring const& time48) {

		if ( ::dnp3_analog_input_event_SPwTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_SPwTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_analog_input_event_DPwTime(uint8 flag, uint32 value_low, uint32 value_high, const_bytestring const& time48) {

		if ( ::dnp3_analog_input_event_DPwTime )
			{
			zeek::BifEvent::enqueue_dnp3_analog_input_event_DPwTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, value_low, value_high, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_32woTime(uint8 flag, int32 frozen_value) {

		if ( ::dnp3_frozen_analog_input_event_32woTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_32woTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_16woTime(uint8 flag, int16 frozen_value) {

		if ( ::dnp3_frozen_analog_input_event_16woTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_16woTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_32wTime(uint8 flag, int32 frozen_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_event_32wTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_32wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_16wTime(uint8 flag, int16 frozen_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_event_16wTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_16wTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_SPwoTime(uint8 flag, uint32 frozen_value) {

		if ( ::dnp3_frozen_analog_input_event_SPwoTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_SPwoTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_DPwoTime(uint8 flag, uint32 frozen_value_low, uint32 frozen_value_high) {

		if ( ::dnp3_frozen_analog_input_event_DPwoTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_DPwoTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value_low, frozen_value_high);
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_SPwTime(uint8 flag, uint32 frozen_value, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_event_SPwTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_SPwTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_frozen_analog_input_event_DPwTime(uint8 flag, uint32 frozen_value_low, uint32 frozen_value_high, const_bytestring const& time48) {

		if ( ::dnp3_frozen_analog_input_event_DPwTime )
			{
			zeek::BifEvent::enqueue_dnp3_frozen_analog_input_event_DPwTime(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), flag, frozen_value_low, frozen_value_high, bytestring_to_time(time48));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_file_transport(uint32 file_handle, uint32 block_num, const_bytestring const& file_data) {

		if ( ::dnp3_file_transport )
			{
			zeek::BifEvent::enqueue_dnp3_file_transport(
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), file_handle, block_num, to_stringval(file_data));
			}

		return true;
		
}

bool DNP3_Flow::get_dnp3_debug_byte(const_bytestring const& debug) {

		if ( ::dnp3_debug_byte )
			{
			zeek::BifEvent::enqueue_dnp3_debug_byte (
				connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig(), to_stringval(debug));
			}

		return true;
		
}

} // namespace DNP3
}  // namespace binpac
