// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif (plugin mode).


#include "functions.bif.h"
#include "zeek/Func.h"

namespace zeek::BifType::Record { zeek::IntrusivePtr<zeek::RecordType> ftp_port; }
namespace BifType::Record { zeek::RecordType * ftp_port; }

#line 4 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

#include <cinttypes>
#include "zeek/Reporter.h"

static zeek::RecordValPtr parse_port(const std::string& line)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ftp_port);

	bool good = false;
	uint32_t port = 0;
	uint32_t addr = 0;

	int32_t bytes[6];
	if ( line.size() >= 11 && sscanf(line.c_str(),
                                     "%" SCNd32 ",%" SCNd32 ",%" SCNd32 ",%" SCNd32 ",%" SCNd32 ",%" SCNd32,
	                                 &bytes[0], &bytes[1], &bytes[2],
	                                 &bytes[3], &bytes[4], &bytes[5]) == 6 )
		{
		good = true;

		for ( int b : bytes )
			if ( b < 0 || b > 255 )
				{
				good = false;
				break;
				}

		if ( good )
			{
			addr = (bytes[0] << 24) | (bytes[1] << 16) |
					(bytes[2] << 8) | bytes[3];
			port = (bytes[4] << 8) | bytes[5];
			}
		}

	r->Assign(0, zeek::make_intrusive<zeek::AddrVal>(htonl(addr)));
	r->Assign(1, zeek::val_mgr->Port(port, TRANSPORT_TCP));
	r->Assign(2, good);

	return r;
	}

static zeek::RecordValPtr parse_eftp(const char* line)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::ftp_port);

	int net_proto = 0;	// currently not used
	zeek::IPAddr addr;	// unspecified IPv6 address (all 128 bits zero)
	int port = 0;
	bool good = false;

	if ( line )
		{
		while ( isspace(*line) )	// skip whitespace
			++line;

		char delimiter = *line;
		char* next_delim;

		if ( *line )
			{
			good = true;
			++line;	// skip delimiter

			net_proto = strtol(line, &next_delim, 10);
			if ( *next_delim != delimiter )
				good = false;

			line = next_delim;
			if ( *line )
				++line;

			if ( *line && *line != delimiter )
				{
				const char* nptr = strchr(line, delimiter);
				if ( nptr == nullptr )
					nptr = line + strlen(line);

				std::string s(line, nptr-line); // extract IP address
				struct in6_addr result;
				good = zeek::IPAddr::ConvertString(s.c_str(), &result);
				if ( good )
					addr = zeek::IPAddr(result);
				}

			line = strchr(line, delimiter);

			if ( line != nullptr )
				{
				++line;	// now the port
				port = strtol(line, &next_delim, 10);
				if ( *next_delim != delimiter )
					good = false;

				if ( port < 0 || port > 65535 )
					{
					port = 0;
					good = false;
					}
				}
			}

		}

	r->Assign(0, zeek::make_intrusive<zeek::AddrVal>(addr));
	r->Assign(1, zeek::val_mgr->Port(port, TRANSPORT_TCP));
	r->Assign(2, good);

	return r;
	}

#line 124 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
zeek::ValPtr zeek::BifFunc::parse_ftp_port_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 125 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("parse_ftp_port() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* s = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 125 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

	return parse_port(s->ToStdString());
	} // end of BifFunc::parse_ftp_port

#line 127 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

#line 139 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
zeek::ValPtr zeek::BifFunc::parse_eftp_port_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 140 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("parse_eftp_port() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* s = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 140 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

	return parse_eftp(s->CheckString());
	} // end of BifFunc::parse_eftp_port

#line 142 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

#line 151 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
zeek::ValPtr zeek::BifFunc::parse_ftp_pasv_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 152 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("parse_ftp_pasv() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* str = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 152 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

	const char* s = str->CheckString();

	if ( str->Len() == 0 )
	   return parse_port("");

	const char* line = strchr(s, '(');
	if ( line )
		++line;	// move past '('
	else if ( line = strstr(s, "PORT"); line != nullptr )
		line += 5;	// Skip over
	else if ( line = strchr(s, ','); line != nullptr )
		{ // Look for comma-separated list.
		do
			{
			// Back up over preceding digits. We'll end on the
			// first digit or the beginning of s.
			--line;
			}
		while ( line >= s && isdigit(*line) );

		// Scoot forward one to point at the first digit or at the
		// beginning of s.
		++line;
		}

	// Make sure we didn't step past the end of the string.
	if ( ! line || ( line - s ) > str->Len() )
		return parse_port("");
	else
		return parse_port(std::string{line});
	} // end of BifFunc::parse_ftp_pasv

#line 183 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

#line 194 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
zeek::ValPtr zeek::BifFunc::parse_ftp_epsv_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 195 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("parse_ftp_epsv() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* str = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 195 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

	const char* s = str->CheckString();
	const char* line = strchr(s, '(');
	if ( line )
		++line; // move past '('
	return parse_eftp(line);
	} // end of BifFunc::parse_ftp_epsv

#line 201 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

#line 213 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
zeek::ValPtr zeek::BifFunc::fmt_ftp_port_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 214 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
{
	// NOLINTNEXTLINE(readability-container-size-empty)
	if ( BiF_ARGS->size() != 2 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("fmt_ftp_port() takes exactly 2 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::AddrVal* a = (zeek::AddrVal*) ((*BiF_ARGS)[0].get()->AsAddrVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek::PortVal* p = (zeek::PortVal*) ((*BiF_ARGS)[1].get()->AsPortVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 214 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"

	const uint32_t* addr;
	int len = a->AsAddr().GetBytes(&addr);
	if ( len == 1 )
		{
		uint32_t a = ntohl(addr[0]);
		uint32_t pn = p->Port();
		return zeek::make_intrusive<zeek::StringVal>(zeek::util::fmt("%d,%d,%d,%d,%d,%d",
		                                                 a >> 24, (a >> 16) & 0xff,
		                                                 (a >> 8) & 0xff, a & 0xff,
		                                                 pn >> 8, pn & 0xff));
		}
	else
		{
		zeek::emit_builtin_error("conversion of non-IPv4 address in fmt_ftp_port",
		                         (*BiF_ARGS)[0]);
		return zeek::val_mgr->EmptyString();
		}
	} // end of BifFunc::fmt_ftp_port

#line 232 "/build/zeek/src/zeek/src/analyzer/protocol/ftp/functions.bif"
