// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_gssapi_gssapi_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_gssapi_gssapi_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/Manager.h"
#include "zeek/analyzer/Analyzer.h"

#include "zeek/analyzer/protocol/gssapi/events.bif.h"


#include <cstdlib>
#include <cinttypes>

namespace binpac {

namespace GSSAPI {
class ContextGSSAPI;
class GSSAPI_Conn;
class GSSAPI_SELECT;
class GSSAPI_NEG_TOKEN;
class GSSAPI_NEG_TOKEN_INIT;
class GSSAPI_NEG_TOKEN_INIT_Arg;
class GSSAPI_NEG_TOKEN_INIT_Arg_Data;
class GSSAPI_NEG_TOKEN_RESP;
class GSSAPI_NEG_TOKEN_RESP_Arg;
class GSSAPI_NEG_TOKEN_MECH_TOKEN;
class KRB_OID_BLOB;
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TypeTag {
    ASN1_INTEGER_TAG = 2,
    ASN1_OCTET_STRING_TAG = 4,
    ASN1_NULL_TAG = 5,
    ASN1_OBJECT_IDENTIFIER_TAG = 6,
    ASN1_SEQUENCE_TAG = 48,
    ASN1_APP_TAG_OFFSET = 96,
    ASN1_INDEX_TAG_OFFSET = 160,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TagClass {
    ASN1_TAG_UNIVERSAL = 0,
    ASN1_TAG_APPLICATION = 1,
    ASN1_TAG_CONTEXT = 2,
    ASN1_TAG_PRIVATE = 3,
};
class ASN1Encoding;
class ASN1EncodingMeta;
class ASN1OptionalEncodingMeta;
class ASN1SequenceMeta;
class ASN1Integer;
class ASN1OctetString;
class ASN1ObjectIdentifier;
class ASN1Boolean;
class ASN1Enumerated;
class SequenceElement;
class Array;
class GSSAPI_Flow;
} // namespace GSSAPI

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace GSSAPI {

class ContextGSSAPI final {
public:
    ContextGSSAPI(GSSAPI_Conn* connection, GSSAPI_Flow* flow);
    ~ContextGSSAPI();

    // Member access functions
    GSSAPI_Conn* connection() const { return connection_; }
    GSSAPI_Flow* flow() const { return flow_; }

protected:
    GSSAPI_Conn* connection_;
    GSSAPI_Flow* flow_;
};


class GSSAPI_Conn final : public binpac::ConnectionAnalyzer {
public:
    GSSAPI_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~GSSAPI_Conn() override;

    // Member access functions
    GSSAPI_Flow* upflow() const { return upflow_; }
    GSSAPI_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool is_first_byte(bytestring const& token, uint8 byte);
    bool forward_blob(GSSAPI_NEG_TOKEN_MECH_TOKEN* val, bool is_orig);
    bool proc_gssapi_neg_result(GSSAPI_NEG_TOKEN_RESP_Arg* val);

protected:

    // Additional members

		zeek::analyzer::Analyzer *ntlm;
		zeek::analyzer::Analyzer *krb5;
	
    GSSAPI_Flow* upflow_;
    GSSAPI_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class GSSAPI_SELECT final {
public:
    GSSAPI_SELECT(bool is_orig);
    ~GSSAPI_SELECT();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* wrapper() const { return wrapper_; }
    uint32 token_case_index() const	{ return token_case_index_; }
    bytestring const& mic_blob() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( token_case_index() ) {
            case ((uint32)1028):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:4:mic_blob", (int64)token_case_index(), "((int) 0x0404)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mic_blob_;
    }
    bytestring const& wrap_blob() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( token_case_index() ) {
            case ((uint32)1284):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:5:wrap_blob", (int64)token_case_index(), "((int) 0x0504)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return wrap_blob_;
    }
    GSSAPI_NEG_TOKEN* neg_token() const {
        return neg_token_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    bool is_init() const { return is_init_; }
    uint32 tok_id() const { return tok_id_; }

protected:
    ASN1EncodingMeta* wrapper_;
    uint32 token_case_index_;
    bytestring mic_blob_;
    bytestring wrap_blob_;
    GSSAPI_NEG_TOKEN* neg_token_;
    bool is_orig_;
    int byteorder_;
    bool is_init_;
    uint32 tok_id_;
};


class GSSAPI_NEG_TOKEN final {
public:
    GSSAPI_NEG_TOKEN(bool is_orig, bool is_init);
    ~GSSAPI_NEG_TOKEN();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    int have_oid_case_index() const	{ return have_oid_case_index_; }
    ASN1Encoding* oid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_oid_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:15:oid", (int64)have_oid_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return oid_;
    }
    int have_init_wrapper_case_index() const	{ return have_init_wrapper_case_index_; }
    ASN1EncodingMeta* init_wrapper() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_init_wrapper_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:19:init_wrapper", (int64)have_init_wrapper_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_wrapper_;
    }
    int msg_type_case_index() const	{ return msg_type_case_index_; }
    GSSAPI_NEG_TOKEN_INIT* init() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:23:init", (int64)msg_type_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return init_;
    }
    GSSAPI_NEG_TOKEN_RESP* resp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_type_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:24:resp", (int64)msg_type_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return resp_;
    }
    bool is_orig() const { return is_orig_; }
    bool is_init() const { return is_init_; }
    int byteorder() const { return byteorder_; }

protected:
    int have_oid_case_index_;
    ASN1Encoding* oid_;
    int have_init_wrapper_case_index_;
    ASN1EncodingMeta* init_wrapper_;
    int msg_type_case_index_;
    GSSAPI_NEG_TOKEN_INIT* init_;
    GSSAPI_NEG_TOKEN_RESP* resp_;
    bool is_orig_;
    bool is_init_;
    int byteorder_;
};


class GSSAPI_NEG_TOKEN_INIT final {
public:
    GSSAPI_NEG_TOKEN_INIT();
    ~GSSAPI_NEG_TOKEN_INIT();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<GSSAPI_NEG_TOKEN_INIT_Arg*>* args() const { return args_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<GSSAPI_NEG_TOKEN_INIT_Arg*>* args_;
    GSSAPI_NEG_TOKEN_INIT_Arg* args__elem_;
};


class GSSAPI_NEG_TOKEN_INIT_Arg final {
public:
    GSSAPI_NEG_TOKEN_INIT_Arg();
    ~GSSAPI_NEG_TOKEN_INIT_Arg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    GSSAPI_NEG_TOKEN_INIT_Arg_Data* args() const { return args_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    GSSAPI_NEG_TOKEN_INIT_Arg_Data* args_;
};


class GSSAPI_NEG_TOKEN_INIT_Arg_Data final {
public:
    GSSAPI_NEG_TOKEN_INIT_Arg_Data(uint8 index);
    ~GSSAPI_NEG_TOKEN_INIT_Arg_Data();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    ASN1Encoding* mech_type_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:39:mech_type_list", (int64)val_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mech_type_list_;
    }
    ASN1Encoding* req_flags() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:40:req_flags", (int64)val_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return req_flags_;
    }
    GSSAPI_NEG_TOKEN_MECH_TOKEN* mech_token() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:41:mech_token", (int64)val_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mech_token_;
    }
    ASN1OctetString* mech_list_mic() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:42:mech_list_mic", (int64)val_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mech_list_mic_;
    }
    uint8 index() const { return index_; }

protected:
    uint8 val_case_index_;
    ASN1Encoding* mech_type_list_;
    ASN1Encoding* req_flags_;
    GSSAPI_NEG_TOKEN_MECH_TOKEN* mech_token_;
    ASN1OctetString* mech_list_mic_;
    uint8 index_;
};


class GSSAPI_NEG_TOKEN_RESP final {
public:
    GSSAPI_NEG_TOKEN_RESP();
    ~GSSAPI_NEG_TOKEN_RESP();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    vector<GSSAPI_NEG_TOKEN_RESP_Arg*>* args() const { return args_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    vector<GSSAPI_NEG_TOKEN_RESP_Arg*>* args_;
    GSSAPI_NEG_TOKEN_RESP_Arg* args__elem_;
};


class GSSAPI_NEG_TOKEN_RESP_Arg final {
public:
    GSSAPI_NEG_TOKEN_RESP_Arg();
    ~GSSAPI_NEG_TOKEN_RESP_Arg();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* seq_meta() const { return seq_meta_; }
    uint8 args_case_index() const	{ return args_case_index_; }
    ASN1Integer* neg_state() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( args_case_index() ) {
            case ((uint8)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:53:neg_state", (int64)args_case_index(), "((int) 0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return neg_state_;
    }
    ASN1Encoding* supported_mech() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( args_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:54:supported_mech", (int64)args_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return supported_mech_;
    }
    GSSAPI_NEG_TOKEN_MECH_TOKEN* response_token() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( args_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:55:response_token", (int64)args_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_token_;
    }
    ASN1OctetString* mech_list_mic() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( args_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/gssapi-protocol.pac:56:mech_list_mic", (int64)args_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mech_list_mic_;
    }
    bool proc() const { BINPAC_ASSERT(has_proc()); return proc_; }
    bool has_proc() const { return has_proc_; }

protected:
    ASN1EncodingMeta* seq_meta_;
    uint8 args_case_index_;
    ASN1Integer* neg_state_;
    ASN1Encoding* supported_mech_;
    GSSAPI_NEG_TOKEN_MECH_TOKEN* response_token_;
    ASN1OctetString* mech_list_mic_;
    bool proc_;
    bool has_proc_;
};


class GSSAPI_NEG_TOKEN_MECH_TOKEN final {
public:
    GSSAPI_NEG_TOKEN_MECH_TOKEN(bool is_orig);
    ~GSSAPI_NEG_TOKEN_MECH_TOKEN();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGSSAPI* t_context);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& token() const { return token_; }
    bool is_orig() const { return is_orig_; }
    bytestring const& ntlm() const { BINPAC_ASSERT(has_ntlm()); return ntlm_; }
    bool has_ntlm() const { return has_ntlm_; }
    KRB_OID_BLOB* krb_with_oid() const { BINPAC_ASSERT(has_krb_with_oid()); return krb_with_oid_; }
    bool has_krb_with_oid() const { return has_krb_with_oid_; }
    bytestring const& krb_blob() const { BINPAC_ASSERT(has_krb_blob()); return krb_blob_; }
    bool has_krb_blob() const { return has_krb_blob_; }
    bool fwd() const { return fwd_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring token_;
    bool is_orig_;
    bytestring ntlm_;
    bool has_ntlm_;
    KRB_OID_BLOB* krb_with_oid_;
    bool has_krb_with_oid_;
    bytestring krb_blob_;
    bool has_krb_blob_;
    bool fwd_;
};


class KRB_OID_BLOB final {
public:
    KRB_OID_BLOB();
    ~KRB_OID_BLOB();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    ASN1OctetString* oid() const { return oid_; }
    uint16 token_id() const { return token_id_; }
    bytestring const& blob() const { return blob_; }

protected:
    ASN1EncodingMeta* meta_;
    ASN1OctetString* oid_;
    uint16 token_id_;
    bytestring blob_;
};


	zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t);
	zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t);
	zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid);
	zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s);


class ASN1Encoding final {
public:
    ASN1Encoding();
    ~ASN1Encoding();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& content() const { return content_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring content_;
};


class ASN1EncodingMeta final {
public:
    ASN1EncodingMeta();
    ~ASN1EncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tag() const { return tag_; }
    uint8 len() const { return len_; }
    bytestring const& more_len() const { return more_len_; }
    bool long_len() const { return long_len_; }
    uint64 length() const { return length_; }
    uint8 index() const { return index_; }
    uint8 tag_class() const { return tag_class_; }
    bool simple_type() const { return simple_type_; }
    uint8 tag_num() const { return tag_num_; }

protected:
    uint8 tag_;
    uint8 len_;
    bytestring more_len_;
    bool long_len_;
    uint64 length_;
    uint8 index_;
    uint8 tag_class_;
    bool simple_type_;
    uint8 tag_num_;
};


class ASN1OptionalEncodingMeta final {
public:
    ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata);
    ~ASN1OptionalEncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ASN1EncodingMeta* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/../asn1/asn1.pac:53:data", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    bool is_present() const { return is_present_; }
    ASN1EncodingMeta* previous_metadata() const { return previous_metadata_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    ASN1EncodingMeta* data_;
    bool is_present_;
    ASN1EncodingMeta* previous_metadata_;
    uint64 length_;
};


class ASN1SequenceMeta final {
public:
    ASN1SequenceMeta();
    ~ASN1SequenceMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* encoding() const { return encoding_; }

protected:
    ASN1EncodingMeta* encoding_;
};


class ASN1Integer final {
public:
    ASN1Integer();
    ~ASN1Integer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1OctetString final {
public:
    ASN1OctetString();
    ~ASN1OctetString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1ObjectIdentifier final {
public:
    ASN1ObjectIdentifier();
    ~ASN1ObjectIdentifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Boolean final {
public:
    ASN1Boolean();
    ~ASN1Boolean();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Enumerated final {
public:
    ASN1Enumerated();
    ~ASN1Enumerated();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class SequenceElement final {
public:
    SequenceElement(bool grab_content);
    ~SequenceElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    int have_content_case_index() const	{ return have_content_case_index_; }
    ASN1Encoding* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/../asn1/asn1.pac:86:data", (int64)have_content_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/gssapi/../asn1/asn1.pac:87:meta", (int64)have_content_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    bool grab_content() const { return grab_content_; }
    uint8 index() const { return index_; }
    uint64 length() const { return length_; }

protected:
    ASN1EncodingMeta* index_meta_;
    int have_content_case_index_;
    ASN1Encoding* data_;
    ASN1EncodingMeta* meta_;
    bool grab_content_;
    uint8 index_;
    uint64 length_;
};


class Array final {
public:
    Array();
    ~Array();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* array_meta() const { return array_meta_; }
    vector<ASN1Encoding*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* array_meta_;
    vector<ASN1Encoding*>* data_;
    ASN1Encoding* data__elem_;
};

int64 binary_to_int64(bytestring const& bs);

class GSSAPI_Flow final : public binpac::FlowAnalyzer {
public:
    GSSAPI_Flow(GSSAPI_Conn* connection, bool is_orig);
    ~GSSAPI_Flow() override;

    // Member access functions
    GSSAPI_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    GSSAPI_SELECT* dataunit_;
    ContextGSSAPI* context_;
    GSSAPI_Conn* connection_;
    bool is_orig_;
};

} // namespace GSSAPI
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_gssapi_gssapi_pac_h */
